/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatoractive;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveDescriptor;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveSlowProcess;
import net.minecraft.entity.player.EntityPlayer;

public class ThermalDissipatorActiveElement
extends TransparentNodeElement {
    ThermalDissipatorActiveDescriptor descriptor;
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    ThermalDissipatorActiveSlowProcess slowProcess = new ThermalDissipatorActiveSlowProcess(this);
    Resistor powerResistor = new Resistor(this.positiveLoad, null);
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();
    public float lastPowerFactor;

    public ThermalDissipatorActiveElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ThermalDissipatorActiveDescriptor)descriptor;
        this.slowProcessList.add(new NodePeriodicPublishProcess(this.node, 4.0, 2.0));
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setTMax(this.descriptor.warmLimit).set(new WorldExplosion(this).machineExplosion());
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.set(this.positiveLoad).setUNominal(this.descriptor.nominalElectricalU).set(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (side == this.front || side == this.front.getInverse()) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        block5: {
            block4: {
                if (side == Direction.YN || side == Direction.YP) break block4;
                if (lrdu == LRDU.Down) break block5;
            }
            return null;
        }
        if (side == this.front || side == this.front.getInverse()) {
            return null;
        }
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        block5: {
            block4: {
                if (side == Direction.YN || side == Direction.YP) break block4;
                if (lrdu == LRDU.Down) break block5;
            }
            return 0;
        }
        if (side == this.front || side == this.front.getInverse()) {
            return 1;
        }
        return 2;
    }

    @Override
    public String multiMeterString(Direction side) {
        return Utils.plotVolt("U : ", this.positiveLoad.getU()) + Utils.plotAmpere("I : ", this.positiveLoad.getCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        return Utils.plotCelsius("T : ", this.thermalLoad.Tc) + Utils.plotPower("P : ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.descriptor.applyTo(this.positiveLoad, this.powerResistor);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            this.lastPowerFactor = (float)(this.powerResistor.getP() / this.descriptor.electricalNominalP);
            stream.writeFloat(this.lastPowerFactor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        if (Eln.wailaEasyMode) {
            info.put("Temperature", Utils.plotCelsius("", this.thermalLoad.Tc));
            info.put("Thermal Power", Utils.plotPower("", this.thermalLoad.getPower()));
        }
        return info;
    }
}

