/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatoractive;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveDescriptor;

public class ThermalDissipatorActiveRender
extends TransparentNodeElementRender {
    ThermalDissipatorActiveDescriptor descriptor;
    RcInterpolator rc = new RcInterpolator(2.0f);
    float alpha = 0.0f;
    float powerFactor;

    public ThermalDissipatorActiveRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (ThermalDissipatorActiveDescriptor)descriptor;
    }

    @Override
    public void draw() {
        this.front.glRotateXnRef();
        this.descriptor.draw(this.alpha);
    }

    @Override
    public void refresh(float deltaT) {
        this.rc.setTarget(this.powerFactor);
        this.rc.step(deltaT);
        this.alpha += this.rc.get() * 360.0f * deltaT;
        while (this.alpha > 360.0f) {
            this.alpha -= 360.0f;
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.powerFactor = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

