/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatoractive;

import mods.eln.sim.IProcess;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveDescriptor;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveElement;

public class ThermalDissipatorActiveSlowProcess
implements IProcess {
    ThermalDissipatorActiveElement dissipator;

    public ThermalDissipatorActiveSlowProcess(ThermalDissipatorActiveElement dissipator) {
        this.dissipator = dissipator;
    }

    @Override
    public void process(double time) {
        ThermalDissipatorActiveDescriptor descriptor = this.dissipator.descriptor;
        double poweredFactor = this.dissipator.powerResistor.getP() / descriptor.electricalNominalP;
        double thermalRp = 1.0 / (1.0 / descriptor.thermalRp + poweredFactor / descriptor.electricalToThermalRp);
        this.dissipator.thermalLoad.setRp(thermalRp);
        if (Math.abs(this.dissipator.lastPowerFactor - (float)poweredFactor) > 0.2f) {
            this.dissipator.needPublish();
        }
    }
}

