/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatorpassive;

import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.thermaldissipatorpassive.ThermalDissipatorPassiveDescriptor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThermalDissipatorPassiveElement
extends TransparentNodeElement {
    ThermalDissipatorPassiveDescriptor descriptor;
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();

    public ThermalDissipatorPassiveElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.thermalLoadList.add(this.thermalLoad);
        this.descriptor = (ThermalDissipatorPassiveDescriptor)descriptor;
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.thermalLoad).setTMax(this.descriptor.warmLimit).set(new WorldExplosion(this).machineExplosion());
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        block3: {
            block2: {
                if (side == Direction.YN || side == Direction.YP) break block2;
                if (lrdu == LRDU.Down) break block3;
            }
            return null;
        }
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        block3: {
            block2: {
                if (side == Direction.YN || side == Direction.YP) break block2;
                if (lrdu == LRDU.Down) break block3;
            }
            return 0;
        }
        return 2;
    }

    @Override
    public String multiMeterString(Direction side) {
        return "";
    }

    @Override
    public String thermoMeterString(Direction side) {
        return Utils.plotCelsius("T : ", this.thermalLoad.Tc) + Utils.plotPower("P : ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack stack = entityPlayer.func_71045_bC();
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            this.thermalLoad.Tc *= 0.5;
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
            return true;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
            this.thermalLoad.Tc *= 0.2;
            if (stack.field_77994_a != 0) {
                --stack.field_77994_a;
            } else {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        if (Eln.wailaEasyMode) {
            info.put("Temperature", Utils.plotCelsius("", this.thermalLoad.Tc));
            info.put("Thermal Power", Utils.plotPower("", this.thermalLoad.getPower()));
        }
        return info;
    }
}

