/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.transformer;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.transformer.TransformerElement;
import mods.eln.transparentnode.transformer.TransformerRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TransformerDescriptor
extends TransparentNodeDescriptor {
    Obj3D obj;
    Obj3D defaultFeroObj;
    public float minimalLoadToHum;
    public SoundCommand highLoadSound;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart defaultFero;
    Obj3D.Obj3DPart sbire;

    public TransformerDescriptor(String name, Obj3D obj, Obj3D defaultFeroObj, float minimalLoadToHum) {
        super(name, TransformerElement.class, TransformerRender.class);
        this.obj = obj;
        this.defaultFeroObj = defaultFeroObj;
        this.minimalLoadToHum = minimalLoadToHum;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.sbire = obj.getPart("sbire");
        }
        if (defaultFeroObj != null) {
            this.defaultFero = defaultFeroObj.getPart("fero");
        }
        this.highLoadSound = new SoundCommand("eln:Transformer", 1.6f);
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Transforms an input voltage to\nan output voltage.", new Object[0]).split("\n"));
        Collections.addAll(list, I18N.tr("The voltage ratio is proportional\nto the cable stacks count ratio.", new Object[0]).split("\n"));
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(this.defaultFero, 1, 4);
        }
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    void draw(Obj3D.Obj3DPart fero, int priCableNbr, int secCableNbr) {
        if (this.main != null) {
            this.main.draw();
        }
        if (fero != null) {
            int idx;
            float y;
            fero.draw();
            if (priCableNbr != 0) {
                GL11.glPushMatrix();
                y = (float)(priCableNbr - 1) * 1.0f / 16.0f;
                GL11.glTranslatef((float)0.0f, (float)(-y), (float)0.0f);
                for (idx = 0; idx < priCableNbr; ++idx) {
                    this.sbire.draw();
                    GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.0f);
                }
                GL11.glPopMatrix();
            }
            if (secCableNbr != 0) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                y = (float)(secCableNbr - 1) * 1.0f / 16.0f;
                GL11.glTranslatef((float)0.0f, (float)(-y), (float)0.0f);
                for (idx = 0; idx < secCableNbr; ++idx) {
                    this.sbire.draw();
                    GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.0f);
                }
                GL11.glPopMatrix();
            }
        }
    }
}

