/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.transformer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Transformer;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.mna.process.TransformerInterSystemProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import mods.eln.transparentnode.transformer.TransformerContainer;
import mods.eln.transparentnode.transformer.TransformerDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TransformerElement
extends TransparentNodeElement {
    public NbtElectricalLoad primaryLoad = new NbtElectricalLoad("primaryLoad");
    public NbtElectricalLoad secondaryLoad = new NbtElectricalLoad("secondaryLoad");
    public VoltageSource primaryVoltageSource = new VoltageSource("primaryVoltageSource");
    public VoltageSource secondaryVoltageSource = new VoltageSource("secondaryVoltageSource");
    public TransformerInterSystemProcess interSystemProcess = new TransformerInterSystemProcess(this.primaryLoad, this.secondaryLoad, this.primaryVoltageSource, this.secondaryVoltageSource);
    public Transformer transformer = new Transformer();
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(3, 64, this);
    float primaryMaxCurrent = 0.0f;
    float secondaryMaxCurrent = 0.0f;
    TransformerDescriptor transformerDescriptor;
    SoundLooper highLoadSoundLooper;
    boolean isIsolator = false;
    VoltageStateWatchDog voltagePrimaryWatchdog = new VoltageStateWatchDog();
    VoltageStateWatchDog voltageSecondaryWatchdog = new VoltageStateWatchDog();
    public static final byte toogleIsIsolator = 1;

    public TransformerElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.electricalLoadList.add(this.primaryLoad);
        this.electricalLoadList.add(this.secondaryLoad);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltagePrimaryWatchdog.set(this.primaryLoad).set(exp));
        this.slowProcessList.add(this.voltageSecondaryWatchdog.set(this.secondaryLoad).set(exp));
        this.transformerDescriptor = (TransformerDescriptor)descriptor;
        this.highLoadSoundLooper = new SoundLooper(this){

            @Override
            public SoundCommand mustStart() {
                float load;
                if (TransformerElement.this.primaryMaxCurrent != 0.0f && TransformerElement.this.secondaryMaxCurrent != 0.0f && (load = (float)Math.max(TransformerElement.this.primaryLoad.getI() / (double)TransformerElement.this.primaryMaxCurrent, TransformerElement.this.secondaryLoad.getI() / (double)TransformerElement.this.secondaryMaxCurrent)) > TransformerElement.this.transformerDescriptor.minimalLoadToHum) {
                    return TransformerElement.this.transformerDescriptor.highLoadSound.copy().mulVolume(0.1f * (load - TransformerElement.this.transformerDescriptor.minimalLoadToHum) / (1.0f - TransformerElement.this.transformerDescriptor.minimalLoadToHum), 1.0f).smallRange();
                }
                return null;
            }
        };
        this.slowProcessList.add(this.highLoadSoundLooper);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        if (this.isIsolator) {
            Eln.simulator.mna.removeProcess(this.interSystemProcess);
        }
    }

    @Override
    public void connectJob() {
        if (this.isIsolator) {
            Eln.simulator.mna.addProcess(this.interSystemProcess);
        }
        super.connectJob();
    }

    @Override
    public void onBreakElement() {
        super.onBreakElement();
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front.left()) {
            return this.primaryLoad;
        }
        if (side == this.front.right()) {
            return this.secondaryLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front.left()) {
                return 1;
            }
            if (side == this.front.right()) {
                return 1;
            }
            if (side == this.front && !this.grounded) {
                return 1;
            }
            if (side == this.front.back() && !this.grounded) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        if (side == this.front.left()) {
            return Utils.plotVolt("UP+:", this.primaryLoad.getU()) + Utils.plotAmpere("IP+:", -this.primaryLoad.getCurrent());
        }
        if (side == this.front.right()) {
            return Utils.plotVolt("US+:", this.secondaryLoad.getU()) + Utils.plotAmpere("IS+:", -this.secondaryLoad.getCurrent());
        }
        return Utils.plotVolt("UP+:", this.primaryLoad.getU()) + Utils.plotAmpere("IP+:", this.transformer.aCurrentState.state) + Utils.plotVolt("  US+:", this.secondaryLoad.getU()) + Utils.plotAmpere("IS+:", this.transformer.bCurrentState.state);
    }

    @Override
    public String thermoMeterString(Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.applyIsolation();
        this.computeInventory();
        this.connect();
    }

    public void computeInventory() {
        ItemStack primaryCable = this.inventory.func_70301_a(0);
        ItemStack secondaryCable = this.inventory.func_70301_a(1);
        ItemStack core = this.inventory.func_70301_a(2);
        ElectricalCableDescriptor primaryCableDescriptor = null;
        ElectricalCableDescriptor secondaryCableDescriptor = null;
        if (primaryCable != null) {
            primaryCableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(primaryCable);
        }
        if (secondaryCable != null) {
            secondaryCableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(secondaryCable);
        }
        if (primaryCableDescriptor != null) {
            this.voltagePrimaryWatchdog.setUNominal(primaryCableDescriptor.electricalNominalVoltage);
        } else {
            this.voltagePrimaryWatchdog.setUNominal(1000000.0);
        }
        if (secondaryCableDescriptor != null) {
            this.voltageSecondaryWatchdog.setUNominal(secondaryCableDescriptor.electricalNominalVoltage);
        } else {
            this.voltageSecondaryWatchdog.setUNominal(1000000.0);
        }
        double coreFactor = 1.0;
        if (core != null) {
            FerromagneticCoreDescriptor coreDescriptor = (FerromagneticCoreDescriptor)FerromagneticCoreDescriptor.getDescriptor(core);
            coreFactor = coreDescriptor.cableMultiplicator;
        }
        if (primaryCable == null || core == null) {
            this.primaryLoad.highImpedance();
            this.primaryMaxCurrent = 0.0f;
        } else {
            primaryCableDescriptor.applyTo(this.primaryLoad, coreFactor);
            this.primaryMaxCurrent = (float)primaryCableDescriptor.electricalMaximalCurrent;
        }
        if (secondaryCable == null || core == null) {
            this.secondaryLoad.highImpedance();
            this.secondaryMaxCurrent = 0.0f;
        } else {
            secondaryCableDescriptor.applyTo(this.secondaryLoad, coreFactor);
            this.secondaryMaxCurrent = (float)secondaryCableDescriptor.electricalMaximalCurrent;
        }
        if (primaryCable != null && secondaryCable != null) {
            this.transformer.setRatio(1.0 * (double)secondaryCable.field_77994_a / (double)primaryCable.field_77994_a);
            this.interSystemProcess.setRatio(1.0 * (double)secondaryCable.field_77994_a / (double)primaryCable.field_77994_a);
        } else {
            this.transformer.setRatio(1.0);
            this.interSystemProcess.setRatio(1.0);
        }
    }

    public void applyIsolation() {
        this.electricalComponentList.remove(this.transformer);
        this.electricalComponentList.remove(this.primaryVoltageSource);
        this.electricalComponentList.remove(this.secondaryVoltageSource);
        this.primaryLoad.remove(this.primaryVoltageSource);
        this.secondaryLoad.remove(this.secondaryVoltageSource);
        this.primaryLoad.remove(this.transformer);
        this.secondaryLoad.remove(this.transformer);
        if (this.isIsolator) {
            this.primaryVoltageSource.connectTo(this.primaryLoad, null);
            this.secondaryVoltageSource.connectTo(this.secondaryLoad, null);
            this.electricalComponentList.add(this.primaryVoltageSource);
            this.electricalComponentList.add(this.secondaryVoltageSource);
        } else {
            this.transformer.connectTo(this.primaryLoad, this.secondaryLoad);
            this.electricalComponentList.add(this.transformer);
        }
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        this.disconnect();
        this.computeInventory();
        this.connect();
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new TransformerContainer(player, (IInventory)this.inventory);
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onGroundedChangedByClient() {
        super.onGroundedChangedByClient();
        this.computeInventory();
        this.reconnect();
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        switch (super.networkUnserialize(stream)) {
            case 1: {
                this.disconnect();
                this.isIsolator = !this.isIsolator;
                this.applyIsolation();
                this.reconnect();
                this.needPublish();
            }
        }
        return 0;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            if (this.inventory.func_70301_a(0) == null) {
                stream.writeByte(0);
            } else {
                stream.writeByte(this.inventory.func_70301_a((int)0).field_77994_a);
            }
            if (this.inventory.func_70301_a(1) == null) {
                stream.writeByte(0);
            } else {
                stream.writeByte(this.inventory.func_70301_a((int)1).field_77994_a);
            }
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(2));
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(1));
            this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
            stream.writeBoolean(this.isIsolator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("isIsolated", this.isIsolator);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.isIsolator = nbt.func_74767_n("isIsolated");
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        DecimalFormat format = new DecimalFormat("#.##");
        info.put("Ratio", format.format(Utils.readPrivateDouble(this.transformer, "ratio")));
        FerromagneticCoreDescriptor core = (FerromagneticCoreDescriptor)FerromagneticCoreDescriptor.getDescriptor(this.inventory.func_70301_a(2));
        if (core != null) {
            info.put("Core Factor", format.format(core.cableMultiplicator));
        }
        info.put("Isolated", this.isIsolator ? "Yes" : "No");
        if (Eln.wailaEasyMode) {
            info.put("Voltage+", Utils.plotVolt("", this.primaryLoad.getU()));
            info.put("Voltage-", Utils.plotVolt("", this.secondaryLoad.getU()));
        }
        return info;
    }
}

