/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.transformer;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.item.FerromagneticCoreDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.transformer.TransformerDescriptor;
import mods.eln.transparentnode.transformer.TransformerGuiDraw;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class TransformerRender
extends TransparentNodeElementRender {
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(3, 64, this);
    TransformerDescriptor descriptor;
    byte primaryStackSize;
    byte secondaryStackSize;
    CableRenderDescriptor priRender;
    CableRenderDescriptor secRender;
    public boolean isIsolator;
    Obj3D.Obj3DPart feroPart;
    LRDUMask priConn = new LRDUMask();
    LRDUMask secConn = new LRDUMask();
    LRDUMask eConn = new LRDUMask();
    CableRenderType cableRenderType;

    public TransformerRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (TransformerDescriptor)descriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        this.descriptor.draw(this.feroPart, this.primaryStackSize, this.secondaryStackSize);
        GL11.glPopMatrix();
        this.cableRenderType = this.drawCable(this.front.down(), this.priRender, this.priConn, this.cableRenderType);
        this.cableRenderType = this.drawCable(this.front.down(), this.secRender, this.secConn, this.cableRenderType);
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new TransformerGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.primaryStackSize = stream.readByte();
            this.secondaryStackSize = stream.readByte();
            ItemStack feroStack = Utils.unserialiseItemStack(stream);
            FerromagneticCoreDescriptor feroDesc = (FerromagneticCoreDescriptor)FerromagneticCoreDescriptor.getDescriptor(feroStack, FerromagneticCoreDescriptor.class);
            this.feroPart = feroDesc == null ? null : feroDesc.feroPart;
            ItemStack priStack = Utils.unserialiseItemStack(stream);
            ElectricalCableDescriptor priDesc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(priStack, ElectricalCableDescriptor.class);
            this.priRender = priDesc == null ? null : priDesc.render;
            ItemStack secStack = Utils.unserialiseItemStack(stream);
            ElectricalCableDescriptor secDesc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(secStack, ElectricalCableDescriptor.class);
            this.secRender = secDesc == null ? null : secDesc.render;
            this.eConn.deserialize(stream);
            this.priConn.mask = 0;
            this.secConn.mask = 0;
            for (LRDU lrdu : LRDU.values()) {
                if (!this.eConn.get(lrdu) || this.front.down().applyLRDU(lrdu) == this.front.left() || this.front.down().applyLRDU(lrdu) == this.front.right()) continue;
                CableRenderDescriptor render = this.getCableRender(this.front.down().applyLRDU(lrdu), LRDU.Down);
                if (render == this.priRender) {
                    this.priConn.set(lrdu, true);
                }
                if (render != this.secRender) continue;
                this.secConn.set(lrdu, true);
            }
            this.cableRenderType = null;
            this.isIsolator = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front.left()) {
                return this.priRender;
            }
            if (side == this.front.right()) {
                return this.secRender;
            }
            if (side == this.front && !this.grounded) {
                return this.priRender;
            }
            if (side == this.front.back() && !this.grounded) {
                return this.secRender;
            }
        }
        return null;
    }

    @Override
    public void notifyNeighborSpawn() {
        super.notifyNeighborSpawn();
        this.cableRenderType = null;
    }
}

