/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import mods.eln.sim.IProcess;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElement;

public class TurbineElectricalProcess
implements IProcess,
IRootSystemPreStepProcess {
    TurbineElement turbine;
    int id;

    public TurbineElectricalProcess(TurbineElement t) {
        this.turbine = t;
    }

    @Override
    public void process(double time) {
        double Ut;
        TurbineDescriptor descriptor = this.turbine.descriptor;
        double deltaT = this.turbine.warmLoad.Tc - this.turbine.coolLoad.Tc;
        double deltaU = this.turbine.positiveLoad.getSubSystem().solve(this.turbine.positiveLoad);
        double targetU = descriptor.TtoU.getValue(deltaT);
        SubSystem.Th th = this.turbine.positiveLoad.getSubSystem().getTh(this.turbine.positiveLoad, this.turbine.electricalPowerSourceProcess);
        if (targetU < th.U) {
            Ut = th.U;
        } else if (th.isHighImpedance()) {
            Ut = targetU;
        } else {
            double a = 1.0 / th.R;
            double b = descriptor.powerOutPerDeltaU - th.U / th.R;
            double c = -descriptor.powerOutPerDeltaU * targetU;
            Ut = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        }
        double i = (Ut - th.U) / th.R;
        double p = i * Ut;
        double pMax = descriptor.nominalP * 1.5;
        if (p > pMax) {
            Ut = (Math.sqrt(th.U * th.U + 4.0 * pMax * th.R) + th.U) / 2.0;
            if (Double.isNaN(Ut = Math.min(Ut, targetU))) {
                Ut = 0.0;
            }
            if (Ut < th.U) {
                Ut = th.U;
            }
        }
        this.turbine.electricalPowerSourceProcess.setU(Ut);
    }

    @Override
    public void rootSystemPreStepProcess() {
        this.process(0.0);
    }
}

