/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.turbine.TurbineContainer;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElectricalProcess;
import mods.eln.transparentnode.turbine.TurbineSlowProcess;
import mods.eln.transparentnode.turbine.TurbineThermalProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class TurbineElement
extends TransparentNodeElement {
    private static final double[] voltageFunctionTable = new double[]{0.0, 0.5, 0.8, 0.9, 0.95, 1.0, 1.1, 1.2};
    private static final FunctionTable voltageFunction = new FunctionTable(voltageFunctionTable, 1.2);
    public NbtElectricalLoad inputLoad = new NbtElectricalLoad("inputLoad");
    public NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    public Resistor inputToTurbinResistor = new Resistor(this.inputLoad, this.positiveLoad);
    public NbtThermalLoad warmLoad = new NbtThermalLoad("warmLoad");
    public NbtThermalLoad coolLoad = new NbtThermalLoad("coolLoad");
    public VoltageSource electricalPowerSourceProcess = new VoltageSource("PowerSource", this.positiveLoad, null);
    public TurbineThermalProcess turbineThermaltProcess = new TurbineThermalProcess(this);
    public TurbineElectricalProcess turbineElectricalProcess = new TurbineElectricalProcess(this);
    public TurbineSlowProcess turbineSlowProcess = new TurbineSlowProcess(this);
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(1, 1, this);
    TurbineDescriptor descriptor;
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog();

    public TurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (TurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.inputLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.inputToTurbinResistor);
        this.thermalLoadList.add(this.warmLoad);
        this.thermalLoadList.add(this.coolLoad);
        this.slowProcessList.add(this.turbineSlowProcess);
        this.electricalComponentList.add(this.electricalPowerSourceProcess);
        this.thermalFastProcessList.add(this.turbineThermaltProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.set(this.warmLoad).setTMax(this.descriptor.nominalDeltaT * 2.0).set(exp);
        this.slowProcessList.add(this.voltageWatchdog.set(this.positiveLoad).setUNominal(this.descriptor.nominalU).set(exp));
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.mna.addProcess(this.turbineElectricalProcess);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.turbineElectricalProcess);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front) {
            return this.inputLoad;
        }
        if (side == this.front.back()) {
            return this.inputLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        if (side == this.front.left()) {
            return this.warmLoad;
        }
        if (side == this.front.right()) {
            return this.coolLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front) {
                return 1;
            }
            if (side == this.front.back()) {
                return 1;
            }
            if (side == this.front.left()) {
                return 2;
            }
            if (side == this.front.right()) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        if (side == this.front.left()) {
            return "";
        }
        if (side == this.front.right()) {
            return "";
        }
        if (side == this.front || side == this.front.back()) {
            return Utils.plotVolt("U+:", this.positiveLoad.getU()) + Utils.plotAmpere("I+:", this.positiveLoad.getCurrent());
        }
        return Utils.plotVolt("U:", this.positiveLoad.getU()) + Utils.plotAmpere("I:", this.positiveLoad.getCurrent());
    }

    @Override
    public String thermoMeterString(Direction side) {
        if (side == this.front.left()) {
            return Utils.plotCelsius("T+:", this.warmLoad.Tc) + Utils.plotPower("P+:", this.warmLoad.getPower());
        }
        if (side == this.front.right()) {
            return Utils.plotCelsius("T-:", this.coolLoad.Tc) + Utils.plotPower("P-:", this.coolLoad.getPower());
        }
        return Utils.plotCelsius("T:", this.warmLoad.Tc - this.coolLoad.Tc);
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.inputLoad);
        this.inputToTurbinResistor.setR(this.descriptor.electricalRs * 30.0);
        this.descriptor.applyTo(this.warmLoad);
        this.descriptor.applyTo(this.coolLoad);
        this.connect();
    }

    public void computeInventory() {
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        this.computeInventory();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new TurbineContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Nominal \u0394T", this.warmLoad.Tc - this.coolLoad.Tc == this.descriptor.nominalDeltaT ? "Yes" : "No");
        if (Eln.wailaEasyMode) {
            info.put("\u0394T", Utils.plotCelsius("", this.warmLoad.Tc - this.coolLoad.Tc));
        }
        return info;
    }
}

