/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import java.io.DataInputStream;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import org.lwjgl.opengl.GL11;

public class TurbineRender
extends TransparentNodeElementRender {
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(1, 64, this);
    TurbineDescriptor descriptor;
    private CableRenderType connectionType;
    boolean cableRefresh;
    LRDUMask eConn = new LRDUMask();
    LRDUMask maskTemp = new LRDUMask();

    public TurbineRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (TurbineDescriptor)descriptor;
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.descriptor.draw();
        GL11.glPopMatrix();
        if (this.cableRefresh) {
            this.cableRefresh = false;
            this.connectionType = CableRender.connectionType(this.tileEntity, this.eConn, this.front.down());
        }
        this.glCableTransforme(this.front.down());
        this.descriptor.eRender.bindCableTexture();
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(this.connectionType.otherdry[lrdu.toInt()]);
            if (!this.eConn.get(lrdu) || lrdu != this.front.down().getLRDUGoingTo(this.front) && lrdu.inverse() != this.front.down().getLRDUGoingTo(this.front)) continue;
            this.maskTemp.set(1 << lrdu.toInt());
            CableRender.drawCable(this.descriptor.eRender, this.maskTemp, this.connectionType);
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front) {
                return this.descriptor.eRender;
            }
            if (side == this.front.back()) {
                return this.descriptor.eRender;
            }
        }
        return null;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        this.eConn.deserialize(stream);
        this.cableRefresh = true;
    }
}

