/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import mods.eln.sim.IProcess;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import mods.eln.transparentnode.turbine.TurbineElement;

public class TurbineSlowProcess
implements IProcess {
    TurbineElement turbine;
    static int staticId = 0;
    int id;
    SoundLooper soundLooper;

    public TurbineSlowProcess(TurbineElement t) {
        this.turbine = t;
        this.id = staticId++;
        this.soundLooper = new SoundLooper(t){

            @Override
            public SoundCommand mustStart() {
                double deltaT = TurbineSlowProcess.this.turbine.warmLoad.Tc - TurbineSlowProcess.this.turbine.coolLoad.Tc;
                if (deltaT < 40.0) {
                    return null;
                }
                float factor = (float)(deltaT / TurbineSlowProcess.this.turbine.descriptor.nominalDeltaT);
                SoundCommand track = TurbineSlowProcess.this.turbine.descriptor.sound.copy().mulVolume(1.0f * (0.1f * factor), 0.9f + 0.2f * factor);
                return track;
            }
        };
    }

    @Override
    public void process(double time) {
        this.soundLooper.process(time);
    }
}

