/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import mods.eln.Eln;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElement;

public class TurbineThermalProcess
implements IProcess {
    TurbineElement turbine;

    public TurbineThermalProcess(TurbineElement t) {
        this.turbine = t;
    }

    @Override
    public void process(double time) {
        TurbineDescriptor descriptor = this.turbine.descriptor;
        VoltageSource src = this.turbine.electricalPowerSourceProcess;
        double eff = Math.abs(1.0 - (this.turbine.coolLoad.Tc + 293.15) / (this.turbine.warmLoad.Tc + 293.15));
        if (eff < 0.05) {
            eff = 0.05;
        }
        double E = src.getP() * time / Eln.instance.heatTurbinePowerFactor;
        double Pout = E / time;
        double Pin = descriptor.PoutToPin.getValue(Pout) / eff;
        this.turbine.warmLoad.movePowerTo(-Pin);
        this.turbine.coolLoad.movePowerTo(Pin * (1.0 - eff));
    }
}

