/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiVerticalTrackBar;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.transparentnode.turret.TurretContainer;
import mods.eln.transparentnode.turret.TurretRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class TurretGui
extends GuiContainerEln {
    private GuiButton killOrSpareButton;
    private GuiVerticalTrackBar chargePower;
    private final TurretRender render;

    public TurretGui(EntityPlayer player, IInventory inventory, TurretRender render) {
        super(new TurretContainer(player, inventory));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.killOrSpareButton = this.newGuiButton(11, 6, 100, "");
        this.chargePower = this.newGuiVerticalTrackBar(146, 8, 20, 35);
        this.chargePower.setStepId(49);
        this.chargePower.setStepIdMax(49);
        this.chargePower.setRange(100.0f, 5000.0f);
        this.chargePower.setComment(0, I18N.tr("Recharge power:", new Object[0]));
        this.chargePower.setValue(this.render.chargePower);
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.killOrSpareButton.field_146126_j = this.render.filterIsSpare ? I18N.tr("Do not attack:", new Object[0]) : I18N.tr("Attack:", new Object[0]);
        this.chargePower.setComment(1, "" + this.chargePower.getValue() + "W");
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new GuiHelperContainer((GuiScreen)this, 176, 134, 8, 52);
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.killOrSpareButton) {
            this.render.clientToggleFilterMeaning();
        } else if (object == this.chargePower) {
            this.render.clientSetChargePower(this.chargePower.getValue());
        }
    }
}

