/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import mods.eln.misc.SlewLimiter;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.turret.TurretDescriptor;

public class TurretMechanicsSimulation
implements IProcess {
    private final SlewLimiter turretAngle;
    private final SlewLimiter gunPosition;
    private final SlewLimiter gunElevation;
    private float shootDuration;
    private boolean enabled;
    private final TurretDescriptor descriptor;

    public TurretMechanicsSimulation(TurretDescriptor descriptor) {
        this.descriptor = descriptor;
        this.turretAngle = new SlewLimiter(descriptor.getProperties().turretAimAnimationSpeed);
        this.gunPosition = new SlewLimiter(descriptor.getProperties().gunArmAnimationSpeed, descriptor.getProperties().gunDisarmAnimationSpeed);
        this.gunElevation = new SlewLimiter(descriptor.getProperties().gunAimAnimationSpeed);
        this.shootDuration = 0.0f;
    }

    public float getTurretAngle() {
        return this.turretAngle.getPosition();
    }

    public float getTurretTargetAngle() {
        return this.turretAngle.getTarget();
    }

    public boolean setTurretAngle(float angle) {
        boolean changed = (angle = Utils.limit(angle, -this.descriptor.getProperties().actionAngle, this.descriptor.getProperties().actionAngle)) != this.turretAngle.getTarget();
        this.turretAngle.setTarget(angle);
        return changed;
    }

    public float getGunPosition() {
        return this.gunPosition.getPosition();
    }

    public float getGunTargetPosition() {
        return this.gunPosition.getTarget();
    }

    public boolean setGunPosition(float position) {
        boolean changed = (position = Utils.limit(position, 0.0f, 1.0f)) != this.gunPosition.getTarget();
        this.gunPosition.setTarget(position);
        return changed;
    }

    public float getGunElevation() {
        return this.gunElevation.getPosition();
    }

    public float getGunTargetElevation() {
        return this.gunElevation.getTarget();
    }

    public boolean setGunElevation(float elevation) {
        if (Float.isNaN(elevation)) {
            return false;
        }
        boolean changed = (elevation = Utils.limit(elevation, this.descriptor.getProperties().gunMinElevation, this.descriptor.getProperties().gunMaxElevation)) != this.gunElevation.getTarget();
        this.gunElevation.setTarget(elevation);
        return changed;
    }

    public boolean inSeekMode() {
        return this.turretAngle.getPositiveSlewRate() == this.descriptor.getProperties().turretSeekAnimationSpeed;
    }

    public void setSeekMode(boolean seekModeEnabled) {
        if (seekModeEnabled) {
            this.turretAngle.setSlewRate(this.descriptor.getProperties().turretSeekAnimationSpeed);
        } else {
            this.turretAngle.setSlewRate(this.descriptor.getProperties().turretAimAnimationSpeed);
        }
    }

    public boolean isTargetReached() {
        return this.turretAngle.targetReached(5.0f) && this.gunPosition.targetReached() && this.gunElevation.targetReached(2.0f);
    }

    public boolean isShooting() {
        return this.shootDuration != 0.0f;
    }

    public boolean shoot() {
        if (this.shootDuration == 0.0f) {
            this.shootDuration = 0.1f;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enabled) {
        boolean changed = enabled != this.enabled;
        this.enabled = enabled;
        if (!enabled) {
            this.shootDuration = 0.0f;
        }
        return changed;
    }

    @Override
    public void process(double time) {
        if (!this.enabled) {
            return;
        }
        this.turretAngle.step((float)time);
        if (this.gunElevation.getPosition() == 0.0f) {
            this.gunPosition.step((float)time);
        }
        if (this.gunPosition.getPosition() == 1.0f) {
            this.gunElevation.step((float)time);
        }
        this.shootDuration = Math.max(this.shootDuration - (float)time, 0.0f);
    }
}

