/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.waterturbine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.waterturbine.WaterTurbineContainer;
import mods.eln.transparentnode.waterturbine.WaterTurbineDescriptor;
import mods.eln.transparentnode.waterturbine.WaterTurbineSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class WaterTurbineElement
extends TransparentNodeElement {
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    PowerSource powerSource = new PowerSource("powerSource", (State)this.positiveLoad);
    WaterTurbineSlowProcess slowProcess = new WaterTurbineSlowProcess(this);
    WaterTurbineDescriptor descriptor;
    Coordonate waterCoord;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(0, 64, this);

    public WaterTurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (WaterTurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerSource);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 2.0, 2.0));
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return null;
    }

    @Override
    public String thermoMeterString(Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.setPhysicalValue();
        this.waterCoord = this.descriptor.getWaterCoordonate(this.node.coordonate.world());
        this.waterCoord.applyTransformation(this.front, this.node.coordonate);
        this.powerSource.setUmax(this.descriptor.maxVoltage);
        this.powerSource.setImax(this.descriptor.nominalPower * 5.0 / this.descriptor.maxVoltage);
        this.connect();
    }

    private void setPhysicalValue() {
        this.descriptor.cable.applyTo(this.positiveLoad);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new WaterTurbineContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)(this.powerSource.getP() / this.descriptor.nominalPower));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        DecimalFormat format = new DecimalFormat("#.##");
        wailaList.put("Voltage", format.format(this.positiveLoad.getU()));
        return wailaList;
    }
}

