/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.waterturbine;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.waterturbine.WaterTurbineDescriptor;
import mods.eln.transparentnode.waterturbine.WaterTurbineGuiDraw;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class WaterTurbineRender
extends TransparentNodeElementRender {
    Coordonate waterCoord;
    Coordonate waterCoordRight;
    RcInterpolator powerFactorFilter = new RcInterpolator(1.0f);
    RcInterpolator dirFilter = new RcInterpolator(0.5f);
    WaterTurbineDescriptor descriptor;
    float alpha = (float)(Math.random() * 360.0);
    boolean soundPlaying = false;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(0, 64, this);
    private float water;
    private float powerFactor;

    public WaterTurbineRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (WaterTurbineDescriptor)descriptor;
    }

    @Override
    public void draw() {
        this.front.glRotateXnRef();
        this.descriptor.draw(this.alpha);
    }

    @Override
    public void refresh(float deltaT) {
        float flowDir;
        float f = flowDir = this.waterCoord.getMeta() > this.waterCoordRight.getMeta() ? 1.0f : -1.0f;
        if (!Utils.isWater(this.waterCoord)) {
            flowDir = 0.0f;
        }
        this.dirFilter.setTarget(flowDir);
        this.dirFilter.step(deltaT);
        this.powerFactorFilter.setTarget((float)((double)this.dirFilter.get() * Math.sqrt(this.powerFactor)));
        this.powerFactorFilter.step(deltaT);
        float alphaN_1 = this.alpha;
        this.alpha += deltaT * this.descriptor.speed * this.powerFactorFilter.get();
        if (this.alpha > 360.0f) {
            this.alpha -= 360.0f;
        }
        if (this.alpha < 0.0f) {
            this.alpha += 360.0f;
        }
        if ((int)(this.alpha / 45.0f) != (int)(alphaN_1 / 45.0f) && !this.soundPlaying) {
            Coordonate coord = this.coordonate();
            this.play(new SoundCommand(this.descriptor.soundName).mulVolume(this.descriptor.nominalVolume * (0.007f + 0.2f * this.powerFactorFilter.get() * this.powerFactorFilter.get()), 1.1f));
            this.soundPlaying = true;
        } else {
            this.soundPlaying = false;
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new WaterTurbineGuiDraw(player, (IInventory)this.inventory, this);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.powerFactor = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waterCoord = this.descriptor.getWaterCoordonate(this.tileEntity.func_145831_w());
        this.waterCoord.setWorld(this.tileEntity.func_145831_w());
        this.waterCoord.applyTransformation(this.front, this.coordonate());
        this.waterCoordRight = new Coordonate(this.waterCoord);
        this.waterCoordRight.setWorld(this.tileEntity.func_145831_w());
        this.waterCoordRight.move(this.front.right());
    }
}

