/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.waterturbine;

import mods.eln.misc.INBTTReady;
import mods.eln.misc.RcRcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.waterturbine.WaterTurbineDescriptor;
import mods.eln.transparentnode.waterturbine.WaterTurbineElement;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;

public class WaterTurbineSlowProcess
implements IProcess,
INBTTReady {
    WaterTurbineElement turbine;
    double refreshTimeout = 0.0;
    double refreshPeriode = 0.2;
    RcRcInterpolator filter = new RcRcInterpolator(2.0f, 2.0f);

    public WaterTurbineSlowProcess(WaterTurbineElement turbine) {
        this.turbine = turbine;
    }

    @Override
    public void process(double time) {
        WaterTurbineDescriptor d = this.turbine.descriptor;
        this.refreshTimeout -= time;
        if (this.refreshTimeout < 0.0) {
            this.refreshTimeout = this.refreshPeriode;
            double waterFactor = this.getWaterFactor();
            if (waterFactor < 0.0) {
                this.filter.setValue((float)((double)this.filter.get() * (1.0 - 0.5 * time)));
            } else {
                this.filter.setTarget((float)(waterFactor * d.nominalPower));
                this.filter.step((float)time);
            }
            this.turbine.powerSource.setP(this.filter.get());
        }
    }

    double getWaterFactor() {
        double time = 0.0;
        if (this.turbine.waterCoord.getBlockExist()) {
            Block block = this.turbine.waterCoord.getBlock();
            int blockMeta = this.turbine.waterCoord.getMeta();
            if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                return -1.0;
            }
            if (blockMeta == 0) {
                return 0.0;
            }
            time = Utils.getWorldTime(this.turbine.world());
        }
        double timeFactor = 1.0 + 0.2 * Math.sin((time - 0.2) * Math.PI * 2.0);
        double weatherFactor = 1.0 + Utils.getWeatherNoLoad(this.turbine.coordonate().dimention) * 2.0;
        return timeFactor * weatherFactor;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.filter.readFromNBT(nbt, str + "filter");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        this.filter.writeToNBT(nbt, str + "filter");
    }
}

