/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.windturbine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.windturbine.WindTurbineDescriptor;
import mods.eln.transparentnode.windturbine.WindTurbineSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class WindTurbineElement
extends TransparentNodeElement {
    private final NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    final PowerSource powerSource = new PowerSource("powerSource", (State)this.positiveLoad);
    private final WindTurbineSlowProcess slowProcess = new WindTurbineSlowProcess("slowProcess", this);
    final WindTurbineDescriptor descriptor;
    private Direction cableFront = Direction.ZP;

    public WindTurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (WindTurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerSource);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 4.0, 4.0));
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.cableFront.left()) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(Direction side, LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.cableFront.left()) {
            return 1;
        }
        if (side == this.cableFront.right() && !this.grounded) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString(Direction side) {
        return null;
    }

    @Override
    public String thermoMeterString(Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.setPhysicalValue();
        this.powerSource.setImax(this.descriptor.nominalPower * 5.0 / this.descriptor.maxVoltage);
        this.connect();
    }

    private void setPhysicalValue() {
        this.descriptor.cable.applyTo(this.positiveLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.cableFront = this.cableFront.right();
            this.reconnect();
        }
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)this.slowProcess.getWind());
            stream.writeFloat((float)(this.powerSource.getP() / this.descriptor.nominalPower));
            this.node.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.cableFront.writeToNBT(nbt, "cableFront");
        Utils.println((Object)this.cableFront);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.cableFront = Direction.readFromNBT(nbt, "cableFront");
        Utils.println((Object)this.cableFront);
    }

    @Override
    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        DecimalFormat format = new DecimalFormat("#.##");
        wailaList.put("Voltage", format.format(this.getElectricalLoad(this.cableFront.left(), LRDU.Down).getU()));
        return wailaList;
    }
}

