/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.windturbine;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.RcInterpolator;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.windturbine.WindTurbineDescriptor;

public class WindTurbineRender
extends TransparentNodeElementRender {
    private float haloBlink_OnTime = 0.5f;
    private float haloBlink_OffTime = 2.5f;
    private boolean soundPlaying = false;
    private float haloBlinkCounter = 0.0f;
    private boolean haloState = false;
    private CableRenderType renderPreProcess;
    private final LRDUMask eConn = new LRDUMask();
    private final RcInterpolator powerFactorFilter = new RcInterpolator(2.0f);
    private final WindTurbineDescriptor descriptor;
    private float alpha = (float)(Math.random() * 360.0);
    private final TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(0, 64, this);
    private float wind;
    private float powerFactor;

    public WindTurbineRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (WindTurbineDescriptor)descriptor;
        Random rand = new Random();
        this.haloBlinkCounter = rand.nextFloat() * this.haloBlink_OffTime;
        this.haloBlink_OffTime += rand.nextFloat() * this.haloBlink_OffTime / 15.0f;
        this.haloBlink_OnTime += rand.nextFloat() * this.haloBlink_OnTime / 15.0f;
    }

    @Override
    public void draw() {
        this.renderPreProcess = this.drawCable(Direction.YN, this.descriptor.cable.render, this.eConn, this.renderPreProcess);
        this.front.glRotateXnRef();
        this.descriptor.draw(this.alpha, this.haloState);
    }

    @Override
    public void refresh(float deltaT) {
        this.powerFactorFilter.setTarget(this.powerFactor);
        this.powerFactorFilter.step(deltaT);
        float alphaN_1 = this.alpha;
        this.alpha = (float)((double)this.alpha + (double)deltaT * this.descriptor.speed * Math.sqrt(this.powerFactorFilter.get()));
        if (this.alpha > 360.0f) {
            this.alpha -= 360.0f;
        }
        if (this.alpha % 120.0f > 45.0f && alphaN_1 % 120.0f <= 45.0f && !this.soundPlaying) {
            this.play(new SoundCommand(this.descriptor.soundName).mediumRange().mulBlockAttenuation(2.0).applyNominalVolume(this.descriptor.nominalVolume).mulVolume(0.007f + 1.0f * (float)Math.sqrt(this.powerFactorFilter.get()), 1.0f + (float)Math.sqrt(this.powerFactorFilter.get()) / 1.3f));
            this.soundPlaying = true;
        } else {
            this.soundPlaying = false;
        }
        this.haloBlinkCounter += deltaT;
        if (!this.haloState) {
            if (this.haloBlinkCounter > this.haloBlink_OffTime) {
                this.haloBlinkCounter -= this.haloBlink_OffTime;
                this.haloState = true;
            }
        } else if (this.haloBlinkCounter > this.haloBlink_OnTime) {
            this.haloBlinkCounter -= this.haloBlink_OnTime;
            this.haloState = false;
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.wind = stream.readFloat();
            this.powerFactor = stream.readFloat();
            this.eConn.deserialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

