/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.wiki;

import java.util.ArrayList;
import java.util.List;
import mods.eln.gui.GuiLabel;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.misc.Recipe;
import mods.eln.misc.RecipesList;
import mods.eln.misc.Utils;
import mods.eln.wiki.Default;
import mods.eln.wiki.GuiItemStack;
import mods.eln.wiki.GuiVerticalExtender;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class ItemDefault
extends Default {
    private ItemStack stack;
    private GuiScreen previewScreen;
    GuiItemStack self;

    public ItemDefault(ItemStack stack, GuiScreen previewScreen) {
        super(previewScreen);
        this.stack = stack;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        try {
            if (this.stack == null) {
                return;
            }
            int y = 6;
            Object desc = Utils.getItemObject(this.stack);
            IPlugIn plugIn = null;
            if (desc instanceof IPlugIn) {
                plugIn = (IPlugIn)desc;
            }
            this.self = new GuiItemStack(6, y, this.stack, this.helper);
            this.extender.add(this.self);
            this.extender.add(new GuiLabel(27, y + 3, this.stack.func_82833_r()));
            y += 24;
            if (plugIn != null) {
                y = plugIn.top(y, this.extender, this.stack);
            }
            ArrayList<IRecipe> recipeOutList = new ArrayList<IRecipe>();
            ArrayList<IRecipe> recipeInList = new ArrayList<IRecipe>();
            if (this.stack != null) {
                List list = CraftingManager.func_77594_a().func_77592_b();
                for (Object o : list) {
                    try {
                        if (!(o instanceof IRecipe)) continue;
                        IRecipe iRecipe = (IRecipe)o;
                        ItemStack out = iRecipe.func_77571_b();
                        if (out != null && out.func_77973_b() == this.stack.func_77973_b() && out.func_77960_j() == this.stack.func_77960_j()) {
                            recipeOutList.add(iRecipe);
                        }
                        for (ItemStack rStack : Utils.getRecipeInputs(iRecipe)) {
                            if (rStack == null || rStack.func_77973_b() != this.stack.func_77973_b() || rStack.func_77960_j() != this.stack.func_77960_j()) continue;
                            recipeInList.add(iRecipe);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            int counter = 0;
            if (recipeOutList.isEmpty()) {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Cannot be crafted!", new Object[0])));
                y += 12;
            } else {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Recipe:", new Object[0])));
                y += 12;
                counter = -1;
                for (IRecipe r : recipeOutList) {
                    ItemStack[][] itemStackArray;
                    if (counter == 0) {
                        y += 60;
                    }
                    if (counter == -1) {
                        counter = 0;
                    }
                    if ((itemStackArray = Utils.getItemStackGrid(r)) == null) continue;
                    for (int idx2 = 0; idx2 < 3; ++idx2) {
                        for (int idx = 0; idx < 3; ++idx) {
                            GuiItemStack gui = new GuiItemStack(idx * 18 + 6 + counter * 60, idx2 * 18 + y, itemStackArray[idx2][idx], this.helper);
                            this.extender.add(gui);
                        }
                    }
                    counter = (counter + 1) % 3;
                }
                y += 70;
            }
            if (recipeInList.isEmpty()) {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Is not a crafting material!", new Object[0])));
                y += 12;
            } else {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Can be used to craft:", new Object[0])));
                y += 12;
                counter = -1;
                for (IRecipe r : recipeInList) {
                    ItemStack[][] itemStackArray;
                    if (counter == 0) {
                        y += 60;
                    }
                    if (counter == -1) {
                        counter = 0;
                    }
                    if ((itemStackArray = Utils.getItemStackGrid(r)) == null) continue;
                    for (int idx2 = 0; idx2 < 3; ++idx2) {
                        for (int idx = 0; idx < 3; ++idx) {
                            ItemStack rStack;
                            rStack = itemStackArray[idx2][idx];
                            GuiItemStack gui = new GuiItemStack(idx * 18 + 6 + counter * 105, idx2 * 18 + y, rStack, this.helper);
                            this.extender.add(gui);
                        }
                    }
                    GuiItemStack gui = new GuiItemStack(69 + counter * 105, 18 + y, r.func_77571_b(), this.helper);
                    this.extender.add(gui);
                    counter = (counter + 1) % 2;
                }
                y += 70;
            }
            counter = -1;
            ArrayList<Recipe> list = RecipesList.getGlobalRecipeWithInput(this.stack);
            if (!list.isEmpty()) {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Can create:", new Object[0])));
                y += 12;
                for (Recipe recipe : list) {
                    if (counter == 0) {
                        y += 23;
                    }
                    if (counter == -1) {
                        counter = 0;
                    }
                    int x = 6 + counter * 60;
                    this.extender.add(new GuiItemStack(x, y, recipe.input, this.helper));
                    x += 36;
                    for (ItemStack m : recipe.machineList) {
                        this.extender.add(new GuiItemStack(x, y, m, this.helper));
                        x += 18;
                    }
                    this.extender.add(new GuiItemStack(x += 18, y, recipe.getOutputCopy()[0], this.helper));
                    this.extender.add(new GuiLabel(x += 22, y + 4, I18N.tr("Cost %1$J", recipe.energy)));
                    counter = (counter + 1) % 1;
                }
                y += 23;
            }
            counter = -1;
            list = RecipesList.getGlobalRecipeWithOutput(this.stack);
            if (!list.isEmpty()) {
                this.extender.add(new GuiLabel(6, y, I18N.tr("Created by:", new Object[0])));
                y += 12;
                for (Recipe recipe : list) {
                    if (counter == 0) {
                        y += 23;
                    }
                    if (counter == -1) {
                        counter = 0;
                    }
                    int x = 6 + counter * 60;
                    this.extender.add(new GuiItemStack(x, y, recipe.input, this.helper));
                    x += 36;
                    for (ItemStack m : recipe.machineList) {
                        this.extender.add(new GuiItemStack(x, y, m, this.helper));
                        x += 18;
                    }
                    this.extender.add(new GuiItemStack(x += 18, y, recipe.getOutputCopy()[0], this.helper));
                    this.extender.add(new GuiLabel(x += 22, y + 4, I18N.tr("Cost %1$J", recipe.energy)));
                    counter = (counter + 1) % 1;
                }
                y += 23;
            }
            if (plugIn != null) {
                int n = plugIn.bottom(y, this.extender, this.stack);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
    }

    public static interface IPlugIn {
        public int top(int var1, GuiVerticalExtender var2, ItemStack var3);

        public int bottom(int var1, GuiVerticalExtender var2, ItemStack var3);
    }
}

