/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.SelectEndermanEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class SlenderHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double distanceFactor = 0.25;
    @CreativeConfig
    public VisualType slender = new VisualTypeOverlay("slender", 50);
    public Visual slenderVisual;
    public Class mutantEnderman = this.loadMutantEnderman();

    private Class loadMutantEnderman() {
        try {
            return Class.forName("chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void tick(@Nullable EntityPlayer player) {
        if (this.slenderVisual == null) {
            this.slenderVisual = new Visual(this.slender, 0);
            VisualManager.add(this.slenderVisual);
        }
        float intensity = (float)this.defaultIntensity;
        if (player != null) {
            float modifier = 0.0f;
            double d0 = player.field_70165_t;
            double d1 = player.field_70163_u;
            double d2 = player.field_70161_v;
            AxisAlignedBB box = player.func_174813_aQ();
            box = box.func_72314_b(16.0, 16.0, 16.0);
            SelectEndermanEvent event = new SelectEndermanEvent(x -> true);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                Double distance = null;
                for (EntityEnderman mob : player.field_70170_p.func_175647_a(EntityEnderman.class, box, null)) {
                    if (mob == null || !event.predicate.test(mob)) continue;
                    if (distance == null) {
                        distance = Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0));
                        continue;
                    }
                    distance = Math.min(distance, Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0)));
                }
                if (this.mutantEnderman != null) {
                    for (EntityEnderman mob : player.field_70170_p.func_175647_a(this.mutantEnderman, box, null)) {
                        if (mob == null) continue;
                        if (distance == null) {
                            distance = Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0));
                            continue;
                        }
                        distance = Math.min(distance, Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0)));
                    }
                }
                if (distance != null) {
                    float distModifier = (float)Math.pow(1.0 / distance / 3.0, 2.0);
                    if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                        modifier = 3.5f;
                    }
                    intensity = (float)Math.max(this.defaultIntensity, Math.min(this.maxIntensity, this.distanceFactor * (double)modifier));
                }
            }
        }
        this.slenderVisual.opacity = intensity;
    }
}

