/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.client.gui;

import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.IConfigElement;
import funwayguy.esm.core.ESM;
import funwayguy.esm.core.ESM_Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;

public class ESMGuiConfig
extends GuiConfig {
    public static ArrayList<Configuration> tempConfigs = new ArrayList();

    public ESMGuiConfig(GuiScreen parent) {
        super(parent, ESMGuiConfig.GetConfigElements(), "ESM", false, false, "Epic Siege Mod");
    }

    private static List<IConfigElement> GetConfigElements() {
        tempConfigs.clear();
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Default Configuration", "", ESMGuiConfig.getConfigElements(ESM_Settings.defConfig.getConfigFile())));
        String prefix = "";
        if (ESM.proxy.isClient()) {
            prefix = "saves/";
        }
        ArrayList<File> worldOptions = new ArrayList<File>();
        for (File file : new File(prefix).listFiles()) {
            if (!file.isDirectory() || !new File(file, "ESM_Options.cfg").exists()) continue;
            worldOptions.add(new File(file, "ESM_Options.cfg"));
        }
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("World Configurations", "epicsiegemod.config.world", ESMGuiConfig.getConfigElements(worldOptions.toArray(new File[0]))));
        return list;
    }

    private static List<IConfigElement> getConfigElements(File file) {
        Configuration config = new Configuration(file, true);
        tempConfigs.add(config);
        Iterator iterator = config.getCategoryNames().iterator();
        ArrayList<IConfigElement> customConfigList = new ArrayList<IConfigElement>();
        while (iterator.hasNext()) {
            ConfigCategory category = config.getCategory((String)iterator.next());
            if (category.isChild()) continue;
            customConfigList.add((IConfigElement)new ConfigElement(category));
        }
        return customConfigList;
    }

    private static List<IConfigElement> getConfigElements(File[] files) {
        ArrayList<IConfigElement> customFileList = new ArrayList<IConfigElement>();
        for (File entry : files) {
            Configuration config = new Configuration(entry, true);
            tempConfigs.add(config);
            Iterator iterator = config.getCategoryNames().iterator();
            ArrayList<ConfigElement> customConfigList = new ArrayList<ConfigElement>();
            while (iterator.hasNext()) {
                ConfigCategory category = config.getCategory((String)iterator.next());
                if (category.isChild()) continue;
                customConfigList.add(new ConfigElement(category));
            }
            customFileList.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(entry.getParentFile().getName(), "null", customConfigList));
        }
        return customFileList;
    }
}

