/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.core;

import funwayguy.esm.core.ESM;
import funwayguy.esm.core.ESM_Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ESM_Settings {
    public static final String Version = "10.0.103";
    public static final String ID = "ESM";
    public static final String Channel = "ESM";
    public static final String Name = "Epic Siege Mod";
    public static final String Proxy = "funwayguy.esm.core.proxies";
    public static int Awareness;
    public static boolean Xray;
    public static int TargetCap;
    public static boolean VillagerTarget;
    public static boolean Apocalypse;
    public static boolean Chaos;
    public static boolean AllowSleep;
    public static boolean QuickPathing;
    public static int ResistanceCoolDown;
    public static boolean keepLoaded;
    public static boolean moreSpawning;
    public static boolean forcePath;
    public static boolean CreeperBreaching;
    public static boolean CreeperNapalm;
    public static boolean CreeperPowered;
    public static int CreeperPoweredRarity;
    public static boolean BlazeSpawn;
    public static int BlazeRarity;
    public static int BlazeFireballs;
    public static ArrayList<Integer> BlazeDimensionBlacklist;
    public static boolean GhastSpawn;
    public static int GhastRarity;
    public static double GhastFireDelay;
    public static boolean GhastBreaching;
    public static double GhastFireDist;
    public static ArrayList<Integer> GhastDimensionBlacklist;
    public static int SkeletonDistance;
    public static int SkeletonAccuracy;
    public static boolean ZombieInfectious;
    public static boolean ZombieDiggers;
    public static boolean ZombieDiggerTools;
    public static boolean ZombieTraps;
    public static int ZombiePillaring;
    public static ArrayList<String> ZombieGriefBlocks;
    public static ArrayList<String> ZombieDigBlacklist;
    public static String EndermanMode;
    public static boolean EndermanPlayerTele;
    public static int SpiderWebChance;
    public static ArrayList<Integer> MobBombs;
    public static int MobBombRarity;
    public static boolean MobBombAll;
    public static boolean WitherSkeletons;
    public static int WitherSkeletonRarity;
    public static int PotionMobs;
    public static int[] PotionMobEffects;
    public static boolean attackEvasion;
    public static boolean NewEnd;
    public static boolean NewHell;
    public static boolean SpawnForts;
    public static int fortRarity;
    public static int fortDistance;
    public static ArrayList<Integer> fortDimensions;
    public static boolean fallFromEnd;
    public static ArrayList<String> fortSpawners;
    public static ArrayList<String> fortDB;
    public static WorldServer[] currentWorlds;
    public static File worldDir;
    public static boolean ambiguous_AI;
    public static Configuration defConfig;
    public static ArrayList<Integer> AIExempt;

    public static void LoadMainConfig(File file) {
        Configuration config = new Configuration(file);
        ESM.log.log(Level.INFO, "Loading ESM Global Config");
        defConfig = config;
        config.load();
        config.setCategoryComment("World", "For the main list of options please refer to the ESM_Options.cfg file in your world directory.");
        NewEnd = config.get("World", "Use New End", false).getBoolean(false);
        NewHell = config.get("World", "Use New Nether", false).getBoolean(false);
        config.save();
        ESM_Settings.ResetToDefault();
    }

    public static void ResetToDefault() {
        int[] tmpFD;
        if (defConfig == null) {
            ESM.log.log(Level.ERROR, "Failed to reset options to default! Global default is null");
            return;
        }
        defConfig.load();
        Awareness = defConfig.get("Main", "Awareness Radius", 64).getInt(64);
        Xray = defConfig.get("Main", "Xray Mobs", true).getBoolean(true);
        TargetCap = defConfig.get("Main", "Pathing Cap", 16).getInt(16);
        VillagerTarget = defConfig.get("Main", "Villager Targeting", true).getBoolean(true);
        Apocalypse = defConfig.get("Main", "Apocalypse Mode", false).getBoolean(false);
        Chaos = defConfig.get("Main", "Chaos Mode", false).getBoolean(false);
        AllowSleep = defConfig.get("Main", "Allow Sleep", false).getBoolean(false);
        ambiguous_AI = defConfig.get("Main", "Ambiguous AI", true, "If set to true, ESM will not check whether the entity is a mob or not when setting up new AI").getBoolean(true);
        QuickPathing = defConfig.get("Main", "Quick Pathing", false, "If set to fales, mobs can use much longer routes to get to their target").getBoolean(false);
        ResistanceCoolDown = defConfig.get("Main", "Resistance Cooldown", 200, "The amount of ticks of resistance given to the player after changing dimensions").getInt(200);
        keepLoaded = defConfig.get("Main", "Keep Loaded", false, "Keeps mobs with an active target from despawning. Can causes issues with chunk loading/unloading").getBoolean(false);
        moreSpawning = defConfig.get("Main", "More Spawning", true, "Reduces spawning safe zone from 24 blocks to 8 and makes mobs require only basic conditions to spawn").getBoolean(true);
        forcePath = defConfig.get("Main", "Force Non-AI Pathing", false, "Forces non pathing mobs to attack from further away. Can cause additional lag").getBoolean(false);
        int[] tmpAIE = defConfig.get("Main", "AI Exempt Mob IDs", new int[0]).getIntList();
        AIExempt = new ArrayList();
        for (int i : tmpAIE) {
            AIExempt.add(i);
        }
        CreeperBreaching = defConfig.get("Creeper", "Breaching", true).getBoolean(true);
        CreeperNapalm = defConfig.get("Creeper", "Napalm", true).getBoolean(true);
        CreeperPowered = defConfig.get("Creeper", "Powered", true).getBoolean(true);
        CreeperPoweredRarity = defConfig.get("Creeper", "Powered Rarity", 9).getInt(9);
        SkeletonAccuracy = defConfig.get("Skeleton", "Arrow Error", 0).getInt(0);
        SkeletonDistance = defConfig.get("Skeleton", "Fire Distance", 64).getInt(64);
        ZombieInfectious = defConfig.get("Zombie", "Infectious", true).getBoolean(true);
        ZombieDiggers = defConfig.get("Zombie", "Diggers", true).getBoolean(true);
        ZombieDiggerTools = defConfig.get("Zombie", "Need Required Tools", true).getBoolean(true);
        ZombieTraps = defConfig.get("Zombie", "Zombies Build Traps", true).getBoolean(true);
        ZombiePillaring = defConfig.get("Zombie", "Pillaring Blocks", 64, "How many blocks to give zombies to pillar up with").getInt(64);
        String[] defGrief = new String[]{"minecraft:furnace", "minecraft:crafting_table", "minecraft:melon_stem", "minecraft:pumpkin_stem", "minecraft:fence_gate", "minecraft:melon_block", "minecraft:pumpkin", "minecraft:glass", "minecraft:glass_pane", "minecraft:stained_glass", "minecraft:stained_glass_pane", "minecraft:carrots", "minecraft:potatoes", "minecraft:brewing_stand", "minecraft:enchanting_table", "minecraft:cake", "minecraft:ladder", "minecraft:wooden_door", "minecraft:farmland", "minecraft:bookshelf", "minecraft:sapling", "minecraft:bed", "minecraft:fence"};
        ZombieGriefBlocks = new ArrayList<String>(Arrays.asList(defConfig.get("Zombie", "General Griefable Blocks", defGrief, "What blocks will be targeted for destruction when not attacking players (Does not affect general digging, light sources are included by default, add ':#' for metadata e.g. 'minecraft:wool:1')").getStringList()));
        ZombieDigBlacklist = new ArrayList<String>(Arrays.asList(defConfig.get("Zombie", "General Griefable Blocks", new String[0], "Blacklisted blocks for digging (Add ':#' for metadata e.g. 'minecraft:wool:1')").getStringList()));
        BlazeSpawn = defConfig.get("Blaze", "Spawn", true).getBoolean(true);
        BlazeRarity = defConfig.get("Blaze", "Rarity", 9).getInt(9);
        BlazeFireballs = defConfig.get("Blaze", "Fireballs", 9).getInt(9);
        int[] tmpBDB = defConfig.get("Blaze", "Dimension Blacklist", new int[0]).getIntList();
        BlazeDimensionBlacklist = new ArrayList();
        for (int i : tmpBDB) {
            BlazeDimensionBlacklist.add(i);
        }
        GhastSpawn = defConfig.get("Ghast", "Spawn", false).getBoolean(false);
        GhastRarity = defConfig.get("Ghast", "Rarity", 9).getInt(9);
        GhastFireDelay = defConfig.get("Ghast", "Fire Delay", 1.0).getDouble(1.0);
        GhastBreaching = defConfig.get("Ghast", "Breaching", true).getBoolean(true);
        GhastFireDist = defConfig.get("Ghast", "Fire Distance", 64.0).getDouble(64.0);
        int[] tmpGDB = defConfig.get("Ghast", "Dimension Blacklist", new int[0]).getIntList();
        GhastDimensionBlacklist = new ArrayList();
        for (int i : tmpGDB) {
            GhastDimensionBlacklist.add(i);
        }
        EndermanMode = defConfig.get("Enderman", "Mode", "Slender", "Valid Endermen Modes (Slender, Normal)").getString();
        EndermanPlayerTele = defConfig.get("Enderman", "Player Teleport", true).getBoolean(true);
        SpiderWebChance = MathHelper.func_76125_a((int)defConfig.get("Spider", "Webbing Chance (0-100)", 25).getInt(25), (int)0, (int)100);
        int[] tmp = defConfig.get("Advanced Mobs", "Mob Bombs", new int[]{52}).getIntList();
        MobBombs = new ArrayList();
        for (int id : tmp) {
            MobBombs.add(id);
        }
        MobBombRarity = defConfig.get("Advanced Mobs", "Mob Bomb Rarity", 9).getInt(9);
        MobBombAll = defConfig.get("Advanced Mobs", "Mob Bomb All", true, "Skip the Mob Bomb list and allow everything!").getBoolean(true);
        WitherSkeletons = defConfig.get("Advanced Mobs", "Wither Skeletons", true).getBoolean(true);
        WitherSkeletonRarity = defConfig.get("Advanced Mobs", "Wither Skeleton Rarity", 9).getInt(9);
        PotionMobs = defConfig.get("Advanced Mobs", "Potion Buff Chance (0-100)", 1).getInt(1);
        PotionMobEffects = defConfig.get("Advanced Mobs", "Potion Buff List", new int[]{14, 12, 5, 1}, "List of all the valid potion IDs a mob can spawn with. Amplifier is always x1").getIntList();
        attackEvasion = defConfig.get("Advanced Mobs", "Attack Evasion", true).getBoolean(true);
        SpawnForts = defConfig.get("World", "Spawn Forts", true).getBoolean(true);
        fortRarity = defConfig.get("World", "Fort Rarity", 100).getInt(100);
        fortDistance = defConfig.get("World", "Fort Distance", 1024).getInt(1024);
        String[] defSpawn = new String[]{"Zombie", "Creeer", "Skeleton", "CaveSpider", "Silverfish", "Spider", "Slime", "Witch"};
        fortSpawners = new ArrayList<String>(Arrays.asList(defConfig.get("World", "Fort Spawner Types", defSpawn).getStringList()));
        fallFromEnd = defConfig.get("World", "Fall From End", true, "Whether the player should fall into the overworld from the new End").getBoolean(true);
        for (int dimID : tmpFD = defConfig.get("World", "Fort Dimensions", new int[]{0}).getIntList()) {
            fortDimensions.add(dimID);
        }
        defConfig.save();
    }

    public static void LoadWorldConfig() {
        int i;
        int i22;
        if (worldDir == null) {
            ESM.log.log(Level.ERROR, "Failed to load world configs! Directory is null");
            return;
        }
        ESM_Settings.ResetToDefault();
        File conFile = new File(worldDir, "ESM_Options.cfg");
        if (!conFile.exists()) {
            try {
                conFile.createNewFile();
            }
            catch (Exception e) {
                ESM.log.log(Level.INFO, "Failed to load ESM Config: " + conFile.getPath(), (Throwable)e);
                return;
            }
        }
        Configuration config = new Configuration(conFile, true);
        ESM.log.log(Level.INFO, "Loading ESM Config: " + conFile.getPath());
        config.load();
        int[] tmpAIE = new int[AIExempt.size()];
        for (int i3 = 0; i3 < AIExempt.size(); ++i3) {
            tmpAIE[i3] = AIExempt.get(i3);
        }
        tmpAIE = config.get("Main", "AI Exempt Mob IDs", tmpAIE).getIntList();
        AIExempt = new ArrayList();
        for (int i22 : tmpAIE) {
            AIExempt.add(i22);
        }
        Awareness = config.get("Main", "Awareness Radius", Awareness).getInt(Awareness);
        Xray = config.get("Main", "Xray Mobs", Xray).getBoolean(Xray);
        TargetCap = config.get("Main", "Pathing Cap", TargetCap).getInt(TargetCap);
        VillagerTarget = config.get("Main", "Villager Targeting", VillagerTarget).getBoolean(VillagerTarget);
        Apocalypse = config.get("Main", "Apocalypse Mode", Apocalypse).getBoolean(Apocalypse);
        Chaos = config.get("Main", "Chaos Mode", Chaos).getBoolean(Chaos);
        AllowSleep = config.get("Main", "Allow Sleep", AllowSleep).getBoolean(AllowSleep);
        ambiguous_AI = config.get("Main", "Ambiguous AI", ambiguous_AI, "If set to true, ESM will not check whether the entity is a mob or not when setting up new AI").getBoolean(ambiguous_AI);
        QuickPathing = config.get("Main", "Quick Pathing", QuickPathing, "If set to fales, mobs can use much longer routes to get to their target").getBoolean(QuickPathing);
        ResistanceCoolDown = config.get("Main", "Resistance Cooldown", ResistanceCoolDown, "The amount of ticks of resistance given to the player after changing dimensions").getInt(ResistanceCoolDown);
        keepLoaded = config.get("Main", "Keep Loaded", false, "Keeps mobs with an active target from despawning. Can causes issues with chunk loading/unloading").getBoolean(false);
        moreSpawning = config.get("Main", "More Spawning", true, "Reduces spawning safe zone from 24 blocks to 8 and makes mobs require only basic conditions to spawn").getBoolean(true);
        forcePath = config.get("Main", "Force Non-AI Pathing", false, "Forces non pathing mobs to attack from further away. Can cause additional lag").getBoolean(false);
        CreeperBreaching = config.get("Creeper", "Breaching", CreeperBreaching).getBoolean(CreeperBreaching);
        CreeperNapalm = config.get("Creeper", "Napalm", CreeperNapalm).getBoolean(CreeperNapalm);
        CreeperPowered = config.get("Creeper", "Powered", CreeperPowered).getBoolean(CreeperPowered);
        CreeperPoweredRarity = config.get("Creeper", "Powered Rarity", CreeperPoweredRarity).getInt(CreeperPoweredRarity);
        SkeletonAccuracy = config.get("Skeleton", "Arrow Error", SkeletonAccuracy).getInt(SkeletonAccuracy);
        SkeletonDistance = config.get("Skeleton", "Fire Distance", SkeletonDistance).getInt(SkeletonDistance);
        ZombieInfectious = config.get("Zombie", "Infectious", ZombieInfectious).getBoolean(ZombieInfectious);
        ZombieDiggers = config.get("Zombie", "Diggers", ZombieDiggers).getBoolean(ZombieDiggers);
        ZombieDiggerTools = config.get("Zombie", "Need Required Tools", ZombieDiggerTools).getBoolean(ZombieDiggerTools);
        ZombieTraps = config.get("Zombie", "Zombies Build Traps", ZombieTraps).getBoolean(ZombieTraps);
        ZombiePillaring = config.get("Zombie", "Pillaring Blocks", ZombiePillaring, "How many blocks to give zombies to pillar up with").getInt(ZombiePillaring);
        ZombieGriefBlocks = new ArrayList<String>(Arrays.asList(config.get("Zombie", "General Griefable Blocks", ZombieGriefBlocks.toArray(new String[0]), "What blocks will be targeted for destruction when not attacking players (Does not affect general digging, light sources are included by default, add ':#' for metadata e.g. 'minecraft:wool:1')").getStringList()));
        ZombieDigBlacklist = new ArrayList<String>(Arrays.asList(config.get("Zombie", "General Griefable Blocks", ZombieDigBlacklist.toArray(new String[0]), "Blacklisted blocks for digging (Add ':#' for metadata e.g. 'minecraft:wool:1')").getStringList()));
        BlazeSpawn = config.get("Blaze", "Spawn", BlazeSpawn).getBoolean(BlazeSpawn);
        BlazeRarity = config.get("Blaze", "Rarity", BlazeRarity).getInt(BlazeRarity);
        BlazeFireballs = config.get("Blaze", "Fireballs", BlazeFireballs).getInt(BlazeFireballs);
        int[] tmpBDB = new int[BlazeDimensionBlacklist.size()];
        for (int i4 = 0; i4 < BlazeDimensionBlacklist.size(); ++i4) {
            tmpBDB[i4] = BlazeDimensionBlacklist.get(i4);
        }
        tmpBDB = config.get("Blaze", "Dimension Blacklist", tmpBDB).getIntList();
        BlazeDimensionBlacklist = new ArrayList();
        for (int i5 : tmpBDB) {
            BlazeDimensionBlacklist.add(i5);
        }
        GhastSpawn = config.get("Ghast", "Spawn", GhastSpawn).getBoolean(GhastSpawn);
        GhastRarity = config.get("Ghast", "Rarity", GhastRarity).getInt(GhastRarity);
        GhastFireDelay = config.get("Ghast", "Fire Delay", GhastFireDelay).getDouble(GhastFireDelay);
        GhastBreaching = config.get("Ghast", "Breaching", GhastBreaching).getBoolean(GhastBreaching);
        GhastFireDist = config.get("Ghast", "Fire Distance", GhastFireDist).getDouble(GhastFireDist);
        int[] tmpGDB = new int[GhastDimensionBlacklist.size()];
        for (int i6 = 0; i6 < GhastDimensionBlacklist.size(); ++i6) {
            tmpGDB[i6] = GhastDimensionBlacklist.get(i6);
        }
        tmpGDB = config.get("Ghast", "Dimension Blacklist", tmpGDB).getIntList();
        GhastDimensionBlacklist = new ArrayList();
        int[] i6 = tmpGDB;
        i22 = i6.length;
        for (int i5 = 0; i5 < i22; ++i5) {
            i = i6[i5];
            GhastDimensionBlacklist.add(i);
        }
        EndermanMode = config.get("Enderman", "Mode", EndermanMode, "Valid Endermen Modes (Slender, Normal)").getString();
        EndermanPlayerTele = config.get("Enderman", "Player Teleport", EndermanPlayerTele).getBoolean(EndermanPlayerTele);
        SpiderWebChance = MathHelper.func_76125_a((int)config.get("Spider", "Webbing Chance (0-100)", SpiderWebChance).getInt(SpiderWebChance), (int)0, (int)100);
        int[] tmpDef = new int[MobBombs.size()];
        for (i22 = 0; i22 < MobBombs.size(); ++i22) {
            tmpDef[i22] = MobBombs.get(i22);
        }
        int[] tmp = config.get("Advanced Mobs", "Mob Bombs", tmpDef).getIntList();
        MobBombs = new ArrayList();
        int[] i5 = tmp;
        i = i5.length;
        for (int j = 0; j < i; ++j) {
            int id = i5[j];
            MobBombs.add(id);
        }
        MobBombRarity = config.get("Advanced Mobs", "Mob Bomb Rarity", MobBombRarity).getInt(MobBombRarity);
        MobBombAll = config.get("Advanced Mobs", "Mob Bomb All", MobBombAll, "Skip the Mob Bomb list and allow everything!").getBoolean(MobBombAll);
        WitherSkeletons = config.get("Advanced Mobs", "Wither Skeletons", WitherSkeletons).getBoolean(WitherSkeletons);
        WitherSkeletonRarity = config.get("Advanced Mobs", "Wither Skeleton Rarity", WitherSkeletonRarity).getInt(WitherSkeletonRarity);
        PotionMobs = config.get("Advanced Mobs", "Potion Buff Chance (0-100)", PotionMobs).getInt(PotionMobs);
        PotionMobEffects = config.get("Advanced Mobs", "Potion Buff List", PotionMobEffects, "List of all the valid potion IDs a mob can spawn with. Amplifier is always x1").getIntList();
        attackEvasion = config.get("Advanced Mobs", "Attack Evasion", attackEvasion).getBoolean(attackEvasion);
        SpawnForts = config.get("World", "Spawn Forts", SpawnForts).getBoolean(SpawnForts);
        fortRarity = config.get("World", "Fort Rarity", fortRarity).getInt(fortRarity);
        fortDistance = config.get("World", "Fort Distance", fortDistance).getInt(fortDistance);
        fallFromEnd = config.get("World", "Fall From End", fallFromEnd, "Whether the player should fall into the overworld from the new End").getBoolean(fallFromEnd);
        int[] tmpFDDef = new int[fortDimensions.size()];
        for (i = 0; i < fortDimensions.size(); ++i) {
            tmpFDDef[i] = fortDimensions.get(i);
        }
        int[] tmpFD = config.get("World", "Fort Dimensions", tmpFDDef).getIntList();
        fortDimensions = new ArrayList();
        for (int dimID : tmpFD) {
            fortDimensions.add(dimID);
        }
        config.save();
        ESM_Utils.UpdateBiomeSpawns();
        fortDB = ESM_Settings.loadFortDB();
    }

    public static ArrayList<String> loadFortDB() {
        File fileFortDB = new File(worldDir, "ESM_fortDB");
        ESM.log.log(Level.INFO, "Loading fortDB from " + fileFortDB.getPath());
        if (!fileFortDB.exists()) {
            return new ArrayList<String>();
        }
        try {
            FileInputStream fileIn = new FileInputStream(fileFortDB);
            BufferedInputStream buffer = new BufferedInputStream(fileIn);
            ObjectInputStream objIn = new ObjectInputStream(buffer);
            ArrayList savedDB = (ArrayList)objIn.readObject();
            objIn.close();
            buffer.close();
            fileIn.close();
            return savedDB;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static void saveFortDB() {
        if (fortDB == null || fortDB.size() <= 0) {
            return;
        }
        File fileFortDB = new File(worldDir, "ESM_fortDB");
        ESM.log.log(Level.INFO, "Saving fortDB to " + fileFortDB.getPath());
        try {
            if (!fileFortDB.exists()) {
                fileFortDB.createNewFile();
            }
            FileOutputStream fileOut = new FileOutputStream(fileFortDB);
            BufferedOutputStream buffer = new BufferedOutputStream(fileOut);
            ObjectOutputStream objOut = new ObjectOutputStream(buffer);
            objOut.writeObject(fortDB);
            objOut.close();
            buffer.close();
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static {
        fortRarity = 2;
        fortDistance = 16;
        fortDimensions = new ArrayList();
        fallFromEnd = true;
        fortSpawners = new ArrayList();
        fortDB = new ArrayList();
        currentWorlds = null;
        worldDir = null;
        ambiguous_AI = true;
        AIExempt = new ArrayList();
    }
}

