/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import funwayguy.esm.ai.ESM_EntityAIAttackEvasion;
import funwayguy.esm.ai.ESM_EntityAIAttackOnCollide;
import funwayguy.esm.ai.ESM_EntityAIAvoidDetonatingCreepers;
import funwayguy.esm.ai.ESM_EntityAIBreakDoor_Proxy;
import funwayguy.esm.ai.ESM_EntityAIBuildTrap;
import funwayguy.esm.ai.ESM_EntityAICreeperSwell;
import funwayguy.esm.ai.ESM_EntityAIDigging;
import funwayguy.esm.ai.ESM_EntityAIGrief;
import funwayguy.esm.ai.ESM_EntityAINearestAttackableTarget;
import funwayguy.esm.ai.ESM_EntityAIPillarUp;
import funwayguy.esm.ai.ESM_EntityAISwimming;
import funwayguy.esm.blocks.ESM_BlockEnderPortal;
import funwayguy.esm.core.ESM;
import funwayguy.esm.core.ESM_Settings;
import funwayguy.esm.handlers.ESM_PathCapHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.Level;

public class ESM_Utils {
    public static ArrayList<BiomeGenBase> nativeBlazeBiomes;
    public static ArrayList<BiomeGenBase> nativeGhastBiomes;

    public static void transferPlayerMPToDimension(EntityPlayerMP player, int par1, boolean forceLoc) {
        if (player.field_71093_bK == 1 && par1 == 1) {
            player.func_71029_a((StatBase)AchievementList.field_76003_C);
            player.field_70170_p.func_72900_e((Entity)player);
            player.field_71136_j = true;
            player.field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(4, 0.0f));
        } else {
            if (player.field_71093_bK == 0 && par1 == 1) {
                player.func_71029_a((StatBase)AchievementList.field_76002_B);
                ChunkCoordinates chunkcoordinates = player.field_71133_b.func_71218_a(par1).func_73054_j();
                if (chunkcoordinates != null) {
                    player.field_71135_a.func_147364_a((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, 0.0f, 0.0f);
                }
                par1 = 1;
            } else if (par1 == -1) {
                player.func_71029_a((StatBase)AchievementList.field_76029_x);
            }
            ESM_Utils.transferPlayerToDimension(player, par1, forceLoc);
            ESM_Utils.resetPlayerMPStats(player);
        }
    }

    public static void transferDimensions(int par1, Entity par2, boolean forceLoc) {
        if (par2 instanceof EntityPlayerMP) {
            ESM_Utils.transferPlayerMPToDimension((EntityPlayerMP)par2, par1, forceLoc);
            return;
        }
        if (!par2.field_70170_p.field_72995_K && !par2.field_70128_L) {
            par2.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            int j = par2.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(j);
            WorldServer worldserver1 = minecraftserver.func_71218_a(par1);
            par2.field_71093_bK = par1;
            if (j == 1 && par1 == 1) {
                worldserver1 = minecraftserver.func_71218_a(0);
                par2.field_71093_bK = 0;
            }
            par2.field_70170_p.func_72900_e(par2);
            par2.field_70128_L = false;
            par2.field_70170_p.field_72984_F.func_76320_a("reposition");
            ESM_Utils.transferEntityToWorld(par2, j, worldserver, worldserver1, forceLoc);
            par2.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)par2), (World)worldserver1);
            if (entity != null) {
                entity.func_82141_a(par2, true);
                if (j == 1 && par1 == 1) {
                    ChunkCoordinates chunkcoordinates = worldserver1.func_72861_E();
                    chunkcoordinates.field_71572_b = par2.field_70170_p.func_72825_h(chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c);
                    entity.func_70012_b((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, entity.field_70177_z, entity.field_70125_A);
                }
                worldserver1.func_72838_d(entity);
            }
            par2.field_70128_L = true;
            par2.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            par2.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    private static void transferEntityToWorld(Entity par1Entity, int par2, WorldServer par3WorldServer, WorldServer par4WorldServer, boolean forceLoc) {
        ESM_Utils.transferEntityToWorld(par1Entity, par2, par3WorldServer, par4WorldServer, par4WorldServer.func_85176_s(), forceLoc);
    }

    private static void transferEntityToWorld(Entity par1Entity, int par2, WorldServer par3WorldServer, WorldServer par4WorldServer, Teleporter teleporter, boolean forceLoc) {
        ChunkCoordinates chunkcoordinates;
        WorldProvider pOld = par3WorldServer.field_73011_w;
        WorldProvider pNew = par4WorldServer.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = par1Entity.field_70165_t * moveFactor;
        double d1 = par1Entity.field_70161_v * moveFactor;
        double d3 = par1Entity.field_70165_t;
        double d4 = par1Entity.field_70163_u;
        double d5 = par1Entity.field_70161_v;
        float f = par1Entity.field_70177_z;
        par3WorldServer.field_72984_F.func_76320_a("moving");
        if (par1Entity.field_71093_bK == 1 && !ESM_Settings.NewEnd) {
            chunkcoordinates = par2 == 1 ? par4WorldServer.func_72861_E() : par4WorldServer.func_73054_j();
            d0 = chunkcoordinates.field_71574_a;
            par1Entity.field_70163_u = chunkcoordinates.field_71572_b;
            d1 = chunkcoordinates.field_71573_c;
            par1Entity.func_70012_b(d0, par1Entity.field_70163_u, d1, 90.0f, 0.0f);
            if (par1Entity.func_70089_S()) {
                par3WorldServer.func_72866_a(par1Entity, false);
            }
        } else if ((par1Entity.field_71093_bK == 1 || par1Entity.field_71093_bK == 0 && !forceLoc) && par2 == 1) {
            chunkcoordinates = par4WorldServer.func_72861_E();
            d0 = chunkcoordinates.field_71574_a;
            par1Entity.field_70163_u = ESM_Utils.getSuitableSpawnHeight((World)par4WorldServer, chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c);
            d1 = chunkcoordinates.field_71573_c;
            par1Entity.func_70012_b(d0 + 0.5, par1Entity.field_70163_u, d1 + 0.5, 90.0f, 0.0f);
            if (par1Entity.func_70089_S()) {
                par3WorldServer.func_72866_a(par1Entity, false);
            }
        }
        par3WorldServer.field_72984_F.func_76319_b();
        if (par2 != 1 || par1Entity.field_71093_bK != 0 || ESM_Settings.NewEnd) {
            par3WorldServer.field_72984_F.func_76320_a("placing");
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            if (par1Entity.func_70089_S()) {
                par4WorldServer.func_72838_d(par1Entity);
                par1Entity.func_70012_b(d0, (double)MathHelper.func_76128_c((double)par1Entity.field_70163_u), d1, par1Entity.field_70177_z, par1Entity.field_70125_A);
                par4WorldServer.func_72866_a(par1Entity, false);
                if (!forceLoc) {
                    if (par1Entity.field_71093_bK == 1) {
                        int i2 = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
                        int j2 = 64;
                        int k2 = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
                        for (int i = -2; i <= 2; ++i) {
                            for (int j = -2; j <= 2; ++j) {
                                par4WorldServer.func_147449_b(i2 + i, j2 - 1, k2 + j, Blocks.field_150343_Z);
                            }
                        }
                        par1Entity.field_70179_y = 0.0;
                        par1Entity.field_70181_x = 0.0;
                        par1Entity.field_70159_w = 0.0;
                        par1Entity.func_70107_b((double)i2, (double)j2, (double)k2);
                    } else if (par2 != 1) {
                        teleporter.func_77185_a(par1Entity, d3, d4, d5, f);
                    }
                }
            }
            par3WorldServer.field_72984_F.func_76319_b();
        }
        par1Entity.func_70029_a((World)par4WorldServer);
    }

    public static void transferPlayerToDimension(EntityPlayerMP par1EntityPlayerMP, int par2, boolean forceLoc) {
        ESM_Utils.transferPlayerToDimension(par1EntityPlayerMP, par2, par1EntityPlayerMP.field_71133_b.func_71218_a(par2).func_85176_s(), forceLoc);
    }

    public static void transferPlayerToDimension(EntityPlayerMP par1EntityPlayerMP, int par2, Teleporter teleporter, boolean forceLoc) {
        ServerConfigurationManager configManager = par1EntityPlayerMP.field_71133_b.func_71203_ab();
        int j = par1EntityPlayerMP.field_71093_bK;
        WorldServer worldserver = par1EntityPlayerMP.field_71133_b.func_71218_a(par1EntityPlayerMP.field_71093_bK);
        par1EntityPlayerMP.field_71093_bK = par2;
        WorldServer worldserver1 = par1EntityPlayerMP.field_71133_b.func_71218_a(par1EntityPlayerMP.field_71093_bK);
        par1EntityPlayerMP.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(par1EntityPlayerMP.field_71093_bK, par1EntityPlayerMP.field_70170_p.field_73013_u, par1EntityPlayerMP.field_70170_p.func_72912_H().func_76067_t(), par1EntityPlayerMP.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)par1EntityPlayerMP);
        par1EntityPlayerMP.field_70128_L = false;
        ESM_Utils.transferEntityToWorld((Entity)par1EntityPlayerMP, j, worldserver, worldserver1, teleporter, forceLoc);
        configManager.func_72375_a(par1EntityPlayerMP, worldserver);
        par1EntityPlayerMP.field_71135_a.func_147364_a(par1EntityPlayerMP.field_70165_t, par1EntityPlayerMP.field_70163_u, par1EntityPlayerMP.field_70161_v, par1EntityPlayerMP.field_70177_z, par1EntityPlayerMP.field_70125_A);
        par1EntityPlayerMP.field_71134_c.func_73080_a(worldserver1);
        configManager.func_72354_b(par1EntityPlayerMP, worldserver1);
        configManager.func_72385_f(par1EntityPlayerMP);
        for (PotionEffect potioneffect : par1EntityPlayerMP.func_70651_bq()) {
            par1EntityPlayerMP.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(par1EntityPlayerMP.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)par1EntityPlayerMP, j, par2);
    }

    public static int getSuitableSpawnHeight(World world, int par1, int par2) {
        int k = 63;
        while (!world.func_147437_c(par1, k, par2) || !world.func_147437_c(par1, k + 1, par2)) {
            ++k;
        }
        ESM.log.log(Level.INFO, "Suitable spawn at " + par1 + ", " + k + ", " + par2);
        return k;
    }

    public static void resetPlayerMPStats(EntityPlayerMP player) {
        Field fXP = null;
        Field fHP = null;
        Field fFD = null;
        try {
            fXP = EntityPlayerMP.class.getDeclaredField("lastExperience");
            fHP = EntityPlayerMP.class.getDeclaredField("lastHealth");
            fFD = EntityPlayerMP.class.getDeclaredField("lastFoodLevel");
        }
        catch (Exception e) {
            try {
                fXP = EntityPlayerMP.class.getDeclaredField("field_71144_ck");
                fHP = EntityPlayerMP.class.getDeclaredField("field_71149_ch");
                fFD = EntityPlayerMP.class.getDeclaredField("field_71146_ci");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return;
            }
        }
        fXP.setAccessible(true);
        fHP.setAccessible(true);
        fFD.setAccessible(true);
        try {
            fXP.setInt(player, -1);
            fHP.setFloat(player, -1.0f);
            fFD.setInt(player, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static int getAIPathCount(World world, EntityLivingBase targetEntity) {
        List attackerList = ESM_PathCapHandler.attackMap.get(targetEntity);
        if (attackerList == null) {
            return 0;
        }
        return attackerList.size();
    }

    public static boolean isCloserThanOtherAttackers(World world, EntityLivingBase attacker, EntityLivingBase target) {
        List attackerList = ESM_PathCapHandler.attackMap.get(target);
        if (attackerList == null || attackerList.size() <= 0) {
            return true;
        }
        float distance = attacker.func_70032_d((Entity)target);
        EntityLivingBase subject = (EntityLivingBase)attackerList.get(attackerList.size() - 1);
        if (subject != null && subject.func_70032_d((Entity)target) > distance && subject != attacker) {
            return true;
        }
        if (subject == null) {
            ESM_PathCapHandler.UpdateAttackers(target);
        }
        return false;
    }

    public static void replaceAI(EntityLiving entityLiving) {
        boolean replaceNAT = false;
        boolean replaceCS = false;
        boolean replaceAE = false;
        ESM_EntityAINearestAttackableTarget esmTargetAI = null;
        for (int i = entityLiving.field_70715_bh.field_75782_a.size() - 1; i >= 0; --i) {
            Class targetType;
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)entityLiving.field_70715_bh.field_75782_a.get(i);
            if (task == null || task.field_75733_a == null || task.field_75733_a.getClass() != EntityAINearestAttackableTarget.class || !(entityLiving instanceof EntityCreature)) continue;
            if (esmTargetAI == null) {
                esmTargetAI = new ESM_EntityAINearestAttackableTarget((EntityCreature)entityLiving, new ArrayList<Class<? extends EntityLivingBase>>(), 0, true);
                if (ESM_Settings.ambiguous_AI) {
                    esmTargetAI.targetClass.add(EntityPlayer.class);
                }
            }
            if ((targetType = (Class)ObfuscationReflectionHelper.getPrivateValue(EntityAINearestAttackableTarget.class, (Object)((EntityAINearestAttackableTarget)task.field_75733_a), (String[])new String[]{"field_75307_b", "targetClass"})) != null && !esmTargetAI.targetClass.contains(targetType)) {
                esmTargetAI.targetClass.add(targetType);
            }
            if (!replaceNAT) {
                replaceNAT = true;
                EntityAITasks entityAITasks = entityLiving.field_70715_bh;
                entityAITasks.getClass();
                EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)esmTargetAI);
                entityLiving.field_70715_bh.field_75782_a.set(i, replacement);
                entityLiving.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)ESM_Settings.Awareness);
                continue;
            }
            entityLiving.field_70715_bh.field_75782_a.remove(i);
        }
        ESM_EntityAIBreakDoor_Proxy esmBD = null;
        for (int i = entityLiving.field_70714_bg.field_75782_a.size() - 1; i >= 0; --i) {
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)entityLiving.field_70714_bg.field_75782_a.get(i);
            if (task == null || task.field_75733_a == null) continue;
            if (task.field_75733_a.getClass() == EntityAICreeperSwell.class && entityLiving instanceof EntityCreeper) {
                if (!replaceCS) {
                    replaceCS = true;
                    EntityAITasks entityAITasks = entityLiving.field_70714_bg;
                    entityAITasks.getClass();
                    EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)new ESM_EntityAICreeperSwell((EntityCreeper)entityLiving));
                    entityLiving.field_70714_bg.field_75782_a.set(i, replacement);
                    continue;
                }
                entityLiving.field_70714_bg.field_75782_a.remove(i);
                continue;
            }
            if (task.field_75733_a.getClass() == EntityAIAvoidEntity.class && entityLiving instanceof EntityVillager) {
                if (!replaceAE) {
                    replaceAE = true;
                    EntityAITasks entityAITasks = entityLiving.field_70714_bg;
                    entityAITasks.getClass();
                    EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)((EntityVillager)entityLiving), IMob.class, 12.0f, 0.6, 0.6));
                    entityLiving.field_70714_bg.field_75782_a.set(i, replacement);
                    continue;
                }
                entityLiving.field_70714_bg.field_75782_a.remove(i);
                continue;
            }
            if (task.field_75733_a.getClass() == EntityAISwimming.class) {
                EntityAITasks entityAITasks = entityLiving.field_70714_bg;
                entityAITasks.getClass();
                EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)new ESM_EntityAISwimming(entityLiving));
                entityLiving.field_70714_bg.field_75782_a.set(i, replacement);
                continue;
            }
            if (task.field_75733_a.getClass() == EntityAIBreakDoor.class) {
                esmBD = new ESM_EntityAIBreakDoor_Proxy(entityLiving);
                EntityAITasks entityAITasks = entityLiving.field_70714_bg;
                entityAITasks.getClass();
                EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)esmBD);
                entityLiving.field_70714_bg.field_75782_a.set(i, replacement);
                continue;
            }
            if (task.field_75733_a.getClass() != EntityAIAttackOnCollide.class || !(entityLiving instanceof EntityCreature)) continue;
            boolean longMemory = (Boolean)ObfuscationReflectionHelper.getPrivateValue(EntityAIAttackOnCollide.class, (Object)((EntityAIAttackOnCollide)task.field_75733_a), (String[])new String[]{"field_75437_f", "longMemory"});
            Class targetType = (Class)ObfuscationReflectionHelper.getPrivateValue(EntityAIAttackOnCollide.class, (Object)((EntityAIAttackOnCollide)task.field_75733_a), (String[])new String[]{"field_75444_h", "classTarget"});
            double speed = (Double)ObfuscationReflectionHelper.getPrivateValue(EntityAIAttackOnCollide.class, (Object)((EntityAIAttackOnCollide)task.field_75733_a), (String[])new String[]{"field_75440_e", "speedTowardsTarget"});
            ESM_EntityAIAttackOnCollide esmAOC = new ESM_EntityAIAttackOnCollide((EntityCreature)entityLiving, targetType, speed, longMemory);
            EntityAITasks entityAITasks = entityLiving.field_70714_bg;
            entityAITasks.getClass();
            EntityAITasks.EntityAITaskEntry replacement = new EntityAITasks.EntityAITaskEntry(entityAITasks, task.field_75731_b, (EntityAIBase)esmAOC);
            entityLiving.field_70714_bg.field_75782_a.set(i, replacement);
        }
        if (entityLiving instanceof EntityCreature) {
            if (entityLiving.field_70715_bh.field_75782_a.size() > 0) {
                entityLiving.field_70715_bh.func_75776_a(0, (EntityAIBase)new ESM_EntityAIAvoidDetonatingCreepers((EntityCreature)entityLiving, 9.0f, 1.5, 1.5));
                if ((entityLiving instanceof IMob || ESM_Settings.ambiguous_AI) && !(entityLiving instanceof EntityCreeper)) {
                    entityLiving.field_70715_bh.func_75776_a(0, (EntityAIBase)new ESM_EntityAIAttackEvasion((EntityCreature)entityLiving, 5.0f, 1.5, 1.5));
                }
            } else {
                entityLiving.field_70715_bh.func_75776_a(0, (EntityAIBase)new ESM_EntityAIAvoidDetonatingCreepers((EntityCreature)entityLiving, 12.0f, 1.0, 1.0));
            }
        }
        if (entityLiving instanceof EntityZombie) {
            try {
                ESM_EntityAIBreakDoor_Proxy tmp = esmBD != null ? esmBD : new ESM_EntityAIBreakDoor_Proxy(entityLiving);
                Field aiField = EntityZombie.class.getDeclaredField("field_146075_bs");
                aiField.setAccessible(true);
                aiField.set(entityLiving, (Object)tmp);
                if (aiField.get(entityLiving) != tmp) {
                    throw new Exception();
                }
                ((EntityZombie)entityLiving).func_146070_a(true);
            }
            catch (Exception e) {
                ESM.log.log(Level.ERROR, "Unable to modify Zombie door breaking AI", (Throwable)e);
            }
            if (ESM_Settings.ZombieDiggers) {
                entityLiving.field_70714_bg.func_75776_a(1, (EntityAIBase)new ESM_EntityAIDigging((EntityLiving)((EntityZombie)entityLiving)));
                entityLiving.field_70714_bg.func_75776_a(6, (EntityAIBase)new ESM_EntityAIGrief((EntityLiving)((EntityZombie)entityLiving)));
                entityLiving.field_70714_bg.func_75776_a(3, (EntityAIBase)new ESM_EntityAIPillarUp(entityLiving));
                entityLiving.field_70714_bg.func_75776_a(5, (EntityAIBase)new ESM_EntityAIBuildTrap(entityLiving));
            }
        }
    }

    public static EntityLivingBase GetNearestValidTarget(EntityLiving entityLiving) {
        return entityLiving.field_70170_p.func_72856_b((Entity)entityLiving, (double)ESM_Settings.Awareness);
    }

    public static boolean isFortAt(World world, int x, int z, int size) {
        int dimension = world.field_73011_w.field_76574_g;
        if (ESM_Settings.fortDistance - x % Math.abs(ESM_Settings.fortDistance) < size || ESM_Settings.fortDistance - z % Math.abs(ESM_Settings.fortDistance) < size) {
            return true;
        }
        int fGridX = x - x % Math.abs(ESM_Settings.fortDistance);
        int fGridZ = z - z % Math.abs(ESM_Settings.fortDistance);
        return ESM_Settings.fortDB.contains(dimension + "," + fGridX + "," + fGridZ);
    }

    public static void addFortToDB(World world, int x, int z) {
        int dimension = world.field_73011_w.field_76574_g;
        int fGridX = x - x % Math.abs(ESM_Settings.fortDistance);
        int fGridZ = z - z % Math.abs(ESM_Settings.fortDistance);
        ESM_Settings.fortDB.add(dimension + "," + fGridX + "," + fGridZ);
        ESM_Settings.saveFortDB();
    }

    public static void replaceEndPortal() {
        Block block = new ESM_BlockEnderPortal(Material.field_151567_E).func_149711_c(-1.0f).func_149752_b(6000000.0f);
        Field fBlock = null;
        Field modifiers = null;
        try {
            fBlock = Blocks.class.getDeclaredField("end_portal");
            modifiers = Field.class.getDeclaredField("modifiers");
        }
        catch (Exception e) {
            try {
                fBlock = Blocks.class.getDeclaredField("field_150384_bq");
                modifiers = Field.class.getDeclaredField("modifiers");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return;
            }
        }
        modifiers.setAccessible(true);
        try {
            modifiers.setInt(fBlock, fBlock.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            ESM.log.log(Level.ERROR, "Failed to replace End Portal", (Throwable)e);
            return;
        }
        fBlock.setAccessible(true);
        try {
            fBlock.set(null, block);
            try {
                Method addRawObj = FMLControlledNamespacedRegistry.class.getDeclaredMethod("addObjectRaw", Integer.TYPE, String.class, Object.class);
                addRawObj.setAccessible(true);
                addRawObj.invoke((Object)GameData.getItemRegistry(), 119, "minecraft:end_portal", new ItemBlock(block));
                addRawObj.invoke((Object)GameData.getBlockRegistry(), 119, "minecraft:end_portal", block);
            }
            catch (Exception e) {
                ESM.log.log(Level.ERROR, "Failed to replace End Portal", (Throwable)e);
            }
        }
        catch (Exception e) {
            ESM.log.log(Level.ERROR, "Failed to replace End Portal", (Throwable)e);
            return;
        }
        if (Blocks.field_150384_bq instanceof ESM_BlockEnderPortal && Block.field_149771_c.func_82594_a("end_portal") instanceof ESM_BlockEnderPortal) {
            ESM.log.log(Level.INFO, "Successfully replaced vanilla End Portal");
        } else {
            ESM.log.log(Level.ERROR, "Failed to override vanilla End Portal block");
        }
    }

    public static void UpdateBiomeSpawns() {
        BiomeGenBase[] biomeList;
        if (nativeBlazeBiomes == null || nativeGhastBiomes == null) {
            ESM_Utils.SetBiomeSpawnDefaults();
        }
        for (BiomeGenBase biome : biomeList = BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            if (!nativeBlazeBiomes.contains(biome)) {
                if (ESM_Settings.BlazeSpawn) {
                    EntityRegistry.addSpawn(EntityBlaze.class, (int)(100 / (ESM_Settings.BlazeRarity <= 0 ? 1 : ESM_Settings.BlazeRarity)), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
                } else {
                    EntityRegistry.removeSpawn(EntityBlaze.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
                }
            }
            if (nativeGhastBiomes.contains(biome)) continue;
            if (ESM_Settings.GhastSpawn) {
                EntityRegistry.addSpawn(EntityGhast.class, (int)(100 / (ESM_Settings.GhastRarity <= 0 ? 1 : ESM_Settings.GhastRarity)), (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
                continue;
            }
            EntityRegistry.removeSpawn(EntityGhast.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
        }
    }

    public static void SetBiomeSpawnDefaults() {
        BiomeGenBase[] biomeList;
        nativeBlazeBiomes = new ArrayList();
        nativeGhastBiomes = new ArrayList();
        for (BiomeGenBase biome : biomeList = BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            List spawnList = biome.func_76747_a(EnumCreatureType.monster);
            for (BiomeGenBase.SpawnListEntry spawn : spawnList) {
                if (spawn.field_76300_b == EntityBlaze.class) {
                    nativeBlazeBiomes.add(biome);
                }
                if (spawn.field_76300_b != EntityGhast.class) continue;
                nativeGhastBiomes.add(biome);
            }
        }
    }
}

