/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.handlers;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import funwayguy.esm.ai.GenericEntitySelector;
import funwayguy.esm.client.gui.ESMGuiConfig;
import funwayguy.esm.core.ESM;
import funwayguy.esm.core.ESM_Settings;
import funwayguy.esm.core.ESM_Utils;
import funwayguy.esm.entities.EntityESMGhast;
import funwayguy.esm.handlers.ESM_PathCapHandler;
import funwayguy.esm.handlers.entities.ESM_BlazeHandler;
import funwayguy.esm.handlers.entities.ESM_CreeperHandler;
import funwayguy.esm.handlers.entities.ESM_EndermanHandler;
import funwayguy.esm.handlers.entities.ESM_SkeletonHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ESM_EventManager {
    Stopwatch timer = Stopwatch.createUnstarted();
    int ticks = 0;
    float TPS = 0.0f;

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        int id;
        if (event.world.field_72995_K) {
            return;
        }
        if (!(!ESM_Settings.Apocalypse || !(event.entity instanceof EntityLivingBase) || event.entity instanceof EntityZombie || event.entity instanceof EntityPlayer || event.entity instanceof EntityEnderman && ESM_Settings.EndermanMode.equalsIgnoreCase("Slender"))) {
            event.entity.func_70106_y();
            event.setCanceled(true);
            return;
        }
        if (event.entity instanceof EntityLiving && (event.entity instanceof IMob || ESM_Settings.ambiguous_AI)) {
            ESM_Utils.replaceAI((EntityLiving)event.entity);
            if (event.entity instanceof EntityMob || event.entity instanceof EntitySpider && !event.world.func_72935_r()) {
                ESM_EventManager.searchForTarget((EntityCreature)event.entity);
            }
        }
        if (event.entity.getEntityData().func_74767_n("ESM_MODIFIED") || ESM_Settings.AIExempt.contains(EntityList.func_75619_a((Entity)event.entity))) {
            event.entity.getEntityData().func_74757_a("ESM_MODIFIED", true);
            return;
        }
        if (event.entity.getClass() == EntityGhast.class) {
            event.setCanceled(true);
            EntityESMGhast newGhast = new EntityESMGhast(event.world);
            newGhast.func_70012_b(event.entity.field_70165_t, event.entity.field_70163_u + 32.0, event.entity.field_70161_v, event.entity.field_70177_z, 0.0f);
            NBTTagCompound oldTags = new NBTTagCompound();
            event.entity.func_70109_d(oldTags);
            newGhast.func_70020_e(oldTags);
            event.world.func_72838_d((Entity)newGhast);
            event.entity.func_70106_y();
        } else if (event.entity instanceof EntityCreeper) {
            ESM_CreeperHandler.onEntityJoinWorld((EntityCreeper)event.entity);
        } else if (!(event.entity instanceof EntitySpider)) {
            if (event.entity instanceof EntitySkeleton) {
                ESM_SkeletonHandler.onEntityJoinWorld((EntitySkeleton)event.entity);
            } else if (event.entity instanceof EntityZombie) {
                if (ESM_Settings.ZombieDiggers && event.world.field_73012_v.nextFloat() < 0.1f) {
                    ((EntityZombie)event.entity).func_98053_h(true);
                    if (event.world.field_73012_v.nextFloat() < 0.1f) {
                        ((EntityZombie)event.entity).func_70062_b(0, new ItemStack(Items.field_151046_w));
                    } else {
                        ((EntityZombie)event.entity).func_70062_b(0, new ItemStack(Items.field_151035_b));
                    }
                } else if (ESM_Settings.ZombieTraps && event.world.field_73012_v.nextFloat() < 0.1f) {
                    ((EntityZombie)event.entity).func_70062_b(0, new ItemStack(Blocks.field_150456_au));
                }
            } else if (event.entity instanceof EntityArrow) {
                EntityLiving shooter;
                EntityLivingBase target;
                EntityArrow arrow = (EntityArrow)event.entity;
                if (arrow.field_70250_c instanceof EntityLiving && arrow.field_70250_c instanceof IMob && (target = (shooter = (EntityLiving)arrow.field_70250_c).func_70638_az()) != null) {
                    ESM_EventManager.replaceArrowAttack(shooter, target, arrow.func_70242_d());
                    event.setCanceled(true);
                    event.entity.func_70106_y();
                }
            } else if (event.entity instanceof EntityBlaze) {
                ESM_BlazeHandler.onEntityJoinWorld((EntityBlaze)event.entity);
            } else if (event.entity instanceof EntitySmallFireball) {
                EntitySmallFireball fireball = (EntitySmallFireball)event.entity;
                if (fireball.field_70235_a instanceof EntityBlaze) {
                    fireball.field_70235_a.getEntityData().func_74768_a("ESM_FIREBALLS", fireball.field_70235_a.getEntityData().func_74762_e("ESM_FIREBALLS") + 1);
                }
            } else if (event.entity instanceof EntityEnderman) {
                ESM_EndermanHandler.onEntityJoinWorld((EntityEnderman)event.entity);
            }
        }
        if ((ESM_Settings.MobBombAll || ESM_Settings.MobBombs != null && ESM_Settings.MobBombs.contains(EntityList.func_75619_a((Entity)event.entity))) && event.entity.field_70153_n == null && event.entity instanceof IMob && !event.isCanceled() && !event.entity.field_70128_L) {
            EntityCreeper passenger;
            event.entity.getEntityData().func_74757_a("ESM_MODIFIED", true);
            if (ESM_Settings.MobBombRarity <= 0) {
                passenger = new EntityCreeper(event.entity.field_70170_p);
                passenger.func_70012_b(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, event.entity.field_70177_z, 0.0f);
                passenger.func_110161_a((IEntityLivingData)null);
                event.entity.field_70170_p.func_72838_d((Entity)passenger);
                passenger.func_70078_a(event.entity);
            } else if (ESM_Settings.MobBombRarity > 0 && event.world.field_73012_v.nextInt(ESM_Settings.MobBombRarity) == 0) {
                passenger = new EntityCreeper(event.entity.field_70170_p);
                passenger.func_70012_b(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, event.entity.field_70177_z, 0.0f);
                passenger.func_110161_a((IEntityLivingData)null);
                event.entity.field_70170_p.func_72838_d((Entity)passenger);
                passenger.func_70078_a(event.entity);
            }
        }
        if (event.entity instanceof IMob && !(event.entity instanceof IBossDisplayData) && event.entity instanceof EntityLivingBase && ESM_Settings.PotionMobs > event.world.field_73012_v.nextInt(100) && ESM_Settings.PotionMobEffects != null && ESM_Settings.PotionMobEffects.length > 0 && Potion.field_76425_a[id = ESM_Settings.PotionMobEffects[event.world.field_73012_v.nextInt(ESM_Settings.PotionMobEffects.length)]] != null) {
            ((EntityLivingBase)event.entity).func_70690_d(new PotionEffect(id, 999999));
        }
        event.entity.getEntityData().func_74757_a("ESM_MODIFIED", true);
    }

    public static void replaceArrowAttack(EntityLiving shooter, EntityLivingBase targetEntity, double par2) {
        double targetDist = shooter.func_70011_f(targetEntity.field_70165_t + (targetEntity.field_70165_t - targetEntity.field_70142_S), targetEntity.field_70121_D.field_72338_b, targetEntity.field_70161_v + (targetEntity.field_70161_v - targetEntity.field_70136_U));
        float fireSpeed = (float)(1.3E-4 * targetDist * targetDist + 0.02 * targetDist + 1.25);
        EntityArrow entityarrow = ESM_Settings.SkeletonDistance <= 0 ? new EntityArrow(shooter.field_70170_p, (EntityLivingBase)shooter, targetEntity, 1.6f, (float)ESM_Settings.SkeletonAccuracy) : new EntityArrow(shooter.field_70170_p, (EntityLivingBase)shooter, targetEntity, fireSpeed, (float)ESM_Settings.SkeletonAccuracy);
        double d0 = targetEntity.field_70165_t + (targetEntity.field_70165_t - targetEntity.field_70142_S) * (targetDist / (double)fireSpeed) - shooter.field_70165_t;
        double d1 = targetEntity.field_70121_D.field_72338_b + (double)(targetEntity.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = targetEntity.field_70161_v + (targetEntity.field_70161_v - targetEntity.field_70136_U) * (targetDist / (double)fireSpeed) - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f4 = (float)d3 * 0.2f;
            entityarrow.func_70186_c(d0, d1 + (double)f4, d2, fireSpeed, (float)ESM_Settings.SkeletonAccuracy);
        }
        int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)shooter.func_70694_bm());
        int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)shooter.func_70694_bm());
        entityarrow.func_70239_b(par2);
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)shooter.func_70694_bm()) > 0 || shooter instanceof EntitySkeleton && ((EntitySkeleton)shooter).func_82202_m() == 1) {
            entityarrow.func_70015_d(100);
        }
        shooter.func_85030_a("random.bow", 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        entityarrow.getEntityData().func_74757_a("ESM_MODIFIED", true);
        shooter.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingHurtEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayer) && event.entityLiving.field_70154_o != null && event.source == DamageSource.field_76368_d) {
            event.entityLiving.func_110145_l(event.entityLiving.field_70154_o);
            event.entityLiving.field_70154_o.field_70153_n = null;
            event.entityLiving.field_70154_o = null;
        }
        if (event.source != null && event.source.func_76346_g() instanceof EntitySpider && ESM_Settings.SpiderWebChance > event.entityLiving.func_70681_au().nextInt(100)) {
            int i = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t);
            int j = MathHelper.func_76128_c((double)event.entityLiving.field_70163_u);
            int k = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v);
            event.entityLiving.field_70170_p.func_147449_b(i, j, k, Blocks.field_150321_G);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase target;
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        ESM_PathCapHandler.RemoveTarget(event.entityLiving);
        if (event.entityLiving instanceof EntityLiving && (target = ((EntityLiving)event.entityLiving).func_70638_az()) != null) {
            ESM_PathCapHandler.UpdateAttackers(target);
        }
        if (event.entity instanceof EntityPlayer && event.source.func_76364_f() instanceof EntityZombie && ESM_Settings.ZombieInfectious) {
            EntityZombie zombie = new EntityZombie(event.entity.field_70170_p);
            zombie.func_70107_b(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v);
            zombie.func_98053_h(true);
            zombie.func_94058_c(event.entity.func_70005_c_());
            zombie.getEntityData().func_74757_a("ESM_MODIFIED", true);
            event.entity.field_70170_p.func_72838_d((Entity)zombie);
        }
    }

    public static void searchForTarget(EntityCreature entity) {
        if (entity.field_70715_bh.field_75782_a.size() >= 1 || entity instanceof EntityEnderman || entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            entity.getEntityData().func_74768_a("ESM_TARGET_COOLDOWN", 0);
            return;
        }
        int cooldown = entity.getEntityData().func_74762_e("ESM_TARGET_COOLDOWN");
        if (cooldown > 0) {
            entity.getEntityData().func_74768_a("ESM_TARGET_COOLDOWN", cooldown - 1);
            return;
        }
        entity.getEntityData().func_74768_a("ESM_TARGET_COOLDOWN", 60);
        EntityLivingBase target = entity.func_70643_av();
        EntityLivingBase entityLivingBase = target = target != null && target.func_70089_S() ? target : entity.func_70638_az();
        EntityLivingBase entityLivingBase2 = target != null && target.func_70089_S() ? target : (target = entity.func_70777_m() instanceof EntityLivingBase ? (EntityLivingBase)entity.func_70777_m() : target);
        if (target != null && target.func_70089_S()) {
            if (ESM_Settings.TargetCap >= 0 && ESM_PathCapHandler.attackMap.get(target) != null && ESM_PathCapHandler.attackMap.get(target).size() > ESM_Settings.TargetCap && !ESM_Utils.isCloserThanOtherAttackers(entity.field_70170_p, (EntityLivingBase)entity, target)) {
                entity.func_70661_as().func_75499_g();
                entity.func_70624_b(null);
                entity.func_70784_b(null);
                entity.func_70604_c(null);
                return;
            }
            if (entity.func_70032_d((Entity)target) > (float)ESM_Settings.Awareness) {
                entity.func_70661_as().func_75499_g();
                entity.func_70624_b(null);
                entity.func_70784_b(null);
                entity.func_70604_c(null);
                return;
            }
            if (!entity.func_70781_l() && ESM_Settings.forcePath) {
                entity.func_70778_a(entity.field_70170_p.func_72865_a((Entity)entity, (Entity)target, (float)ESM_Settings.Awareness, true, false, false, true));
                entity.getEntityData().func_74768_a("ESM_TARGET_COOLDOWN", 10);
            }
            entity.func_70784_b((Entity)target);
            entity.func_70624_b(target);
            entity.func_70604_c(target);
            return;
        }
        EntityLivingBase closestTarget = null;
        ArrayList targets = new ArrayList();
        targets.addAll(entity.field_70170_p.func_82733_a(EntityLivingBase.class, entity.field_70121_D.func_72314_b((double)ESM_Settings.Awareness, (double)ESM_Settings.Awareness, (double)ESM_Settings.Awareness), (IEntitySelector)new GenericEntitySelector((EntityLivingBase)entity)));
        Collections.sort(targets, new EntityAINearestAttackableTarget.Sorter((Entity)entity));
        for (int i = 0; i < targets.size(); ++i) {
            EntityLivingBase subject = (EntityLivingBase)targets.get(i);
            if (ESM_Settings.TargetCap >= 0 && ESM_PathCapHandler.attackMap.get(subject) != null && ESM_PathCapHandler.attackMap.get(subject).size() >= ESM_Settings.TargetCap && !ESM_Utils.isCloserThanOtherAttackers(entity.field_70170_p, (EntityLivingBase)entity, subject)) continue;
            closestTarget = subject;
            break;
        }
        entity.func_70784_b(closestTarget);
        entity.func_70624_b(closestTarget);
        entity.func_70604_c(closestTarget);
        if (closestTarget != null) {
            entity.func_70778_a(entity.field_70170_p.func_72865_a((Entity)entity, (Entity)closestTarget, (float)ESM_Settings.Awareness, true, false, false, true));
            ESM_PathCapHandler.AddNewAttack((EntityLivingBase)entity, closestTarget);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
            ++this.ticks;
            if (this.ticks >= 100) {
                this.timer.stop();
                this.TPS = (float)this.ticks / (float)this.timer.elapsed(TimeUnit.MILLISECONDS) * 1000.0f;
                this.ticks = 0;
                this.timer.reset();
                this.timer.start();
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int z;
        int y;
        int x;
        if (ESM_EventManager.getPortalTime((Entity)event.entityLiving) >= event.entityLiving.func_82145_z() - 1 && ESM_EventManager.getInPortal((Entity)event.entityLiving) && ESM_Settings.NewHell) {
            if (event.entityLiving.field_71093_bK != -1) {
                event.entityLiving.field_71088_bW = event.entityLiving.func_82147_ab();
                ESM_EventManager.setInPortal((Entity)event.entityLiving, false);
                ESM_Utils.transferDimensions(-1, (Entity)event.entityLiving, false);
            } else {
                event.entityLiving.field_71088_bW = event.entityLiving.func_82147_ab();
                ESM_EventManager.setInPortal((Entity)event.entityLiving, false);
                ESM_Utils.transferDimensions(0, (Entity)event.entityLiving, false);
            }
        }
        if (event.entityLiving.field_70163_u < 0.0 && event.entityLiving.field_71093_bK == 1 && event.entityLiving instanceof EntityPlayer && ESM_Settings.NewEnd && ESM_Settings.fallFromEnd) {
            event.entityLiving.func_70107_b(event.entityLiving.field_70165_t, 255.0, event.entityLiving.field_70161_v);
            ESM_Utils.transferDimensions(0, (Entity)event.entityLiving, true);
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(!ESM_Settings.Apocalypse || event.entityLiving instanceof EntityPlayer || event.entityLiving instanceof EntityZombie || event.entityLiving instanceof EntityEnderman && ESM_Settings.EndermanMode.equalsIgnoreCase("Slender"))) {
            event.entityLiving.func_70106_y();
            return;
        }
        if (ESM_Settings.AIExempt.contains(EntityList.func_75619_a((Entity)event.entity))) {
            return;
        }
        if (event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).func_70638_az() != null) {
            ESM_PathCapHandler.AddNewAttack(event.entityLiving, ((EntityLiving)event.entityLiving).func_70638_az());
        } else if (event.entityLiving.func_70643_av() != null) {
            ESM_PathCapHandler.AddNewAttack(event.entityLiving, event.entityLiving.func_70643_av());
        } else if (event.entityLiving instanceof EntityCreature && ((EntityCreature)event.entityLiving).func_70777_m() != null && ((EntityCreature)event.entityLiving).func_70777_m() instanceof EntityLivingBase) {
            ESM_PathCapHandler.AddNewAttack(event.entityLiving, (EntityLivingBase)((EntityCreature)event.entityLiving).func_70777_m());
        }
        if (ESM_Settings.Awareness != 16 && (event.entityLiving instanceof EntityMob || event.entityLiving instanceof EntitySpider && !event.entityLiving.field_70170_p.func_72935_r())) {
            ESM_EventManager.searchForTarget((EntityCreature)event.entityLiving);
        }
        if (event.entityLiving instanceof EntityCreeper) {
            ESM_CreeperHandler.onLivingUpdate((EntityCreeper)event.entityLiving);
        } else if (event.entityLiving instanceof EntitySkeleton) {
            ESM_SkeletonHandler.onLivingUpdate((EntitySkeleton)event.entityLiving);
        } else if (event.entityLiving instanceof EntityBlaze) {
            ESM_BlazeHandler.onLivingUpdate((EntityBlaze)event.entityLiving);
        } else if (event.entityLiving instanceof EntityEnderman) {
            ESM_EndermanHandler.onLivingUpdate((EntityEnderman)event.entityLiving);
        } else if (ESM_Settings.moreSpawning && event.entityLiving instanceof EntityPlayer && event.entityLiving.func_70681_au().nextInt(25) == 0 && event.entityLiving.field_70170_p instanceof WorldServer && event.entityLiving.field_70170_p.func_72977_a((double)(x = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t) + event.entityLiving.func_70681_au().nextInt(48) - 24), (double)(y = MathHelper.func_76128_c((double)event.entityLiving.field_70163_u) + event.entityLiving.func_70681_au().nextInt(48) - 24), (double)(z = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v) + event.entityLiving.func_70681_au().nextInt(48) - 24), 8.0) == null && SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.monster, (World)event.entityLiving.field_70170_p, (int)x, (int)y, (int)z)) {
            BiomeGenBase.SpawnListEntry spawnlistentry = ((WorldServer)event.entityLiving.field_70170_p).func_73057_a(EnumCreatureType.monster, x, y, z);
            try {
                EntityLiving entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(event.entityLiving.field_70170_p);
                entityliving.func_70012_b((double)x, (double)y, (double)z, event.entityLiving.func_70681_au().nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)event.entityLiving.field_70170_p, (float)x, (float)y, (float)z);
                if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi()) {
                    event.entityLiving.field_70170_p.func_72838_d((Entity)entityliving);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        AxisAlignedBB bounds = event.entityLiving.func_70114_g((Entity)event.entityLiving);
        AxisAlignedBB axisAlignedBB = bounds = bounds != null ? bounds : event.entityLiving.func_70046_E();
        if (bounds != null && !event.entityLiving.field_70170_p.func_72872_a(EntityPlayer.class, bounds.func_72314_b(5.0, 5.0, 5.0)).isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (ESM_Settings.ResistanceCoolDown > 0) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, ESM_Settings.ResistanceCoolDown, 5));
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (ESM_Settings.ResistanceCoolDown > 0) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, ESM_Settings.ResistanceCoolDown, 5));
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (ESM_Settings.AllowSleep || event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            if (event.entityPlayer.func_70608_bn() || !event.entityPlayer.func_70089_S()) {
                return;
            }
            if (!event.entityPlayer.field_70170_p.field_73011_w.func_76567_e()) {
                return;
            }
            if (event.entityPlayer.field_70170_p.func_72935_r()) {
                return;
            }
            if (Math.abs(event.entityPlayer.field_70165_t - (double)event.x) > 3.0 || Math.abs(event.entityPlayer.field_70163_u - (double)event.y) > 2.0 || Math.abs(event.entityPlayer.field_70161_v - (double)event.z) > 3.0) {
                return;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = event.entityPlayer.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((double)event.x - d0), (double)((double)event.y - d1), (double)((double)event.z - d0), (double)((double)event.x + d0), (double)((double)event.y + d1), (double)((double)event.z + d0)));
            if (!list.isEmpty()) {
                return;
            }
        }
        event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
        if (event.entityPlayer.func_70115_ae()) {
            event.entityPlayer.func_70078_a((Entity)null);
        }
        event.entityPlayer.func_71063_a(new ChunkCoordinates(event.x, event.y, event.z), false);
        event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Spawnpoint set"));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        MinecraftServer server;
        if (!event.world.field_72995_K && (ESM_Settings.currentWorlds == null || ESM_Settings.worldDir == null) && (server = MinecraftServer.func_71276_C()).func_71278_l()) {
            ESM_Settings.currentWorlds = server.field_71305_c;
            ESM_Settings.worldDir = ESM.proxy.isClient() ? server.func_71209_f("saves/" + server.func_71270_I()) : server.func_71209_f(server.func_71270_I());
            ESM_Settings.LoadWorldConfig();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        MinecraftServer mc;
        if (!event.world.field_72995_K && !(mc = MinecraftServer.func_71276_C()).func_71278_l()) {
            ESM_PathCapHandler.attackMap.clear();
            ESM_Settings.currentWorlds = null;
            ESM_Settings.worldDir = null;
        }
    }

    public static int getPortalTime(Entity entity) {
        int time = -1;
        Field field = null;
        try {
            field = Entity.class.getDeclaredField("portalCounter");
        }
        catch (Exception e) {
            try {
                field = Entity.class.getDeclaredField("field_82153_h");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return time;
            }
        }
        field.setAccessible(true);
        try {
            time = field.getInt(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return time;
        }
        return time;
    }

    public static boolean getInPortal(Entity entity) {
        boolean flag = false;
        Field field = null;
        try {
            field = Entity.class.getDeclaredField("inPortal");
        }
        catch (Exception e) {
            try {
                field = Entity.class.getDeclaredField("field_71087_bX");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return flag;
            }
        }
        field.setAccessible(true);
        try {
            flag = field.getBoolean(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return flag;
        }
        return flag;
    }

    public static void setInPortal(Entity entity, boolean value) {
        Field field = null;
        try {
            field = Entity.class.getDeclaredField("inPortal");
        }
        catch (Exception e) {
            try {
                field = Entity.class.getDeclaredField("field_71087_bX");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return;
            }
        }
        field.setAccessible(true);
        try {
            field.setBoolean(entity, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static boolean isNearSpawner(World world, int x, int y, int z) {
        for (int i = x - 5; i < x + 5; ++i) {
            for (int j = y - 5; j < y + 5; ++j) {
                for (int k = z - 5; k < z + 5; ++k) {
                    if (!world.func_72863_F().func_73149_a(i >> 4, k >> 4) || world.func_147439_a(i, j, k) != Blocks.field_150474_ac) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("ESM")) {
            for (Configuration config : ESMGuiConfig.tempConfigs) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void allowDespawn(LivingSpawnEvent.AllowDespawn event) {
        if (!ESM_Settings.keepLoaded) {
            return;
        }
        if (event.entityLiving instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)event.entityLiving;
            if (creature.func_70777_m() != null && creature.func_70777_m() instanceof EntityPlayer && !creature.func_70777_m().field_70128_L) {
                event.setResult(Event.Result.DENY);
                return;
            }
        } else if (event.entityLiving instanceof EntityESMGhast) {
            EntityESMGhast ghast = (EntityESMGhast)event.entityLiving;
            if (ghast.field_70792_g != null && ghast.field_70792_g instanceof EntityPlayer && !ghast.field_70792_g.field_70128_L) {
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent
    public void allowSpawn(LivingSpawnEvent.CheckSpawn event) {
        BiomeGenBase biome = event.world.func_72807_a((int)event.x, (int)event.z);
        if (event.entityLiving instanceof EntityGhast && ESM_Settings.GhastDimensionBlacklist.contains(event.world.field_73011_w.field_76574_g) && !ESM_Utils.nativeGhastBiomes.contains(biome)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (event.entityLiving instanceof EntityBlaze && ESM_Settings.BlazeDimensionBlacklist.contains(event.world.field_73011_w.field_76574_g) && !ESM_Utils.nativeBlazeBiomes.contains(biome)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (event.entityLiving instanceof EntityMob && ESM_Settings.moreSpawning && event.getResult() != Event.Result.DENY) {
            int i = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t);
            int j = MathHelper.func_76128_c((double)event.entityLiving.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v);
            int l = event.entityLiving.field_70170_p.func_72957_l(i, j, k);
            if (event.entityLiving.field_70170_p.func_72911_I()) {
                int i1 = event.entityLiving.field_70170_p.field_73008_k;
                event.entityLiving.field_70170_p.field_73008_k = 10;
                l = event.entityLiving.field_70170_p.func_72957_l(i, j, k);
                event.entityLiving.field_70170_p.field_73008_k = i1;
            }
            if (event.world.func_72855_b(event.entityLiving.field_70121_D) && event.world.func_72945_a((Entity)event.entityLiving, event.entityLiving.field_70121_D).isEmpty() && !event.world.func_72953_d(event.entityLiving.field_70121_D) && ((EntityMob)event.entityLiving).func_70783_a(i, j, k) >= 0.0f && l <= 7) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

