/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.handlers.entities;

import funwayguy.esm.core.ESM_Settings;
import funwayguy.esm.core.ESM_Utils;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ESM_EndermanHandler {
    public static final AttributeModifier speedBoostMod = new AttributeModifier(UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0"), "Attacking speed boost", (double)6.2f, 0).func_111168_a(false);
    public static final AttributeModifier speedHaltMod = new AttributeModifier(UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A2"), "Staring speed halt", -1.0, 2).func_111168_a(false);

    public static void onEntityJoinWorld(EntityEnderman enderman) {
    }

    public static void onLivingUpdate(EntityEnderman enderman) {
        if (enderman.func_70777_m() != null && enderman.func_70777_m() instanceof EntityLivingBase) {
            IAttributeInstance attributeinstance;
            EntityLivingBase target = (EntityLivingBase)enderman.func_70777_m();
            if (ESM_Settings.EndermanMode.equalsIgnoreCase("Slender") && enderman.getEntityData().func_74767_n("ESM_LOOKED_AWAY")) {
                target.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
                target.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
                target.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 100, 0));
                attributeinstance = enderman.func_110148_a(SharedMonsterAttributes.field_111263_d);
                attributeinstance.func_111124_b(speedBoostMod);
                attributeinstance.func_111124_b(speedHaltMod);
                if (ESM_EndermanHandler.shouldAttackTarget(enderman, target) && enderman.func_70068_e((Entity)target) < 8.0) {
                    if (enderman.func_70681_au().nextInt(20) == 0 && ESM_Settings.EndermanPlayerTele) {
                        ESM_EndermanHandler.teleportTargetRandomly(target);
                    } else {
                        ESM_EndermanHandler.teleportTargetRandomly((EntityLivingBase)enderman);
                    }
                    enderman.field_70170_p.func_72956_a((Entity)enderman, "ambient.cave.cave", 1.0f, 0.5f);
                } else if (enderman.func_70681_au().nextInt(100) == 0) {
                    enderman.field_70170_p.func_72956_a((Entity)enderman, "ambient.cave.cave", 1.0f, 0.5f);
                }
            }
            if (ESM_Settings.EndermanMode.equalsIgnoreCase("Slender")) {
                if (!ESM_EndermanHandler.shouldAttackTarget(enderman, target)) {
                    enderman.getEntityData().func_74757_a("ESM_LOOKED_AWAY", true);
                } else {
                    attributeinstance = enderman.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    attributeinstance.func_111124_b(speedHaltMod);
                    attributeinstance.func_111121_a(speedHaltMod);
                }
            }
        } else {
            enderman.getEntityData().func_74757_a("ESM_LOOKED_AWAY", false);
            IAttributeInstance attributeinstance = enderman.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attributeinstance.func_111124_b(speedHaltMod);
            EntityLivingBase target = ESM_EndermanHandler.getValidTarget(enderman);
            if (target != null) {
                enderman.func_70784_b((Entity)target);
            }
        }
    }

    public static EntityLivingBase getValidTarget(EntityEnderman enderman) {
        EntityLivingBase target = ESM_Utils.GetNearestValidTarget((EntityLiving)enderman);
        if (target != null) {
            if (ESM_EndermanHandler.shouldAttackTarget(enderman, target)) {
                ESM_EndermanHandler.setAggressive(enderman, true);
                int stare = ESM_EndermanHandler.getStareTimer(enderman);
                if (stare == 0) {
                    enderman.field_70170_p.func_72956_a((Entity)target, "mob.endermen.stare", 1.0f, 1.0f);
                }
                ESM_EndermanHandler.setStareTimer(enderman, stare + 1);
                if (stare++ == 5) {
                    ESM_EndermanHandler.setStareTimer(enderman, 0);
                    enderman.func_70819_e(true);
                    return target;
                }
            } else {
                ESM_EndermanHandler.setStareTimer(enderman, 0);
            }
        }
        return null;
    }

    public static boolean shouldAttackTarget(EntityEnderman enderman, EntityLivingBase target) {
        ItemStack itemstack = target.func_71124_b(4);
        if (itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 vec3 = target.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)(enderman.field_70165_t - target.field_70165_t), (double)(enderman.field_70121_D.field_72338_b + (double)(enderman.field_70131_O / 2.0f) - (target.field_70163_u + (double)target.func_70047_e())), (double)(enderman.field_70161_v - target.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        if (d1 > 0.75 - 0.025 / d0 && ESM_Settings.EndermanMode.equalsIgnoreCase("Slender")) {
            return enderman.func_70685_l((Entity)target);
        }
        if (d1 > 1.0 - 0.025 / d0) {
            return enderman.func_70685_l((Entity)target);
        }
        return false;
    }

    public static void setAggressive(EntityEnderman enderman, boolean state) {
        Field field = null;
        try {
            field = EntityEnderman.class.getDeclaredField("isAggressive");
        }
        catch (Exception e) {
            try {
                field = EntityEnderman.class.getDeclaredField("field_104003_g");
            }
            catch (Exception e1) {
                e.printStackTrace();
                e1.printStackTrace();
                return;
            }
        }
        field.setAccessible(true);
        try {
            field.setBoolean(enderman, state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static int getStareTimer(EntityEnderman enderman) {
        return enderman.getEntityData().func_74762_e("ESM_STARETIMER");
    }

    public static void setStareTimer(EntityEnderman enderman, int stare) {
        enderman.getEntityData().func_74768_a("ESM_STARETIMER", stare);
    }

    public static boolean teleportTargetRandomly(EntityLivingBase target) {
        double d = target.field_70165_t + (target.func_70681_au().nextDouble() - 0.5) * 64.0;
        double d1 = target.field_70163_u + (double)(target.func_70681_au().nextInt(64) - 32);
        double d2 = target.field_70161_v + (target.func_70681_au().nextDouble() - 0.5) * 64.0;
        return ESM_EndermanHandler.teleportTargetTo(target, d, d1, d2);
    }

    public static boolean teleportTargetTo(EntityLivingBase target, double par1, double par3, double par5) {
        int k;
        int j;
        double d = target.field_70165_t;
        double d1 = target.field_70163_u;
        double d2 = target.field_70161_v;
        target.field_70165_t = par1;
        target.field_70163_u = par3;
        target.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)target.field_70165_t);
        if (target.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)target.field_70163_u), k = MathHelper.func_76128_c((double)target.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block i1 = target.field_70170_p.func_147439_a(i, j - 1, k);
                if (i1.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                target.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                target.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (target.field_70170_p.func_72945_a((Entity)target, target.field_70121_D).size() == 0 && !target.field_70170_p.func_72953_d(target.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            target.func_70107_b(d, d1, d2);
            return false;
        }
        int l = 128;
        for (int j1 = 0; j1 < l; ++j1) {
            double d3 = (double)j1 / ((double)l - 1.0);
            float f = (target.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (target.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (target.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d4 = d + (target.field_70165_t - d) * d3 + (target.func_70681_au().nextDouble() - 0.5) * (double)target.field_70130_N * 2.0;
            double d5 = d1 + (target.field_70163_u - d1) * d3 + target.func_70681_au().nextDouble() * (double)target.field_70131_O;
            double d6 = d2 + (target.field_70161_v - d2) * d3 + (target.func_70681_au().nextDouble() - 0.5) * (double)target.field_70130_N * 2.0;
            target.field_70170_p.func_72869_a("portal", d4, d5, d6, (double)f, (double)f1, (double)f2);
        }
        target.field_70170_p.func_72908_a(d, d1, d2, "mob.endermen.portal", 1.0f, 1.0f);
        target.field_70170_p.func_72956_a((Entity)target, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

