/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.world.gen;

import funwayguy.esm.core.ESM;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;

public abstract class FortressBase {
    public World worldObj;
    public int originX;
    public int originY;
    public int originZ;
    public int orientation;

    public FortressBase(World par1World, int chunkX, int chunkZ) {
        this.worldObj = par1World;
        this.originX = chunkX * 16;
        this.originZ = chunkZ * 16;
        this.originY = this.GetYHeight(this.originX + 8, 96, this.originZ + 8);
        this.orientation = par1World.field_73012_v.nextInt(4);
    }

    public int GetYHeight(int posX, int startY, int posZ) {
        int y;
        for (y = startY; y > 16 && (this.worldObj.func_147439_a(posX, y, posZ) != Blocks.field_150350_a || this.worldObj.func_147439_a(posX, y - 1, posZ) == Blocks.field_150350_a); --y) {
        }
        return y;
    }

    public abstract boolean buildStructure();

    protected void customFillWithBlocks(World par1World, int par3, int par4, int par5, int par6, int par7, int par8, Block block1, Block block2, boolean par11) {
        for (int var12 = par4; var12 <= par7; ++var12) {
            for (int var13 = par3; var13 <= par6; ++var13) {
                for (int var14 = par5; var14 <= par8; ++var14) {
                    if (par11 && this.customGetBlockAtCurrentPosition(this.worldObj, var13, var12, var14) == Blocks.field_150350_a) continue;
                    if (var12 != par4 && var12 != par7 && var13 != par3 && var13 != par6 && var14 != par5 && var14 != par8) {
                        this.customPlaceBlockAtCurrentPosition(this.worldObj, block2, 0, var13, var12, var14);
                        continue;
                    }
                    this.customPlaceBlockAtCurrentPosition(this.worldObj, block1, 0, var13, var12, var14);
                }
            }
        }
    }

    protected void customPlaceBlockAtCurrentPosition(World par1World, Block block, int par3, int par4, int par5, int par6) {
        int var8 = this.getXWithOffset(par4, par6);
        int var9 = this.getYWithOffset(par5);
        int var10 = this.getZWithOffset(par4, par6);
        par1World.func_147465_d(var8, var9, var10, block, par3, 2);
    }

    protected Block customGetBlockAtCurrentPosition(World par1World, int par2, int par3, int par4) {
        int var6 = this.getXWithOffset(par2, par4);
        int var7 = this.getYWithOffset(par3);
        int var8 = this.getZWithOffset(par2, par4);
        return par1World.func_147439_a(var6, var7, var8);
    }

    protected int customGetBlockSkyLightAtCurrentPosition(World par1World, int par2, int par3, int par4) {
        int var6 = this.getXWithOffset(par2, par4);
        int var7 = this.getYWithOffset(par3);
        int var8 = this.getZWithOffset(par2, par4);
        Chunk chunk = par1World.func_72938_d(var6, var8);
        return chunk.func_76614_a(EnumSkyBlock.Sky, var6 & 0xF, var7, var8 & 0xF);
    }

    protected boolean customGenerateStructureChestContents(World par1World, int par4, int par5, int par6) {
        int var9 = this.getXWithOffset(par4, par6);
        int var10 = this.getYWithOffset(par5);
        int var11 = this.getZWithOffset(par4, par6);
        par1World.func_147465_d(var9, var10, var11, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntityChest var12 = (TileEntityChest)par1World.func_147438_o(var9, var10, var11);
        if (var12 != null) {
            for (int i = 0; i <= var12.func_70302_i_(); ++i) {
                var12.func_70299_a(i, new ItemStack(Items.field_151062_by, 1, 0));
            }
            var12.func_70299_a(10, new ItemStack(Blocks.field_150475_bE, 1, 0));
            var12.func_70299_a(13, new ItemStack(Blocks.field_150475_bE, 1, 0));
            var12.func_70299_a(16, new ItemStack(Blocks.field_150475_bE, 1, 0));
        } else {
            ESM.log.log(Level.ERROR, "Loot chest did not generate loot correctly... did something override it?");
        }
        return true;
    }

    protected void customGenerateSpawner(World par1World, int par3, int par4, int par5, String par6) {
        int var3 = this.getXWithOffset(par3, par5);
        int var4 = this.getYWithOffset(par4);
        int var5 = this.getZWithOffset(par3, par5);
        par1World.func_147449_b(var3, var4, var5, Blocks.field_150474_ac);
        TileEntityMobSpawner var7 = (TileEntityMobSpawner)par1World.func_147438_o(var3, var4, var5);
        if (var7 != null) {
            var7.func_145881_a().func_98272_a(par6);
        }
    }

    protected void customPlaceIronDoorAtCurrentPosition(World par1World, int par4, int par5, int par6, int par7) {
        int var8 = this.getXWithOffset(par4, par6);
        int var9 = this.getYWithOffset(par5);
        int var10 = this.getZWithOffset(par4, par6);
        ItemDoor.func_150924_a((World)this.worldObj, (int)var8, (int)var9, (int)var10, (int)par7, (Block)Blocks.field_150454_av);
    }

    protected int getXWithOffset(int x, int z) {
        return x + this.originX;
    }

    protected int getYWithOffset(int y) {
        return y + this.originY;
    }

    protected int getZWithOffset(int x, int z) {
        return z + this.originZ;
    }
}

