/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.world.gen;

import funwayguy.esm.core.ESM_Utils;
import funwayguy.esm.world.gen.FortressBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class FortressSpace
extends FortressBase {
    static final Block baseBlock = Blocks.field_150343_Z;
    static final Block detailBlock = Blocks.field_150377_bs;

    public FortressSpace(World par1World, int chunkX, int chunkZ) {
        super(par1World, chunkX, chunkZ);
        this.originY = 64;
        this.orientation = 0;
    }

    @Override
    public boolean buildStructure() {
        if (ESM_Utils.isFortAt(this.worldObj, this.getXWithOffset(0, 0), this.getZWithOffset(0, 0), 32)) {
            return false;
        }
        ESM_Utils.addFortToDB(this.worldObj, this.getXWithOffset(0, 0), this.getZWithOffset(0, 0));
        this.buildTower(this.worldObj, -12, 0, -12, 2);
        this.buildTower(this.worldObj, 12, 0, 12, 2);
        this.buildTower(this.worldObj, 12, 0, -12, 2);
        this.buildTower(this.worldObj, -12, 0, 12, 2);
        this.buildTower(this.worldObj, 0, 0, 0, 4);
        this.buildWall(this.worldObj, -7, 0, -12, 1, 15, 1);
        this.buildWall(this.worldObj, -12, 0, -7, 0, 15, 1);
        this.buildWall(this.worldObj, 7, 0, 12, 3, 15, 1);
        this.buildWall(this.worldObj, 12, 0, 7, 2, 15, 1);
        int dragonX = this.getXWithOffset(0, 0);
        int dragonY = 96;
        int dragonZ = this.getZWithOffset(0, 0);
        EntityDragon var4 = new EntityDragon(this.worldObj);
        var4.func_70012_b((double)dragonX, (double)dragonY, (double)dragonZ, this.worldObj.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.worldObj.func_72838_d((Entity)var4);
        return true;
    }

    protected void buildTower(World world, int x, int y, int z, int floors) {
        int k;
        int i;
        if (floors < 1) {
            return;
        }
        this.customFillWithBlocks(world, x - 4, y, z - 2, x + 4, y, z + 2, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 3, y, z - 3, x + 3, y, z + 3, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 2, y, z - 4, x + 2, y, z + 4, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 4, y, z, x + 4, y, z, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x, y, z - 4, x, y, z + 4, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x - 1, y, z - 1, x + 1, y, z + 1, detailBlock, detailBlock, false);
        for (i = -4; i <= 4; i += 8) {
            for (k = -2; k <= 2; k += 4) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -3; i <= 3; i += 6) {
            for (k = -3; k <= 3; k += 6) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -2; i <= 2; i += 4) {
            for (k = -4; k <= 4; k += 8) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -2; i <= 2; i += 4) {
            for (k = -4; k <= 4; k += 8) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -1; i <= 1; i += 2) {
            for (k = -4; k <= 4; k += 8) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -4; i <= 4; i += 8) {
            for (k = -1; k <= 1; k += 2) {
                this.customFillWithBlocks(world, x + i, y, z + k, x + i, y + 4, z + k, baseBlock, baseBlock, false);
            }
        }
        for (i = -1; i <= 1; i += 2) {
            for (k = -4; k <= 4; k += 8) {
                this.customFillWithBlocks(world, x + i, y + 1, z + k, x + i, y + 3, z + k, detailBlock, detailBlock, false);
            }
        }
        for (i = -4; i <= 4; i += 8) {
            for (k = -1; k <= 1; k += 2) {
                this.customFillWithBlocks(world, x + i, y + 1, z + k, x + i, y + 3, z + k, detailBlock, detailBlock, false);
            }
        }
        this.customFillWithBlocks(world, x - 4, y, z, x - 4, y + 4, z, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x + 4, y, z, x + 4, y + 4, z, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x, y, z - 4, x, y + 4, z - 4, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x, y, z + 4, x, y + 4, z + 4, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x - 4, y + 1, z, x - 4, y + 3, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x + 4, y + 1, z, x + 4, y + 3, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x, y + 1, z - 4, x, y + 3, z - 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x, y + 1, z + 4, x, y + 3, z + 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        for (int currentFloor = 1; currentFloor < floors; ++currentFloor) {
            int k2;
            int i2;
            this.customFillWithBlocks(world, x - 4, y + currentFloor * 5, z - 2, x + 4, y + currentFloor * 5, z + 2, baseBlock, baseBlock, false);
            this.customFillWithBlocks(world, x - 3, y + currentFloor * 5, z - 3, x + 3, y + currentFloor * 5, z + 3, baseBlock, baseBlock, false);
            this.customFillWithBlocks(world, x - 2, y + currentFloor * 5, z - 4, x + 2, y + currentFloor * 5, z + 4, baseBlock, baseBlock, false);
            this.customFillWithBlocks(world, x - 1, y + currentFloor * 5, z - 1, x + 1, y + currentFloor * 5, z + 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.customFillWithBlocks(world, x - 4, y + currentFloor * 5, z, x + 4, y + currentFloor * 5, z, detailBlock, detailBlock, false);
            this.customFillWithBlocks(world, x, y + currentFloor * 5, z - 4, x, y + currentFloor * 5, z + 4, detailBlock, detailBlock, false);
            for (i2 = -4; i2 <= 4; i2 += 8) {
                for (k2 = -2; k2 <= 2; k2 += 4) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -3; i2 <= 3; i2 += 6) {
                for (k2 = -3; k2 <= 3; k2 += 6) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -2; i2 <= 2; i2 += 4) {
                for (k2 = -4; k2 <= 4; k2 += 8) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -2; i2 <= 2; i2 += 4) {
                for (k2 = -4; k2 <= 4; k2 += 8) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -1; i2 <= 1; i2 += 2) {
                for (k2 = -4; k2 <= 4; k2 += 8) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -4; i2 <= 4; i2 += 8) {
                for (k2 = -1; k2 <= 1; k2 += 2) {
                    this.customFillWithBlocks(world, x + i2, y + currentFloor * 5, z + k2, x + i2, y + 4 + currentFloor * 5, z + k2, baseBlock, baseBlock, false);
                }
            }
            for (i2 = -1; i2 <= 1; i2 += 2) {
                for (k2 = -4; k2 <= 4; k2 += 8) {
                    this.customFillWithBlocks(world, x + i2, y + 2 + currentFloor * 5, z + k2, x + i2, y + 3 + currentFloor * 5, z + k2, detailBlock, detailBlock, false);
                }
            }
            for (i2 = -4; i2 <= 4; i2 += 8) {
                for (k2 = -1; k2 <= 1; k2 += 2) {
                    this.customFillWithBlocks(world, x + i2, y + 2 + currentFloor * 5, z + k2, x + i2, y + 3 + currentFloor * 5, z + k2, detailBlock, detailBlock, false);
                }
            }
            this.customFillWithBlocks(world, x - 4, y + currentFloor * 5, z, x - 4, y + 4 + currentFloor * 5, z, detailBlock, detailBlock, false);
            this.customFillWithBlocks(world, x + 4, y + currentFloor * 5, z, x + 4, y + 4 + currentFloor * 5, z, detailBlock, detailBlock, false);
            this.customFillWithBlocks(world, x, y + currentFloor * 5, z - 4, x, y + 4 + currentFloor * 5, z - 4, detailBlock, detailBlock, false);
            this.customFillWithBlocks(world, x, y + currentFloor * 5, z + 4, x, y + 4 + currentFloor * 5, z + 4, detailBlock, detailBlock, false);
            this.customFillWithBlocks(world, x - 4, y + 2 + currentFloor * 5, z, x - 4, y + 3 + currentFloor * 5, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.customFillWithBlocks(world, x + 4, y + 2 + currentFloor * 5, z, x + 4, y + 3 + currentFloor * 5, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.customFillWithBlocks(world, x, y + 2 + currentFloor * 5, z - 4, x, y + 3 + currentFloor * 5, z - 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.customFillWithBlocks(world, x, y + 2 + currentFloor * 5, z + 4, x, y + 3 + currentFloor * 5, z + 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        }
        this.customFillWithBlocks(world, x - 4, y + floors * 5, z - 2, x + 4, y + floors * 5, z + 2, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 3, y + floors * 5, z - 3, x + 3, y + floors * 5, z + 3, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 2, y + floors * 5, z - 4, x + 2, y + floors * 5, z + 4, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 4, y + floors * 5, z, x + 4, y + floors * 5, z, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x, y + floors * 5, z - 4, x, y + floors * 5, z + 4, detailBlock, detailBlock, false);
        this.customFillWithBlocks(world, x - 1, y + floors * 5, z - 1, x + 1, y + floors * 5, z + 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x - 4, y + floors * 5 + 1, z - 4, x + 4, y + floors * 5 + 1, z + 4, baseBlock, baseBlock, false);
        this.customFillWithBlocks(world, x - 3, y + floors * 5 + 1, z - 3, x + 3, y + floors * 5 + 1, z + 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x - 2, y + floors * 5 + 1, z - 4, x + 2, y + floors * 5 + 1, z + 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customFillWithBlocks(world, x - 4, y + floors * 5 + 1, z - 2, x + 4, y + floors * 5 + 1, z + 2, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 4, y + floors * 5 + 2, z - 4);
        this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 4, y + floors * 5 + 2, z + 4);
        this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 4, y + floors * 5 + 2, z + 4);
        this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 4, y + floors * 5 + 2, z - 4);
        for (i = -2; i < 3; ++i) {
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + floors * 5 + 1, z + 5);
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + floors * 5 + 1, z - 5);
            if (i % 2 != 0) continue;
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + floors * 5 + 2, z + 5);
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + floors * 5 + 2, z - 5);
        }
        for (i = -2; i < 3; ++i) {
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 5, y + floors * 5 + 1, z + i);
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 5, y + floors * 5 + 1, z + i);
            if (i % 2 != 0) continue;
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 5, y + floors * 5 + 2, z + i);
            this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 5, y + floors * 5 + 2, z + i);
        }
        this.customFillWithBlocks(world, x, y, z, x, y + floors * 5 + 1, z, detailBlock, detailBlock, false);
        EntityEnderCrystal crystal = new EntityEnderCrystal(world);
        crystal.func_70012_b((double)((float)this.getXWithOffset(x, z) + 0.5f), (double)(64 + y + floors * 5 + 2), (double)((float)this.getZWithOffset(x, z) + 0.5f), 0.0f, 0.0f);
        world.func_72838_d((Entity)crystal);
        world.func_147465_d(this.getXWithOffset(x, z), 64 + y + floors * 5 + 2, this.getZWithOffset(x, z), Blocks.field_150357_h, 0, 2);
    }

    protected void buildWall(World world, int x, int y, int z, int direction, int length, int phase) {
        switch (direction) {
            case 0: {
                this.customFillWithBlocks(world, x - 2, y + 0, z, x + 2, y + 5, z + length - 1, baseBlock, baseBlock, false);
                this.customFillWithBlocks(world, x - 1, y + 1, z, x + 1, y + 4, z + length - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.customFillWithBlocks(world, x + 2, y + 5, z, x + 2, y + 5, z + length - 1, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x + 0, y + 5, z, x + 0, y + 5, z + length - 1, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x - 2, y + 5, z, x - 2, y + 5, z + length - 1, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x + 0, y, z, x + 0, y, z + length - 1, detailBlock, detailBlock, false);
                for (int i = 0; i < length; ++i) {
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 2, y + 6, z + i);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 2, y + 6, z + i);
                    if (i % 2 != phase) continue;
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 2, y + 7, z + i);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 2, y + 7, z + i);
                }
                break;
            }
            case 1: {
                this.customFillWithBlocks(world, x, y + 0, z - 2, x + length - 1, y + 5, z + 2, baseBlock, baseBlock, false);
                this.customFillWithBlocks(world, x, y + 1, z - 1, x + length - 1, y + 4, z + 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.customFillWithBlocks(world, x, y + 5, z - 2, x + length - 1, y + 5, z - 2, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x, y + 5, z + 0, x + length - 1, y + 5, z + 0, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x, y + 5, z + 2, x + length - 1, y + 5, z + 2, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x, y, z + 0, x + length - 1, y, z + 0, detailBlock, detailBlock, false);
                for (int i = 0; i < length; ++i) {
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + 6, z - 2);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + 6, z + 2);
                    if (i % 2 != phase) continue;
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + 7, z - 2);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + i, y + 7, z + 2);
                }
                break;
            }
            case 2: {
                this.customFillWithBlocks(world, x - 2, y + 0, z - length + 1, x + 2, y + 5, z, baseBlock, baseBlock, false);
                this.customFillWithBlocks(world, x - 1, y + 1, z - length + 1, x + 1, y + 4, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.customFillWithBlocks(world, x + 2, y + 5, z - length + 1, x + 2, y + 5, z, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x + 0, y + 5, z - length + 1, x + 0, y + 5, z, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x - 2, y + 5, z - length + 1, x - 2, y + 5, z, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x + 0, y, z - length, x + 0, y, z, detailBlock, detailBlock, false);
                for (int i = 0; i < length; ++i) {
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 2, y + 6, z - i);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 2, y + 6, z - i);
                    if (i % 2 != phase) continue;
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - 2, y + 7, z - i);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x + 2, y + 7, z - i);
                }
                break;
            }
            case 3: {
                this.customFillWithBlocks(world, x - length + 1, y + 0, z - 2, x, y + 5, z + 2, baseBlock, baseBlock, false);
                this.customFillWithBlocks(world, x - length + 1, y + 1, z - 1, x, y + 4, z + 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.customFillWithBlocks(world, x - length + 1, y + 5, z - 2, x, y + 5, z - 2, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x - length + 1, y + 5, z + 0, x, y + 5, z + 0, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x - length + 1, y + 5, z + 2, x, y + 5, z + 2, detailBlock, detailBlock, false);
                this.customFillWithBlocks(world, x - length + 1, y, z + 0, x, y, z + 0, detailBlock, detailBlock, false);
                for (int i = 0; i < length; ++i) {
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - i, y + 6, z - 2);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - i, y + 6, z + 2);
                    if (i % 2 != phase) continue;
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - i, y + 7, z - 2);
                    this.customPlaceBlockAtCurrentPosition(world, baseBlock, 0, x - i, y + 7, z + 2);
                }
                break;
            }
        }
    }
}

