/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.esm.world.gen;

import cpw.mods.fml.common.IWorldGenerator;
import funwayguy.esm.core.ESM;
import funwayguy.esm.core.ESM_Settings;
import funwayguy.esm.world.gen.FortressDesert;
import funwayguy.esm.world.gen.FortressHell;
import funwayguy.esm.world.gen.FortressJungle;
import funwayguy.esm.world.gen.FortressSpace;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.Level;

public class WorldGenFortress
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int blockZ;
        int blockX;
        ChunkCoordinates spawnPoint;
        BiomeGenBase biome = world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
        int chance = 1;
        if (ESM_Settings.fortRarity > 1) {
            chance = ESM_Settings.fortRarity;
        }
        if ((spawnPoint = world.field_73011_w.getSpawnPoint()).func_71569_e(blockX = chunkX * 16 + 8, 64, blockZ = chunkZ * 16 + 8) < (float)(ESM_Settings.fortDistance * ESM_Settings.fortDistance)) {
            return;
        }
        ArrayList<BiomeDictionary.Type> typeList = new ArrayList<BiomeDictionary.Type>();
        BiomeDictionary.Type[] typeArray = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < typeArray.length; ++i) {
            typeList.add(typeArray[i]);
        }
        if (random.nextInt(chance) == 0 && ESM_Settings.SpawnForts) {
            FortressDesert fortD;
            if (typeList.contains(BiomeDictionary.Type.JUNGLE)) {
                FortressJungle fortJ = new FortressJungle(world, chunkX, chunkZ);
                if (fortJ.buildStructure()) {
                    ESM.log.log(Level.INFO, "New Jungle Fortress at (" + chunkX * 16 + "," + chunkZ * 16 + ")");
                }
            } else if (typeList.contains(BiomeDictionary.Type.END) && world.field_73011_w.field_76574_g == 1 && ESM_Settings.NewEnd) {
                FortressSpace fortS = new FortressSpace(world, chunkX, chunkZ);
                if (fortS.buildStructure()) {
                    ESM.log.log(Level.INFO, "New End Fortress at (" + chunkX * 16 + "," + chunkZ * 16 + ")");
                }
            } else if (typeList.contains(BiomeDictionary.Type.NETHER)) {
                FortressHell fortH = new FortressHell(world, chunkX, chunkZ);
                if (fortH.buildStructure()) {
                    ESM.log.log(Level.INFO, "New Hell Fortress at (" + chunkX * 16 + "," + chunkZ * 16 + ")");
                }
            } else if ((typeList.contains(BiomeDictionary.Type.SANDY) || typeList.contains(BiomeDictionary.Type.WASTELAND) || typeList.contains(BiomeDictionary.Type.SNOWY) || typeList.contains(BiomeDictionary.Type.JUNGLE) || typeList.contains(BiomeDictionary.Type.SWAMP)) && (fortD = new FortressDesert(world, chunkX, chunkZ, biome)).buildStructure()) {
                ESM.log.log(Level.INFO, "New Desert Fortress at (" + chunkX * 16 + "," + chunkZ * 16 + ")");
            }
        }
    }
}

