-- Register functionality by: Ian898 
-- Date: 26/11/2018
-- THANK YOU IAN!

-- "by" Team LTW
-- used to add extendedDriving


g_specializationManager:addSpecialization("extendedDriving", "extendedDriving", g_currentModDirectory.."extendedDriving.lua")

registerExtendedDriving = {}

function registerExtendedDriving:register(name)
    
	local addSpec = false
	
    for _, vehicle in pairs(g_vehicleTypeManager:getVehicleTypes()) do
        
        local drivable = false;
        local extendedDriving = false;
		
        
        for _, spec in pairs(vehicle.specializationNames) do
        
            if spec == "drivable" then -- check for drivable, only insert into drivable
                drivable = true;
            end
            
            if spec == "extendedDriving" then -- don't insert if already inserted
                extendedDriving = true;
            end
            
        end    
        if drivable and not extendedDriving then
            g_vehicleTypeManager:addSpecialization(vehicle.name, "FS19_extendedDriving.extendedDriving")
			addSpec = true
        end
    end
	if addSpec then
		print("Register specialization extendedDriving V1.0.0.0 -- (by Team LTW)")
    end
end

VehicleTypeManager.finalizeVehicleTypes = Utils.prependedFunction(VehicleTypeManager.finalizeVehicleTypes, registerExtendedDriving.register)