FIFA = 23
DEFAULT_PROC_NAME = "FIFA23.exe"

FUT_API_PAGE = 1
URL_LINKS = {
    FUT = {
        player_details = 'https://www.futbin.com/%d/player/%d/',
        player_search = 'https://www.futbin.com/search',
        card_bg = 'https://cdn.futbin.com/content/FIFA23/img/cards/'
    },
    PATREON = "https://www.patreon.com/xAranaktu",
    DISCORD = "https://discord.gg/va9EtdB",
    VERSION = "https://raw.githubusercontent.com/xAranaktu/FIFA-23-CM-Cheat-Table/master/VERSION",
    CDN = "https://fifatracker-cdn.fra1.digitaloceanspaces.com",
}

CT_MEMORY_RECORDS = {
    GUI_SCRIPT = 15,
    PLAYERS_PRIMARY_POS = 46,
    PLAYERS_SECONDARY_POS = 42,
    PLAYERS_NATIONALITY = 89,
    CUSTOM_TRANSFERS = 3034,

    HEIGHT_CB = 39,
    WEIGHT_CB = 53,
    SKINCOLOR_CB = 106,
    HEADTYPE_CB = 35,
    HAIRCOLOR_CB = 4880,
    BODYTYPE_CB = 119,
    NO_YES_CB = 17,
    FIVE_STARS_CB = 103,
    WR_CB = 70,
    GENDER_CB = 58,
    PREFERREDFOOT_CB = 90,
    ZERO_TEN = 5029,
    FORMATION_CB = 5256
}

AOB_PATTERNS = {
    fnGetColData = '40 53 48 83 EC 30 4C 8B D2 4D 8B D8 8B 12 8D 42 FD 83 F8 01',
    AltTab = '48 83 EC 48 48 83 3D ?? ?? ?? ?? ?? 74 4F 48 8D 0D',
    pModeManagers = '4C 89 25 ?? ?? ?? ?? 4C 89 35 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? EB 03',
    DatabaseBasePtr = 'E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 44 24 30',
    ScreenID = '49 8B D4 A8 01 4C 8B C6 48 0F 45 15',
    GTNRevealPlayerData = '41 8B 8F 98 02 00 00 39',
    UnlimitedPlayerRelease = '8B 46 10 39 45 54',
    ReleasePlayerMsgBox = 'FF 94 24 C0 00 00 00 89 44 24 60',
    ReleasePlayerFee = '41 8B 55 10 4C 63 F0',
    ReleasePlayerFeeTwo = '49 63 C0 48 01 01',
    HireScout = '89 84 24 28 01 00 00 48 8D 4C 24 60',
    YouthAcademyAllCountriesAvailable = '8B 0C 90 41 8D 57 21',
    YACountryIsBeingScouted = '40 80 FE 01 75 0C 4C 8D 05',
    SideManipulator = '48 8B 84 CF 18 01 00 00 83',
    PGMApplyXp = 'F3 0F 2C C1 41 01 07',
    CoachTrainingAlwaysA = '66 C7 46 04 01 01 8B',
    MatchScore = '8B 90 B4 26 02 00',
    MatchTimer = '8B 41 50 89 47 10',
    DisableSubstitutions = '44 8B B4 1E 5C A7 00 00',
    IngameStamina = '89 83 A0 04 00 00 8B 47',
    UnlimitedSubstitutions = '8B 84 01 0C 9F 00 00',
    EditReleaseClause = '8B 48 08 83 F9 FF 74 06 89 8B',
    AllowTransferAppThTxt = '8B D8 83 F8 0E 77',
    AllowTransferAppBtnClick = '44 8B F0 89 45 67',
    AllowSign = '41 FF D1 89 45 50',
    AllowLoanApp = '44 8B F8 89 45 50',
    CustomManagerEditable = 'C7 85 C4 00 00 00 0F 27 00 00 39',
    ManagerNeverRetire = '8B AB 24 03 00 00 8B',
    UpdateManagerRating = '8B 00 4C 8D 9C 24 F8 00 00 00',
    GetManagerRating = '48 8D 05 ?? ?? ?? ?? 4D 89 B4 24 ?? ?? ?? ?? 41 BD',
    IntJobOffer = '48 2B 88 80 01 00 00 48 B8 89 88 88 88 88 88 88 88 48 F7 E9 48 03 D1 48 C1 FA 05 48 8B C2 48 C1 E8 3F 48 03 D0 85 D2',
    ClubJobOfferAlwaysAccept = 'FF 50 08 3B 47 2C',
    ClubJobOffer = 'FF 50 78 48 8B BE D8 00 00 00',
    OnSharpnessChange = '41 88 69 24 48 83 C4 30',
    OnStaminaChange1 = '88 51 11 3B 46 10',
    EditPlayerName = 'C6 44 24 20 00 C6 44 24 2F 0F 48 C7 44 24 30 00 00 00 00 80 78 01',

    ChangeStadium = '41 8B B4 24 C4 18 00 00',
    MatchHalfLength = '45 8B 84 24 E8 18 00 00',
    MatchWeather = '83 F8 FF 0F 44 C6 48 81',
    MatchTODDisplay = '44 8B 4F 40 C1 FA 05',
    MatchTODReal = '49 8B C5 B9 02 00 00 00',

    AgreeTransferRequest = '44 8B E8 48 8B 89 98 01 00 00',

    YAMaxPerReport = '47 8B 44 FE 58',
    VProSkillPoints = '8B 48 04 89 8B 8C 06 00 00',
    CreatedPlayerTrainingXP = '49 8B 46 50 4D 8D 4E 40',

    GenNewYAReport = '83 C0 0E F2 0F 11 54 24 2C',
    fnGenYAReport = '40 55 57 48 8D 6C 24 ?? 48 81 EC ?? ?? ?? ?? 48 8B 01 48 8B F9 FF 50 08 84 C0 0F 84 ?? ?? ?? ?? 48 8B 57 08 48 89 9C 24 ?? ?? ?? ?? 4C 89 B4 24 ?? ?? ?? ??',
    YouthAcademyGeneratePlayer = '28 FF FF FF FF 48 8B 5C 24 70',
    YASomeScoutIni = '48 48 8B 07 48 8B 80 98 01 00 00',

    -- On view scout report
    YAYouthPlayerUtilSettings = '48 8B 51 18 48 8D 8D ?? ?? ?? ?? 48 83 C2 08 E8 ?? ?? ?? ?? 44 8B 85 ?? ?? ?? ?? 45 8B F8 48 63 44 24',

    FreezeLineup = '48 89 5C 24 ?? 48 89 74 24 ?? 57 48 83 EC 20 41 83 38 FF 49 8B F8 48 8B 01 8B F2 48 8B D9 75 0B 49 8B D0 FF 90',
    ContractNeg = '48 8B 50 38 48 83 EA 40 49 FF 60 08 CC CC CC CC CC',
    NegStatusCheck = 'FF 90 40 01 00 00 89 47 18',
    GameSettings = '49 63 CD 8B 34 C8',


    -- Free fly camera
    CAM_ROTATE = "F3 0F 11 83 C8 05 00 00 F3",
    FULL_ANGLE_ROTV = "F3 0F 10 40 60 F3 0F 58 83 B4",
    CAM_TARGET = "0F 11 AB 60 0B 00 00",
    CAM_V_ROTATE_SPEED_MUL = "F3 41 0F 5E C5 F3 0F 11 83 B0",
    CAM_H_ROTATE_SPEED_MUL = "F3 0F 11 83 AC 0B 00 00",
    CAM_Z_ROTATE_SPEED_MUL = "F3 0F 11 83 B4 0B 00 00 F3",
    STADIUM_BOUNDARY = "0F 10 32 0F 28 D6 0F C6 C0 00", -- XMM5?
    CAM_Z_BOUNDARY = "66 0F 70 0A ?? 0F 28 05 ?? ?? ?? ?? 0F 2F C1 76",

    CustomTransfers = '4C 8B C3 48 8B 01 74 0C FF 50 10',

    -- FootballCompEng_Win64_retail.dll
    -- FootballCompEng = {
    --     MODULE_NAME = 'FootballCompEng_Win64_retail.dll',
    --     AOBS = {
    --         SimMatchSettings = '8B A8 A4 00 00 00',
    --         Calendar = '41 8B C4 49 8B D4',
    --         --MatchFixing = '48 8B 0B 48 8B 00',
    --         --MatchFixingGoals = '48 8B 3C C8 48 85 FF 74 ?? 48 8B 4E 10'
    --     }
    -- }
}

DEFAULT_CFG = {
    flags = {
        debug_mode = false,
        no_images = false,
        deactive_on_close = false,
        hide_ce_scanner = false,
        check_for_update = true,
        only_check_for_free_update = false,
        cache_players_data = false,
        hide_players_potential = false
    },
    directories = {
    },
    game =
    {
        name = DEFAULT_PROC_NAME,
        name_trial = "FIFA23_TRIAL.exe"
    },
    gui = {
        opacity = 255
    },
    auto_activate = {
        18,      -- Scripts
        214      -- FIFA Database Tables
    },
    hotkeys = {
        sync_with_game = 'VK_F5',
        search_player_by_id = 'VK_RETURN'
    },
    theme = {
        default = 'dark',
        current = 'dark'
    },
    language = {
        default = 'en_US',
        current = 'en_US'
    },
    other = {
        ignore_update = "23.1.0.0"
    }
}

DB_TABLE_STRUCT_OFFSETS = {
    first_record = 0x30,                -- 8 bytes
    shortname = 0x40,                   -- 4 bytes
    record_size = 0x44,                 -- 4 bytes
    bit_records_count = 0x48,           -- 4 bytes
    compressed_str_len = 0x50,          -- 4 bytes
    total_records = 0x78,               -- 2 bytes
    total_records2 = 0x7A,              -- 2 bytes
    written_records = 0x7C,             -- 2 bytes
    canceled_records = 0x7E,            -- 2 bytes
    fieldcount = 0x82                   -- 1 bytes
}

DB_TABLES_META_MAP = {
    dcplayernames = {
        nameid = 1,
        name = 2
    },
    editedplayernames = {
        playerid = 1,
        firstname = 2,
        surname = 3,
        playerjerseyname = 4,
        commonname = 5
    },
    teams = {
        teamid = 1,
        stadiummowpattern_code = 2,
        goalnetstanchioncolor2b = 3,
        penaltytakerid = 4,
        trait1vweak = 5,
        domesticcups = 6,
        goalnetstanchioncolor2r = 7,
        captainid = 8,
        longitude = 9,
        clubworth = 10,
        offensivewidth = 11,
        teamstadiumcapacity = 12,
        goalnetstanchioncolor1b = 13,
        goalnetstanchioncolor1r = 14,
        longkicktakerid = 15,
        stanchionflamethrower = 16,
        uefa_consecutive_wins = 17,
        profitability = 18,
        pitchwear = 19,
        buildupplay = 20,
        form = 21,
        playsurfacetype = 22,
        leftcornerkicktakerid = 23,
        stadiumgoalnetstyle = 24,
        crowdregion = 25,
        popularity = 26,
        numtransfersin = 27,
        personalityid = 28,
        opponentstrongthreshold = 29,
        hasstandingcrowd = 30,
        genericint1 = 31,
        favoriteteamsheetid = 32,
        goalnetstanchioncolor1g = 33,
        haslargeflag = 34,
        midfieldrating = 35,
        defensivestyle = 36,
        attackrating = 37,
        hasvikingclap = 38,
        prev_el_champ = 39,
        ethnicity = 40,
        trait1vstrong = 41,
        iscompetitionpoleflagenabled = 42,
        goalnetstanchioncolor2g = 43,
        domesticprestige = 44,
        flamethrowercannon = 45,
        playersinboxfk = 46,
        assetid = 47,
        matchdaydefenserating = 48,
        playersinboxcross = 49,
        utcoffset = 50,
        teamcolor3b = 51,
        crowdskintonecode = 52,
        teamcolor2r = 53,
        freekicktakerid = 54,
        teamcolor2b = 55,
        offensivestyle = 56,
        presassetone = 57,
        teamcolor3r = 58,
        leftfreekicktakerid = 59,
        trainingstadium = 60,
        internationalprestige = 61,
        rivalteam = 62,
        matchdayattackrating = 63,
        genericbanner = 64,
        teamcolor1r = 65,
        defensivedepth = 66,
        cityid = 67,
        matchdayoverallrating = 68,
        uefa_el_wins = 69,
        hastifo = 70,
        teamcolor1b = 71,
        matchdaymidfieldrating = 72,
        playersinboxcorner = 73,
        stadiumgoalnetpattern = 74,
        powid = 75,
        genericint2 = 76,
        trait1vequal = 77,
        opponentweakthreshold = 78,
        teamcolor1g = 79,
        iscompetitionscarfenabled = 80,
        skinnyflags = 81,
        defenserating = 82,
        leaguetitles = 83,
        rightcornerkicktakerid = 84,
        uefa_cl_wins = 85,
        uefa_uecl_wins = 86,
        hassubstitutionboard = 87,
        pitchcolor = 88,
        ballid = 89,
        defensivewidth = 90,
        chancecreation = 91,
        teamcolor2g = 92,
        latitude = 93,
        isbannerenabled = 94,
        foundationyear = 95,
        jerseytype = 96,
        teamname = 97,
        iscompetitioncrowdcardsenabled = 98,
        youthdevelopment = 99,
        pitchlinecolor = 100,
        teamcolor3g = 101,
        rightfreekicktakerid = 102,
        overallrating = 103,
        presassettwo = 104
    },
    career_users = {
        userid = 1,
        sponsorid = 2,
        leagueseasonmessagesent = 3,
        firstname = 4,
        surname = 5,
        agentname = 6,
        playertype = 7,
        nationalteamid = 8,
        usertype = 9,
        clubteamid = 10,
        leagueid = 11,
        wage = 12,
        commonname = 13,
        seasoncount = 14,
        goalnews = 15,
        nationalityid = 16,
        primarycompobjid = 17
    },
    career_playercontract = {
        playerid = 1,
        teamid = 2,
        loan_wage_split = 3,
        performancebonuscountachieved = 4,
        contract_date = 5,
        signon_bonus = 6,
        contract_status = 7,
        performancebonuscount = 8,
        playerrole = 9,
        wage = 10,
        performancebonustype = 11,
        duration_months = 12,
        performancebonusvalue = 13,
        isperformancebonusachieved = 14,
        last_status_change_date = 15
    },
    default_teamsheets = {
        teamid = 1,
        customsub1in = 2,
        customsub2out = 3,
        customsub0in = 4,
        customsub2in = 5,
        playerid51 = 6,
        penaltytakerid = 7,
        playerid10 = 8,
        customsub1out = 9,
        playerid49 = 10,
        playerid14 = 11,
        playerid41 = 12,
        playerid45 = 13,
        playerid18 = 14,
        captainid = 15,
        playerid30 = 16,
        playerid34 = 17,
        playerid6 = 18,
        playerid2 = 19,
        playerid38 = 20,
        longkicktakerid = 21,
        playerid28 = 22,
        playerid20 = 23,
        playerid24 = 24,
        playerid29 = 25,
        playerid25 = 26,
        leftcornerkicktakerid = 27,
        playerid21 = 28,
        playerid35 = 29,
        playerid31 = 30,
        playerid3 = 31,
        playerid39 = 32,
        playerid7 = 33,
        playerid15 = 34,
        playerid48 = 35,
        playerid11 = 36,
        playerid19 = 37,
        playerid44 = 38,
        playerid40 = 39,
        playerid50 = 40,
        playerid42 = 41,
        playerid46 = 42,
        playerid13 = 43,
        freekicktakerid = 44,
        playerid17 = 45,
        leftfreekicktakerid = 46,
        playerid23 = 47,
        playerid27 = 48,
        customsub0out = 49,
        playerid5 = 50,
        playerid1 = 51,
        playerid33 = 52,
        playerid9 = 53,
        playerid37 = 54,
        playerid0 = 55,
        playerid4 = 56,
        playerid36 = 57,
        playerid32 = 58,
        playerid8 = 59,
        playerid26 = 60,
        playerid22 = 61,
        rightcornerkicktakerid = 62,
        playerid47 = 63,
        playerid43 = 64,
        playerid16 = 65,
        rightfreekicktakerid = 66,
        playerid12 = 67
    },
    default_mentalities = {
        mentalityid = 1,
        position3 = 2,
        position7 = 3,
        teamid = 4,
        playerid10 = 5,
        sourceformationid = 6,
        offset8y = 7,
        playerid6 = 8,
        playerid2 = 9,
        offensivewidth = 10,
        formationaudioid = 11,
        offset9y = 12,
        buildupplay = 13,
        offset9x = 14,
        playerinstruction10_2 = 15,
        offset8x = 16,
        playerid3 = 17,
        playerid7 = 18,
        defensivestyle = 19,
        playerinstruction8_1 = 20,
        playerinstruction9_1 = 21,
        playerinstruction0_1 = 22,
        playerinstruction1_1 = 23,
        playerinstruction3_1 = 24,
        playerinstruction2_1 = 25,
        playerinstruction6_1 = 26,
        playerinstruction7_1 = 27,
        playerinstruction5_1 = 28,
        playerinstruction4_1 = 29,
        position6 = 30,
        position2 = 31,
        playersinboxfk = 32,
        offset1x = 33,
        playersinboxcross = 34,
        position10 = 35,
        offset4y = 36,
        offensivestyle = 37,
        offset5y = 38,
        position8 = 39,
        offset0x = 40,
        position0 = 41,
        position4 = 42,
        offset7y = 43,
        offset10x = 44,
        defensivedepth = 45,
        offset2x = 46,
        playerid5 = 47,
        offset3x = 48,
        playerid1 = 49,
        offset6y = 50,
        playerid9 = 51,
        playersinboxcorner = 52,
        playerid0 = 53,
        playerid4 = 54,
        offset3y = 55,
        playerid8 = 56,
        offset6x = 57,
        offset10y = 58,
        playerinstruction10_1 = 59,
        offset7x = 60,
        offset2y = 61,
        formationfullnameid = 62,
        defensivewidth = 63,
        chancecreation = 64,
        position9 = 65,
        offset5x = 66,
        position5 = 67,
        position1 = 68,
        offset0y = 69,
        playerinstruction1_2 = 70,
        playerinstruction0_2 = 71,
        playerinstruction2_2 = 72,
        playerinstruction3_2 = 73,
        playerinstruction7_2 = 74,
        playerinstruction6_2 = 75,
        playerinstruction4_2 = 76,
        playerinstruction5_2 = 77,
        offset1y = 78,
        offset4x = 79,
        playerinstruction9_2 = 80,
        playerinstruction8_2 = 81
    },
    manager = {
        teamid = 1,
        headvariation = 2,
        haircolorcode = 3,
        hashighqualityhead = 4,
        outfitid = 5,
        firstname = 6,
        headclasscode = 7,
        surname = 8,
        weight = 9,
        bodytypecode = 10,
        skintypecode = 11,
        personalityid = 12,
        managerid = 13,
        ethnicity = 14,
        nationality = 15,
        skintonecode = 16,
        facialhaircolorcode = 17,
        sideburnscode = 18,
        faceposerpreset = 19,
        hairtypecode = 20,
        gender = 21,
        eyecolorcode = 22,
        facialhairtypecode = 23,
        commonname = 24,
        height = 25,
        managerjointeamdate = 26,
        eyebrowcode = 27,
        seasonaloutfitid = 28,
        headassetid = 29,
        headtypecode = 30,
        hairstylecode = 31
    },
    leagueteamlinks = {
        artificialkey = 1,
        homegf = 2,
        teamid = 3,
        unbeatenaway = 4,
        highestpossible = 5,
        objective = 6,
        yettowin = 7,
        hasachievedobjective = 8,
        previousyeartableposition = 9,
        awaygf = 10,
        homelosses = 11,
        awaywins = 12,
        homedraws = 13,
        awaylosses = 14,
        points = 15,
        unbeatenallcomps = 16,
        teamlongform = 17,
        nummatchesplayed = 18,
        homega = 19,
        leagueid = 20,
        currenttableposition = 21,
        grouping = 22,
        awayga = 23,
        unbeatenhome = 24,
        actualvsexpectations = 25,
        unbeatenleague = 26,
        lastgameresult = 27,
        teamshortform = 28,
        homewins = 29,
        awaydraws = 30,
        champion = 31,
        teamform = 32,
        highestprobable = 33,
        prevleagueid = 34
    },
    career_calendar = {
        dateid = 1,
        transferwindowend2 = 2,
        transferwindowstart1 = 3,
        setupdate = 4,
        enddate = 5,
        objectivecheckdate = 6,
        startdate = 7,
        currdate = 8,
        transferwindowstart2 = 9,
        transferwindowend1 = 10
    },
    teamplayerlinks = {
        artificialkey = 1,
        teamid = 2,
        isamongtopscorers = 3,
        istopscorer = 4,
        form = 5,
        reds = 6,
        leagueappearances = 7,
        jerseynumber = 8,
        leaguegoalsprevmatch = 9,
        leaguegoals = 10,
        playerid = 11,
        injury = 12,
        leaguegoalsprevthreematches = 13,
        yellows = 14,
        isamongtopscorersinteam = 15,
        position = 16
    },
    players = {
        playerid = 1,
        weakfootabilitytypecode = 2,
        paskic = 3,
        accessorycolourcode4 = 4,
        accessorycode1 = 5,
        personality = 6,
        smallsidedshoetypecode = 7,
        modifier = 8,
        animfreekickstartposcode = 9,
        gkkicking = 10,
        jerseyfit = 11,
        jerseystylecode = 12,
        dribbling = 13,
        shotpower = 14,
        balance = 15,
        headvariation = 16,
        contractvaliduntil = 17,
        firstnameid = 18,
        haircolorcode = 19,
        preferredposition1 = 20,
        hashighqualityhead = 21,
        penalties = 22,
        volleys = 23,
        tattooback = 24,
        headclasscode = 25,
        tattoorightleg = 26,
        finishingcode2 = 27,
        shohan = 28,
        iscustomized = 29,
        slidingtackle = 30,
        defensiveawareness = 31,
        jumping = 32,
        birthdate = 33,
        runningcode1 = 34,
        pacdiv = 35,
        headingaccuracy = 36,
        phypos = 37,
        aggression = 38,
        trait1 = 39,
        longpassing = 40,
        potential = 41,
        socklengthcode = 42,
        weight = 43,
        shoetypecode = 44,
        bodytypecode = 45,
        gkpositioning = 46,
        driref = 47,
        skintypecode = 48,
        gkglovetypecode = 49,
        tattooleftarm = 50,
        lastnameid = 51,
        preferredposition4 = 52,
        curve = 53,
        defspe = 54,
        nationality = 55,
        skintonecode = 56,
        isretiring = 57,
        accessorycolourcode1 = 58,
        facialhaircolorcode = 59,
        sideburnscode = 60,
        animpenaltiesstartposcode = 61,
        shoecolorcode2 = 62,
        strength = 63,
        accessorycode4 = 64,
        faceposerpreset = 65,
        playerjointeamdate = 66,
        shortpassing = 67,
        interceptions = 68,
        finishing = 69,
        attackingworkrate = 70,
        hairtypecode = 71,
        gender = 72,
        gkhandling = 73,
        sprintspeed = 74,
        preferredposition2 = 75,
        acceleration = 76,
        stamina = 77,
        reactions = 78,
        eyecolorcode = 79,
        accessorycolourcode3 = 80,
        defensiveworkrate = 81,
        accessorycode2 = 82,
        emotion = 83,
        hasseasonaljersey = 84,
        trait2 = 85,
        runningcode2 = 86,
        facialhairtypecode = 87,
        crossing = 88,
        gkdiving = 89,
        height = 90,
        skillmoves = 91,
        longshots = 92,
        tattooleftleg = 93,
        standingtackle = 94,
        finishingcode1 = 95,
        eyebrowcode = 96,
        commonnameid = 97,
        usercaneditname = 98,
        tattoofront = 99,
        shoedesigncode = 100,
        skillmoveslikelihood = 101,
        agility = 102,
        gksavetype = 103,
        avatarpomid = 104,
        freekickaccuracy = 105,
        playerjerseynameid = 106,
        internationalrep = 107,
        positioning = 108,
        tattoorightarm = 109,
        vision = 110,
        gkreflexes = 111,
        composure = 112,
        gkkickstyle = 113,
        shortstyle = 114,
        accessorycode3 = 115,
        tattoohead = 116,
        accessorycolourcode2 = 117,
        shoecolorcode1 = 118,
        headassetid = 119,
        ballcontrol = 120,
        preferredfoot = 121,
        headtypecode = 122,
        hairstylecode = 123,
        preferredposition3 = 124,
        runstylecode = 125,
        overallrating = 126,
        jerseysleevelengthcode = 127
    },
    teamkits = {
        teamtechid = 1,
        jerseynumbercolorterg = 2,
        jerseyfit = 3,
        shortsnumbercolorprimg = 4,
        isembargoed = 5,
        armbandtype = 6,
        jerseyfrontnumberplacementcode = 7,
        isinheritbasedetailmap = 8,
        jerseycollargeometrytype = 9,
        shortsnumbercolorsecg = 10,
        teamcolorprimb = 11,
        teamcolorprimr = 12,
        chestbadge = 13,
        teamcolorsecpercent = 14,
        hasadvertisingkit = 15,
        shortsnumbercolorsecr = 16,
        shortsnumberplacementcode = 17,
        jerseyshapestyle = 18,
        shortsnumbercolorsecb = 19,
        teamkittypetechid = 20,
        teamcolorprimg = 21,
        shortsnumbercolorprimr = 22,
        jerseynamelayouttype = 23,
        jerseynumbercolorterr = 24,
        jerseynumbercolorterb = 25,
        shortsnumbercolorprimb = 26,
        teamcolortertr = 27,
        shortsnumbercolorterr = 28,
        teamcolorprimpercent = 29,
        jerseynamecolorg = 30,
        islocked = 31,
        jerseynamefonttype = 32,
        shortsnumbercolorterb = 33,
        teamcolortertb = 34,
        jerseyrenderingdetailmaptype = 35,
        jerseynumbercolorprimb = 36,
        jerseynumbercolorsecr = 37,
        numberfonttype = 38,
        renderingmaterialtype = 39,
        teamcolorsecg = 40,
        year = 41,
        teamcolortertpercent = 42,
        jerseynumbercolorprimr = 43,
        jerseynumbercolorsecb = 44,
        powid = 45,
        shortsrenderingdetailmaptype = 46,
        teamcolorsecr = 47,
        dlc = 48,
        captainarmband = 49,
        shortsnumberfonttype = 50,
        jerseynumbercolorsecg = 51,
        jerseynumbercolorprimg = 52,
        teamcolorsecb = 53,
        jerseyrestriction = 54,
        jerseynamecolorr = 55,
        jerseybacknameplacementcode = 56,
        shortstyle = 57,
        shortsnumbercolorterg = 58,
        teamcolortertg = 59,
        jerseyleftsleevebadge = 60,
        teamkitid = 61,
        jerseybacknamefontcase = 62,
        jerseyrightsleevebadge = 63,
        jerseynamecolorb = 64
    },
    competitionkits = {
        teamtechid = 1,
        jerseynumbercolorterg = 2,
        shortsnumbercolorprimg = 3,
        jerseyfrontnumberplacementcode = 4,
        shortsnumbercolorsecg = 5,
        shortsnumbercolorsecr = 6,
        shortsnumberplacementcode = 7,
        shortsnumbercolorsecb = 8,
        competitionid = 9,
        teamkittypetechid = 10,
        shortsnumbercolorprimr = 11,
        jerseynamelayouttype = 12,
        jerseynumbercolorterr = 13,
        jerseynumbercolorterb = 14,
        shortsnumbercolorprimb = 15,
        shortsnumbercolorterr = 16,
        jerseynamecolorg = 17,
        jerseynamefonttype = 18,
        shortsnumbercolorterb = 19,
        jerseynumbercolorprimb = 20,
        jerseynumbercolorsecr = 21,
        numberfonttype = 22,
        year = 23,
        jerseynumbercolorprimr = 24,
        jerseynumbercolorsecb = 25,
        shortsnumberfonttype = 26,
        jerseynumbercolorsecg = 27,
        jerseynumbercolorprimg = 28,
        jerseynamecolorr = 29,
        jerseybacknameplacementcode = 30,
        shortsnumbercolorterg = 31,
        jerseybacknamefontcase = 32,
        jerseynamecolorb = 33
    }
}

DB_TABLES_META = {
    dcplayernames = {
        {
            name = "nameid",
            shortname = "FuiB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 13,
            offset = 0x26,
            rangehigh = 50000,
            rangelow = 44000,
            startbit = 0,
            key = true,
        },
        {
            name = "name",
            shortname = "vIys",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 304,
            offset = 0x0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        }
    },
    editedplayernames = {
        {
            name = "playerid",
            shortname = "ykFq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xB4,
            rangehigh = 500000,
            rangelow = 0,
            startbit = 0,
            key = true,
        },
        {
            name = "firstname",
            shortname = "HdeP",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 360,
            offset = 0x0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "surname",
            shortname = "rREd",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 360,
            offset = 0x87,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerjerseyname",
            shortname = "kRfb",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 360,
            offset = 0x5A,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "commonname",
            shortname = "xnfZ",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 360,
            offset = 0x2D,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        }
    },
    teams = {
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x80,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 6,
            key = true,
        },
        {
            name = "stadiummowpattern_code",
            shortname = "dUTO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x69,
            rangehigh = 15,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "goalnetstanchioncolor2b",
            shortname = "gCAn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x15,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "penaltytakerid",
            shortname = "hPku",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x95,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "trait1vweak",
            shortname = "kzMW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 23,
            offset = 0x75,
            rangehigh = 8388607,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "domesticcups",
            shortname = "zqra",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x7C,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "goalnetstanchioncolor2r",
            shortname = "BZQX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xD,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "captainid",
            shortname = "FVzk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x88,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "longitude",
            shortname = "NQXQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x6D,
            rangehigh = 180,
            rangelow = -180,
            startbit = 0,
        },
        {
            name = "clubworth",
            shortname = "QSnJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x6,
            rangehigh = 9999999,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offensivewidth",
            shortname = "TEos",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x93,
            rangehigh = 100,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "teamstadiumcapacity",
            shortname = "TehK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x60,
            rangehigh = 999999,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "goalnetstanchioncolor1b",
            shortname = "Tnbc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xF,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "goalnetstanchioncolor1r",
            shortname = "WELo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x16,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "longkicktakerid",
            shortname = "WiRV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x73,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "stanchionflamethrower",
            shortname = "XDPj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x88,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "uefa_consecutive_wins",
            shortname = "ZKAU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x72,
            rangehigh = 256,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "profitability",
            shortname = "hXEu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x94,
            rangehigh = 10,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "pitchwear",
            shortname = "kjiI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x5E,
            rangehigh = 10,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "buildupplay",
            shortname = "mIWR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x6E,
            rangehigh = 3,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "form",
            shortname = "rLZx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x9D,
            rangehigh = 100,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "playsurfacetype",
            shortname = "vFwL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x68,
            rangehigh = 7,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "leftcornerkicktakerid",
            shortname = "xcde",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7D,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "stadiumgoalnetstyle",
            shortname = "CauK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x62,
            rangehigh = 50,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "crowdregion",
            shortname = "Edjp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x8F,
            rangehigh = 31,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "popularity",
            shortname = "FcOK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x5F,
            rangehigh = 10,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "numtransfersin",
            shortname = "Gjri",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x87,
            rangehigh = 31,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "personalityid",
            shortname = "IIKl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x8B,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "opponentstrongthreshold",
            shortname = "MQCj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x14,
            rangehigh = 100,
            rangelow = -100,
            startbit = 0,
        },
        {
            name = "hasstandingcrowd",
            shortname = "NOYS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x6F,
            rangehigh = 3,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "genericint1",
            shortname = "NSMy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x9E,
            rangehigh = 100,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "favoriteteamsheetid",
            shortname = "PccS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x6F,
            rangehigh = 1000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "goalnetstanchioncolor1g",
            shortname = "PNLv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x18,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "haslargeflag",
            shortname = "QgOx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x9B,
            rangehigh = 2,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "midfieldrating",
            shortname = "SqFN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x68,
            rangehigh = 99,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "defensivestyle",
            shortname = "SdiC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x58,
            rangehigh = 4,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "attackrating",
            shortname = "UAKP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6B,
            rangehigh = 99,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "hasvikingclap",
            shortname = "VsCG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x5D,
            rangehigh = 1,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "prev_el_champ",
            shortname = "YTAn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x8B,
            rangehigh = 1,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "ethnicity",
            shortname = "aArc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x7D,
            rangehigh = 11,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "trait1vstrong",
            shortname = "aDMz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 23,
            offset = 0x9F,
            rangehigh = 8388607,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "iscompetitionpoleflagenabled",
            shortname = "eLCT",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x71,
            rangehigh = 2,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "goalnetstanchioncolor2g",
            shortname = "oEoM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xA,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "domesticprestige",
            shortname = "ppLE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x5B,
            rangehigh = 20,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "flamethrowercannon",
            shortname = "pqZD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x5A,
            rangehigh = 4,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "playersinboxfk",
            shortname = "pOHj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x87,
            rangehigh = 4,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "assetid",
            shortname = "yeEP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 32,
            offset = 0x0,
            rangehigh = 2147483647,
            rangelow = -2147483648,
            startbit = 0,
        },
        {
            name = "matchdaydefenserating",
            shortname = "zHfR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6E,
            rangehigh = 99,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "playersinboxcross",
            shortname = "BuNm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x8B,
            rangehigh = 9,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "utcoffset",
            shortname = "Csgu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x94,
            rangehigh = 13,
            rangelow = -12,
            startbit = 6,
        },
        {
            name = "teamcolor3b",
            shortname = "Gzty",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x55,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "crowdskintonecode",
            shortname = "KvHw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x9A,
            rangehigh = 15,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "teamcolor2r",
            shortname = "KzYP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xB,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "freekicktakerid",
            shortname = "LfBw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x98,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "teamcolor2b",
            shortname = "PcIL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x9,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offensivestyle",
            shortname = "QHJl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x8A,
            rangehigh = 3,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "presassetone",
            shortname = "TdUB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x56,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolor3r",
            shortname = "Tsda",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xE,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "leftfreekicktakerid",
            shortname = "WLKn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x8B,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "trainingstadium",
            shortname = "WvVx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x9C,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "internationalprestige",
            shortname = "edvw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x9B,
            rangehigh = 20,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "rivalteam",
            shortname = "erSL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x65,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "matchdayattackrating",
            shortname = "jmRz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xA2,
            rangehigh = 99,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "genericbanner",
            shortname = "jfmo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x8F,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "teamcolor1r",
            shortname = "lWTE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x5,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "defensivedepth",
            shortname = "nXaF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x5C,
            rangehigh = 100,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "cityid",
            shortname = "pNIL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x63,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "matchdayoverallrating",
            shortname = "sqCP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6A,
            rangehigh = 99,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "uefa_el_wins",
            shortname = "yhYg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x83,
            rangehigh = 256,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "hastifo",
            shortname = "BdXK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x5F,
            rangehigh = 1,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "teamcolor1b",
            shortname = "EVjc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x10,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "matchdaymidfieldrating",
            shortname = "HHDP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6A,
            rangehigh = 99,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "playersinboxcorner",
            shortname = "IbXP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x6C,
            rangehigh = 4,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "stadiumgoalnetpattern",
            shortname = "LOZj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x88,
            rangehigh = 1,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "powid",
            shortname = "MbYC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 15,
            offset = 0x56,
            rangehigh = 32000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "genericint2",
            shortname = "MLlE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x5B,
            rangehigh = 100,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "trait1vequal",
            shortname = "TPvg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 23,
            offset = 0x84,
            rangehigh = 8388607,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "opponentweakthreshold",
            shortname = "Umue",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x11,
            rangehigh = 100,
            rangelow = -100,
            startbit = 0,
        },
        {
            name = "teamcolor1g",
            shortname = "UrDD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x4,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "iscompetitionscarfenabled",
            shortname = "VtHL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x63,
            rangehigh = 2,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "skinnyflags",
            shortname = "WwbT",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x71,
            rangehigh = 1,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "defenserating",
            shortname = "btsS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x70,
            rangehigh = 99,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "leaguetitles",
            shortname = "cpXo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x8E,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "rightcornerkicktakerid",
            shortname = "fBiX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x78,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "uefa_cl_wins",
            shortname = "hJha",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x7B,
            rangehigh = 256,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "uefa_uecl_wins",
            shortname = "igKs",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x90,
            rangehigh = 256,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "hassubstitutionboard",
            shortname = "kfND",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x58,
            rangehigh = 1,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "pitchcolor",
            shortname = "lzGH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x5E,
            rangehigh = 10,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "ballid",
            shortname = "pxes",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x92,
            rangehigh = 300,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "defensivewidth",
            shortname = "pmLL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x64,
            rangehigh = 100,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "chancecreation",
            shortname = "qjXG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5E,
            rangehigh = 3,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolor2g",
            shortname = "rags",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x17,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "latitude",
            shortname = "sjQg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x12,
            rangehigh = 90,
            rangelow = -90,
            startbit = 0,
        },
        {
            name = "isbannerenabled",
            shortname = "uhiM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x68,
            rangehigh = 2,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "foundationyear",
            shortname = "yDDQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xC,
            rangehigh = 2050,
            rangelow = 1800,
            startbit = 0,
        },
        {
            name = "jerseytype",
            shortname = "zgDG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5D,
            rangehigh = 2,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "teamname",
            shortname = "AUsv",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 480,
            offset = 0x19,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "iscompetitioncrowdcardsenabled",
            shortname = "FtgW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x78,
            rangehigh = 3,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "youthdevelopment",
            shortname = "HNrf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x80,
            rangehigh = 10,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "pitchlinecolor",
            shortname = "IOSv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x97,
            rangehigh = 10,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "teamcolor3g",
            shortname = "Olxh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x13,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "rightfreekicktakerid",
            shortname = "TxVD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x58,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "overallrating",
            shortname = "UERs",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x91,
            rangehigh = 99,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "presassettwo",
            shortname = "UjYK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5F,
            rangehigh = 3,
            rangelow = 0,
            startbit = 7,
        }
    },
    career_users = {
        {
            name = "userid",
            shortname = "uipx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x8F,
            rangehigh = 63,
            rangelow = -1,
            startbit = 2,
            key = true,
        },
        {
            name = "sponsorid",
            shortname = "AEUQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x84,
            rangehigh = 30,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "leagueseasonmessagesent",
            shortname = "BneM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x83,
            rangehigh = 256,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "firstname",
            shortname = "HdeP",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 256,
            offset = 0x0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "surname",
            shortname = "rREd",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 256,
            offset = 0x40,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "agentname",
            shortname = "zvSh",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 256,
            offset = 0x60,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playertype",
            shortname = "GzsD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x81,
            rangehigh = 2,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "nationalteamid",
            shortname = "daeI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x81,
            rangehigh = 200000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "usertype",
            shortname = "Hwev",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x8E,
            rangehigh = 3,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "clubteamid",
            shortname = "NTyS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x86,
            rangehigh = 200000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "leagueid",
            shortname = "aQrQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x85,
            rangehigh = 3000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "wage",
            shortname = "cmGX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 31,
            offset = 0x89,
            rangehigh = 2147483520,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "commonname",
            shortname = "xnfZ",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 256,
            offset = 0x20,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "seasoncount",
            shortname = "CXJt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x8E,
            rangehigh = 15,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "goalnews",
            shortname = "MEjD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x81,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "nationalityid",
            shortname = "NGIq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x80,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "primarycompobjid",
            shortname = "XGBd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x8D,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 0,
        }
    },
    career_playercontract = {
        {
            name = "playerid",
            shortname = "ykFq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x12,
            rangehigh = 300000,
            rangelow = 0,
            startbit = 5,
            key = true,
        },
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0xB,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "loan_wage_split",
            shortname = "qjYv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x15,
            rangehigh = 100,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "performancebonuscountachieved",
            shortname = "IdMw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x15,
            rangehigh = 1000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "contract_date",
            shortname = "Qssj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x10,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 2,
        },
        {
            name = "signon_bonus",
            shortname = "hbrw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 31,
            offset = 0x17,
            rangehigh = 2147483520,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "contract_status",
            shortname = "iNUH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x1,
            rangehigh = 12,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "performancebonuscount",
            shortname = "AinI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x1,
            rangehigh = 1000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerrole",
            shortname = "NclQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x2,
            rangehigh = 5,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "wage",
            shortname = "cmGX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 31,
            offset = 0x3,
            rangehigh = 2147483520,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "performancebonustype",
            shortname = "dcdd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xB,
            rangehigh = 31,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "duration_months",
            shortname = "aNxl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x0,
            rangehigh = 180,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "performancebonusvalue",
            shortname = "gkLa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 31,
            offset = 0x7,
            rangehigh = 2147483520,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "isperformancebonusachieved",
            shortname = "jtSA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x1,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "last_status_change_date",
            shortname = "EBrh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xD,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 7,
        }
    },
    default_teamsheets = {
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x66,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 1,
            key = true,
        },
        {
            name = "customsub1in",
            shortname = "aNgZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x47,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "customsub2out",
            shortname = "aoQg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x63,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "customsub0in",
            shortname = "bveC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "customsub2in",
            shortname = "cTCk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x6F,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid51",
            shortname = "deBn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x76,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "penaltytakerid",
            shortname = "hPku",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x8C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid10",
            shortname = "qhEx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x97,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "customsub1out",
            shortname = "sdHe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x55,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid49",
            shortname = "uOEg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x61,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid14",
            shortname = "xckU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x36,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid41",
            shortname = "AFka",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x4C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid45",
            shortname = "DkET",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x31,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid18",
            shortname = "EyUf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x5A,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "captainid",
            shortname = "FVzk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x74,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid30",
            shortname = "ILuX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x44,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid34",
            shortname = "LaCu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x89,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid6",
            shortname = "RaOP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x28,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid2",
            shortname = "SfCW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x40,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid38",
            shortname = "SAKJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x15,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "longkicktakerid",
            shortname = "WiRV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x3B,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid28",
            shortname = "bXPw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x93,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid20",
            shortname = "hozK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x1C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid24",
            shortname = "iVHj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x6A,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid29",
            shortname = "ocLy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x9C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid25",
            shortname = "xODp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7B,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "leftcornerkicktakerid",
            shortname = "xcde",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x57,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid21",
            shortname = "yrvw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x95,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid35",
            shortname = "EZGA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x0,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid31",
            shortname = "HQyJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x17,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid3",
            shortname = "Ncmk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x71,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid39",
            shortname = "NDOL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x1E,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid7",
            shortname = "OhyJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x1A,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid15",
            shortname = "SfAa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x49,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid48",
            shortname = "VNUO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x23,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid11",
            shortname = "ZaUj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x6D,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid19",
            shortname = "bxkp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x80,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid44",
            shortname = "cnUF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xE,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid40",
            shortname = "fyAg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x5F,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid50",
            shortname = "mdlt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x87,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid42",
            shortname = "BwJM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x21,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid46",
            shortname = "CtBV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x39,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid13",
            shortname = "HYBP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x26,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "freekicktakerid",
            shortname = "LfBw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x90,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid17",
            shortname = "MlJq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x82,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "leftfreekicktakerid",
            shortname = "WLKn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x79,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid23",
            shortname = "gxCc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x50,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid27",
            shortname = "jMiF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x10,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "customsub0out",
            shortname = "ohUP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x2A,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid5",
            shortname = "wjrR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x2F,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid1",
            shortname = "zWHI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x13,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid33",
            shortname = "FCTp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7D,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid9",
            shortname = "FJbC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x4,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "playerid37",
            shortname = "GjzQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x2D,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid0",
            shortname = "MVLC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x2,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid4",
            shortname = "Povf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x5C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playerid36",
            shortname = "VgjC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x9,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid32",
            shortname = "WJDv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x8E,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid8",
            shortname = "WCfU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x34,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid26",
            shortname = "cHyr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x84,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid22",
            shortname = "fySi",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x68,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "rightcornerkicktakerid",
            shortname = "fBiX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x42,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid47",
            shortname = "Juxb",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x4E,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid43",
            shortname = "KrFy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x9A,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "playerid16",
            shortname = "PmFc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x53,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "rightfreekicktakerid",
            shortname = "TxVD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xB,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "playerid12",
            shortname = "UTxV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x3D,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 6,
        }
    },
    default_mentalities = {
        {
            name = "mentalityid",
            shortname = "AwZu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 13,
            offset = 0xBD,
            rangehigh = 8000,
            rangelow = 0,
            startbit = 3,
            key = true,
        },
        {
            name = "position3",
            shortname = "cGsr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xBB,
            rangehigh = 32,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "position7",
            shortname = "fvcy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xC4,
            rangehigh = 32,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0xA7,
            rangehigh = 200000,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "playerid10",
            shortname = "qhEx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xC1,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "sourceformationid",
            shortname = "CeOS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x88,
            rangehigh = 2000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "offset8y",
            shortname = "MhRc",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x38,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid6",
            shortname = "RaOP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7F,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "playerid2",
            shortname = "SfCW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x92,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "offensivewidth",
            shortname = "TEos",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xBB,
            rangehigh = 100,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "formationaudioid",
            shortname = "jMjY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x99,
            rangehigh = 30,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "offset9y",
            shortname = "lCgp",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x50,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "buildupplay",
            shortname = "mIWR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x85,
            rangehigh = 3,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "offset9x",
            shortname = "uBQf",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x3C,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction10_2",
            shortname = "BCSe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xA0,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset8x",
            shortname = "DahS",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x20,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid3",
            shortname = "Ncmk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xB1,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "playerid7",
            shortname = "OhyJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x7B,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "defensivestyle",
            shortname = "SdiC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x68,
            rangehigh = 4,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction8_1",
            shortname = "YIMV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x8E,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "playerinstruction9_1",
            shortname = "ZuaG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x6C,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "playerinstruction0_1",
            shortname = "aXll",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0xB3,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "playerinstruction1_1",
            shortname = "bNXC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x61,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "playerinstruction3_1",
            shortname = "cpzA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x5B,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "playerinstruction2_1",
            shortname = "dDlz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0xC6,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "playerinstruction6_1",
            shortname = "eulb",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x99,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "playerinstruction7_1",
            shortname = "fgvQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x81,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "playerinstruction5_1",
            shortname = "gEXW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x94,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "playerinstruction4_1",
            shortname = "hOph",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0xAA,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "position6",
            shortname = "ksMI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x75,
            rangehigh = 32,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "position2",
            shortname = "nNch",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xA9,
            rangehigh = 32,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playersinboxfk",
            shortname = "pOHj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0xAE,
            rangehigh = 4,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "offset1x",
            shortname = "yMyn",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x48,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playersinboxcross",
            shortname = "BuNm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0xB7,
            rangehigh = 9,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "position10",
            shortname = "FuLD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x68,
            rangehigh = 32,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "offset4y",
            shortname = "Iwmo",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x4C,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offensivestyle",
            shortname = "QHJl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0xB3,
            rangehigh = 3,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "offset5y",
            shortname = "RnDB",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x4,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "position8",
            shortname = "TMpL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x7E,
            rangehigh = 32,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "offset0x",
            shortname = "XjPa",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x34,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "position0",
            shortname = "ZzVx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0xC3,
            rangehigh = 1,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "position4",
            shortname = "aCho",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xB7,
            rangehigh = 32,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "offset7y",
            shortname = "fdNX",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x30,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset10x",
            shortname = "jIiE",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x8,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "defensivedepth",
            shortname = "nXaF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6B,
            rangehigh = 100,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "offset2x",
            shortname = "pFxE",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0xC,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid5",
            shortname = "wjrR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x85,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "offset3x",
            shortname = "wKsR",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x1C,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid1",
            shortname = "zWHI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x73,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "offset6y",
            shortname = "CCIK",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x14,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid9",
            shortname = "FJbC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x65,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "playersinboxcorner",
            shortname = "IbXP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x81,
            rangehigh = 4,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "playerid0",
            shortname = "MVLC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x5F,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "playerid4",
            shortname = "Povf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xA5,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 0,
        },
        {
            name = "offset3y",
            shortname = "PJwT",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x28,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid8",
            shortname = "WCfU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x8C,
            rangehigh = 500000,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "offset6x",
            shortname = "ZBMA",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset10y",
            shortname = "cLmS",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x24,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction10_1",
            shortname = "gLvA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x58,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset7x",
            shortname = "gWJN",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x18,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset2y",
            shortname = "mytG",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x10,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "formationfullnameid",
            shortname = "nFPu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xBC,
            rangehigh = 30,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "defensivewidth",
            shortname = "pmLL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x7D,
            rangehigh = 100,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "chancecreation",
            shortname = "qjXG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x6C,
            rangehigh = 3,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "position9",
            shortname = "sPtx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xC4,
            rangehigh = 32,
            rangelow = -1,
            startbit = 1,
        },
        {
            name = "offset5x",
            shortname = "usnj",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x40,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "position5",
            shortname = "BBlW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x98,
            rangehigh = 32,
            rangelow = -1,
            startbit = 3,
        },
        {
            name = "position1",
            shortname = "CEZz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xC5,
            rangehigh = 32,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "offset0y",
            shortname = "Eozk",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x44,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction1_2",
            shortname = "GEaI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x76,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "playerinstruction0_2",
            shortname = "HOMT",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x89,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "playerinstruction2_2",
            shortname = "IuIp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xB8,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "playerinstruction3_2",
            shortname = "Jgue",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xA2,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "playerinstruction7_2",
            shortname = "Kpqu",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xBF,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction6_2",
            shortname = "LDId",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x9D,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "playerinstruction4_2",
            shortname = "MXQH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x70,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "playerinstruction5_2",
            shortname = "NNaI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x78,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "offset1y",
            shortname = "NPOx",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x54,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "offset4x",
            shortname = "TzCW",
            fld_type = "DBOFIELDTYPE_REAL",
            depth = 32,
            offset = 0x2C,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerinstruction9_2",
            shortname = "UnXE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x69,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "playerinstruction8_2",
            shortname = "VBlj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xAE,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 4,
        }
    },
    manager = {
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0xFF,
            rangehigh = 200000,
            rangelow = 0,
            startbit = 6,
            key = true,
        },
        {
            name = "headvariation",
            shortname = "pHkq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x105,
            rangehigh = 31,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "haircolorcode",
            shortname = "uGEA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xF1,
            rangehigh = 50,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "hashighqualityhead",
            shortname = "ykrW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0xFC,
            rangehigh = 1,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "outfitid",
            shortname = "CRrt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0x106,
            rangehigh = 1000000,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "firstname",
            shortname = "HdeP",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 640,
            offset = 0x0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "headclasscode",
            shortname = "HvCm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x103,
            rangehigh = 2,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "surname",
            shortname = "rREd",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 640,
            offset = 0xA0,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "weight",
            shortname = "sNZW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xFB,
            rangehigh = 115,
            rangelow = 30,
            startbit = 2,
        },
        {
            name = "bodytypecode",
            shortname = "xWyx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x109,
            rangehigh = 512,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "skintypecode",
            shortname = "Dlgo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xF0,
            rangehigh = 160,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "personalityid",
            shortname = "IIKl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x103,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "managerid",
            shortname = "VHIB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xF2,
            rangehigh = 500000,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "ethnicity",
            shortname = "aArc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0xFE,
            rangehigh = 11,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "nationality",
            shortname = "enmm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x103,
            rangehigh = 3000,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "skintonecode",
            shortname = "ejir",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x105,
            rangehigh = 11,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "facialhaircolorcode",
            shortname = "mIlz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x10D,
            rangehigh = 50,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "sideburnscode",
            shortname = "mrAn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x105,
            rangehigh = 3,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "faceposerpreset",
            shortname = "qwYd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0xFF,
            rangehigh = 15,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "hairtypecode",
            shortname = "CkYD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0xF4,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "gender",
            shortname = "EveZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0xFC,
            rangehigh = 1,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "eyecolorcode",
            shortname = "Zufj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x102,
            rangehigh = 16,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "facialhairtypecode",
            shortname = "onGA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xF1,
            rangehigh = 50,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "commonname",
            shortname = "xnfZ",
            fld_type = "DBOFIELDTYPE_STRING",
            depth = 640,
            offset = 0x50,
            rangehigh = 0,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "height",
            shortname = "ypBQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xF7,
            rangehigh = 215,
            rangelow = 130,
            startbit = 7,
        },
        {
            name = "managerjointeamdate",
            shortname = "FcMy",
            fld_type = "DBOFIELDTYPE_DATE",
            depth = 20,
            offset = 0x10A,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "eyebrowcode",
            shortname = "HqUh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x102,
            rangehigh = 15,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "seasonaloutfitid",
            shortname = "tFVQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 20,
            offset = 0xF8,
            rangehigh = 1000000,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "headassetid",
            shortname = "GEba",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xFC,
            rangehigh = 500000,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "headtypecode",
            shortname = "OoQO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 14,
            offset = 0xF6,
            rangehigh = 16000,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "hairstylecode",
            shortname = "OFRx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x108,
            rangehigh = 31,
            rangelow = 0,
            startbit = 7,
        }
    },
    leagueteamlinks = {
        {
            name = "artificialkey",
            shortname = "JMld",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0xE,
            rangehigh = 4000,
            rangelow = 0,
            startbit = 2,
            key = true,
        },
        {
            name = "homegf",
            shortname = "gazb",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2,
            rangehigh = 200,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x10,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "unbeatenaway",
            shortname = "vjer",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x17,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "highestpossible",
            shortname = "BgxX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xA,
            rangehigh = 20,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "objective",
            shortname = "BPRm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x14,
            rangehigh = 20,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "yettowin",
            shortname = "CLrO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x7,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "hasachievedobjective",
            shortname = "JPKL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x6,
            rangehigh = 1,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "previousyeartableposition",
            shortname = "MDeW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1,
            rangehigh = 256,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "awaygf",
            shortname = "Unns",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x4,
            rangehigh = 200,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "homelosses",
            shortname = "oQGq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x16,
            rangehigh = 25,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "awaywins",
            shortname = "txAm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x13,
            rangehigh = 25,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "homedraws",
            shortname = "HjBw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x18,
            rangehigh = 25,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "awaylosses",
            shortname = "QMes",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x17,
            rangehigh = 25,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "points",
            shortname = "Yyym",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x14,
            rangehigh = 4095,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "unbeatenallcomps",
            shortname = "cMyO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x7,
            rangehigh = 1,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "teamlongform",
            shortname = "Ogsy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x19,
            rangehigh = 100,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "nummatchesplayed",
            shortname = "QbIe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xF,
            rangehigh = 50,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "homega",
            shortname = "WWGU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x0,
            rangehigh = 200,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "leagueid",
            shortname = "aQrQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x7,
            rangehigh = 4000,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "currenttableposition",
            shortname = "fNOl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x3,
            rangehigh = 256,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "grouping",
            shortname = "pBOj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x12,
            rangehigh = 20,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "awayga",
            shortname = "uruv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x5,
            rangehigh = 200,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "unbeatenhome",
            shortname = "MCMq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x17,
            rangehigh = 1,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "actualvsexpectations",
            shortname = "OcBo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x16,
            rangehigh = 4,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "unbeatenleague",
            shortname = "VDJP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x7,
            rangehigh = 1,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "lastgameresult",
            shortname = "VfPr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x17,
            rangehigh = 2,
            rangelow = -1,
            startbit = 2,
        },
        {
            name = "teamshortform",
            shortname = "hzrF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6,
            rangehigh = 100,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "homewins",
            shortname = "oxHc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xD,
            rangehigh = 25,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "awaydraws",
            shortname = "vmpt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x18,
            rangehigh = 25,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "champion",
            shortname = "wEjP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x7,
            rangehigh = 1,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "teamform",
            shortname = "wTTa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 15,
            offset = 0xB,
            rangehigh = 22222,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "highestprobable",
            shortname = "HtAc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xD,
            rangehigh = 20,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "prevleagueid",
            shortname = "PSlV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x9,
            rangehigh = 3000,
            rangelow = 1,
            startbit = 0,
        }
    },
    career_calendar = {
        {
            name = "dateid",
            shortname = "RgdW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x6,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
            key = true,
        },
        {
            name = "transferwindowend2",
            shortname = "igYC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x2,
            rangehigh = 1231,
            rangelow = 101,
            startbit = 6,
        },
        {
            name = "transferwindowstart1",
            shortname = "sUgA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x1,
            rangehigh = 1231,
            rangelow = 101,
            startbit = 3,
        },
        {
            name = "setupdate",
            shortname = "KNVN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x4,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 1,
        },
        {
            name = "enddate",
            shortname = "ZPUX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x6,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 5,
        },
        {
            name = "objectivecheckdate",
            shortname = "tmje",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xF,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 1,
        },
        {
            name = "startdate",
            shortname = "vHhZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xB,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 3,
        },
        {
            name = "currdate",
            shortname = "aLZZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x9,
            rangehigh = 20601231,
            rangelow = 20080101,
            startbit = 0,
        },
        {
            name = "transferwindowstart2",
            shortname = "Jdde",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0xD,
            rangehigh = 1231,
            rangelow = 101,
            startbit = 6,
        },
        {
            name = "transferwindowend1",
            shortname = "PpdA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x0,
            rangehigh = 1231,
            rangelow = 101,
            startbit = 0,
        }
    },
    teamplayerlinks = {
        {
            name = "artificialkey",
            shortname = "JMld",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x3,
            rangehigh = 300000,
            rangelow = 0,
            startbit = 5,
            key = true,
        },
        {
            name = "teamid",
            shortname = "mCXg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x6,
            rangehigh = 200000,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "isamongtopscorers",
            shortname = "SuuG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x1,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "istopscorer",
            shortname = "YbEm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0xA,
            rangehigh = 1,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "form",
            shortname = "rLZx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0xD,
            rangehigh = 5,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "reds",
            shortname = "jIcz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xD,
            rangehigh = 20,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "leagueappearances",
            shortname = "stFk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x9,
            rangehigh = 50,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "jerseynumber",
            shortname = "JFiY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x2,
            rangehigh = 99,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "leaguegoalsprevmatch",
            shortname = "NbFh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x8,
            rangehigh = 10,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "leaguegoals",
            shortname = "UMDX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x0,
            rangehigh = 200,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "playerid",
            shortname = "ykFq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0xB,
            rangehigh = 500000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "injury",
            shortname = "Vili",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x8,
            rangehigh = 35,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "leaguegoalsprevthreematches",
            shortname = "dGNm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0xA,
            rangehigh = 25,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "yellows",
            shortname = "jtWI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x1,
            rangehigh = 40,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "isamongtopscorersinteam",
            shortname = "pchV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x1,
            rangehigh = 1,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "position",
            shortname = "vjla",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x2,
            rangehigh = 33,
            rangelow = 0,
            startbit = 7,
        }
    },
    players = {
        {
            name = "playerid",
            shortname = "ykFq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x61,
            rangehigh = 500000,
            rangelow = 0,
            startbit = 1,
            key = true,
        },
        {
            name = "weakfootabilitytypecode",
            shortname = "aOBn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x5E,
            rangehigh = 5,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "paskic",
            shortname = "ceRf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x4F,
            rangehigh = 99,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "accessorycolourcode4",
            shortname = "cAUq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x63,
            rangehigh = 100,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "accessorycode1",
            shortname = "gOol",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x56,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "personality",
            shortname = "hxxo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x5F,
            rangehigh = 5,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "smallsidedshoetypecode",
            shortname = "iKqs",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x68,
            rangehigh = 1000,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "modifier",
            shortname = "isYi",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x53,
            rangehigh = 5,
            rangelow = -5,
            startbit = 6,
        },
        {
            name = "animfreekickstartposcode",
            shortname = "jLuE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x19,
            rangehigh = 18,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "gkkicking",
            shortname = "kqda",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x45,
            rangehigh = 99,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "jerseyfit",
            shortname = "lTKv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x6B,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseystylecode",
            shortname = "miIB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0xE,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "dribbling",
            shortname = "nEbM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x26,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "shotpower",
            shortname = "ohpV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x39,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "balance",
            shortname = "onkY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x41,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "headvariation",
            shortname = "pHkq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x65,
            rangehigh = 31,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "contractvaliduntil",
            shortname = "qvmK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x24,
            rangehigh = 2047,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "firstnameid",
            shortname = "tHlO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 16,
            offset = 0x0,
            rangehigh = 50000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "haircolorcode",
            shortname = "uGEA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0xC,
            rangehigh = 50,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "preferredposition1",
            shortname = "wZQU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x36,
            rangehigh = 31,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "hashighqualityhead",
            shortname = "ykrW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x3F,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "penalties",
            shortname = "AGsE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x18,
            rangehigh = 99,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "volleys",
            shortname = "Dydz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x74,
            rangehigh = 99,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "tattooback",
            shortname = "HEDC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0xF,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "headclasscode",
            shortname = "HvCm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5A,
            rangehigh = 2,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "tattoorightleg",
            shortname = "JRjz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x76,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "finishingcode2",
            shortname = "LwOe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 17,
            offset = 0x4B,
            rangehigh = 100000,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "shohan",
            shortname = "NTFr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x66,
            rangehigh = 99,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "iscustomized",
            shortname = "Oirg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x51,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "slidingtackle",
            shortname = "PhuM",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x27,
            rangehigh = 99,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "defensiveawareness",
            shortname = "SJKz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x70,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "jumping",
            shortname = "URGo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x5E,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "birthdate",
            shortname = "WVIU",
            fld_type = "DBOFIELDTYPE_DATE",
            depth = 20,
            offset = 0x33,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "runningcode1",
            shortname = "ZeVz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 17,
            offset = 0x71,
            rangehigh = 100000,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "pacdiv",
            shortname = "aapy",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x6F,
            rangehigh = 99,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "headingaccuracy",
            shortname = "aReg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x50,
            rangehigh = 99,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "phypos",
            shortname = "hdMV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x38,
            rangehigh = 99,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "aggression",
            shortname = "iTce",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x4D,
            rangehigh = 99,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "trait1",
            shortname = "juxV",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 30,
            offset = 0x3A,
            rangehigh = 1073741823,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "longpassing",
            shortname = "kerE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x17,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "potential",
            shortname = "mpuH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x1D,
            rangehigh = 99,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "socklengthcode",
            shortname = "nVWW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x3E,
            rangehigh = 4,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "weight",
            shortname = "sNZW",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x3E,
            rangehigh = 150,
            rangelow = 30,
            startbit = 5,
        },
        {
            name = "shoetypecode",
            shortname = "tgwT",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x32,
            rangehigh = 1000,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "bodytypecode",
            shortname = "xWyx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x6E,
            rangehigh = 512,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "gkpositioning",
            shortname = "yfhq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x64,
            rangehigh = 99,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "driref",
            shortname = "zNYP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x2C,
            rangehigh = 99,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "skintypecode",
            shortname = "Dlgo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x8,
            rangehigh = 160,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "gkglovetypecode",
            shortname = "GReX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x3F,
            rangehigh = 127,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "tattooleftarm",
            shortname = "HfYD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x13,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "lastnameid",
            shortname = "QCfa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 16,
            offset = 0x2,
            rangehigh = 50000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "preferredposition4",
            shortname = "YnYz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x73,
            rangehigh = 32,
            rangelow = -1,
            startbit = 6,
        },
        {
            name = "curve",
            shortname = "YFaA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xD,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "defspe",
            shortname = "aEqa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x46,
            rangehigh = 99,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "nationality",
            shortname = "enmm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 12,
            offset = 0x5C,
            rangehigh = 3000,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "skintonecode",
            shortname = "ejir",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x67,
            rangehigh = 11,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "isretiring",
            shortname = "kvuF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x19,
            rangehigh = 1,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "accessorycolourcode1",
            shortname = "kmkN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x29,
            rangehigh = 100,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "facialhaircolorcode",
            shortname = "mIlz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x77,
            rangehigh = 50,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "sideburnscode",
            shortname = "mrAn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5E,
            rangehigh = 3,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "animpenaltiesstartposcode",
            shortname = "naby",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x6F,
            rangehigh = 18,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "shoecolorcode2",
            shortname = "nbJH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x1C,
            rangehigh = 31,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "strength",
            shortname = "nmgT",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x31,
            rangehigh = 99,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "accessorycode4",
            shortname = "oQQC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x10,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "faceposerpreset",
            shortname = "qwYd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x49,
            rangehigh = 15,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "playerjointeamdate",
            shortname = "vTpl",
            fld_type = "DBOFIELDTYPE_DATE",
            depth = 20,
            offset = 0x58,
            rangehigh = 1048575,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "shortpassing",
            shortname = "vObb",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x47,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "interceptions",
            shortname = "wWzG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x1B,
            rangehigh = 99,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "finishing",
            shortname = "xJZL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x25,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "attackingworkrate",
            shortname = "BqFe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x4B,
            rangehigh = 2,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "hairtypecode",
            shortname = "CkYD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x14,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "gender",
            shortname = "EveZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x42,
            rangehigh = 1,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "gkhandling",
            shortname = "GBGj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x54,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "sprintspeed",
            shortname = "NrcP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x2D,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "preferredposition2",
            shortname = "NgVS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x30,
            rangehigh = 32,
            rangelow = -1,
            startbit = 5,
        },
        {
            name = "acceleration",
            shortname = "SPge",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x4E,
            rangehigh = 99,
            rangelow = 1,
            startbit = 3,
        },
        {
            name = "stamina",
            shortname = "XjDq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x60,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "reactions",
            shortname = "YCnI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x21,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "eyecolorcode",
            shortname = "Zufj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x55,
            rangehigh = 16,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "accessorycolourcode3",
            shortname = "acRl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x56,
            rangehigh = 100,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "defensiveworkrate",
            shortname = "boFm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x5B,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "accessorycode2",
            shortname = "dXNv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x6B,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "emotion",
            shortname = "gNbt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x69,
            rangehigh = 5,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "hasseasonaljersey",
            shortname = "iCDR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x2F,
            rangehigh = 7,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "trait2",
            shortname = "inAr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x9,
            rangehigh = 16777215,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "runningcode2",
            shortname = "oXYh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 17,
            offset = 0x51,
            rangehigh = 100000,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "facialhairtypecode",
            shortname = "onGA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xC,
            rangehigh = 75,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "crossing",
            shortname = "wGOH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x1D,
            rangehigh = 99,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "gkdiving",
            shortname = "xrSG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x1A,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "height",
            shortname = "ypBQ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x2E,
            rangehigh = 220,
            rangelow = 130,
            startbit = 1,
        },
        {
            name = "skillmoves",
            shortname = "BAPc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x49,
            rangehigh = 4,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "longshots",
            shortname = "CsBG",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x19,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "tattooleftleg",
            shortname = "CVWU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x36,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "standingtackle",
            shortname = "CsyD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x15,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "finishingcode1",
            shortname = "GFLI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 17,
            offset = 0x1F,
            rangehigh = 100000,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "eyebrowcode",
            shortname = "HqUh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 4,
            offset = 0x51,
            rangehigh = 15,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "commonnameid",
            shortname = "HDYx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 16,
            offset = 0x6,
            rangehigh = 50000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "usercaneditname",
            shortname = "NBsd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x49,
            rangehigh = 1,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "tattoofront",
            shortname = "OnPm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x5B,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "shoedesigncode",
            shortname = "PeUv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x6C,
            rangehigh = 3,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "skillmoveslikelihood",
            shortname = "PJsq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x65,
            rangehigh = 4,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "agility",
            shortname = "RRQB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0xE,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "gksavetype",
            shortname = "SJED",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x12,
            rangehigh = 1,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "avatarpomid",
            shortname = "VRvd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x4A,
            rangehigh = 511,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "freekickaccuracy",
            shortname = "VgKc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x48,
            rangehigh = 99,
            rangelow = 1,
            startbit = 1,
        },
        {
            name = "playerjerseynameid",
            shortname = "Vqpv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 16,
            offset = 0x4,
            rangehigh = 50000,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "internationalrep",
            shortname = "WVsa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x46,
            rangehigh = 5,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "positioning",
            shortname = "XsFD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x12,
            rangehigh = 99,
            rangelow = 1,
            startbit = 2,
        },
        {
            name = "tattoorightarm",
            shortname = "YjNY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x40,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "vision",
            shortname = "ZoOK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x23,
            rangehigh = 99,
            rangelow = 1,
            startbit = 4,
        },
        {
            name = "gkreflexes",
            shortname = "eYFI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x1E,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "composure",
            shortname = "jlQJ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x22,
            rangehigh = 99,
            rangelow = 1,
            startbit = 5,
        },
        {
            name = "gkkickstyle",
            shortname = "rJqp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x60,
            rangehigh = 3,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortstyle",
            shortname = "wwlr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x67,
            rangehigh = 1,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "accessorycode3",
            shortname = "ycJN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x28,
            rangehigh = 2000,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "tattoohead",
            shortname = "BhwR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 10,
            offset = 0x2F,
            rangehigh = 1023,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "accessorycolourcode2",
            shortname = "Bfhz",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x75,
            rangehigh = 100,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "shoecolorcode1",
            shortname = "CSEx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x6C,
            rangehigh = 31,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "headassetid",
            shortname = "GEba",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 19,
            offset = 0x42,
            rangehigh = 500000,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "ballcontrol",
            shortname = "MgwU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x37,
            rangehigh = 99,
            rangelow = 1,
            startbit = 7,
        },
        {
            name = "preferredfoot",
            shortname = "MDvm",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x5E,
            rangehigh = 2,
            rangelow = 1,
            startbit = 0,
        },
        {
            name = "headtypecode",
            shortname = "OoQO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 14,
            offset = 0x2A,
            rangehigh = 16000,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "hairstylecode",
            shortname = "OFRx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x6D,
            rangehigh = 31,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "preferredposition3",
            shortname = "OblE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x16,
            rangehigh = 32,
            rangelow = -1,
            startbit = 4,
        },
        {
            name = "runstylecode",
            shortname = "Tbvt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 6,
            offset = 0x6A,
            rangehigh = 32,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "overallrating",
            shortname = "UERs",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x67,
            rangehigh = 99,
            rangelow = 1,
            startbit = 6,
        },
        {
            name = "jerseysleevelengthcode",
            shortname = "UFvj",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x55,
            rangehigh = 7,
            rangelow = 0,
            startbit = 5,
        }
    },
    teamkits = {
        {
            name = "teamtechid",
            shortname = "qljg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x3C,
            rangehigh = 200000,
            rangelow = 0,
            startbit = 0,
            key = true,
        },
        {
            name = "jerseynumbercolorterg",
            shortname = "bLBP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x11,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyfit",
            shortname = "lTKv",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x40,
            rangehigh = 1,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorprimg",
            shortname = "myaC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x4,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "isembargoed",
            shortname = "nokh",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x3E,
            rangehigh = 1,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "armbandtype",
            shortname = "pqlp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x3F,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "jerseyfrontnumberplacementcode",
            shortname = "qaaE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x7,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "isinheritbasedetailmap",
            shortname = "DNJD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x35,
            rangehigh = 1,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "jerseycollargeometrytype",
            shortname = "MQyn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x28,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorsecg",
            shortname = "NTld",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x22,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorprimb",
            shortname = "Qhfp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2B,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorprimr",
            shortname = "dSvZ",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1C,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "chestbadge",
            shortname = "hEvA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x0,
            rangehigh = 9999999,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorsecpercent",
            shortname = "lROa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x38,
            rangehigh = 100,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "hasadvertisingkit",
            shortname = "lAgk",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x3E,
            rangehigh = 1,
            rangelow = 0,
            startbit = 3,
        },
        {
            name = "shortsnumbercolorsecr",
            shortname = "wGly",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x32,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumberplacementcode",
            shortname = "zdlB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x3,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyshapestyle",
            shortname = "IkRY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1A,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorsecb",
            shortname = "JtVK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xB,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamkittypetechid",
            shortname = "MlXB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x33,
            rangehigh = 22,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "teamcolorprimg",
            shortname = "MHXK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xC,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorprimr",
            shortname = "TPaN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xE,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamelayouttype",
            shortname = "bieS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x14,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorterr",
            shortname = "eCpU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x15,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorterb",
            shortname = "jpFw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x30,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorprimb",
            shortname = "uAKR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x12,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolortertr",
            shortname = "CPDe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x23,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorterr",
            shortname = "CUKn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x26,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorprimpercent",
            shortname = "KRfU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x37,
            rangehigh = 100,
            rangelow = 0,
            startbit = 6,
        },
        {
            name = "jerseynamecolorg",
            shortname = "MSIa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1D,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "islocked",
            shortname = "NhCK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x35,
            rangehigh = 1,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "jerseynamefonttype",
            shortname = "TEgR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x13,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorterb",
            shortname = "XvaL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xD,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolortertb",
            shortname = "XAnO",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x10,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyrenderingdetailmaptype",
            shortname = "aNtq",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2C,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorprimb",
            shortname = "fpEX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x19,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecr",
            shortname = "gsuF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x8,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "numberfonttype",
            shortname = "iNiN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xF,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "renderingmaterialtype",
            shortname = "iZRe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x25,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorsecg",
            shortname = "neKc",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x21,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "year",
            shortname = "qFnd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x39,
            rangehigh = 2027,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "teamcolortertpercent",
            shortname = "yrUn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 7,
            offset = 0x3E,
            rangehigh = 100,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "jerseynumbercolorprimr",
            shortname = "GCoH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x9,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecb",
            shortname = "Jjet",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2E,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "powid",
            shortname = "MbYC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 15,
            offset = 0x33,
            rangehigh = 32000,
            rangelow = -1,
            startbit = 7,
        },
        {
            name = "shortsrenderingdetailmaptype",
            shortname = "MbnD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x6,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorsecr",
            shortname = "OvKn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x27,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "dlc",
            shortname = "OIbl",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 1,
            offset = 0x3E,
            rangehigh = 1,
            rangelow = 0,
            startbit = 4,
        },
        {
            name = "captainarmband",
            shortname = "UgGf",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 9,
            offset = 0x3A,
            rangehigh = 511,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "shortsnumberfonttype",
            shortname = "Vyfr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2D,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecg",
            shortname = "ZZGe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x24,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorprimg",
            shortname = "bXAI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xA,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolorsecb",
            shortname = "jUaD",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x5,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyrestriction",
            shortname = "lHax",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x40,
            rangehigh = 2,
            rangelow = 0,
            startbit = 1,
        },
        {
            name = "jerseynamecolorr",
            shortname = "tvQp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2A,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseybacknameplacementcode",
            shortname = "vMtY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1B,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortstyle",
            shortname = "wwlr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 3,
            offset = 0x3F,
            rangehigh = 7,
            rangelow = 0,
            startbit = 5,
        },
        {
            name = "shortsnumbercolorterg",
            shortname = "zJKo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x29,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamcolortertg",
            shortname = "zyzx",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x31,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyleftsleevebadge",
            shortname = "BKca",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x1E,
            rangehigh = 9999999,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamkitid",
            shortname = "DPYU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 14,
            offset = 0x36,
            rangehigh = 16383,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseybacknamefontcase",
            shortname = "LZNA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x33,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyrightsleevebadge",
            shortname = "SwCX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x16,
            rangehigh = 9999999,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamecolorb",
            shortname = "Uggt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2F,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        }
    },
    competitionkits = {
        {
            name = "teamtechid",
            shortname = "qljg",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 18,
            offset = 0x21,
            rangehigh = 200000,
            rangelow = 0,
            startbit = 2,
            key = true,
        },
        {
            name = "jerseynumbercolorterg",
            shortname = "bLBP",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xD,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorprimg",
            shortname = "myaC",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseyfrontnumberplacementcode",
            shortname = "qaaE",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x2,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorsecg",
            shortname = "NTld",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x15,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorsecr",
            shortname = "wGly",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1E,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumberplacementcode",
            shortname = "zdlB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x0,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorsecb",
            shortname = "JtVK",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x6,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "competitionid",
            shortname = "LhXN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 24,
            offset = 0x8,
            rangehigh = 9999999,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "teamkittypetechid",
            shortname = "MlXB",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 5,
            offset = 0x1F,
            rangehigh = 22,
            rangelow = 0,
            startbit = 2,
        },
        {
            name = "shortsnumbercolorprimr",
            shortname = "TPaN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xB,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamelayouttype",
            shortname = "bieS",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x10,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorterr",
            shortname = "eCpU",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x11,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorterb",
            shortname = "jpFw",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1D,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorprimb",
            shortname = "uAKR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xE,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorterr",
            shortname = "CUKn",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x17,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamecolorg",
            shortname = "MSIa",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x14,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamefonttype",
            shortname = "TEgR",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xF,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorterb",
            shortname = "XvaL",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x7,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorprimb",
            shortname = "fpEX",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x12,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecr",
            shortname = "gsuF",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x3,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "numberfonttype",
            shortname = "iNiN",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0xC,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "year",
            shortname = "qFnd",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 11,
            offset = 0x1F,
            rangehigh = 2027,
            rangelow = 0,
            startbit = 7,
        },
        {
            name = "jerseynumbercolorprimr",
            shortname = "GCoH",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x4,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecb",
            shortname = "Jjet",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1B,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumberfonttype",
            shortname = "Vyfr",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1A,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorsecg",
            shortname = "ZZGe",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x16,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynumbercolorprimg",
            shortname = "bXAI",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x5,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamecolorr",
            shortname = "tvQp",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x19,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseybacknameplacementcode",
            shortname = "vMtY",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x13,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "shortsnumbercolorterg",
            shortname = "zJKo",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x18,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseybacknamefontcase",
            shortname = "LZNA",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 2,
            offset = 0x1F,
            rangehigh = 2,
            rangelow = 0,
            startbit = 0,
        },
        {
            name = "jerseynamecolorb",
            shortname = "Uggt",
            fld_type = "DBOFIELDTYPE_INTEGER",
            depth = 8,
            offset = 0x1C,
            rangehigh = 255,
            rangelow = 0,
            startbit = 0,
        }
    }
}

COMP_OBJID_CID = {
    [1] = 990,
    [58] = 980,
    [79] = 981,
    [92] = 232,
    [95] = 223,
    [179] = 224,
    [250] = 226,
    [328] = 212,
    [344] = 80,
    [350] = 81,
    [357] = 213,
    [379] = 4,
    [385] = 214,
    [390] = 215,
    [408] = 1,
    [414] = 216,
    [419] = 228,
    [422] = 201,
    [618] = 202,
    [732] = 203,
    [804] = 13,
    [807] = 14,
    [810] = 60,
    [813] = 61,
    [816] = 414,
    [824] = 360,
    [832] = 361,
    [841] = 233,
    [844] = 204,
    [903] = 16,
    [906] = 17,
    [909] = 451,
    [919] = 206,
    [985] = 19,
    [988] = 20,
    [991] = 21,
    [996] = 2076,
    [1004] = 207,
    [1010] = 365,
    [1026] = 65,
    [1030] = 211,
    [1033] = 210,
    [1069] = 31,
    [1073] = 314,
    [1098] = 10,
    [1102] = 217,
    [1124] = 41,
    [1128] = 366,
    [1150] = 66,
    [1154] = 218,
    [1176] = 308,
    [1180] = 1004,
    [1204] = 330,
    [1210] = 5060,
    [1217] = 219,
    [1245] = 50,
    [1252] = 225,
    [1260] = 208,
    [1360] = 53,
    [1363] = 54,
    [1366] = 354,
    [1375] = 220,
    [1393] = 56,
    [1397] = 221,
    [1413] = 189,
    [1417] = 68,
    [1420] = 268,
    [1449] = 234,
    [1482] = 39,
    [1511] = 85,
    [1533] = 84,
    [1556] = 3005,
    [1578] = 351,
    [1594] = 2012,
    [1598] = 2149,
    [1607] = 1007,
    [1630] = 349,
    [1634] = 83,
    [1641] = 350,
    [1645] = 1015,
    [1648] = 1003,
    [1707] = 1014,
    [1758] = 353,
    [1762] = 7
}

COMP_NAMES = {
    [1] = "3F Superliga",
    [4] = "1A Pro League",
    [7] = "Liga do Brasil",
    [10] = "Eredivisie",
    [13] = "Premier League",
    [14] = "EFL Championship",
    [16] = "Ligue 1 Uber Eats",
    [17] = "Ligue 2 BKT",
    [19] = "Bundesliga",
    [20] = "Bundesliga 2",
    [21] = "Relegation Match",
    [31] = "Serie A TIM",
    [39] = "MLS",
    [41] = "Eliteserien",
    [50] = "cinch Prem",
    [53] = "LaLiga Santander",
    [54] = "LaLiga SmartBank",
    [56] = "Allsvenskan",
    [60] = "EFL League One",
    [61] = "EFL League Two",
    [65] = "SSE Airtricity PD",
    [66] = "PKO Ekstraklasa",
    [68] = "Süper Lig",
    [80] = "O. Bundesliga",
    [81] = "O. Bundesliga Play-offs",
    [83] = "K League 1",
    [84] = "LIGA MX Clausura",
    [85] = "LIGA MX Apertura",
    [189] = "CSSL",
    [201] = "Emirates FA Cup",
    [202] = "Carabao Cup",
    [203] = "Papa John’s Trophy",
    [204] = "Coupe Nationale",
    [206] = "DFB-Pokal",
    [207] = "Supercup",
    [208] = "Copa de Espana",
    [210] = "Coppa Italia",
    [211] = "Supercoppa",
    [212] = "Osterreich-Pokal",
    [213] = "Croky Cup",
    [214] = "Pro League Play-Off",
    [215] = "Sydbank Pokalen",
    [216] = "Superliga Playoffs",
    [217] = "NM",
    [218] = "Taca Portuguesa",
    [219] = "Scottish Cup",
    [220] = "Sveriges Cup",
    [221] = "Schweizer Pokal",
    [223] = "UEFA Champions League",
    [224] = "UEFA Europa League",
    [225] = "Supercopa",
    [226] = "UECL",
    [228] = "FA Community Shield",
    [232] = "UEFA Super Cup",
    [233] = "Trophee Champ.",
    [234] = "U.S. Open Cup",
    [268] = "Turk kupasi",
    [308] = "Liga Portugal",
    [314] = "Oranje Beker",
    [330] = "Liga I",
    [349] = "Meiji Yasuda J1",
    [350] = "MBS Pro League",
    [351] = "A-League",
    [353] = "LPF",
    [354] = "P. de Ascenso",
    [360] = "Lg One Play-Offs",
    [361] = "Lg Two Play-Offs",
    [365] = "EA SPORTS Cup",
    [366] = "Puchar Kraju",
    [414] = "Champ. Play-Offs",
    [451] = "Barrages Ligue 1",
    [980] = "European Champ.",
    [981] = "EC Qualifiers ",
    [990] = "FIFA World Cup™",
    [1003] = "Libertadores",
    [1004] = "Cupa Nationala",
    [1007] = "Levain Cup",
    [1014] = "Sudamericana",
    [1015] = "Recopa",
    [2012] = "CSL",
    [2076] = "3. Liga",
    [2149] = "Hero ISL",
    [3005] = "Asia Contl Cup",
    [5060] = "Liga I Play-offs",
}

MODE_MANAGERS_OFFSETS = {
    IFCEInterface = 0x38,
    TransferIO = 0x238,
    BoardManager = 0x2F8,
    FinanceManager = 0x578,
    FitnessManager = 0x5B8,
    TcmFinanceManager = 0x7F8,
    PlayerContractManager = 0x918,
    PlayerDataRevealManager = 0x938,
    PlayerFormManager = 0x978,
    PlayerGrowthManager = 0x998,
    PlayerMoraleManager = 0x9D8,
    PlayerStatusManager = 0xA58,
    ScoutManager = 0xB58,
    TransferManager = 0xF38,
    YouthPlayerUtil = 0xFB8,
}

NegotiationsStorageDao_STRUCT = {
    impl = 0x8
}

Action_STRUCT = {
    size = 0xC,

    action_date = 0x0,
    action_type = 0x8
}

BoardManager_STRUCT = {
    SACK_BOOL_1 = 0x94,
    SACK_BOOL_2 = 0x95,
    SACK_BOOL_3 = 0x96
}

NegotiationsStorageDaoImpl_STRUCT = {
    CPU_CLUB_HIST_OFF = 0x8,
    CPU_PLAYER_HIST_OFF = 0x10,
    CPU_CLUB_LOAN_HIST_OFF = 0x18,
    CPU_PLAYER_LOAN_HIST_OFF = 0x20,
    USER_CLUB_HIST_OFF = 0x28,
    USER_CLUB_LOAN_HIST_OFF = 0x30,
    USER_PLAYER_HIST_OFF = 0x38
}

USER_CLUB_LOAN_HIST_STRUCT = {
    size = 0xF8,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    offers_vec = 0x10,
    requests_vec = 0x30,
    actions_vec = 0x50
}

USER_CLUB_TRANSFER_HIST_STRUCT = {
    size = 0x98,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    offers_vec = 0x10,
    requests_vec = 0x30,
    actions_vec = 0x50
}

USER_PLAYER_TRANSFER_HIST_STRUCT = {
    size = 0x98,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    seller_accepted = 0xC,
    buyer_accepted = 0xD,
    seller_rejected = 0xE,
    buyer_rejected = 0xF,
    offers_vec = 0x10,
    requests_vec = 0x30,
    actions_vec = 0x50
}

USER_TRANSFER_OFFER_STRUCT = {
    size = 0x30,

    exchange_playerid = 0x0,
    sum = 0xC
}

USER_TRANSFER_REQUEST_STRUCT = {
    size = 0x30,

    exchange_playerid = 0x0,
    sum = 0xC
}

CPU_TRANSFER_OFFER_STRUCT = {
    size = 0xC,

    sum = 0x0,
    date = 0x4
}

CPU_TRANSFER_REQUEST_STRUCT = {
    size = 0x14,
    
    sum = 0x0,
    date = 0xC
}

CPU_LOAN_OFFER_STRUCT = {
    size = 0x14,

    contract_len = 0x0,
    fee = 0x4,
    date = 0x8
}

CPU_LOAN_REQUEST_STRUCT = {
    size = 0x14,

    contract_len = 0x0,
    fee = 0x4,
    date = 0xC
}


CPU_CLUB_LOAN_HIST_STRUCT = {
    size = 0xC0,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    offers_vec = 0x38,
    requests_vec = 0x58,
    seller_accepted = 0x78,
    buyer_accepted = 0x79,
    seller_rejected = 0x7A,
    buyer_rejected = 0x7B,
    last_action_idx = 0x7C,
    actions_arr = 0x80
}

CPU_PLAYER_LOAN_HIST_STRUCT = {
    size = 0x98,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    offers_vec = 0x10,
    requests_vec = 0x30,
    seller_accepted = 0x50,
    buyer_accepted = 0x52,
    seller_rejected = 0x53,
    buyer_rejected = 0x54,
    last_action_idx = 0x58,
    actions_arr = 0x5C
}

CPU_CLUB_TRANSFER_HIST_STRUCT = {
    size = 0xB0,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    offers_vec = 0x20,
    requests_vec = 0x40,
    seller_accepted = 0x68,
    buyer_accepted = 0x69,
    seller_rejected = 0x6A,
    buyer_rejected = 0x6B,
    triggered_rlc = 0x6C,
    last_action_idx = 0x70,
    actions_arr = 0x74
}

CPU_PLAYER_TRANSFER_HIST_STRUCT = {
    size = 0xB0,

    playerid = 0x0,
    toteamid = 0x4,
    fromteamid = 0x8,
    buyer_accepted = 0xC,
    buyer_rejected = 0xD,
    seller_accepted_stalls = 0xE,
    seller_accepted = 0xF,
    seller_rejected = 0x10
}

IFCEInterface_STRUCT = {
    FCEData = 0x20,
    FCEData_lists = 0x8,

    PlayersStats_off = 0x90,
    PlayersStats_n = 16000,
    PlayersStats_begin = 0x30
}

FCEData_PlayerStats_STRUCT = {
    size = 0x68,
    idx = 0x8,
    is_in_use = 0xA,
    teamid = 0x10,
    playerid = 0x14,
    compobjid = 0x18,
    avg = 0x1C,
    goals = 0x1E,
    yellow = 0x1F,
    two_yellow = 0x20,
    red = 0x21,
    app = 0x22,
    assists = 0x23,
    motm = 0x24,
    saves = 0x25,
    goals_conceded = 0x26,
    clean_sheets = 0x27
}

YOUTHPLAYERUTIL_STRUCT = {
    variance_n = 6,
    settings_offset = 0x18,
    pot_var_off = 0x798,
    max_display_val_offset = 0x7CC
}

TRANSFER_MANAGER_STRUCT = {
    NegotiationsStorageDao_offset = 0x1988
}

SCOUTMANAGER_STRUCT = {
    ranges_num = 2,
    max_exp = 5,
    max_know = 5,
    -- EXPERIENCE_1_PERC_FIND_PLAYERS_RANGE_0
    base_mission_cost_off = 0x28,
    players_per_report_off = 0x54,

}

PLAYERFORM_STRUCT = {
    size = 0x64,
    pid = 0x0,
    recent_avg = 0x4,
    form = 0x8,
    last_games_avg_1 = 0xC,
    players_form_list_offset = 0x130,
    _start = 0x8,
    _end = 0x10,
    values_array = {
        25, 50, 65, 75, 90
    }
}

PLAYERMORALE_STRUCT = {
    size = 0x60,
    pid = 0x0,
    contract = 0x24,
    morale_val = 0x28,
    playtime = 0x30,
    _start = 0x4B0,
    _end = 0x4B8,
    values_array = {
        15, 40, 65, 75, 95
    }
}

-- fm001
PLAYERFITESS_STRUCT = {
    size = 0x18,
    pid = 0x0,
    tid = 0x4, -- -1 (?!)
    full_fit_date = 0x8,
    partial_fit_date = 0xC,
    days_since_game = 0x10,
    fitness = 0x11,
    is_injured = 0x12,
    inj_part = 0x13,
    inj_type = 0x14,
    recovery_stage = 0x15, -- 3
    in_use = 0x16, -- 1

    fitness_start_offset = 0x1998,
    fitness_end_offset = 0x19A0,

    sharpness_start_offset = 0x19E8,
    sharpness_next = 0x0,
    sharpness_prev = 0x8,
    sharpness_pid = 0x20,
    sharpness_value = 0x24 -- 1 byte
}

PLAYERRLC_STRUCT = {
    size = 0xC,
    pid = 0x0,
    tid = 0x4,
    value = 0x8,
    _start = 0x160,
    _end = 0x168,
}

-- us002
PLAYERROLE_STRUCT = {
    size = 0x8,
    pid = 0x0,
    role = 0x4,
    _start = 0x18,
    _end = 0x20
}



PLAYERGROWTHSYSTEM_STRUCT = {
    size = 0x9C,
    _start = 0x5E8,
    _end = 0x5F0,
    pid = 0x0
}

PlayerGrowthManager_Data = {
    fields_ordered_array = {
        "acceleration",
        "sprintspeed",
        "agility",
        "balance",
        "jumping",
        "stamina",
        "strength",
        "reactions",
        "aggression",
        "composure",
        "interceptions",
        "positioning",
        "vision",
        "ballcontrol",
        "crossing",
        "dribbling",
        "finishing",
        "freekickaccuracy",
        "headingaccuracy",
        "longpassing",
        "shortpassing",
        "defensiveawareness",
        "shotpower",
        "longshots",
        "standingtackle",
        "slidingtackle",
        "volleys",
        "curve",
        "penalties",
        "gkdiving",
        "gkhandling",
        "gkkicking",
        "gkreflexes",
        "gkpositioning",
        "defensiveworkrate",
        "attackingworkrate",
        "weakfootabilitytypecode",
        "skillmoves"
    },
    xp_to_wr = {
        5000,    -- medium
        100,    -- low
        10000   -- high
    },
    xp_to_star = {
        100,
        2500,
        5000,
        7500,
        10000
    },
    xp_to_attribute = {
        1000,
        2101,
        3202,
        4305,
        5410,
        6518,
        7628,
        8742,
        9860,
        10983,
        12110,
        13243,
        14382,
        15528,
        16680,
        17840,
        19008,
        20185,
        21370,
        22565,
        23770,
        24986,
        26212,
        27450,
        28700,
        29963,
        31238,
        32527,
        33830,
        35148,
        36480,
        37828,
        39192,
        40573,
        41970,
        43385,
        44818,
        46270,
        47740,
        49230,
        50740,
        52271,
        53822,
        55395,
        56990,
        58608,
        60248,
        61912,
        63600,
        65313,
        67050,
        68813,
        70602,
        72418,
        74260,
        76130,
        78028,
        79955,
        81910,
        83895,
        85910,
        87956,
        90032,
        92140,
        94280,
        96453,
        98658,
        100897,
        103170,
        105478,
        107820,
        110198,
        112612,
        115063,
        117550,
        120075,
        122638,
        125240,
        127880,
        130560,
        133280,
        136041,
        138842,
        141685,
        144570,
        147498,
        150468,
        153482,
        156540,
        159643,
        162790,
        165983,
        169222,
        172508,
        175840,
        179220,
        182648,
        186125,
        189650
    }
}

-- All available forms
FORMS = {
    MainWindowForm, SettingsForm, PlayersEditorForm
}

-- OVR Calculation formula
-- key - position_id
--     - key - attribute (component name in GUI)
--     - value - percent of the ovr
--[[
0: 'GK'
1: 'SW'
2: 'RWB'
3: 'RB'
4: 'RCB'
5: 'CB'
6: 'LCB'
7: 'LB'
8: 'LWB'
9: 'RDM'
10: 'CDM'
11: 'LDM'
12: 'RM'
13: 'RCM'
14: 'CM'
15: 'LCM'
16: 'LM'
17: 'RAM'
18: 'CAM'
19: 'LAM'
20: 'RF'
21: 'CF'
22: 'LF'
23: 'RW'
24: 'RS'
25: 'ST'
26: 'LS'
27: 'LW'
--]]

POS_TO_NAME = {
    [0] = "GK",
    [1] = "SW",
    [2] = "RWB",
    [3] = "RB",
    [4] = "RCB",
    [5] = "CB",
    [6] = "LCB",
    [7] = "LB",
    [8] = "LWB",
    [9] = "RDM",
    [10] = "CDM",
    [11] = "LDM",
    [12] = "RM",
    [13] = "RCM",
    [14] = "CM",
    [15] = "LCM",
    [16] = "LM",
    [17] = "RAM",
    [18] = "CAM",
    [19] = "LAM",
    [20] = "RF",
    [21] = "CF",
    [22] = "LF",
    [23] = "RW",
    [24] = "RS",
    [25] = "ST",
    [26] = "LS",
    [27] = "LW"
}

KITTYPE_NAMES = {
    [0] = "Home Kit",
    [1] = "Away Kit",
    [2] = "GK Kit",
    [3] = "Third Kit",
}

OVR_FORMULA = {
    ["0"]= {
        ReactionsEdit = 0.11,
        GKDivingEdit = 0.21,
        GKHandlingEdit = 0.21,
        GKKickingEdit = 0.05,
        GKReflexEdit = 0.21,
        GKPositioningEdit = 0.21
    },
    ["2"]= {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.06,
        StaminaEdit = 0.10,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.12,
        BallControlEdit = 0.08,
        CrossingEdit = 0.12,
        DribblingEdit = 0.04,
        ShortPassingEdit = 0.10,
        DefensiveAwarenessEdit = 0.07,
        StandingTackleEdit = 0.08,
        SlidingTackleEdit = 0.11
    },
    ["3"]= {
        AccelerationEdit = 0.05,
        SprintSpeedEdit = 0.07,
        StaminaEdit = 0.08,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.12,
        BallControlEdit = 0.07,
        CrossingEdit = 0.09,
        HeadingAccuracyEdit = 0.04,
        ShortPassingEdit = 0.07,
        DefensiveAwarenessEdit = 0.08,
        StandingTackleEdit = 0.11,
        SlidingTackleEdit = 0.14
    },
    ["4"]= {
        SprintSpeedEdit = 0.02,
        JumpingEdit = 0.03,
        StrengthEdit = 0.10,
        ReactionsEdit = 0.05,
        AggressionEdit = 0.07,
        InterceptionsEdit = 0.13,
        BallControlEdit = 0.04,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        DefensiveAwarenessEdit = 0.14,
        StandingTackleEdit = 0.17,
        SlidingTackleEdit = 0.10
    },
    ["5"]= {
        SprintSpeedEdit = 0.02,
        JumpingEdit = 0.03,
        StrengthEdit = 0.10,
        ReactionsEdit = 0.05,
        AggressionEdit = 0.07,
        InterceptionsEdit = 0.13,
        BallControlEdit = 0.04,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        DefensiveAwarenessEdit = 0.14,
        StandingTackleEdit = 0.17,
        SlidingTackleEdit = 0.10
    },
    ["6"]= {
        SprintSpeedEdit = 0.02,
        JumpingEdit = 0.03,
        StrengthEdit = 0.10,
        ReactionsEdit = 0.05,
        AggressionEdit = 0.07,
        InterceptionsEdit = 0.13,
        BallControlEdit = 0.04,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        DefensiveAwarenessEdit = 0.14,
        StandingTackleEdit = 0.17,
        SlidingTackleEdit = 0.10
    },
    ["7"]= {
        AccelerationEdit = 0.05,
        SprintSpeedEdit = 0.07,
        StaminaEdit = 0.08,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.12,
        BallControlEdit = 0.07,
        CrossingEdit = 0.09,
        HeadingAccuracyEdit = 0.04,
        ShortPassingEdit = 0.07,
        DefensiveAwarenessEdit = 0.08,
        StandingTackleEdit = 0.11,
        SlidingTackleEdit = 0.14
    },
    ["8"]= {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.06,
        StaminaEdit = 0.10,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.12,
        BallControlEdit = 0.08,
        CrossingEdit = 0.12,
        DribblingEdit = 0.04,
        ShortPassingEdit = 0.10,
        DefensiveAwarenessEdit = 0.07,
        StandingTackleEdit = 0.08,
        SlidingTackleEdit = 0.11
    },
    ["9"]= {
        StaminaEdit = 0.06,
        StrengthEdit = 0.04,
        ReactionsEdit = 0.07,
        AggressionEdit = 0.05,
        InterceptionsEdit = 0.14,
        VisionEdit = 0.04,
        BallControlEdit = 0.10,
        LongPassingEdit = 0.10,
        ShortPassingEdit = 0.14,
        DefensiveAwarenessEdit = 0.09,
        StandingTackleEdit = 0.12,
        SlidingTackleEdit = 0.05
    },
    ["10"] = {
        StaminaEdit = 0.06,
        StrengthEdit = 0.04,
        ReactionsEdit = 0.07,
        AggressionEdit = 0.05,
        InterceptionsEdit = 0.14,
        VisionEdit = 0.04,
        BallControlEdit = 0.10,
        LongPassingEdit = 0.10,
        ShortPassingEdit = 0.14,
        DefensiveAwarenessEdit = 0.09,
        StandingTackleEdit = 0.12,
        SlidingTackleEdit = 0.05
    },
    ["11"] = {
        StaminaEdit = 0.06,
        StrengthEdit = 0.04,
        ReactionsEdit = 0.07,
        AggressionEdit = 0.05,
        InterceptionsEdit = 0.14,
        VisionEdit = 0.04,
        BallControlEdit = 0.10,
        LongPassingEdit = 0.10,
        ShortPassingEdit = 0.14,
        DefensiveAwarenessEdit = 0.09,
        StandingTackleEdit = 0.12,
        SlidingTackleEdit = 0.05
    },
    ["12"] = {
        AccelerationEdit = 0.07,
        SprintSpeedEdit = 0.06,
        StaminaEdit = 0.05,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.08,
        VisionEdit = 0.07,
        BallControlEdit = 0.13,
        CrossingEdit = 0.10,
        DribblingEdit = 0.15,
        FinishingEdit = 0.06,
        LongPassingEdit = 0.05,
        ShortPassingEdit = 0.11
    },
    ["13"] = {
        StaminaEdit = 0.06,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.05,
        AttackPositioningEdit = 0.06,
        VisionEdit = 0.13,
        BallControlEdit = 0.14,
        DribblingEdit = 0.07,
        FinishingEdit = 0.02,
        LongPassingEdit = 0.13,
        ShortPassingEdit = 0.17,
        LongShotsEdit = 0.04,
        StandingTackleEdit = 0.05
    },
    ["14"] = {
        StaminaEdit = 0.06,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.05,
        AttackPositioningEdit = 0.06,
        VisionEdit = 0.13,
        BallControlEdit = 0.14,
        DribblingEdit = 0.07,
        FinishingEdit = 0.02,
        LongPassingEdit = 0.13,
        ShortPassingEdit = 0.17,
        LongShotsEdit = 0.04,
        StandingTackleEdit = 0.05
    },
    ["15"] = {
        StaminaEdit = 0.06,
        ReactionsEdit = 0.08,
        InterceptionsEdit = 0.05,
        AttackPositioningEdit = 0.06,
        VisionEdit = 0.13,
        BallControlEdit = 0.14,
        DribblingEdit = 0.07,
        FinishingEdit = 0.02,
        LongPassingEdit = 0.13,
        ShortPassingEdit = 0.17,
        LongShotsEdit = 0.04,
        StandingTackleEdit = 0.05
    },
    ["16"] = {
        AccelerationEdit = 0.07,
        SprintSpeedEdit = 0.06,
        StaminaEdit = 0.05,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.08,
        VisionEdit = 0.07,
        BallControlEdit = 0.13,
        CrossingEdit = 0.10,
        DribblingEdit = 0.15,
        FinishingEdit = 0.06,
        LongPassingEdit = 0.05,
        ShortPassingEdit = 0.11
    },
    ["17"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.03,
        AgilityEdit = 0.03,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.09,
        VisionEdit = 0.14,
        BallControlEdit = 0.15,
        DribblingEdit = 0.13,
        FinishingEdit = 0.07,
        LongPassingEdit = 0.04,
        ShortPassingEdit = 0.16,
        LongShotsEdit = 0.05
    },
    ["18"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.03,
        AgilityEdit = 0.03,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.09,
        VisionEdit = 0.14,
        BallControlEdit = 0.15,
        DribblingEdit = 0.13,
        FinishingEdit = 0.07,
        LongPassingEdit = 0.04,
        ShortPassingEdit = 0.16,
        LongShotsEdit = 0.05
    },
    ["19"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.03,
        AgilityEdit = 0.03,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.09,
        VisionEdit = 0.14,
        BallControlEdit = 0.15,
        DribblingEdit = 0.13,
        FinishingEdit = 0.07,
        LongPassingEdit = 0.04,
        ShortPassingEdit = 0.16,
        LongShotsEdit = 0.05
    },
    ["20"] = {
        AccelerationEdit = 0.05,
        SprintSpeedEdit = 0.05,
        ReactionsEdit = 0.09,
        AttackPositioningEdit = 0.13,
        VisionEdit = 0.08,
        BallControlEdit = 0.15,
        DribblingEdit = 0.14,
        FinishingEdit = 0.11,
        HeadingAccuracyEdit = 0.02,
        ShortPassingEdit = 0.09,
        ShotPowerEdit = 0.05,
        LongShotsEdit = 0.04
    },
    ["21"] = {
        AccelerationEdit = 0.05,
        SprintSpeedEdit = 0.05,
        ReactionsEdit = 0.09,
        AttackPositioningEdit = 0.13,
        VisionEdit = 0.08,
        BallControlEdit = 0.15,
        DribblingEdit = 0.14,
        FinishingEdit = 0.11,
        HeadingAccuracyEdit = 0.02,
        ShortPassingEdit = 0.09,
        ShotPowerEdit = 0.05,
        LongShotsEdit = 0.04
    },
    ["22"] = {
        AccelerationEdit = 0.05,
        SprintSpeedEdit = 0.05,
        ReactionsEdit = 0.09,
        AttackPositioningEdit = 0.13,
        VisionEdit = 0.08,
        BallControlEdit = 0.15,
        DribblingEdit = 0.14,
        FinishingEdit = 0.11,
        HeadingAccuracyEdit = 0.02,
        ShortPassingEdit = 0.09,
        ShotPowerEdit = 0.05,
        LongShotsEdit = 0.04
    },
    ["23"] = {
        AccelerationEdit = 0.07,
        SprintSpeedEdit = 0.06,
        AgilityEdit = 0.03,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.09,
        VisionEdit = 0.06,
        BallControlEdit = 0.14,
        CrossingEdit = 0.09,
        DribblingEdit = 0.16,
        FinishingEdit = 0.10,
        ShortPassingEdit = 0.09,
        LongShotsEdit = 0.04
    },
    ["24"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.05,
        StrengthEdit = 0.05,
        ReactionsEdit = 0.08,
        AttackPositioningEdit = 0.13,
        BallControlEdit = 0.10,
        DribblingEdit = 0.07,
        FinishingEdit = 0.18,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        ShotPowerEdit = 0.10,
        LongShotsEdit = 0.03,
        VolleysEdit = 0.02
    },
    ["25"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.05,
        StrengthEdit = 0.05,
        ReactionsEdit = 0.08,
        AttackPositioningEdit = 0.13,
        BallControlEdit = 0.10,
        DribblingEdit = 0.07,
        FinishingEdit = 0.18,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        ShotPowerEdit = 0.10,
        LongShotsEdit = 0.03,
        VolleysEdit = 0.02
    },
    ["26"] = {
        AccelerationEdit = 0.04,
        SprintSpeedEdit = 0.05,
        StrengthEdit = 0.05,
        ReactionsEdit = 0.08,
        AttackPositioningEdit = 0.13,
        BallControlEdit = 0.10,
        DribblingEdit = 0.07,
        FinishingEdit = 0.18,
        HeadingAccuracyEdit = 0.10,
        ShortPassingEdit = 0.05,
        ShotPowerEdit = 0.10,
        LongShotsEdit = 0.03,
        VolleysEdit = 0.02
    },
    ["27"] = {
        AccelerationEdit = 0.07,
        SprintSpeedEdit = 0.06,
        AgilityEdit = 0.03,
        ReactionsEdit = 0.07,
        AttackPositioningEdit = 0.09,
        VisionEdit = 0.06,
        BallControlEdit = 0.14,
        CrossingEdit = 0.09,
        DribblingEdit = 0.16,
        FinishingEdit = 0.10,
        ShortPassingEdit = 0.09,
        LongShotsEdit = 0.04
    }
}

OVR_FORMULA_2 = {
    [0] = {
        reactions = 0.11,
        gkdiving = 0.21,
        gkhandling = 0.21,
        gkkicking = 0.05,
        gkreflexes = 0.21,
        gkpositioning = 0.21
    },
    [2] = {
        acceleration = 0.04,
        sprintspeed = 0.06,
        stamina = 0.10,
        reactions = 0.08,
        interceptions = 0.12,
        ballcontrol = 0.08,
        crossing = 0.12,
        dribbling = 0.04,
        shortpassing = 0.10,
        defensiveawareness = 0.07,
        standingtackle = 0.08,
        slidingtackle = 0.11
    },
    [3] = {
        acceleration = 0.05,
        sprintspeed = 0.07,
        stamina = 0.08,
        reactions = 0.08,
        interceptions = 0.12,
        ballcontrol = 0.07,
        crossing = 0.09,
        headingaccuracy = 0.04,
        shortpassing = 0.07,
        defensiveawareness = 0.08,
        standingtackle = 0.11,
        slidingtackle = 0.14
    },
    [4] = {
        sprintspeed = 0.02,
        jumping = 0.03,
        strength = 0.10,
        reactions = 0.05,
        aggression = 0.07,
        interceptions = 0.13,
        ballcontrol = 0.04,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        defensiveawareness = 0.14,
        standingtackle = 0.17,
        slidingtackle = 0.10
    },
    [5] = {
        sprintspeed = 0.02,
        jumping = 0.03,
        strength = 0.10,
        reactions = 0.05,
        aggression = 0.07,
        interceptions = 0.13,
        ballcontrol = 0.04,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        defensiveawareness = 0.14,
        standingtackle = 0.17,
        slidingtackle = 0.10
    },
    [6] = {
        sprintspeed = 0.02,
        jumping = 0.03,
        strength = 0.10,
        reactions = 0.05,
        aggression = 0.07,
        interceptions = 0.13,
        ballcontrol = 0.04,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        defensiveawareness = 0.14,
        standingtackle = 0.17,
        slidingtackle = 0.10
    },
    [7] = {
        acceleration = 0.05,
        sprintspeed = 0.07,
        stamina = 0.08,
        reactions = 0.08,
        interceptions = 0.12,
        ballcontrol = 0.07,
        crossing = 0.09,
        headingaccuracy = 0.04,
        shortpassing = 0.07,
        defensiveawareness = 0.08,
        standingtackle = 0.11,
        slidingtackle = 0.14
    },
    [8] = {
        acceleration = 0.04,
        sprintspeed = 0.06,
        stamina = 0.10,
        reactions = 0.08,
        interceptions = 0.12,
        ballcontrol = 0.08,
        crossing = 0.12,
        dribbling = 0.04,
        shortpassing = 0.10,
        defensiveawareness = 0.07,
        standingtackle = 0.08,
        slidingtackle = 0.11
    },
    [9] = {
        stamina = 0.06,
        strength = 0.04,
        reactions = 0.07,
        aggression = 0.05,
        interceptions = 0.14,
        vision = 0.04,
        ballcontrol = 0.10,
        longpassing = 0.10,
        shortpassing = 0.14,
        defensiveawareness = 0.09,
        standingtackle = 0.12,
        slidingtackle = 0.05
    },
    [10] = {
        stamina = 0.06,
        strength = 0.04,
        reactions = 0.07,
        aggression = 0.05,
        interceptions = 0.14,
        vision = 0.04,
        ballcontrol = 0.10,
        longpassing = 0.10,
        shortpassing = 0.14,
        defensiveawareness = 0.09,
        standingtackle = 0.12,
        slidingtackle = 0.05
    },
    [11] = {
        stamina = 0.06,
        strength = 0.04,
        reactions = 0.07,
        aggression = 0.05,
        interceptions = 0.14,
        vision = 0.04,
        ballcontrol = 0.10,
        longpassing = 0.10,
        shortpassing = 0.14,
        defensiveawareness = 0.09,
        standingtackle = 0.12,
        slidingtackle = 0.05
    },
    [12] = {
        acceleration = 0.07,
        sprintspeed = 0.06,
        stamina = 0.05,
        reactions = 0.07,
        positioning = 0.08,
        vision = 0.07,
        ballcontrol = 0.13,
        crossing = 0.10,
        dribbling = 0.15,
        finishing = 0.06,
        longpassing = 0.05,
        shortpassing = 0.11
    },
    [13] = {
        stamina = 0.06,
        reactions = 0.08,
        interceptions = 0.05,
        positioning = 0.06,
        vision = 0.13,
        ballcontrol = 0.14,
        dribbling = 0.07,
        finishing = 0.02,
        longpassing = 0.13,
        shortpassing = 0.17,
        longshots = 0.04,
        standingtackle = 0.05
    },
    [14] = {
        stamina = 0.06,
        reactions = 0.08,
        interceptions = 0.05,
        positioning = 0.06,
        vision = 0.13,
        ballcontrol = 0.14,
        dribbling = 0.07,
        finishing = 0.02,
        longpassing = 0.13,
        shortpassing = 0.17,
        longshots = 0.04,
        standingtackle = 0.05
    },
    [15] = {
        stamina = 0.06,
        reactions = 0.08,
        interceptions = 0.05,
        positioning = 0.06,
        vision = 0.13,
        ballcontrol = 0.14,
        dribbling = 0.07,
        finishing = 0.02,
        longpassing = 0.13,
        shortpassing = 0.17,
        longshots = 0.04,
        standingtackle = 0.05
    },
    [16] = {
        acceleration = 0.07,
        sprintspeed = 0.06,
        stamina = 0.05,
        reactions = 0.07,
        positioning = 0.08,
        vision = 0.07,
        ballcontrol = 0.13,
        crossing = 0.10,
        dribbling = 0.15,
        finishing = 0.06,
        longpassing = 0.05,
        shortpassing = 0.11
    },
    [17] = {
        acceleration = 0.04,
        sprintspeed = 0.03,
        agility = 0.03,
        reactions = 0.07,
        positioning = 0.09,
        vision = 0.14,
        ballcontrol = 0.15,
        dribbling = 0.13,
        finishing = 0.07,
        longpassing = 0.04,
        shortpassing = 0.16,
        longshots = 0.05
    },
    [18] = {
        acceleration = 0.04,
        sprintspeed = 0.03,
        agility = 0.03,
        reactions = 0.07,
        positioning = 0.09,
        vision = 0.14,
        ballcontrol = 0.15,
        dribbling = 0.13,
        finishing = 0.07,
        longpassing = 0.04,
        shortpassing = 0.16,
        longshots = 0.05
    },
    [19] = {
        acceleration = 0.04,
        sprintspeed = 0.03,
        agility = 0.03,
        reactions = 0.07,
        positioning = 0.09,
        vision = 0.14,
        ballcontrol = 0.15,
        dribbling = 0.13,
        finishing = 0.07,
        longpassing = 0.04,
        shortpassing = 0.16,
        longshots = 0.05
    },
    [20] = {
        acceleration = 0.05,
        sprintspeed = 0.05,
        reactions = 0.09,
        positioning = 0.13,
        vision = 0.08,
        ballcontrol = 0.15,
        dribbling = 0.14,
        finishing = 0.11,
        headingaccuracy = 0.02,
        shortpassing = 0.09,
        shotpower = 0.05,
        longshots = 0.04
    },
    [21] = {
        acceleration = 0.05,
        sprintspeed = 0.05,
        reactions = 0.09,
        positioning = 0.13,
        vision = 0.08,
        ballcontrol = 0.15,
        dribbling = 0.14,
        finishing = 0.11,
        headingaccuracy = 0.02,
        shortpassing = 0.09,
        shotpower = 0.05,
        longshots = 0.04
    },
    [22] = {
        acceleration = 0.05,
        sprintspeed = 0.05,
        reactions = 0.09,
        positioning = 0.13,
        vision = 0.08,
        ballcontrol = 0.15,
        dribbling = 0.14,
        finishing = 0.11,
        headingaccuracy = 0.02,
        shortpassing = 0.09,
        shotpower = 0.05,
        longshots = 0.04
    },
    [23] = {
        acceleration = 0.07,
        sprintspeed = 0.06,
        agility = 0.03,
        reactions = 0.07,
        positioning = 0.09,
        vision = 0.06,
        ballcontrol = 0.14,
        crossing = 0.09,
        dribbling = 0.16,
        finishing = 0.10,
        shortpassing = 0.09,
        longshots = 0.04
    },
    [24] = {
        acceleration = 0.04,
        sprintspeed = 0.05,
        strength = 0.05,
        reactions = 0.08,
        positioning = 0.13,
        ballcontrol = 0.10,
        dribbling = 0.07,
        finishing = 0.18,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        shotpower = 0.10,
        longshots = 0.03,
        volleys = 0.02
    },
    [25] = {
        acceleration = 0.04,
        sprintspeed = 0.05,
        strength = 0.05,
        reactions = 0.08,
        positioning = 0.13,
        ballcontrol = 0.10,
        dribbling = 0.07,
        finishing = 0.18,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        shotpower = 0.10,
        longshots = 0.03,
        volleys = 0.02
    },
    [26] = {
        acceleration = 0.04,
        sprintspeed = 0.05,
        strength = 0.05,
        reactions = 0.08,
        positioning = 0.13,
        ballcontrol = 0.10,
        dribbling = 0.07,
        finishing = 0.18,
        headingaccuracy = 0.10,
        shortpassing = 0.05,
        shotpower = 0.10,
        longshots = 0.03,
        volleys = 0.02
    },
    [27] = {
        acceleration = 0.07,
        sprintspeed = 0.06,
        agility = 0.03,
        reactions = 0.07,
        positioning = 0.09,
        vision = 0.06,
        ballcontrol = 0.14,
        crossing = 0.09,
        dribbling = 0.16,
        finishing = 0.10,
        shortpassing = 0.09,
        longshots = 0.04
    }
}

HEAD_TYPE_CB_IDX = {
    "Caucasian",
    "African_South_European",
    "Asian",
    "Arabic",
    "African_South",
    "Latin", 
    "Eastern_European",
    "North_European",
    "African_North",
    "South_European",
    "African"
}

HEAD_TYPE_GROUPS = {
    Caucasian = {
        0,
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        8,
        9,
        10,
        11,
        12,
        13,
        14,
        15,
        16,
        17,
        18,
        19,
        20,
        21,
        22,
        23,
        24,
        25,
        26,
        27,
        28,
        29,
        30,
        31,
        32,
        33,
        34,
        35,
        36,
        37,
        38,
        39,
        40,
        41,
        42,
        43,
        44,
        46,
        47,
        48,
        49,
        50,
        51,
        52,
        53,
        54,
        55,
        56,
        57,
        58,
        59,
        5500,
        5501,
        5502,
        5503,
        5504,
        5505,
        5506,
        5507,
        5508,
        5509,
        5510
    },
    African_South_European = {
        5000,
        5001,
        5002,
        5003,
        10500,
        10501,
        10502,
        10503,
        10504,
        10505,
        10506,
        10507
    },
    Asian = {
        500,
        501,
        502,
        503,
        504,
        505,
        506,
        507,
        508,
        509,
        510,
        511,
        512,
        513,
        514,
        515,
        516,
        517,
        518,
        519,
        520,
        521,
        522,
        525,
        526,
        527,
        528,
        529,
        530,
        531,
        532,
        533,
        534,
        535,
        536,
        537,
        538,
        539,
        540,
        541,
        542,
        543,
        544,
        545,
        546,
        547,
        548,
        549,
        550,
        551,
        552,
        553,
        554,
        555,
        556,
        557,
        558,
        559,
        560,
        561,
        562,
        600,
        601,
        602,
        6000,
        6001,
        6002,
        6003,
        6004,
        6005,
        6006,
        6007,
        6008,
        6009,
        6010,
        6011,
        6012,
        6013,
        6014,
        6015,
        6016,
        6017,
        6018,
        6019,
        6020,
        6021,
        6022,
        6023,
        6024,
        6025,
        6026,
        6027,
        6028,
        6029
    },
    Arabic = {
        2500,
        2501,
        2502,
        2503,
        2504,
        2505,
        2506,
        2507,
        2508,
        2509,
        2510,
        2511,
        2512,
        2514,
        2515,
        2516,
        2517,
        2518,
        2519,
        2520,
        2521,
        2522,
        8000,
        8001,
        8002
    },
    African_South = {
        3000,
        3001,
        3002,
        3003,
        3004,
        3005,
        8500,
        8501,
        8502
    },
    Latin = {
        1500,
        1501,
        1502,
        1503,
        1504,
        1505,
        1506,
        1507,
        1508,
        1509,
        1510,
        1511,
        1512,
        1514,
        1515,
        1516,
        1517,
        1518,
        1519,
        1520,
        1521,
        1522,
        1523,
        1524,
        1525,
        1526,
        1527,
        1528,
        1529,
        1530,
        1531,
        1532,
        1533,
        1534,
        1535,
        1536,
        1537,
        1538,
        1539,
        1540,
        1541,
        1542,
        1543,
        1545,
        1546,
        1547,
        1548,
        1549,
        7000,
        7001,
        7002,
        7003,
        7004,
        7005,
        7006,
        7007,
        7008,
        7009,
        7010,
        7011,
        7012,
        7013,
        7014,
        7015,
        7016,
        7017,
        7018,
        7019,
        7020,
        7021,
        7022,
        7023,
        7024,
        7025,
        7026
    },
    Eastern_European = {
        2000,
        2001,
        2002,
        2003,
        2004,
        2005,
        2006,
        2007,
        2008,
        2009,
        2010,
        2012,
        2013,
        2014,
        2015,
        2016,
        2017,
        2019,
        2020,
        2021,
        2022,
        2023,
        2024,
        2027,
        2028,
        2029,
        2030,
        2031,
        7500,
        7501,
        7502
    },
    North_European = {
        4000,
        4001,
        4002,
        4003,
        4004,
        4005,
        4006,
        4007,
        4008,
        4009,
        4010,
        4011,
        4012,
        4013,
        4014,
        4015,
        4016,
        4017,
        9500,
        9501,
        9502,
        9503,
        9504,
        9505,
        9506,
        9507,
        9508,
        9509,
        9510,
        9511,
        9512,
    },
    African_North = {
        4500,
        4501,
        4502,
        4525,
        10000,
        10001,
        10002,
        10003,
        10004,
        10005,
        10006,
        10007,
        10008,
        10009,
        10010,
        10011,
        10012,
        10013,
        10014,
        10015,
        10016,
        10017,
        10018,
        10019,
        10020,
        10021,
        10022,
        10023,
        10024,
        10025,
        10026,
        10027
    },
    South_European = {
        3500,
        3501,
        3502,
        3503,
        3504,
        3505,
        3506,
        3507,
        3508,
        3509,
        3510,
        3512,
        3513,
        3514,
        3515,
        3516,
        3517,
        3518,
        3519,
        9000,
        9001,
        9002
    },
    African = {
        1000,
        1001,
        1002,
        1003,
        1004,
        1005,
        1006,
        1007,
        1008,
        1009,
        1010,
        1011,
        1012,
        1013,
        1014,
        1015,
        1016,
        1017,
        1018,
        1019,
        1020,
        1021,
        1023,
        1024,
        1025,
        1027,
        1028,
        1029,
        1030,
        1031,
        1033,
        1035,
        1036,
        1037,
        1038,
        1039,
        6500,
        6501,
        6502
    }
}

-- Min and max value that attribute/potential/overall can be.
ATTRIBUTE_BOUNDS = {
    min = 1,
    max = 99,
}

FORMATIONS_DATA = {
    [0] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 12,
        position8 = 16,
        position9 = 18,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.65,
        offset5y = 0.3375,
        offset6x = 0.35,
        offset6y = 0.3375,
        offset7x = 0.925,
        offset7y = 0.5875,
        offset8x = 0.075,
        offset8y = 0.5875,
        offset9x = 0.5,
        offset9y = 0.6625,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 3,
        formationaudioid = 14,
        sourceformationid = 0
    },
    [1] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 12,
        position7 = 14,
        position8 = 16,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.672,
        offset2y = 0.1521,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.5,
        offset5y = 0.3375,
        offset6x = 0.925,
        offset6y = 0.5875,
        offset7x = 0.5,
        offset7y = 0.5125,
        offset8x = 0.075,
        offset8y = 0.5875,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 12,
        sourceformationid = 1
    },
    [2] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 12,
        position7 = 13,
        position8 = 15,
        position9 = 16,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.5,
        offset5y = 0.3375,
        offset6x = 0.925,
        offset6y = 0.5875,
        offset7x = 0.64,
        offset7y = 0.55,
        offset8x = 0.3561,
        offset8y = 0.55,
        offset9x = 0.075,
        offset9y = 0.5875,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 15,
        sourceformationid = 2
    },
    [3] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 17,
        position8 = 18,
        position9 = 19,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.7125,
        offset2y = 0.175,
        offset3x = 0.2875,
        offset3y = 0.175,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.65,
        offset5y = 0.3375,
        offset6x = 0.35,
        offset6y = 0.3375,
        offset7x = 0.8,
        offset7y = 0.6625,
        offset8x = 0.5,
        offset8y = 0.6625,
        offset9x = 0.2,
        offset9y = 0.6625,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 16,
        formationaudioid = 14,
        sourceformationid = 3
    },
    [4] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 12,
        position8 = 16,
        position9 = 18,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.945,
        offset1y = 0.225,
        offset2x = 0.65,
        offset2y = 0.15,
        offset3x = 0.35,
        offset3y = 0.15,
        offset4x = 0.055,
        offset4y = 0.225,
        offset5x = 0.65,
        offset5y = 0.3375,
        offset6x = 0.35,
        offset6y = 0.3375,
        offset7x = 0.91,
        offset7y = 0.56,
        offset8x = 0.09,
        offset8y = 0.56,
        offset9x = 0.5,
        offset9y = 0.66,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 3,
        formationaudioid = 14,
        sourceformationid = 4
    },
    [5] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 13,
        position6 = 15,
        position7 = 23,
        position8 = 24,
        position9 = 26,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.945,
        offset1y = 0.225,
        offset2x = 0.65,
        offset2y = 0.15,
        offset3x = 0.35,
        offset3y = 0.15,
        offset4x = 0.055,
        offset4y = 0.225,
        offset5x = 0.65,
        offset5y = 0.5125,
        offset6x = 0.35,
        offset6y = 0.5125,
        offset7x = 0.9,
        offset7y = 0.8325,
        offset8x = 0.6,
        offset8y = 0.875,
        offset9x = 0.39,
        offset9y = 0.875,
        offset10x = 0.1,
        offset10y = 0.8325,
        formationfullnameid = -1,
        formationaudioid = 2,
        sourceformationid = 5
    },
    [6] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 13,
        position6 = 14,
        position7 = 15,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.9,
        offset1y = 0.225,
        offset2x = 0.6375,
        offset2y = 0.175,
        offset3x = 0.3625,
        offset3y = 0.175,
        offset4x = 0.1,
        offset4y = 0.225,
        offset5x = 0.66,
        offset5y = 0.55,
        offset6x = 0.5,
        offset6y = 0.4785,
        offset7x = 0.34,
        offset7y = 0.55,
        offset8x = 0.5,
        offset8y = 0.7,
        offset9x = 0.61,
        offset9y = 0.85,
        offset10x = 0.4,
        offset10y = 0.85,
        formationfullnameid = -1,
        formationaudioid = 9,
        sourceformationid = 6
    },
    [7] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 13,
        position6 = 14,
        position7 = 15,
        position8 = 20,
        position9 = 22,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.95,
        offset1y = 0.225,
        offset2x = 0.6708,
        offset2y = 0.1644,
        offset3x = 0.327,
        offset3y = 0.1686,
        offset4x = 0.05,
        offset4y = 0.225,
        offset5x = 0.65,
        offset5y = 0.5125,
        offset6x = 0.5,
        offset6y = 0.475,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.7125,
        offset8y = 0.75,
        offset9x = 0.2875,
        offset9y = 0.75,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 20,
        formationaudioid = 8,
        sourceformationid = 7
    },
    [8] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 13,
        position6 = 14,
        position7 = 15,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.65,
        offset5y = 0.5125,
        offset6x = 0.5,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.925,
        offset8y = 0.825,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.075,
        offset10y = 0.825,
        formationfullnameid = 17,
        formationaudioid = 6,
        sourceformationid = 8
    },
    [9] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 13,
        position7 = 15,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.9,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.5,
        offset5y = 0.3375,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.925,
        offset8y = 0.825,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.075,
        offset10y = 0.825,
        formationfullnameid = 7,
        formationaudioid = 6,
        sourceformationid = 9
    },
    [10] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 14,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.1394,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.65,
        offset5y = 0.3375,
        offset6x = 0.35,
        offset6y = 0.3375,
        offset7x = 0.5,
        offset7y = 0.5125,
        offset8x = 0.925,
        offset8y = 0.825,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.075,
        offset10y = 0.825,
        formationfullnameid = 5,
        formationaudioid = 6,
        sourceformationid = 10
    },
    [11] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 13,
        position6 = 15,
        position7 = 18,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.945,
        offset1y = 0.225,
        offset2x = 0.65,
        offset2y = 0.15,
        offset3x = 0.35,
        offset3y = 0.15,
        offset4x = 0.055,
        offset4y = 0.225,
        offset5x = 0.65,
        offset5y = 0.5125,
        offset6x = 0.35,
        offset6y = 0.5125,
        offset7x = 0.5,
        offset7y = 0.66,
        offset8x = 0.9,
        offset8y = 0.85,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.1,
        offset10y = 0.85,
        formationfullnameid = 4,
        formationaudioid = 6,
        sourceformationid = 11
    },
    [12] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 13,
        position7 = 15,
        position8 = 21,
        position9 = 23,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.9189,
        offset1y = 0.1957,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.5,
        offset5y = 0.3375,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.5,
        offset8y = 0.75,
        offset9x = 0.925,
        offset9y = 0.825,
        offset10x = 0.075,
        offset10y = 0.825,
        formationfullnameid = 6,
        formationaudioid = 7,
        sourceformationid = 12
    },
    [13] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 17,
        position8 = 19,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.6587,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.66,
        offset5y = 0.3673,
        offset6x = 0.36,
        offset6y = 0.375,
        offset7x = 0.8,
        offset7y = 0.6625,
        offset8x = 0.2,
        offset8y = 0.6625,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 10,
        sourceformationid = 13
    },
    [14] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 12,
        position7 = 16,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.9,
        offset1y = 0.2085,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.4974,
        offset5y = 0.3622,
        offset6x = 0.9212,
        offset6y = 0.65,
        offset7x = 0.075,
        offset7y = 0.65,
        offset8x = 0.4939,
        offset8y = 0.7,
        offset9x = 0.61,
        offset9y = 0.875,
        offset10x = 0.38,
        offset10y = 0.875,
        formationfullnameid = 10,
        formationaudioid = 11,
        sourceformationid = 14
    },
    [15] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 10,
        position6 = 13,
        position7 = 15,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.5,
        offset5y = 0.3375,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.5,
        offset8y = 0.6646,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = 9,
        formationaudioid = 11,
        sourceformationid = 15
    },
    [16] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 12,
        position6 = 13,
        position7 = 15,
        position8 = 16,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.925,
        offset5y = 0.5875,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.075,
        offset8y = 0.5875,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = 11,
        formationaudioid = 10,
        sourceformationid = 16
    },
    [17] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 9,
        position6 = 11,
        position7 = 12,
        position8 = 16,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.6568,
        offset2y = 0.15,
        offset3x = 0.3523,
        offset3y = 0.1543,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.65,
        offset5y = 0.3375,
        offset6x = 0.35,
        offset6y = 0.3375,
        offset7x = 0.925,
        offset7y = 0.5875,
        offset8x = 0.075,
        offset8y = 0.5875,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = 12,
        formationaudioid = 10,
        sourceformationid = 17
    },
    [18] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 12,
        position6 = 13,
        position7 = 15,
        position8 = 16,
        position9 = 18,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.9008,
        offset5y = 0.6492,
        offset6x = 0.653,
        offset6y = 0.5359,
        offset7x = 0.3409,
        offset7y = 0.5444,
        offset8x = 0.075,
        offset8y = 0.6428,
        offset9x = 0.5,
        offset9y = 0.6625,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 18,
        formationaudioid = 14,
        sourceformationid = 18
    },
    [19] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 12,
        position6 = 13,
        position7 = 15,
        position8 = 16,
        position9 = 21,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.9,
        offset5y = 0.65,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.1,
        offset8y = 0.65,
        offset9x = 0.5,
        offset9y = 0.75,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 8,
        formationaudioid = 13,
        sourceformationid = 19
    },
    [20] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 12,
        position6 = 13,
        position7 = 14,
        position8 = 15,
        position9 = 16,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.2,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.325,
        offset3y = 0.15,
        offset4x = 0.075,
        offset4y = 0.2,
        offset5x = 0.925,
        offset5y = 0.5875,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.5,
        offset7y = 0.5125,
        offset8x = 0.35,
        offset8y = 0.5125,
        offset9x = 0.075,
        offset9y = 0.5875,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 19,
        formationaudioid = 15,
        sourceformationid = 20
    },
    [21] = {
        position0 = 0,
        position1 = 3,
        position2 = 4,
        position3 = 6,
        position4 = 7,
        position5 = 12,
        position6 = 14,
        position7 = 16,
        position8 = 17,
        position9 = 19,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.945,
        offset1y = 0.225,
        offset2x = 0.65,
        offset2y = 0.15,
        offset3x = 0.35,
        offset3y = 0.15,
        offset4x = 0.055,
        offset4y = 0.225,
        offset5x = 0.9,
        offset5y = 0.525,
        offset6x = 0.5,
        offset6y = 0.475,
        offset7x = 0.1,
        offset7y = 0.525,
        offset8x = 0.75,
        offset8y = 0.67,
        offset9x = 0.25,
        offset9y = 0.67,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 15,
        formationaudioid = 14,
        sourceformationid = 21
    },
    [22] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 10,
        position5 = 12,
        position6 = 13,
        position7 = 15,
        position8 = 16,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.67,
        offset1y = 0.125,
        offset2x = 0.5,
        offset2y = 0.15,
        offset3x = 0.33,
        offset3y = 0.125,
        offset4x = 0.5,
        offset4y = 0.3375,
        offset5x = 0.9,
        offset5y = 0.65,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.1,
        offset8y = 0.65,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 1,
        sourceformationid = 22
    },
    [23] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 12,
        position5 = 13,
        position6 = 15,
        position7 = 16,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.7125,
        offset1y = 0.175,
        offset2x = 0.5025,
        offset2y = 0.125,
        offset3x = 0.2875,
        offset3y = 0.175,
        offset4x = 0.95,
        offset4y = 0.525,
        offset5x = 0.66,
        offset5y = 0.475,
        offset6x = 0.34,
        offset6y = 0.475,
        offset7x = 0.05,
        offset7y = 0.525,
        offset8x = 0.5,
        offset8y = 0.6625,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 1,
        sourceformationid = 23
    },
    [24] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 12,
        position5 = 13,
        position6 = 15,
        position7 = 16,
        position8 = 20,
        position9 = 22,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.6817,
        offset1y = 0.1509,
        offset2x = 0.5,
        offset2y = 0.15,
        offset3x = 0.3204,
        offset3y = 0.1521,
        offset4x = 0.925,
        offset4y = 0.5875,
        offset5x = 0.65,
        offset5y = 0.5061,
        offset6x = 0.3439,
        offset6y = 0.475,
        offset7x = 0.075,
        offset7y = 0.5875,
        offset8x = 0.7095,
        offset8y = 0.725,
        offset9x = 0.2875,
        offset9y = 0.75,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 21,
        formationaudioid = 0,
        sourceformationid = 24
    },
    [25] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 12,
        position5 = 13,
        position6 = 15,
        position7 = 16,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.7125,
        offset1y = 0.175,
        offset2x = 0.5,
        offset2y = 0.15,
        offset3x = 0.2875,
        offset3y = 0.175,
        offset4x = 0.928,
        offset4y = 0.525,
        offset5x = 0.65,
        offset5y = 0.5125,
        offset6x = 0.35,
        offset6y = 0.5125,
        offset7x = 0.078,
        offset7y = 0.525,
        offset8x = 0.9,
        offset8y = 0.775,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.1,
        offset10y = 0.775,
        formationfullnameid = 2,
        formationaudioid = 0,
        sourceformationid = 25
    },
    [26] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 10,
        position5 = 12,
        position6 = 16,
        position7 = 18,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.7125,
        offset1y = 0.125,
        offset2x = 0.5,
        offset2y = 0.175,
        offset3x = 0.2875,
        offset3y = 0.125,
        offset4x = 0.5,
        offset4y = 0.375,
        offset5x = 0.9,
        offset5y = 0.55,
        offset6x = 0.1,
        offset6y = 0.55,
        offset7x = 0.5,
        offset7y = 0.65,
        offset8x = 0.9,
        offset8y = 0.85,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.1,
        offset10y = 0.85,
        formationfullnameid = 1,
        formationaudioid = 0,
        sourceformationid = 26
    },
    [27] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 9,
        position5 = 11,
        position6 = 12,
        position7 = 16,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.7125,
        offset1y = 0.125,
        offset2x = 0.5,
        offset2y = 0.175,
        offset3x = 0.2875,
        offset3y = 0.125,
        offset4x = 0.65,
        offset4y = 0.3375,
        offset5x = 0.35,
        offset5y = 0.3375,
        offset6x = 0.92,
        offset6y = 0.525,
        offset7x = 0.08,
        offset7y = 0.525,
        offset8x = 0.5,
        offset8y = 0.62,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = 22,
        formationaudioid = 1,
        sourceformationid = 27
    },
    [28] = {
        position0 = 0,
        position1 = 4,
        position2 = 5,
        position3 = 6,
        position4 = 9,
        position5 = 11,
        position6 = 12,
        position7 = 14,
        position8 = 16,
        position9 = 21,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.67,
        offset1y = 0.125,
        offset2x = 0.5,
        offset2y = 0.15,
        offset3x = 0.33,
        offset3y = 0.125,
        offset4x = 0.65,
        offset4y = 0.3375,
        offset5x = 0.35,
        offset5y = 0.3375,
        offset6x = 0.925,
        offset6y = 0.5875,
        offset7x = 0.5,
        offset7y = 0.5125,
        offset8x = 0.075,
        offset8y = 0.5875,
        offset9x = 0.5,
        offset9y = 0.75,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 23,
        formationaudioid = 1,
        sourceformationid = 28
    },
    [29] = {
        position0 = 0,
        position1 = 2,
        position2 = 4,
        position3 = 5,
        position4 = 6,
        position5 = 8,
        position6 = 13,
        position7 = 15,
        position8 = 18,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.275,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.5,
        offset3y = 0.15,
        offset4x = 0.325,
        offset4y = 0.15,
        offset5x = 0.075,
        offset5y = 0.275,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.5,
        offset8y = 0.6625,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 4,
        sourceformationid = 29
    },
    [30] = {
        position0 = 0,
        position1 = 2,
        position2 = 4,
        position3 = 5,
        position4 = 6,
        position5 = 8,
        position6 = 13,
        position7 = 15,
        position8 = 23,
        position9 = 25,
        position10 = 27,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.9,
        offset1y = 0.28,
        offset2x = 0.7125,
        offset2y = 0.125,
        offset3x = 0.5,
        offset3y = 0.175,
        offset4x = 0.2875,
        offset4y = 0.125,
        offset5x = 0.1,
        offset5y = 0.28,
        offset6x = 0.65,
        offset6y = 0.5125,
        offset7x = 0.35,
        offset7y = 0.5125,
        offset8x = 0.9,
        offset8y = 0.82,
        offset9x = 0.4995,
        offset9y = 0.875,
        offset10x = 0.1,
        offset10y = 0.82,
        formationfullnameid = -1,
        formationaudioid = 3,
        sourceformationid = 30
    },
    [31] = {
        position0 = 0,
        position1 = 2,
        position2 = 4,
        position3 = 5,
        position4 = 6,
        position5 = 8,
        position6 = 13,
        position7 = 14,
        position8 = 15,
        position9 = 24,
        position10 = 26,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.925,
        offset1y = 0.275,
        offset2x = 0.7125,
        offset2y = 0.175,
        offset3x = 0.5,
        offset3y = 0.15,
        offset4x = 0.2875,
        offset4y = 0.175,
        offset5x = 0.075,
        offset5y = 0.275,
        offset6x = 0.66,
        offset6y = 0.55,
        offset7x = 0.5152,
        offset7y = 0.475,
        offset8x = 0.34,
        offset8y = 0.5415,
        offset9x = 0.6,
        offset9y = 0.875,
        offset10x = 0.39,
        offset10y = 0.875,
        formationfullnameid = -1,
        formationaudioid = 4,
        sourceformationid = 31
    },
    [32] = {
        position0 = 0,
        position1 = 2,
        position2 = 4,
        position3 = 5,
        position4 = 6,
        position5 = 8,
        position6 = 10,
        position7 = 12,
        position8 = 16,
        position9 = 18,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.015,
        offset1x = 0.9,
        offset1y = 0.28,
        offset2x = 0.7125,
        offset2y = 0.125,
        offset3x = 0.5,
        offset3y = 0.175,
        offset4x = 0.2875,
        offset4y = 0.125,
        offset5x = 0.1,
        offset5y = 0.28,
        offset6x = 0.5,
        offset6y = 0.375,
        offset7x = 0.9,
        offset7y = 0.6,
        offset8x = 0.1,
        offset8y = 0.6,
        offset9x = 0.5,
        offset9y = 0.66,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 13,
        formationaudioid = 5,
        sourceformationid = 32
    },
    [33] = {
        position0 = 0,
        position1 = 2,
        position2 = 4,
        position3 = 5,
        position4 = 6,
        position5 = 8,
        position6 = 12,
        position7 = 13,
        position8 = 15,
        position9 = 16,
        position10 = 25,
        offset0x = 0.5,
        offset0y = 0.0175,
        offset1x = 0.9,
        offset1y = 0.2941,
        offset2x = 0.675,
        offset2y = 0.15,
        offset3x = 0.5,
        offset3y = 0.15,
        offset4x = 0.325,
        offset4y = 0.15,
        offset5x = 0.0962,
        offset5y = 0.2963,
        offset6x = 0.925,
        offset6y = 0.5875,
        offset7x = 0.66,
        offset7y = 0.55,
        offset8x = 0.34,
        offset8y = 0.55,
        offset9x = 0.075,
        offset9y = 0.5875,
        offset10x = 0.4995,
        offset10y = 0.875,
        formationfullnameid = 14,
        formationaudioid = 5,
        sourceformationid = 33
    }
}

CLONE_COLUMNS = {
    firstnameid = 1,
    lastnameid = 2,
    playerjerseynameid = 3,
    commonnameid = 4,
    skintypecode = 5,
    trait2 = 6,
    haircolorcode = 7,
    facialhairtypecode = 8,
    curve = 9,
    jerseystylecode = 10,
    agility = 11,
    tattooback = 12,
    accessorycode4 = 13,
    gksavetype = 14,
    positioning = 15,
    tattooleftarm = 16,
    hairtypecode = 17,
    standingtackle = 18,
    preferredposition3 = 19,
    longpassing = 20,
    penalties = 21,
    animfreekickstartposcode = 22,
    isretiring = 23,
    longshots = 24,
    gkdiving = 25,
    interceptions = 26,
    shoecolorcode2 = 27,
    crossing = 28,
    potential = 29,
    gkreflexes = 30,
    finishingcode1 = 31,
    reactions = 32,
    composure = 33,
    vision = 34,
    contractvaliduntil = 35,
    finishing = 36,
    dribbling = 37,
    slidingtackle = 38,
    accessorycode3 = 39,
    accessorycolourcode1 = 40,
    headtypecode = 41,
    driref = 42,
    sprintspeed = 43,
    height = 44,
    hasseasonaljersey = 45,
    tattoohead = 46,
    preferredposition2 = 47,
    strength = 48,
    shoetypecode = 49,
    birthdate = 50,
    preferredposition1 = 51,
    tattooleftleg = 52,
    ballcontrol = 53,
    phypos = 54,
    shotpower = 55,
    trait1 = 56,
    socklengthcode = 57,
    weight = 58,
    hashighqualityhead = 59,
    gkglovetypecode = 60,
    tattoorightarm = 61,
    balance = 62,
    gender = 63,
    headassetid = 64,
    gkkicking = 65,
    defspe = 66,
    internationalrep = 67,
    shortpassing = 68,
    freekickaccuracy = 69,
    skillmoves = 70,
    faceposerpreset = 71,
    usercaneditname = 72,
    avatarpomid = 73,
    attackingworkrate = 74,
    finishingcode2 = 75,
    aggression = 76,
    acceleration = 77,
    paskic = 78,
    headingaccuracy = 79,
    iscustomized = 80,
    eyebrowcode = 81,
    runningcode2 = 82,
    modifier = 83,
    gkhandling = 84,
    eyecolorcode = 85,
    jerseysleevelengthcode = 86,
    accessorycolourcode3 = 87,
    accessorycode1 = 88,
    playerjointeamdate = 89,
    headclasscode = 90,
    defensiveworkrate = 91,
    tattoofront = 92,
    nationality = 93,
    preferredfoot = 94,
    sideburnscode = 95,
    weakfootabilitytypecode = 96,
    jumping = 97,
    personality = 98,
    gkkickstyle = 99,
    stamina = 100,
    playerid = 101,
    accessorycolourcode4 = 102,
    gkpositioning = 103,
    headvariation = 104,
    skillmoveslikelihood = 105,
    shohan = 106,
    skintonecode = 107,
    shortstyle = 108,
    overallrating = 109,
    smallsidedshoetypecode = 110,
    emotion = 111,
    runstylecode = 112,
    jerseyfit = 113,
    accessorycode2 = 114,
    shoedesigncode = 115,
    shoecolorcode1 = 116,
    hairstylecode = 117,
    bodytypecode = 118,
    animpenaltiesstartposcode = 119,
    pacdiv = 120,
    defensiveawareness = 121,
    runningcode1 = 122,
    preferredposition4 = 123,
    volleys = 124,
    accessorycolourcode2 = 125,
    tattoorightleg = 126,
    facialhaircolorcode = 127
}