<?php fuel_set_var('layout', '')?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">
<head>
 	<title>FUEL CMS</title>
	<meta charset="UTF-8" />
	<meta name="ROBOTS" content="ALL" />
	<meta name="MSSmartTagsPreventParsing" content="true" />

	<meta name="keywords" content="<?=fuel_var('meta_keywords')?>" />
	<meta name="description" content="<?=fuel_var('meta_description')?>" />

	<base href="<?=site_url()?>" />
	<style type="text/css" media="screen">
		/***************************************************************
		RESET BROWSER VALUES SO EVERYONE IS THE SAME
		***************************************************************/
		* { outline-style: none; -moz-outline-style: none; -webkit-text-size-adjust: none; }
		h1,h2,h3,h4,h5,h6,pre,code { font-size:1em; }
		ul,ol,li,dl,dt,dd,h1,h2,h3,h4,h5,h6,pre,form,body,html,p,blockquote,fieldset { margin:0; padding:0; }
		input { margin: 0; }
		a img,:link img,:visited img { border: none; }
		ol,ul{list-style:none;}
		th{text-align:left;}
		h1,h2,h3,h4{font-size:100%;}
		q:before,q:after{content:'';}
		pre,code{font:115% monospace; font-size:100%;}
		th{text-align:left;}
		cite,code,th,address{font-style:normal;font-weight:normal;}
		body { font-size:62.5%; }


		/***************************************************************
		TAG STYLES
		***************************************************************/
		body { background: #000 url(http://www.fuelcms.org/assets/images/bg_waves.jpg) no-repeat top center; font-family: 'Lucida Grande', Arial, sans-serif; color: #fff; font-size: 12px; }
		h1 { font-size: 30px; margin-top: 50px; text-shadow: #000 0px 1px 3px; padding-left: 160px; line-height: 20px; }
		h2 { font-size: 16px; color: #fff; color: #c8d1d9; margin-bottom: 15px; text-shadow: #000 0px 1px 3px; padding-left: 164px; line-height: 28px; }
		h3 { font-size: 16px; color: #ea5b17; margin-bottom: 5px; font-weight: normal; }
		h4 { font-size: 12px; margin-bottom: 5px; }
		a { color: #dc461c; }
		p { margin-bottom: 20px; }
		ul { margin: 0 0 20px 0; }
		ol { list-style: decimal; margin: 0 0 20px 20px; }
		li { margin-bottom: 3px; }

		/***************************************************************
		GENERIC CLASSES
		***************************************************************/
		.clear { clear: both; height: 0; line-height: 0; font-size: 0; }
		.success { background-color: #6ec461; background-repeat: no-repeat; padding: 2px; }
		.warning { background-color: #ff1; background-repeat: no-repeat; padding: 2px; }
		.error { background-color: #c30; background-repeat: no-repeat; padding: 2px; }
		.important { font-size: 16px; font-weight: bold; }
		/***************************************************************
		MAIN AREAS
		***************************************************************/
		div#container {
			-webkit-box-shadow: 1px 1px 10px rgba(0, 0, 0, 0.8);
			-moz-box-shadow: 1px 1px 10px rgba(0, 0, 0, 0.8);
			width: 600px; margin: 70px auto; border: 1px solid #1e466a; padding: 20px; -moz-border-radius: 10px; -webkit-border-radius: 10px;
			background: -webkit-gradient(linear, left top, left bottom, from(rgba(42, 96, 147, 0.35)), to(#000));
			filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#1e466a', endColorstr='#000'); /* for IE */
		 }
		div#logo {  background: transparent url(http://www.fuelcms.org/assets/images/fuel_logo_sm.png) no-repeat; width: 150px; height: 150px; float: left; }
		div#content { padding: 10px 20px; }
	</style>
</head>
<body>

	<div id="container">
		<div id="logo"></div>
		<h1>欢迎使用 FUEL CMS</h1>
		<h2>基于 CodeIgniter 的模块化开发框架</h2>

		<div class="clear"></div>
		<div id="content">
			<h3>开始</h3>
			<p>FUEL CMS 基于 CodeIgniter 2.0 架构，如果你熟悉 CodeIgniter 的安装，以下很多步骤你应该非常熟悉：</p>

			<ol>
				<li>将 Apache 服务器的 .htaccess 文件的 RewriteBase 属性修改为正确的目录，它默认为 Web 服务器的根目录。
				如果你不能开启 Apache 服务器的 mod_rewrite 模块，你需要将配置文件 <strong>fuel/application/config/config.php</strong> 中 $config['index_page'] 的值由空修改为 'index.php'。</li>
				<li>在 MySQL 数据库中创建一个数据库，然后执行 <strong>fuel/install/fuel_schema.sql</strong> 文件或 <strong>fuel/install/widgicorp.sql</strong> 文件，后者将创建演示数据。
					如果你已经安装了前一个版本的 FUEL CMS，你可以执行 <strong>fuel/install/fuel_0.9.2_upgrade.sql</strong> 文件。
					数据库安装完成后，修改配置文件 <strong>fuel/application/config/database.php</strong> 中的设置。
				</li>
				<li>将以下目录设置为可写：
					<ul>
						<li class="<?=(is_really_writable(APPPATH.'cache/')) ? 'success' : 'error'; ?>">
							<?=APPPATH.'cache/'?>
						</li>
						<li class="<?=(is_really_writable(APPPATH.'cache/dwoo/')) ? 'success' : 'error'; ?>">
							<?=APPPATH.'cache/dwoo/'?>
						</li>
						<li class="<?=(is_really_writable(APPPATH.'cache/dwoo/compiled')) ? 'success' : 'error'; ?>">
							<?=APPPATH.'cache/dwoo/compiled'?>
						</li>
						<li class="<?=(is_really_writable(assets_server_path('', 'images'))) ? 'success' : 'error'; ?>">
							<?=WEB_ROOT.'assets/images'?>
						</li>
					</ul>
				</li>
				<?php if (!$this->config->item('admin_enabled', 'fuel')) : ?>
				<li>如果你想使用 FUEL 的后台管理功能，修改配置文件 fuel/application/config/MY_fuel.php 中 $config['admin_enabled'] 的值为 <strong>TRUE</strong>。</li>
				<?php endif; ?>
				<?php if ($this->config->item('fuel_mode', 'fuel') == 'views') : ?>
				<li>如果你想在 FUEL 中编辑页面，修改配置未见 fuel/application/config/MY_fuel.php 中 $config['fuel_mode'] 的值为 <strong>AUTO</strong>。<strong>在演示站点中必须这样设置。</strong></li>
				<?php endif; ?>
				<li>警告：请确保 <strong>fuel/data_backup</strong> 目录和 <strong>fuel/crons</strong> 目录不能够从浏览器访问。FUEL 根目录中的 .htaccess 文件默认已经阻止了 fuel/data_backup 目录和 fuel/cron 目录被访问。</li>
				<li>登陆后台管理页面： <br />
				<a href="<?=site_url('fuel')?>"><?=site_url('fuel')?></a><br />
				用户名: <strong>admin</strong> <br />
				密码: <strong>admin</strong> <br />
				</li>

			</ol>

			<p class="important">安装完成！</p>

			<h3>更多信息？</h3>
			<ul>
				<li><a href="http://www.fuelcms.org/blog" target="_blank">关注我们的博客</a></li>
				<li><a href="http://www.fuelcms.org/user_guide/general/quickstart">查看入门指南</a></li>
				<li><a href="http://www.fuelcms.org/user_guide">查看用户手册</a></li>
			</ul>
		</div>
	</div>

</body>
</html>