-- phpMyAdmin SQL Dump
-- version 3.1.3.1
-- http://www.phpmyadmin.net
--
-- 主机: localhost
-- 生成日期: 2012 年 06 月 17 日 14:45
-- 服务器版本: 5.1.33
-- PHP 版本: 5.2.9-2

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- 数据库: `fuelcms_cn`
--

-- --------------------------------------------------------

--
-- 表的结构 `articles`
--

DROP TABLE IF EXISTS `articles`;
CREATE TABLE IF NOT EXISTS `articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;


-- --------------------------------------------------------

--
-- 表的结构 `authors`
--

DROP TABLE IF EXISTS `authors`;
CREATE TABLE IF NOT EXISTS `authors` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bio` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `avatar` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;


-- --------------------------------------------------------

--
-- 表的结构 `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;


-- --------------------------------------------------------

--
-- 表的结构 `categories_to_articles`
--

DROP TABLE IF EXISTS `categories_to_articles`;
CREATE TABLE IF NOT EXISTS `categories_to_articles` (
  `category_id` smallint(5) unsigned NOT NULL,
  `article_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_archives`
--

DROP TABLE IF EXISTS `fuel_archives`;
CREATE TABLE IF NOT EXISTS `fuel_archives` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_id` int(10) unsigned NOT NULL,
  `table_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `version_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `archived_user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_blocks`
--

DROP TABLE IF EXISTS `fuel_blocks`;
CREATE TABLE IF NOT EXISTS `fuel_blocks` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `view` text COLLATE utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `date_added` datetime DEFAULT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_categories`
--

DROP TABLE IF EXISTS `fuel_blog_categories`;
CREATE TABLE IF NOT EXISTS `fuel_blog_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `permalink` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT 'URL最后一段',
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `permalink` (`permalink`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- 导出表中的数据 `fuel_blog_categories`
--

INSERT INTO `fuel_blog_categories` (`id`, `name`, `permalink`, `published`) VALUES
(1, '未分类', 'uncategorized', 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_comments`
--

DROP TABLE IF EXISTS `fuel_blog_comments`;
CREATE TABLE IF NOT EXISTS `fuel_blog_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL,
  `author_id` int(10) unsigned NOT NULL,
  `author_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `author_email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `author_website` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `author_ip` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `is_spam` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `date_added` datetime NOT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_links`
--

DROP TABLE IF EXISTS `fuel_blog_links`;
CREATE TABLE IF NOT EXISTS `fuel_blog_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `target` enum('blank','self','parent') DEFAULT 'blank',
  `description` varchar(100) DEFAULT NULL,
  `precedence` int(11) NOT NULL DEFAULT '0',
  `published` enum('yes','no') DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_posts`
--

DROP TABLE IF EXISTS `fuel_blog_posts`;
CREATE TABLE IF NOT EXISTS `fuel_blog_posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `permalink` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '链接的最后一段，留空则系统自动生成',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `content_filtered` text COLLATE utf8_unicode_ci NOT NULL,
  `formatting` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `excerpt` text CHARACTER SET utf8 NOT NULL COMMENT '从内容中摘录的一小段文字',
  `author_id` int(10) unsigned DEFAULT NULL COMMENT '如果为空，作者为当前登录用户',
  `sticky` enum('yes','no') CHARACTER SET utf8 NOT NULL DEFAULT 'no' COMMENT '使帖子忽略发布日期，保持在列表顶部',
  `allow_comments` enum('yes','no') CHARACTER SET utf8 DEFAULT 'no' COMMENT '是否允许评论',
  `date_added` datetime DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permalink` (`permalink`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_posts_to_categories`
--

DROP TABLE IF EXISTS `fuel_blog_posts_to_categories`;
CREATE TABLE IF NOT EXISTS `fuel_blog_posts_to_categories` (
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`post_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_settings`
--

DROP TABLE IF EXISTS `fuel_blog_settings`;
CREATE TABLE IF NOT EXISTS `fuel_blog_settings` (
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- 导出表中的数据 `fuel_blog_settings`
--

INSERT INTO `fuel_blog_settings` (`name`, `value`) VALUES
('title', 'My Blog'),
('uri', 'blog/'),
('theme_layout', 'blog'),
('theme_path', 'themes/default/'),
('theme_module', 'blog'),
('use_cache', '0'),
('cache_ttl', '3600'),
('per_page', '2'),
('description', ''),
('use_captchas', '1'),
('monitor_comments', '1'),
('save_spam', '1'),
('allow_comments', '1'),
('akismet_api_key', ''),
('comments_time_limit', ''),
('multiple_comment_submission_time_limit', '30'),
('asset_upload_path', 'images/blog/');

-- --------------------------------------------------------

--
-- 表的结构 `fuel_blog_users`
--

DROP TABLE IF EXISTS `fuel_blog_users`;
CREATE TABLE IF NOT EXISTS `fuel_blog_users` (
  `fuel_user_id` int(10) unsigned NOT NULL,
  `display_name` varchar(50) NOT NULL,
  `website` varchar(100) NOT NULL,
  `about` text NOT NULL,
  `avatar_image` varchar(255) NOT NULL,
  `twitter` varchar(255) NOT NULL,
  `facebook` varchar(255) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `active` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`fuel_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



-- --------------------------------------------------------

--
-- 表的结构 `fuel_logs`
--

DROP TABLE IF EXISTS `fuel_logs`;
CREATE TABLE IF NOT EXISTS `fuel_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_date` datetime NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;




-- --------------------------------------------------------

--
-- 表的结构 `fuel_navigation`
--

DROP TABLE IF EXISTS `fuel_navigation`;
CREATE TABLE IF NOT EXISTS `fuel_navigation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(5) unsigned NOT NULL DEFAULT '1',
  `location` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '你希望链接到的URL除域名以外的部分(例如：company/about)',
  `nav_key` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '如果留空，系统会自动生成',
  `label` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '显示在菜单中的名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用于创建菜单层级，留空表示顶级菜单',
  `precedence` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数值越大，显示越靠前',
  `attributes` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '导航栏的额外属性(例如：target="_blank")',
  `selected` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通常只需要留空',
  `hidden` enum('yes','no') CHARACTER SET utf8 NOT NULL DEFAULT 'no' COMMENT '菜单是否显示',
  `published` enum('yes','no') CHARACTER SET utf8 NOT NULL DEFAULT 'yes' COMMENT '菜单是否发布',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id` (`group_id`,`location`,`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_navigation_groups`
--

DROP TABLE IF EXISTS `fuel_navigation_groups`;
CREATE TABLE IF NOT EXISTS `fuel_navigation_groups` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- 导出表中的数据 `fuel_navigation_groups`
--

INSERT INTO `fuel_navigation_groups` (`id`, `name`, `published`) VALUES
(1, '默认分组', 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `fuel_pages`
--

DROP TABLE IF EXISTS `fuel_pages`;
CREATE TABLE IF NOT EXISTS `fuel_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `location` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '根路径后面的部分，例如：“首页”只需要输入“home”',
  `layout` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '和页面关联的模板名称',
  `published` enum('yes','no') CHARACTER SET utf8 NOT NULL DEFAULT 'yes' COMMENT '“是”则显示页面，“否”则返回404错误',
  `cache` enum('yes','no') CHARACTER SET utf8 NOT NULL DEFAULT 'yes' COMMENT '缓存控制页面是从数据库中取出还是更高效的保存在文件中。如果页面包含动态内容，最好把缓存设置为''''''''否''''''''',
  `date_added` datetime DEFAULT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_modified_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `location` (`location`),
  KEY `layout` (`layout`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;


-- --------------------------------------------------------

--
-- 表的结构 `fuel_page_variables`
--

DROP TABLE IF EXISTS `fuel_page_variables`;
CREATE TABLE IF NOT EXISTS `fuel_page_variables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `scope` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `type` enum('string','int','boolean','array','template') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'string',
  `active` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id` (`page_id`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=180 ;



-- --------------------------------------------------------

--
-- 表的结构 `fuel_permissions`
--

DROP TABLE IF EXISTS `fuel_permissions`;
CREATE TABLE IF NOT EXISTS `fuel_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '以“管理”命名的权限将出现在左侧菜单',
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=32 ;

--
-- 导出表中的数据 `fuel_permissions`
--

INSERT INTO `fuel_permissions` (`id`, `name`, `description`, `active`) VALUES
(1, 'pages', '页面管理', 'yes'),
(2, 'pages_publish', '发布页面', 'yes'),
(3, 'pages_delete', '删除页面', 'yes'),
(4, 'navigation', '导航栏管理', 'yes'),
(5, 'users', '用户管理', 'yes'),
(6, 'tools/backup', '数据库备份管理', 'yes'),
(7, 'manage/cache', '页面缓存管理', 'yes'),
(8, 'manage/activity', '查看操作日志', 'yes'),
(10, 'google_analytics', '谷歌分析', 'yes'),
(11, 'tools/user_guide', '访问用户手册', 'yes'),
(12, 'manage', '查看管理面板', 'yes'),
(13, 'permissions', '权限管理', 'yes'),
(14, 'tools', '工具管理', 'yes'),
(15, 'tools/seo/google_keywords', '谷歌关键字管理', 'yes'),
(16, 'sitevariables', '变量管理', 'yes'),
(17, 'blog/posts', '博客/帖子管理', 'yes'),
(18, 'blog/categories', '博客/分类管理', 'yes'),
(19, 'blog/comments', '博客/评论管理', 'yes'),
(20, 'blog/links', '博客/链接管理', 'yes'),
(21, 'blog/users', '博客/作者管理', 'yes'),
(22, 'blog/settings', '博客/设置', 'yes'),
(23, 'assets', '资源管理', 'yes'),
(24, 'tools/validate', '页面验证', 'yes'),
(25, 'tools/seo', '页面分析管理', 'yes'),
(26, 'tools/tester', '测试模块', 'yes'),
(27, 'blocks', '代码块管理', 'yes'),
(28, 'site_docs', '查看网站文档', 'yes'),
(29, 'tools/cronjobs', '计划任务管理', 'yes'),
(30, 'quotes', '引用', 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `fuel_site_variables`
--

DROP TABLE IF EXISTS `fuel_site_variables`;
CREATE TABLE IF NOT EXISTS `fuel_site_variables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `scope` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '不填表示变量全站可用',
  `active` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- 导出表中的数据 `fuel_site_variables`
--


-- --------------------------------------------------------

--
-- 表的结构 `fuel_users`
--

DROP TABLE IF EXISTS `fuel_users`;
CREATE TABLE IF NOT EXISTS `fuel_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `first_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `last_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'english',
  `reset_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `super_admin` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `active` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- 导出表中的数据 `fuel_users`
--

INSERT INTO `fuel_users` (`id`, `user_name`, `password`, `email`, `first_name`, `last_name`, `language`, `reset_key`, `super_admin`, `active`) VALUES
(1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '', 'Admin', '', 'chinese', 'IGdcUYXy', 'yes', 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `fuel_user_to_permissions`
--

DROP TABLE IF EXISTS `fuel_user_to_permissions`;
CREATE TABLE IF NOT EXISTS `fuel_user_to_permissions` (
  `user_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- --------------------------------------------------------

--
-- 表的结构 `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE IF NOT EXISTS `projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '工程名称',
  `slug` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '如果留空，系统自动生成',
  `client` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `website` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `launch_date` date DEFAULT NULL,
  `image` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `featured` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  `precedence` int(11) NOT NULL DEFAULT '999' COMMENT '数值越大，位置越靠前',
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- 表的结构 `quotes`
--

DROP TABLE IF EXISTS `quotes`;
CREATE TABLE IF NOT EXISTS `quotes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `precedence` int(11) NOT NULL DEFAULT '0',
  `published` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;
