<h1>配置</h1>
<p>以下是你可以设置 FUEL 的主要配置选项，它们位于 <dfn>application/config/MY_fuel.php</dfn> 文件中（译者注：它们也可以在模块的配置文件如 fuel.php 中配置，以起到根据不同的模块个性化配置的作用）：</p>

<table border="0" cellspacing="1" cellpadding="0" class="tableborder">
	<tbody>
		<tr>
			<th>名称</th>
			<th>默认值</th>
			<th>选项</th>
			<th>描述</th>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>基本设置</h4></td>
		</tr>
		<tr>
			<td><strong>site_name</strong></td>
			<td>MyWebsite</td>
			<td>无</td>
			<td>显示在后台管理界面上方，<strong>它同时被用来生成 session key</strong>。</td>
		</tr>
		<tr>
			<td><strong>fuel_path</strong></td>
			<td>fuel/</td>
			<td>无</td>
			<td>后台管理页面的根路径。</td>
		</tr>
		<tr>
			<td><strong>fuel_mode</strong></td>
			<td>views</td>
			<td>cms, views, auto</td>
			<td><dfn>cms</dfn> 模式从数据库中取得视图和变量；
				<dfn>views</dfn> 模式从 views 目录中取得视图，从 _variables 目录中取得变量；
				<dfn>auto</dfn> 模式首先尝试从数据库中取得视图，如果不存在或者没有发布，则检查相应的视图文件。
			</td>
		</tr>
		<tr>
			<td><strong>login_redirect</strong></td>
			<td>fuel/dashboard</td>
			<td>无</td>
			<td>登陆后跳转到的页面。</td>
		</tr>
		<tr>
			<td><strong>logout_redirect</strong></td>
			<td>:last</td>
			<td>无</td>
			<td>退出后跳转到的页面。使用特殊值 <strong>:last</strong> 来跳转到最后停留的页面。</td>
		</tr>
		<tr>
			<td><strong>domain</strong></td>
			<td>$_SERVER['SERVER_NAME']</td>
			<td>无</td>
			<td>域名，用于系统邮件的发送。</td>
		</tr>
		<tr>
			<td><strong>from_email</strong></td>
			<td>'admin@'.$config['domain']</td>
			<td>无</td>
			<td>发送方邮件地址，用于系统邮件的发送。</td>
		</tr>
		<tr>
			<td><strong>allow_forgotten_password</strong></td>
			<td>TRUE</td>
			<td>布尔值 TRUE/FALSE</td>
			<td>允许使用忘记密码功能。</td>
		</tr>
		<tr>
			<td><strong>max_number_archived</strong></td>
			<td>5</td>
			<td>无</td>
			<td>可归档的模块项目的最大值。</td>
		</tr>
		<tr>
			<td><strong>warn_if_modified</strong></td>
			<td>TRUE</td>
			<td>布尔值 TRUE/FALSE</td>
			<td>如果表单数据被修改过，不保存离开页面是否发出警告。</td>
		</tr>
		<tr>
			<td><strong>max_recent_pages</strong></td>
			<td>5</td>
			<td>无</td>
			<td>显示最近访问页面的最大值。</td>
		</tr>
		<tr>
			<td><strong>saved_page_state_max</strong></td>
			<td>5</td>
			<td>无</td>
			<td>保存页面状态的最大值。它被用于保存列表页中的排序和过滤结果，这些信息被保存在当次会话的 session 中。</td>
		</tr>
		<tr>
			<td><strong>fuel_cookie_path</strong></td>
			<td>/</td>
			<td>无</td>
			<td>提供一个 cookie 路径，如果你需要的话可以跟 CI 配置文件中的值不同（默认为 CI 配置文件中的值）。</td>
		</tr>
		<tr>
			<td><strong>xtra_css</strong></td>
			<td>无</td>
			<td>无</td>
			<td>提供第三方应用集成和客户化可能需要的额外的 css 文件，他们必须保存在 assets/css 目录，而不是 fuel/assets/css 目录。</td>
		</tr>
		<tr>
			<td><strong>keyboard_shortcuts</strong></td>
			<td>
<pre>
array(
	'toggle_view' => 'Ctrl+Shift+m',
	'save' => 'Ctrl+Shift+s',
	'view' => 'Ctrl+Shift+p'
);
</pre>
			</td>
			<td>无</td>
			<td>管理界面快捷键。</td>
		</tr>
		<tr>
			<td><strong>dashboards</strong></td>
			<td>
<pre>
array('fuel', 'backup');
</pre>
			</td>
			<td>无</td>
			<td>仪表盘页面所包含的模块。</td>
		</tr>
		<tr>
			<td><strong>dashboard_rss</strong></td>
			<td>http://www.thedaylightstudio.com/the-whiteboard/categories/fuel-cms/feed/rss</td>
			<td>无</td>
			<td>仪表盘页面获取新闻条目的 RSS 路径。</td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>资源设置</h4></td>
		</tr>
		<tr>
			<td><strong>fuel_assets_path</strong></td>
			<td>fuel/modules/{module}/assets/</td>
			<td>无</td>
			<td>相对于网站根目录的资源路径。</td>
		</tr>
		<tr>
			<td><strong>assets_excluded_dirs</strong></td>
			<td>
<pre>
array('js', 'css', 'cache', 'swf', 'captchas')
</pre>
			</td>
			<td>无</td>
			<td>允许被访问的资源目录。</td>
		</tr>
		<tr>
			<td><strong>assets_allow_subfolder_creation</strong></td>
			<td>TRUE</td>
			<td>布尔值 TRUE/FALSE</td>
			<td>如果资源目录中的子目录不存在，是否允许创建。</td>
		</tr>
		<tr>
			<td><strong>editable_asset_filetypes</strong></td>
			<td>
<pre>
array(
	'images' => 'jpg|jpeg|jpe|gif|png',
	'pdf' => 'pdf',
	'media' => 'jpg|jpeg|jpe|png|gif|mov|mp3|aiff'
);
</pre>
			</td>
			<td>无</td>
			<td>指定资源目录可以包含的文件类型的扩展名。</td>
		</tr>
		<tr>
			<td><strong>assets_upload_max_size</strong></td>
			<td>1000</td>
			<td>无</td>
			<td>资源目录可上传的最大文件。</td>
		</tr>
		<tr>
			<td><strong>assets_upload_max_width</strong></td>
			<td>1024</td>
			<td>无</td>
			<td>图片资源可上传的最大宽度。</td>
		</tr>
		<tr>
			<td><strong>assets_upload_max_height</strong></td>
			<td>768</td>
			<td>无</td>
			<td>图片资源可上传的最大高度。</td>
		</tr>
		<tr>
			<td><strong>fuel_javascript</strong></td>
			<td>
<pre>
array(
	'jquery/plugins/date',
	'jquery/plugins/jquery.datePicker',
	'jquery/plugins/jquery.fillin',
	'jquery/plugins/jquery.markitup.pack',
	'jquery/plugins/jquery.markitup.set',
	'jquery/plugins/jquery.easing',
	'jquery/plugins/jquery.bgiframe',
	'jquery/plugins/jquery.tooltip',
	'jquery/plugins/jquery.scrollTo-min',
	'jquery/plugins/jqModal',
	'jquery/plugins/jquery.checksave',
	'jquery/plugins/jquery.form',
	'jquery/plugins/jquery.treeview.min',
	'jquery/plugins/jquery.hotkeys',
	'jquery/plugins/jquery.cookie',
	'jquery/plugins/jquery.fillin',
	'jquery/plugins/jquery.selso',
	'jquery/plugins/jquery-ui-1.8.4.custom.min',
	'jquery/plugins/jquery.disable.text.select.pack',
	'jquery/plugins/jquery.supercomboselect',
	'jquery/plugins/jquery.MultiFile.pack'
);
</pre>
			</td>
			<td>无</td>
			<td>除了前端被包含的 js 文件外还包含的 Javascript 文件(主要是 jquery 插件，用于控制管理页面显示效果)。</td>
		</tr>
		<tr>
			<td><strong>fuel_css</strong></td>
			<td>无</td>
			<td>无</td>
			<td>除了 fuel.css 文件以外其他被自动加载的 CSS 文件。 </td>
		</tr>
		<tr>
			<td><strong>fuel_assets_output</strong></td>
			<td>无</td>
			<td>TRUE, FALSE, inline, gzip, whitespace, 或 combine</td>
			<td>是否开启资源优化。需要所有模块的资源目录下有一个可写的 assets/cache 目录。</td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>安全设置</h4></td>
		</tr>
		<tr>
			<td><strong>default_pwd</strong></td>
			<td>admin</td>
			<td>无</td>
			<td>管理界面的默认密码（登陆后会提示用户修改）。</td>
		</tr>
		<tr>
			<td><strong>admin_enabled</strong></td>
			<td>FALSE</td>
			<td>布尔值 TRUE/FALSE</td>
			<td>是否开启 FUEL 的后台管理功能（默认用户名为admin）？</td>
		</tr>
		<tr>
			<td><strong>num_logins_before_lock</strong></td>
			<td>3</td>
			<td>无</td>
			<td>允许尝试密码的次数，超过这个次数会锁定登陆。</td>
		</tr>
		<tr>
			<td><strong>seconds_to_unlock</strong></td>
			<td>60</td>
			<td>无</td>
			<td>当用户尝试密码次数超过设定值后，锁定登陆的时间。</td>
		</tr>
		<tr>
			<td><strong>dev_password</strong></td>
			<td>无</td>
			<td>无</td>
			<td>如果你设置一个开发密码，需要输入密码才可以访问网站。</td>
		</tr>
		<tr>
			<td><strong>auto_search_views</strong></td>
			<td>FALSE</td>
			<td>布尔值 TRUE/FALSE</td>
			<td>当设置为TRUE时。如果用户输入的 URI 是 about/history，而 about/history 不存在，但 about 存在，请求将被转发到 about 页面。</td>
		</tr>
		<tr>
			<td><strong>module_sanitize_funcs</strong></td>
			<td>TRUE</td>
			<td>布尔值 TRUE/FALSE；字符串 "xss", "php", "template" 或 "entities"；或者包含多个值的数组 array('xss', 'php', 'template', 'entities')</td>
			<td>模块中的函数可以被用于无害输入的值，数组的键在模块的配置中确定。</td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>模块设置</h4></td>
		</tr>
		<tr>
			<td><strong>modules_allowed</strong></td>
			<td>
<pre>
array('blog', 'tools')
</pre>
			</td>
			<td>无</td>
			<td>指定管理界面中允许使用的模块。</td>
		</tr>
		<tr>
			<td><strong>nav</strong></td>
			<td>
<pre>

// site... Dashboard will always be there
$config['nav']['site'] = array(
	'dashboard' => lang('module_dashboard'),
	'pages' => lang('module_pages'),
	'blocks' => lang('module_blocks'),
	'navigation' => lang('module_navigation'),
	'assets' => lang('module_assets'),
	'sitevariables' => lang('module_sitevariables')
	);

// if set to auto, then it will automatically include all in MY_fuel_modules.php
$config['nav']['shop'] = array();

// blog placeholder if it exists
$config['nav']['blog'] = array();

// if set to auto, then it will automatically include all in MY_fuel_modules.php
$config['nav']['modules'] = 'AUTO';

// tools
$config['nav']['tools'] = array();

// manage
$config['nav']['manage'] = array(
	'users' => lang('nav_users'),
	'permissions' => lang('nav_permissions'),
	'manage/cache' => lang('nav_manage/cache'),
	'manage/activity' => lang('nav_manage/activity')
	);
</pre>
			</td>
			<td>无</td>
			<td>左侧导航菜单。子建包括 <dfn>site</dfn>、<dfn>shop</dfn>、<dfn>blog</dfn>、<dfn>modules</dfn>、<dfn>tools</dfn> 和 <dfn>manage</dfn></td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>路由设置</h4></td>
		</tr>
		<tr>
			<td><strong>default_home_view</strong></td>
			<td>home</td>
			<td>无</td>
			<td>默认首页视图。</td>
		</tr>
		<tr>
			<td><strong>use_page_cache</strong></td>
			<td>'cms'</td>
			<td>TRUE, FALSE 'cms', 'views'</td>
			<td>是否开启缓存。</td>
		</tr>
		<tr>
			<td><strong>page_cache_ttl</strong></td>
			<td>0</td>
			<td>无</td>
			<td>页面缓存保存时间。设置为0表示永久保存，直到页面或其他模块被更新。</td>
		</tr>
		<tr>
			<td><strong>page_cache_group</strong></td>
			<td>pages</td>
			<td>无</td>
			<td>缓存所在的组的名称(你可以删除一个组，从而删除组中所有的缓存)。</td>
		</tr>
		<tr>
			<td><strong>max_page_params</strong></td>
			<td>0</td>
			<td>无</td>
			<td>可以传递到页面的最大参数个数，用于控制数据库查询条件。设置为0表示不限制。</td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>数据库表设置</h4></td>
		</tr>
		<tr>
			<td><strong>tables</strong></td>
			<td>
<pre>
array(
	'archives' => 'fuel_archives',
	'logs' => 'fuel_logs',
	'navigation' => 'fuel_navigation',
	'navigation_groups' => 'fuel_navigation_groups',
	'pagevars' => 'fuel_page_variables',
	'pages' => 'fuel_pages',
	'blocks' => 'fuel_blocks',
	'permissions' => 'fuel_permissions',
	'user_to_permissions' => 'fuel_user_to_permissions',
	'users' => 'fuel_users'
);
</pre>
			</td>
			<td>无</td>
			<td>指定名称对应的数据库表。</td>
		</tr>
		<tr>
			<td colspan="4" class="hdr"><h4>页面设置</h4></td>
		</tr>
		<tr>
			<td><strong>auto_page_navigation_group_id</strong></td>
			<td>1</td>
			<td>无</td>
			<td>指定自动创建的导航条目所在的分组。</td>
		</tr>
		<tr>
			<td><strong>page_uri_prefix</strong></td>
			<td>无</td>
			<td>无</td>
			<td>自动获取地址中这个标记之后的路径。</td>
		</tr>
	</tbody>
</table>