<h1>站点创建指南</h1>
<p>下面是创建一个简单站点的快速指南。它包含在 FUEL 中创建页面、目录结构、布局和可复用代码块的几种不同方式，我们的示例站点将包含以下页面：</p>
<ul>
	<li><a href="#static"><strong>about</strong>: 静态页面</a></li>
	<li><a href="#editable"><strong>about/team</strong>: 可编辑页面</a></li>
	<li><a href="#controller"><strong>about/contact</strong>: 控制器页面</a></li>
	<li><a href="#news"><strong>news</strong>: 模块页面</a></li>
</ul>

<p class="important">请确保 <dfn>application/config/MY_fuel.php</dfn> 文件中的 <kbd>fuel_mode</kbd> 属性设置为 <dfn>AUTO</dfn>（译者注：这样在载入页面时系统会检查文件，否则只检查数据库。）</p>


<a name="static"></a>
<h2>创建一个静态页面 - about</h2>

<h3>使用内置控制器的方法   </h3>
<p>在 FUEL 中有多种方法可以创建页面。最简单的方法是只创建一个视图文件，我们称之为 <a href="<?=user_guide_url('general/opt-in-controllers')?>">内置控制器</a> 法，它允许你创建不需要控制器的页面。例如：一个路径为 <strong>about/contact</strong> 的页面，只需要创建一个名为 <strong>views/about/contact.php</strong> 的视图文件即可。这种方法还有一些好处，例如它不需要路由就可以做到深路径结构和路径中的连接符。</p>

<p>在这个指南里，我们要为 <dfn>about</dfn> 页面创建一个静态的视图文件，因此我们创建了 <dfn>application/views/about.php</dfn> 文件，内容如下： </p>

<pre class="brush: php">
<h1>Hello World</h1>
<p>This is our about page</p>
</pre>

<p>注意，系统会自动为 <dfn>about</dfn> 页面添加页头和页尾。因为在 <dfn>application/views/_variables/global.php</dfn> 文件中指定使用的 <dfn>main</dfn> 布局文件中包含了加载页头和页尾的申明(更多关于传递变量到页面的方法下面会讲到)。布局文件保存在 <dfn>application/views/_layouts/</dfn> 目录 (更多关于布局的定义下面同样会讲到)。</p>

<p class="important"><kbd>home</kbd> 视图文件被保留作为网站的首页（译者注：当然，你可以在配置文件中修改使用哪个视图文件作为默认首页）。</p>

<h3>传递变量到一个页面</h3>
<p>FUEL 提供几种方法在不需要创建控制器的情况下传递变量到视图文件。默认地，定义在 <dfn>application/views/_variables/global.php</dfn> 文件中的 <dfn>$vars</dfn> 数组变量会被传递到使用 <a href="<?=user_guide_url('general/opt-in-controllers')?>">内置控制器</a> 法创建的所有页面中。
 在这个指南里，我们要增加一个在每个页面都能访问的变量 <dfn>$bigpic</dfn>。我们希望这个变量表示页面顶部的图片，并应用到网站的所有页面。我们把这个变量添加到 <dfn>application/views/_variables/global.php</dfn> 文件如下：</p>

<pre class="brush: php">

// declared here so we don't have to in controller variable files'
$CI =& get_instance();

// generic global page variables used for all pages
$vars = array();
$vars['layout'] = 'main';
$vars['page_title'] = '';
$vars['meta_keywords'] = '';
$vars['meta_description'] = '';
$vars['js'] = '';
$vars['css'] = '';
$vars['body_class'] = $CI-&gt;uri->segment(1).' '.$CI-&gt;uri-&gt;segment(2);

// big pic image at top of the site
$vars['bigpic'] = 'my_bigpic.jpg';

// page specific variables
$pages = array();

</pre>

<p>然后我们创建变量文件 <dfn>application/views/_variables/about.php</dfn>，添加一个值为 <dfn>about_bigpic.jpg</dfn> 的“控制器级(译者注：仅在一个控制器下有效)”变量 $bigpic，让它覆盖全局变量，只影响 about 分段下的页面：
</p>

<pre class="brush: php">
// big pic image at top of the site
$vars['bigpic'] = 'about_bigpic.jpg';
</pre>

<p>译者注：此时访问 about 或 about/contact 之类的页面，$bigpic 的值为 'about_bigpic.jpg'，而其他页面，如：home 或 blog 之类的页面，$bigpic 的值仍然为 'my_bigpic.jpg'。</p>

<a name="controller"></a>
<h2>使用控制器 - about/contact</h2>
<p>FUEL 仍然允许你使用 CodeIgniter 中标准的 MVC 方法创建页面。在这个指南里，我们要使用一个控制器 <dfn>about/contact</dfn>，它包含一个需要传递的表单。我们也可以在里面指定变量，就如同在 <dfn>application/views/_variables/</dfn> 文件中做的那样：</p>

<pre class="brush:php">
class About extends CI_Controller {

	function __construct()
	{
		parent::__construct();
	}

	function contact()
	{
		// set your variables
		$vars = array('page_title' => 'Contact : My Website');

		//... form code goes here

		// load the fuel_page library class and pass it the view file you want to load
		$this->load->module_library(FUEL_FOLDER, 'fuel_page', array('location' => 'about/contact'));
		$this->fuel_page->add_variables($vars);
		$this->fuel_page->render();

	}
</pre>


<a name="editable"></a>
<h2>创建一个可编辑页面 - about/team</h2>
<p>我们需要登录 FUEL 后台来创建 <dfn>about/team</dfn> 页面。访问
<dfn>http://mysite.com/fuel</dfn> (<strong>mysite.com</strong> 是你安装 FUEL 的域名)，输入管理员的用户名 <dfn>admin</dfn> 和密码 (如果你没有修改的话，默认是 <dfn>admin</dfn>)。 点击左侧的 <dfn>页面</dfn> 菜单栏，按照指示
<a href="<?=user_guide_url('modules/fuel/pages')?>">创建</a> 页面. 在<dfn>位置</dfn>中输入 <strong>about/team</strong>，在<dfn>内容</dfn>中输入以下内容，点击保存后查看页面：</p>

<pre class="brush: php">
<h1>Team</h1>
<p>This is our team page</p>
</pre>

<a name="news"></a>
<h2>模块页面 - news</h2>
<p>模块页面是一个静态页面和一个用于生成页面内容的模块的结合。这种页面在指南中将被大量应用，我们将要创建一个 news 页面用于显示所有的新闻条目，和一个 news detail 页面，用于显示这些新闻的内容。这个页面由以下几部分组成：
This requires the following:</p>
<ul>
	<li>数据库表</li>
	<li>模型文件</li>
	<li>修改 <dfn>application/config/MY_fuel_modules.php</dfn> 配置文件</li>
	<li>视图文件</li>
	<li>变量文件</li>
</ul>

<h3>数据库表</h3>
<p>执行下面的 SQL 语句来创建新闻表。</p>
<pre class="brush: php">
CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `headline` varchar(255) collate utf8_unicode_ci NOT NULL,
  `slug` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `release_date` date NOT NULL,
  `content` text collate utf8_unicode_ci NOT NULL,
  `link` varchar(255) collate utf8_unicode_ci NOT NULL,
  `published` enum('yes','no') collate utf8_unicode_ci NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `permalink` (`slug`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;
</pre>

<h3>新闻模型</h3>
<p>以下是我们使用的新闻模型。我们有一个创建模型的指南， <a href="<?=user_guide_url('modules/tutorial')?>">点击这里</a>。</p>
<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once(FUEL_PATH.'models/base_module_model.php');

class News_model extends Base_module_model {

	public $required = array('headline');
	public $record_class = 'News_item';
	public $parsed_fields = array('content');

	function __construct()
	{
		parent::__construct('news'); // table name
	}

	function list_items($limit = NULL, $offset = NULL, $col = 'release_date', $order = 'desc')
	{
		$this-&gt;db-&gt;select('id, headline, slug, published');
		$data = parent::list_items($limit, $offset, $col, $order);
		return $data;
	}


	function on_before_clean($values)
	{
		if (empty($values['slug'])) $values['slug'] = url_title($values['headline'], 'dash', TRUE);
		if (!intval($values['release_date'])) $values['release_date'] = datetime_now();
		return $values;
	}

	function form_fields($values = array())
	{
		$fields = parent::form_fields();
		$fields['slug']['comment'] = 'If no slug is provided, one will be provided for you';
		$fields['release_date']['comment'] = 'A release date will automatically be created for you of the current date if left blank';
		return $fields;
	}

	function _common_query()
	{
		parent::_common_query(); // to do active and published
		$this-&gt;db-&gt;order_by('release_date desc');
	}
}

class News_item_model extends Base_module_record {

	protected $_date_format = 'F d, Y';

	function get_url()
	{
		if (!empty($this-&gt;link)) return $this-&gt;link;
		return site_url('news/'.$this-&gt;slug);
	}

	function get_excerpt_formatted($char_limit = NULL, $readmore = '')
	{
		$this-&gt;_CI-&gt;load-&gt;helper('typography');
		$this-&gt;_CI-&gt;load-&gt;helper('text');
		$excerpt = $this-&gt;content;

		if (!empty($char_limit))
		{
			// must strip tags to get accruate character count
			$excerpt = strip_tags($excerpt);
			$excerpt = character_limiter($excerpt, $char_limit);
		}
		$excerpt = auto_typography($excerpt);
		$excerpt = $this-&gt;_parse($excerpt);
		if (!empty($readmore))
		{
			$excerpt .= ' '.anchor($this-&gt;get_url(), $readmore, 'class="readmore"');
		}
		return $excerpt;
	}

}
?&gt;
</pre>

<h3>修改 MY_fuel_modules.php 配置文件</h3>
<p>添加以下模块到 <dfn>application/config/MY_fuel_modules.php</dfn> 文件中： </p>
<pre class="brush: php">
$config['modules']['news'] = array(
	'preview_path' => 'news/{slug}'
);
</pre>


<h3>视图文件</h3>
<p>你可以使用控制器来处理 URL 分段逻辑，但在这个指南里，我们只使用视图。
以下视图文件中使用了 <a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_model</a> 辅助方法和 <a href="<?=user_guide_url('libraries/my_model/data_record_class_functions')?>">custom record objects</a> 自定义记录对象。</p>
<pre class="brush: php">
&lt;?php
$slug = uri_segment(2);
if (!empty($slug))
{
	$news_item = fuel_model('news', array('find' => 'one', 'where' => array('slug' => $slug)));
	if (empty($news_item)) show_404();
}
else
{
	$news = fuel_model('news');
}
?&gt;

<h1>News</h1>

&lt;?php if (!empty($news_item)) : ?&gt;

&lt;?php fuel_set_var('page_title', $news_item->headline); ?&gt;

&lt;div class="news_item"&gt;
	&lt;h2&gt;&lt;?=$news_item-&gt;headline?&gt;&lt;/h2&gt;
	&lt;div class="date"&gt;&lt;?=$news_item-&gt;release_date_formatted?&gt;&lt;/div&gt;
	&lt;?=$news_item-&gt;content_formatted?&gt;
&lt;/div&gt;

&lt;?php else: ?&gt;


&lt;?php foreach($news as $item) : ?&gt;

&lt;div class="news_item"&gt;
	&lt;h2&gt;&lt;a href="&lt;?=$item-&gt;url?&gt;"&gt;&lt;?=$item-&gt;headline?&gt;&lt;/a&gt;&lt;/h2&gt;
	&lt;div class="date"&gt;&lt;?=$item-&gt;release_date_formatted?&gt;&lt;/div&gt;
	&lt;?=$item-&gt;get_excerpt_formatted(300, 'Read Full Story &raquo;')?&gt;

	&lt;hr /&gt;
&lt;/div&gt;

&lt;?php endforeach; ?&gt;

&lt;?php endif; ?&gt;

</pre>

<h3>新闻变量文件</h3>
<p>我们需要做的最后一件事是创建一个新闻变量文件，使用特殊变量 <dfn>view</dfn> 为 news 分段下的所有页面指定视图文件，这使我们可以在新闻的列表和内容视图中使用相同的视图文件。</p>

<pre class="brush: php">
&lt;?php
$vars['news'] = array('view' => 'news');
?&gt;
</pre>
