<h1>内置控制器</h1>

<p>你可曾感觉即使最简单的页面也要创建一个控制器方法来渲染的做法有点傻？
内置控制器可以帮助你不需要控制器就能创建页面，从而提高开发效率。
变量可以像 CodeIgniter 的路由（译者注：/contact/id/12表示把id=12传递到contact控制器）那样被传递到视图文件，或者在页面中设置变量，它会被依次传递到页面的所有子视图。你甚至可以在视图里加载类库、模型和辅助函数。
这种方法还能让网站的目录结构层次更深而无须为控制器设置路由。
</p>

<h2>它是怎么工作的？</h2>
<p>实现方法是修改 CodeIgniter 的路由，让所有请求不再映射到对应控制器的方法，而是映射到一个叫做 <dfn>page_router</dfn> 的控制器。这个控制器会以下两件事中的一件，这取决于 FUEL 的配置文件中 <dfn>fuel_mode</dfn> 的设置:
</p>

<ol>
	<li>渲染保存在数据库中的页面（一般在生成环境下才使用这个配置）</li>
	<li>通过请求 URI 找到对应的视图文件，然后把 <dfn>views/_variables</dfn> 文件夹中对应的变量文件中的变量映射到视图，最后渲染成一个页面。
</ol>

<h2>变量文件是什么？</h2>
<p>变量文件中是一个变量数组，它会被传递到页面。变量文件保存在 <dfn>views/_variables</dfn> 目录。</p>

<p>以下是三个级别的变量：</p>
<ul>
	<li><strong>global - 全局变量</strong> - 全局变量会加载到所有使用内置控制器的页面。</li>
	<li><strong>controller - 控制器变量</strong> - 控制器变量会加载到控制器下所有的页面（译者注：对比 CI 中一个控制器的所有方法来理解）。
	<dfn>http://www.mywebsite.com/about</dfn> 请求会加载控制器 <strong>about</strong> 的变量。控制器变量在设置站点的一个分段下所有模板的变量时非常有用（例如：about 和 about/contact可以一起设置变量）。
	</li>
	<li><strong>page - 页面变量</strong> - 顾名思义，页面变量只会加载到一个特定的页面。</li>
</ul>

<h2>全局变量</h2>
<p><strong>全局变量</strong>可以使用 <dfn>$vars</dfn> 数组在 <dfn>views/_variables/global.php</dfn> 文件中设置。通常你会在这个文件里设置页面的默认变量，以下变量已经默认被设置了：
</p>
<pre class="brush:php">
$vars['layout'] = 'main';
$vars['page_title'] = '';
$vars['meta_keywords'] = '';
$vars['meta_description'] = '';
$vars['js'] = '';
$vars['css'] = '';
$vars['body_class'] = $CI->uri->segment(1).' '.$CI->uri->segment(2);
</pre>

<h2>控制器变量</h2>
<p><strong>控制器变量</strong>通常被应用于网站的控制器级页面。例如：你的页面 http://www.mysite.com/about 有一个 <strong>about</strong> 分段，
你可以创建一个变量文件 <dfn>views/_variables/about.php</dfn>，这个文件里的变量会覆盖所有和全局变量文件中具有相同键的值，
这些变量会自动加载到 about 分段的所有子页面（例如：http://www.mysite.com/about/contact），控制器变量使用和全局变量相同的变量数组 <dfn>$vars</dfn> ：
</p>
<pre class="brush:php">
$vars['layout'] = 'level2';
$vars['page_title'] = 'About : My Website';
$vars['body_class'] = 'about';
</pre>

<h2>页面变量</h2>
<p><strong>页面变量</strong>被应用于特定的 URL 路径。他们会覆盖所有全局变量和控制器变量中与自己具有相同键的值。
举个例子，你想要覆盖 <dfn>page_title</dfn> 变量，把它从 <strong>About : My Website</strong> 变成 <strong>Contact : My Website.</strong>。
你需要在全局变量文件或者控制器变量文件（例如：<dfn>views/_variables/about.php</dfn>）中创建一个 <dfn>$pages</dfn> 变量数组，将数组的键设置为页面的 URI 或者<strong>正则表达式</strong>来匹配页面（和 CI 的路由文件一样），
数组的值是需要传递给页面的变量数组。
</p>
<pre class="brush:php">
// 控制器变量
$vars['layout'] = 'level2';
$vars['page_title'] = 'About : My Website';
$vars['body_class'] = 'about';

// 页面变量
$pages['about/contact'] = array('page_title' => 'Contact : My Website');
$pages['about/contact$|about/careers$'] = array('layout' => 'special');
</pre>

<h2>从视图内部添加变量</h2>
<p>另一种创建<dfn>页面变量</dfn>的方法是在视图文件中使用 <dfn>fuel_set_var</dfn> 辅助函数定义变量。
通过这种方式设置变量，请注意变量会同时被传递到包含该视图文件的布局文件中。
</p>

<pre class="brush:php">
&lt;?php fuel_set_var('page_title', 'About : My Website'); ?&gt;

&lt;h1&gt;About My Website&lt;/h1&gt;
&lt;p&gt;A long, long, time ago, in a galaxy far, far away...&lt;/p&gt;
</pre>

<h2>在控制器内部使用变量文件</h2>
<p>你可能需要在一个控制器内部使用变量（例如：你有一个位于 <strong>about/contact</strong>　的表单和一个位于 <strong>about</strong> 的控制器变量文件），你可以像这样加载它：
</p>
<pre class="brush:php">
class About extends CI_Controller {

	function About()
	{
		parent::__construct();
	}

	function contact()
	{
		// 设置变量
		$vars = array('page_title' => 'Contact : My Website');

		// 表单代码

		// 载入 fuel_page 类库，然后把视图文件传递给它
		$this->load->module_library(FUEL_FOLDER, 'fuel_page', array('location' => 'about/contact'));
		$this->fuel_page->add_variables($vars);
		$this->fuel_page->render();

	}
</pre>


<h2>特殊变量</h2>
<p>以下是可以在变量文件中使用的特殊变量：</p>
<ul>
	<li><strong>helpers</strong> - 需要加载的辅助函数字符串或数组。</li>
	<li><strong>libraries</strong> - 需要加载的类库字符串或数组。</li>
	<li><strong>models</strong> -  需要加载的模块字符串或数组。</li>
	<li><strong>layout</strong> - 指向布局文件的路径。布局文件中的 <dfn>$body</dfn> 变量加载视图文件的内容。</li>
	<li><strong>view</strong> - 页面使用的视图文件。页面默认使用这个视图文件，如果不存在，它会查找和它的 URI 路径匹配的视图文件。</li>
	<li><strong>parse_view</strong> - 确定视图文件是否可以被<a href="<?=user_guide_url('parsing')?>">解析</a>。</li>
	<li><strong>allow_empty_content</strong> - 确定是否允许视图文件的内容为空而不报404错误。</li>
	<li><strong>CI</strong> - CodeIgniter 的对象变量（译者注：相当于 CI 控制器中的 $this）。</li>

</ul>