<h1>安全</h1>
<p>FUEL CMS 有以下几种安全选项可供配置。除此之外，和其他 CI 应用程序一样，Cookie 的密钥具有相同的默认值，你应该到配置文件中修改成你自己的密钥。</p>

<h2>FUEL 安全设置</h2>
<p><a href="<?=user_guide_url('general/configuration')?>">FUEL 配置</a> 提供几种安全设置：</p>
<ul>
	<li><strong>restrict_to_remote_ip</strong> - 限制只让某些 IP 地址访问 FUEL （可以是一个包含多个 IP 的数组）。</li>
	<li><strong>default_pwd</strong> - 登陆 FUEL 的默认密码，登陆之后会提示修改。它的默认值是 <dfn>admin</dfn>。</li>
	<li><strong>admin_enabled</strong> - 是否允许使用管理后台。默认值是 <dfn>FALSE</dfn>。</li>
	<li><strong>num_logins_before_lock</strong> - 允许尝试密码的次数，超过这个次数会锁定登陆。 (锁定的时间由 <dfn>seconds_to_unlock</dfn> 确定)。 默认值是 <dfn>3</dfn>。</li>
	<li><strong>seconds_to_unlock</strong> - 当用户尝试密码次数超过设定值后，锁定登陆的时间。 默认值是 <dfn>60</dfn>。</li>
	<li><strong>dev_password</strong> - 如果你设置一个开发密码，需要输入密码才可以访问网站。默认没有密码。</li>
</ul>

<h2>模块安全设置</h2>
<p>此外，还存在下面一些模块的特殊安全设置：</p>
<ul>
	<li><strong>sanitize_input</strong> - 在插入和更新数据前过滤接收的数据。
		如果为 <dfn>TRUE</dfn>，将调用 <a href="http://codeigniter.com/user_guide/helpers/security_helper.html" target="_blank">xss_clean</a> 函数处理数据。
		如果为 <dfn>FALSE</dfn>，将不会调用过滤函数。
		你可以使用一个数组来提供多个函数来过滤输入的数据。
		设置多个过滤函数的数组通过<a href="<?=user_guide_url('general/configuration')?>">配置文件</a>安全设置下的 <dfn>module_sanitize_funcs</dfn> 来设置。
		以下列出默认值：
		<ul>
			<li><strong>xss</strong> = xss_clean 函数</li>
			<li><strong>php</strong> = encode_php_tags 函数</li>
			<li><strong>template</strong> = php_to_template_syntax 函数</li>
			<li><strong>entities</strong> = entities 函数</li>
		</ul>
	<li><strong>sanitize_images</strong> - 在图片上使用 <a href="http://codeigniter.org.cn/user_guide/helpers/security_helper.html" target="_blank">xss_clean</a> 函数。</li>
</ul>

