<h1><strong>教程：</strong> 创建简单模块</h1>
<p>以下是在 FUEL 中创建一个<a href="<?=user_guide_url('modules/simple')?>"><strong>简单模块</strong></a>的教程。
不要让<em>简单</em>这个词误导了。你仍然可以创建非常强大的模块，视图和控制器只有在创建<a href="<?=user_guide_url('modules/advanced')?>"><strong>高级模块</strong></a>时才会用到。
在这个教程里，我们将创建几个模块，用于创建文章并将它们分类。
我们将使用四个数据模型，创建三个模块。
我们将从最简单的模块开始，逐步完成其他模块，
首先是作者模块，然后是文章模块，最后我们将创建分类模块来给文章分类。
</p>

<h4><strong>这个教程分为以下几步：</strong></h4>
<ol>
	<li><a href="#setup">下载和安装</a></li>
	<li><a href="#authors_module">作者模块</a></li>
	<li><a href="#articles_module">文章模块</a></li>
	<li><a href="#categories_module">分类模块</a></li>
	<li><a href="#categories_to_articles">分类和文章关联模块</a></li>
	<li><a href="#permissions">设置权限</a></li>
	<li><a href="#polishing">一些修饰</a></li>
	<li><a href="#views">在视图中显示</a></li>
</ol>

<h2 id="setup">下载和安装</h2>
<p>在开始学习教程之前，我们推荐你下载<a href="<?=assets_path('file/fuel_modules_example.zip')?>"><strong>示例源码</strong></a>简单的看一看，以便你更容易跟上节奏。</p>

<p>我们需要创建四个数据库表来支持这些模块 &mdash; 作者表(authors)、文章表(articles)、分类表(categories)和分类文章关联表(categories_to_articles)。</p>

<p>请确保已经安装并配置好<a href="<?=user_guide_url('general/db-setup')?>"> FUEL 的数据库</a>，并能够登录后台。
你需要在 FUEL 的数据库中增加本教程中的模块需要用到的数据库表。</p>

<h2 id="authors_module">作者模块</h2>
<p>首先，我们来创建作者模块。</p>

<h3>安装作者表(authors)</h3>
<p>以下是作者模型(model)要用到的数据库表的建表语句，把它复制下来并在本教程所使用的数据库实例中执行。 </p>

<pre class="brush: sql">
CREATE TABLE `authors` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `email` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `bio` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `avatar` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `published` enum('yes','no') collate utf8_unicode_ci NOT NULL default 'yes',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
</pre>

<p class="important"><strong>注意 <kbd>published</kbd> 列。</strong> 枚举列 <kbd>published</kbd> 和 <kbd>active</kbd>
在 FUEL 中有特殊的含义，他们用来决定是在站点中显示(页面或文章的)内容。
</p>

<h3>创建作者模型</h3>
<p>创建完数据库表之后，我们要创建模型来连接它。
通过在 <dfn>fuel/application/model</dfn> 文件夹中创建一个名为 <dfn>authors_model.php</dfn> 的文件实现。
在这个文件中我们创建两个类，第一个类 <dfn>Authors_model</dfn> 继承 <a href="<?=user_guide_url('libraries/base_module_model')?>">模型基础类(Base_module_model)</a>
(它是 <a href="<?=user_guide_url('libraries/my_model')?>">模型核心类(MY_Model)</a>的子类)。
</p>

<p>我们在 <dfn>authors_model.php</dfn> 文件中创建的第二个类是定制记录(Custom Record)类 <dfn>Author_model</dfn>。
这个类不是必须的，但它可以给记录增加额外的功能。
</p>

<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

class Authors_model extends Base_module_model {

    function __construct()
    {
        parent::__construct('authors');
    }
}

class Author_model extends Base_module_record {

}
</pre>

<p>这就是我们需要为模型做的所有工作，现在我们把它挂接到 FUEL 管理页面中。
</p>

<h3>挂接作者模块</h3>
<p>现在我们的表和模型都创建好了，我们需要将它们传达给 FUEL，打开 <dfn>application/config/MY_fuel_modules.php</dfn> 文件，在里面加入一行：</p>
<pre class="brush: php">
$config['modules']['authors'] = array();
</pre>

<p>译者注：如果要实现模块的本地化，可以在 <dfn>application/language/chinese</dfn> 中创建 <dfn>authors_lang.php</dfn> 文件，然后向数组中传入参数：</p>
<pre class="brush: php">
$config['modules']['authors'] = array(
	'language' => array('authors'),
	'module_name' => lang('module_authors'),
);
</pre>
<p>authors_lang.php 文件的类容如下：</p>
<pre class="brush: php">
$lang['form_label_bio'] = '个人简介';
$lang['form_label_avatar'] = '头像';
$lang['form_label_avatar_upload'] = '上传头像';
</pre>
<p>在 modules/fuel/language/chiese/fuel_lang.php 文件中加入一行：</p>
<pre class="brush: php">
$lang['module_authors'] = '作者';
</pre>
<p class="important">译者注：由于本教程中我们已经实现了本地化，因此你看到的是中文，实际练习时可能是英文的，不过没有关系，以后你会知道怎么做。</p>
<p class="important">这个教程所使用的模块没有设置参数，<a href="<?=user_guide_url('modules/simple')?>">点击这里</a>查看传递给模块的完整参数列表。</p>

<p>登陆 FUEL (例如： http://mysite.com/fuel)，在左边的模块区域你可以看到刚才创建的作者模块。</p>
<img src="<?=img_path('examples/authors_module.png', 'user_guide')?>" class="screen" />

<p class="important">如果你看不到左边的模块，请确定你是以管理员身份登录，并具有使用模块的<a href="#permissions">权限</a>。
</p>

<p>作者表单应该看起来像这样：</p>
<img src="<?=img_path('examples/authors_form.png', 'user_guide')?>" class="screen" />

<h2 id="articles_module">文章模块</h2>
<p>文章模块包含文章的类容，以及一些元素信息，包括指向作者表的外键(译者注：实现用下拉框选择作者)。</p>

<h3>安装文章表(articles)</h3>
<p>以下是文章模型(model)要用到的数据库表的建表语句，把它复制下来并在本教程所使用的数据库实例中执行。 </p>

<pre class="brush: sql">
CREATE TABLE `articles` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `author_id` tinyint(3) unsigned NOT NULL default '0',
  `title` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `permalink` varchar(255) collate utf8_unicode_ci NOT NULL default '',
  `content` text collate utf8_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` enum('yes','no') collate utf8_unicode_ci NOT NULL default 'yes',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
</pre>

<h3>创建文章模型</h3>
<p>创建完数据库表后，按照上面的步骤创建文章模型。同样，在 <dfn>fuel/application/model</dfn> 文件夹中创建一个 <dfn>articles_model.php</dfn> 文件。
将下面的代码添加到文件中：
</p>

<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

class Articles_model extends Base_module_model {

    function __construct()
    {
        parent::__construct('articles');
    }
}

class Article_model extends Base_module_record {

}
</pre>

<h4>改变列表视图显示的列</h4>
<p>我们需要添加一些东西让这个模块看起来更加自然。首先是修改 list_items 方法让 author_id 列显示作者姓名，然后让内容的长度限制在50个字符以内，最后让日期字段 date_added 列以 <dfn>mm/dd/yyyy</dfn> 格式显示。 以下是实现方法：</p>

<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

class Articles_model extends Base_module_model {

    function __construct()
    {
        parent::__construct('articles');
    }

    function list_items($limit = NULL, $offset = NULL, $col = 'name', $order = 'asc')
    {
        $this->db->join('authors', 'authors.id = articles.author_id', 'left');
        $this->db->select('articles.id, authors.name AS author, title, SUBSTRING(content, 1, 50) AS content, date_added, articles.published', FALSE);
        $data = parent::list_items($limit, $offset, $col, $order);
        return $data;
    }

}

class Article_model extends Base_module_record {

}
</pre>
<p>注意，我们在列名前面加上表名以防止发生未明指定表的错误。最后，因为我们在 select 方法中使用了 MySQL 的函数，需要将 <dfn>FALSE</dfn> 传给第二个参数。
</p>
<p class="important">主键 <kbd>id</kbd> 列在管理界面上不可见，但必须包含它，因为它用于标识一行数据。</p>
<p class="important">我们以默认列 <dfn>$col</dfn> 和排序值 <dnf>$order</dnf> 显示列表，但可以在<a href="<?=user_guide_url('modules/simple')?>">模块</a>中设置其他值让数据以更合适的方式排序。</p>


<h4>配置表单</h4>
<p>接下来我们需要修改用于创建和编辑文章的表单界面。 你会发现作者(author_id)是一个文本框不是很方便，我们将使用一个下拉框取代它，用户可以从列表中选择作者。
为了实现这个功能，我们添加一个 <dfn>foreign_keys</dfn> 属性到模型中，然后把 <dfn>author_id</dfn> 标记为指向<dfn>作者(authors_model)</dfn>的外键。
这样做就可以创建一个显示作者列表的下拉框。另外，向模型中添加 <dfn>parsed_fields</dfn> 属性可以告诉它针对指定的字段解析所有的模板语法。
<dfn>content_formatted</dfn> 字段是一个可以被记录模型(Record Model)访问的派生字段，因此它也被添加进来了。</p>

<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once(FUEL_PATH.'models/base_module_model.php');

class Articles_model extends Base_module_model {

	public $foreign_keys = array('author_id' => 'authors_model');
	public $parsed_fields = array('content', 'content_formatted');

    function __construct()
    {
        parent::__construct('articles'); // table name
    }

    function list_items($limit = NULL, $offset = NULL, $col = 'name', $order = 'asc')
    {
        $this->db->join('authors', 'authors.id = articles.author_id', 'left');
        $this->db->select('articles.id, authors.name AS author, title, SUBSTRING(content, 1, 50) AS content, date_added, articles.published', FALSE);
        $data = parent::list_items($limit, $offset, $col, $order);
        return $data;
    }

    function form_fields($values = array())
    {
        $fields = parent::form_fields($values);
		// ******************* ADD CUSOM FORM STUFF HERE *******************
        return $fields;
    }
}

class Article_model extends Data_record {

}
</pre>

<p class="important"><a href="<?=user_guide_url('libraries/my_model/table_class_functions#options_list')?>">options_list</a> 方法创建一个键值对数组被 FUEL 的
<a href="<?=user_guide_url('libraries/form_builder')?>">表单生成器(Form_builder)</a>类用来创建字段。</p>

<p class="important"><kbd>date_added</kbd> 列在管理页面中默认被隐藏了，但它可以被自动检测为一个字段并被插入一个日期。
模型核心类(MY_Model)会默认隐藏 <kbd>date_added、entry_date、last_modified 和 last_updated</kbd> 列。</p>

<p>虽然我们还没有把这个模型全部完成，我们还是先创建分类模块。
当我们完成分类模块后，我们将返回文章模型并使用 <dfn>form_fields</dfn> 方法把它和分类模型关联起来。 此时这个表单看起来应该像这样：</p>

<img src="<?=img_path('examples/articles_form.png', 'user_guide')?>" class="screen" />

<h2 id="categories_module">分类模块</h2>
<p>分类模块用于将文章归类，你可以创建多个分类，并在文章里分别将它们与文章关联（我们马上就要做这件事）。</p>

<h3>安装分类变量(categories)</h3>
<p>分类模块由两个表组成 &mdash; 一个表用于记录分类信息，另一个表用于记录分类和文章关联信息，以下是建表语句：</p>

<pre class="brush: sql">
CREATE TABLE  `categories` (
 `id` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
 `name` VARCHAR( 100 ) NOT NULL ,
 `published` ENUM(  'yes',  'no' ) NOT NULL DEFAULT  'yes'
) ENGINE = MYISAM ;

CREATE TABLE  `categories_to_articles` (
 `category_id` SMALLINT UNSIGNED NOT NULL ,
 `article_id` INT UNSIGNED NOT NULL ,
PRIMARY KEY (  `category_id` ,  `article_id` )
) ENGINE = MYISAM ;
</pre>

<h3>创建分类模型</h3>
<p>现在我们要创建两个模型，每张表一个。然而，文章分类关联表(category_to_articles)只用于帮助文章和分类建立联系，在后台管理中不可见。</p>

<h4>分类模型</h4>
<p>和前面一样，我们开始创建分类模型。在 <dfn>fuel/application/model</dfn> 目录创建名为 <dfn>categories_model.php</dfn> 的文件。
将下面的代码添加到文件中：
</p>

<pre class="brush: php">
&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once(FUEL_PATH.'models/base_module_model.php');

class Categories_model extends Base_module_model {

	public $record_class = 'Category';

	function __construct()
	{
		parent::__construct('categories');
	}


	// cleanup category to articles
	function on_after_delete($where)
	{
		$CI =& get_instance();
		$CI->load->model('categories_to_articles_model');
		if (is_array($where) && isset($where['id']))
		{
			$where = array('category_id' => $where['id']);
			$CI->categories_to_articles_model->delete($where);
		}
	}

}

class Category_model extends Base_module_record {
}
</pre>
<p>我们在这个模块里做了两件额外的事情。首先，我们增加了记录类属性 <dfn>$record_class</dfn> 来指定和模块关联的记录类的名称。
之所以这样做是因为 <dfn>categories</dfn> 的在英文中的单数模式不是简单的去掉结尾的 "s"(译者注：系统可以自动将模型类名去掉结尾的s作为记录类名，所以如果模型类名不特殊，可以不指定$record_class)。
第二件事是增加了一个钩子用于在分类信息删除时自动删除所有包含已删除category_id的文章分类关联信息 <dfn>categories_to_articles</dfn>，这样做的目的是让分类删除后，文章分类关联表中不会存留垃圾信息。
</p>

<h4>文章分类关联模型</h4>
<p>在 <dfn>fuel/application/model</dfn> 目录创建一个名为 <dfn>categories_to_articles.php</dfn> 的文件，在里面添加以下代码：
</p>

<pre class="brush: php">

&lt;?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

class Categories_to_articles_model extends MY_Model {

	public $record_class = 'Category_to_article';

	function __construct()
	{
		parent::__construct('categories_to_articles');
	}

	function _common_query()
	{
        $this->db->select('categories_to_articles.*, articles.title, categories.name AS category_name, articles.author_id, categories.published');
        $this->db->join('articles', 'categories_to_articles.article_id = articles.id', 'left');
        $this->db->join('categories', 'categories_to_articles.category_id = categories.id', 'left');
        $this->db->join('authors', 'authors.id = articles.author_id', 'left');
	}

}

class Category_to_article_model extends Data_record {
	public $category_name = '';
	public $title = '';
	public $author_id;
}
</pre>
<p>和分类模型<dfn>Categories_model</dfn>一样，我们需要指定记录类属性 record_class。
而且我们使用 <dfn>_common_query</dfn> 方法在查询时自动连接文章标题、分类名和作者ID。
我们还要在记录类(译者注：我们一直将 record class 翻译为记录类，它可能不太好理解。如果你懂 Java 可以将它理解为 JavaBean)里添加三个属性，用于记录文章标题、分类名和作者ID。</p>

<h3>挂接分类模块</h3>
<p>在数据库表和模型创建完成后，我们就可以将它集成到 FUEL 后台管理中，
打开 <dfn>applicaitons/config/MY_fuel_modules.php</dfn> 文件，添加一行代码：
</p>
<pre class="brush: php">
$config['modules']['categories'] = array();
</pre>

<p>分类表单应该看起来像这样：</p>
<img src="<?=img_path('examples/categories_form.png', 'user_guide')?>" class="screen" />

<h2 id="categories_to_articles">分类和文章关联模块</h2>
<p>现在文章的分类模块已经创建好了，我们需要在文章模型中添加一个字段，以便将文章和一个或多个分类关联。
回到文章模型，增加 <dfn>form_fields</dfn> 方法如下：</p>

<pre class="brush: php">
...
function form_fields($values = array())
{

	// ******************* NEW RELATED CATEGORY FIELD BEGIN *******************
	$related = array('categories' => 'categories_to_articles_model');
	// ******************* NEW RELATED CATEGORY FIELD END *******************

	$fields = parent::form_fields($values, $related);

	$CI =& get_instance();
	$CI->load->model('authors_model');
	$CI->load->model('categories_model');
	$CI->load->model('categories_to_articles_model');

	$author_options = $CI->authors_model->options_list('id', 'name', array('published' => 'yes'));
	$fields['author_id'] = array('type' => 'select', 'options' => $author_options);

	return $fields;
}
...
</pre>

<p>这样就可以在表单中添加一个多选字段，用来关联文章和分类。</p>

<h3>增加一个保存钩子(After Save Hook)</h3>
<p>现在还没有完，我们需要确保在点击保存按钮后，文章的分类信息也可以保存（译者注：因为它不是存在文章表，而是存在文章分类关联表）。
在文章模型 <dfn>Articles_model</dfn> 中添加一个钩子方法  <dfn>on_after_save</dfn>。我们一般使用这种保存关联(save_related)方法来保存多对多查找表的数据：
</p>

<pre class="brush: php">
...
function on_after_save($values)
{
	$data = (!empty($this->normalized_save_data['categories'])) ? $this->normalized_save_data['categories'] : array();
	$this->save_related('categories_to_articles_model', array('article_id' => $values['id']), array('category_id' => $data));
}
...
</pre>

<h2 id="permissions">设置权限</h2>
<img src="<?=img_path('examples/manage_permissions.png', 'user_guide')?>" class="screen img_right" />
<p>模块创建完之后，我们可能希望让其他人可以使用它们。
我们需要创建权限，让用户可以在后台管理页面访问这些模块。
我们需要做以下几个操作：</p>
<ol>
	<li>点击左侧的权限链接，创建<dfn>作者管理</dfn>权限，它可以被分配给用户。 </li>
	<li>为了将权限分配给用户，点击左侧菜单中的用户链接，选择一个用户。</li>
	<li>在用户编辑界面，勾选你刚才创建的作者管理权限。</li>
</ol>
<p>重复这些操作来创建文章管理权限。</p>

<h2 id="polishing">一些修饰</h2>
<p>我们已经有了作者、文章和分类模块，现在可以增加一些修饰。
</p>

<h3>修饰作者模块</h3>
<p>为了完善作者模块，我们要做以下几件事：</p>

<ol>
	<li>增加必填字段</li>
	<li>为表单增加图片上传功能</li>
	<li>在记录类中增加一个 avatar_image 方法用于生成头像链接</li>
</ol>

<h4>必填字段</h4>
<p>首先我们给模型增加一些必填字段，如下：</p>

<pre class="brush: php">
...
class Authors_model extends Base_module_model {

	public $required = array('name', 'email');

...
</pre>

<h4>图片上传</h4>
<p>接下来，给模块增加图片上传功能。为了实现这个，需要像这样修改 <dfn>form_fields</dfn> 方法：</p>

<pre class="brush: php">
...
function form_fields($values = array())
{
	$fields = parent::form_fields($values);

	$upload_path = assets_server_path('authors/', 'images');
	$fields['avatar_upload'] = array('type' => 'file', 'upload_path' => $upload_path, 'overwrite' => TRUE);
	$fields['published']['order'] = 1000;
	return $fields;
}
...
</pre>
<p class="important">以 <kbd>image</kbd> 或 <kbd>img</kbd> 结尾的字段名会被自动转换成模块的图片选择字段/上传字段(注意：在模板中需要手工创建这两个字段)。</p>
<p class="important"><kbd>_upload</kbd> 后缀使 FUEL 上传图片并赋值给 <kbd>avatar</kbd> 字段。
<kbd>upload_path</kbd> 数组参数告诉 FUEL 上传图片的位置。 在这个例子中，图片将被上传到 <kbd>assets/images/authors</kbd> 目录
<kbd>(目录必须有可写权限)</kbd>。</p>

<p class="important">通过添加 published 的 <kbd>order</kbd> 参数，可以改变它在表单中显示的位置。</p>

<h4>在记录类中添加方法</h4>
<p>最后一个工作是在记录类中增加一个 <strong>get_avatar_image</strong> 方法， 它返回指向头像图片的路径：</p>

<pre class="brush: php">
...
class Author_model extends Data_record {

	public function get_avatar_image()
	{
		return '&lt;img src="'.img_path($this->avatar).'" /&gt;';
	}
}
...
</pre>
<br />


<h3>修饰文章模块</h3>
<p>为了完善文章模块，我们要做以下几件事：</p>
<ol>
	<li>增加必填字段</li>
	<li>整合作者模块</li>
	<li>在模型中增加一个 tree 方法</li>
	<li>改进表单</li>
	<li>增加一个 on_after_delete 钩子</li>
	<li>在记录类中增加方法</li>
</ol>

<h4>必填字段</h4>
<p>对于作者模块，我们首先要为模型增加一些必填项：</p>


<pre class="brush: php">
...
class Articles_model extends Base_module_model {

	public $required = array('title', 'content');

...
</pre>


<h4>整合作者模块</h4>
<p>在模块中可以一键链接到另一个模块的表单。在文章模块中，用户可以直接添加和修改作者。
你可以通过使用 <a href="<?=user_guide_url('modules/forms')?>">特别的 CSS 样式名称</a> 来实现，可以将 <dfn>add_edit</dfn> 放置在一个字段上面来整合一个已经存在的模块。
注意下面的例子中有一个 <dfn>class</dfn> 名称被添加到 <dfn>author_id</dfn> 字段。字段值的开头是
<dfn>add_edit</dfn>，紧接着是你希望整合的模块的标识(key)。下面的代码展示了表单中显示的样式：
</p>

<pre class="brush: php">
...
function form_fields($values = array())
{
    $fields = parent::form_fields($values);
    $CI =& get_instance();

    if ($CI->fuel_auth->has_permission('authors'))
    {
        $fields['author_id']['class'] = 'add_edit authors';
    }

    return $fields;
}
...
</pre>
<img src="<?=img_path('examples/add_edit.png', 'user_guide')?>" class="screen" />

<h4>tree 方法</h4>
<p>在 FUEL 中可以创建一个 tree 方法，使用层次分明的树形结构来显示列表数据。
在文章模块中， 我们使用分类名称来创建树形视图。tree 方法必须返回一个遵循<a href="<?=user_guide_url('libraries/menu')?>">菜单</a>分层结构的数组。层次名称会随着它的发布状态改变(未发布的信息不会显示出来)。</p>

<pre class="brush: php">
...
function tree()
{
	$CI =& get_instance();
	$CI->load->model('categories_model');
	$CI->load->model('categories_to_articles_model');

	$return = array();
	$categories = $CI->categories_model->find_all(array(), 'id asc');
	$categories_to_articles = $CI->categories_to_articles_model->find_all('', 'categories.name asc');

	$cat_id = -1;
	foreach($categories as $category)
	{
		$cat_id = $category->id;
		$return[] = array('id' => $category->id, 'label' => $category->name, 'parent_id' => 0, 'location' => fuel_url('categories/edit/'.$category->id));
	}
	$i = $cat_id +1;

	foreach($categories_to_articles as $val)
	{
		$attributes = ($val->published == 'no') ? array('class' => 'unpublished', 'title' => 'unpublished') : NULL;
		$return[$i] = array('id' => $i, 'label' => $val->title, 'parent_id' => $val->category_id, 'location' => fuel_url('articles/edit/'.$val->article_id), 'attributes' =>  $attributes);
		$i++;
	}
	return $return;
}
...
</pre>
<p class="important">注意：我们没有将未分类的文章显示在树形视图中,如果需要你可以给未分类的条目创建另一个父级分类。</p>

<p>tree 方法在后台管理界面展示如下：</p>
<img src="<?=img_path('examples/articles_tree.png', 'user_guide')?>" class="screen" />


<h4>添加一个删除钩子(After Delete Hook)</h4>
<p>你可以在模块中创建<dfn>钩子</dfn>，它包含可以在特定事件发生时执行的函数。
在文章模型中，我们希望添加一个钩子，让它在文章被删除后自动删除 categories_to_articles 表中所有和已删除文章相关联的数据，使得这张表不会存留垃圾数据。
以下是我们添加到文章模型中的方法：
</p>

<pre class="brush: php">
...
// cleanup articles from categories to articles table
function on_after_delete($where)
{
	$this->delete_related('categories_to_articles_model', 'article_id', $where);
}
...
</pre>

<h4>将作者延迟加载(lazy load)到文章中</h4>
<p>通过在<dfn>文章模型</dfn>中添加 <dfn>foreign_keys</dfn> 属性，
<dfn>文章模型</dfn>的记录类会自动延迟加载(lazy load)和当前记录相关联的<dfn>作者模型</dfn>。这意味着你可以像这样访问作者： <dfn>$article->author->name</dfn>。
</p>

<p>你也可以在记录类中手动使用 <dfn>lazy_load</dfn> 方法实现延迟加载。
如果我们要在文章模型中手动延迟加载作者模型，可以这样做：</p>
<pre class="brush: php">
class Article_model extends Data_record {

	function get_author()
	{
		return $this->lazy_load('author_id', 'authors_model');
	}
}
</pre>
<p>同样地，我们在文章分类关联模型(categories_to_articles_model)中添加以下<dfn>外键(foreign_keys)</dfn>：</p>
<pre class="brush: php">
class Categories_to_articles_model extends MY_Model {

    public $record_class = 'Category_to_article';
	public $foreign_keys = array('category_id' => 'categories_model', 'article_id' => 'articles_model', 'author_id' => 'authors_model');
...
</pre>


<br />

<h3>修饰分类模块</h3>
<p>为了改善分类模块，我们将增加必填项、增加 on_after_delete 钩子以及改善模型验证(validation)。</p>
<ol>
	<li>增加必填项</li>
	<li>增加 on_after_delete 钩子</li>
	<li>改善模型验证(validation)</li>
</ol>


<h4>必填项</h4>
<p>和以前的模块一样，第一件事是像这样增加  <dfn>name</dfn> 字段为必填项：</p>

<pre class="brush: php">
...
class Categories_model extends Base_module_model {

	public $required = array('name');

...
</pre>

<h4>增加一个删除钩子(After Delete Hook)</h4>
<p>和文章模型一样，我们将为分类模型增加一个 on_after_delete 钩子，使得分类被删除后，<dfn>categories_to_articles</dfn> 表中与已删除分类关联的数据一起被删除。
以下是实现方法：</p>
<pre class="brush: php">
...
// cleanup articles from categories to articles table
function on_after_delete($where)
{
	$this->delete_related('categories_to_articles_model', 'category_id', $where);
}
...
</pre>

<h4>增加一个验证钩子(Before Validation Hook)</h4>
<p>我们常用的一个表单验证是在所有记录中维护字段的唯一性。
在分类模块中，我们希望确保<strong>名称(name)</strong>值在所有记录里是唯一的，这意味着不能存在两个名称字段的值相同的记录。
我们增加一个 <dfn>on_before_validate</dfn> 钩子来检查记录是否已存在，从而返回 <dfn>is_editable</dfn> 或 <dfn>is_new</dfn> 的验证结果。
</p>

<pre class="brush: php">
...
function on_before_validate($values)
{
	if (!empty($values['id']))
	{
		$this->add_validation('name', array(&$this, 'is_editable'), lang('error_val_empty_or_already_exists', 'name'), array('name', $values['id']));
	}
	else
	{
		$this->add_validation('name', array(&$this, 'is_new'), lang('error_val_empty_or_already_exists', 'name'), 'name');
	}
	return $values;
}
...
</pre>

<p class="important"><kbd>is_editable</kbd> 和 <kbd>is_new</kbd> 是模型核心类(MY_Model)的方法。<kbd>add_validation</kbd> 的第二个参数，
,是一个包含类的实例和方法名的数组， 而不是简单的函数名字符串。</p>

<h2 id="views">在视图中显示</h2>
<p>模块都已经在 FUEL 中创建了，现在我们可以将模块的模型数据添加到视图中。
虽然我们可以使用控制器将数据传入视图，但在这个例子里，我们只需要让视图自己包含这个逻辑。
(<a href="<?=user_guide_url('general/opt-in-controllers')?>">查看内联控制器原理</a>)。
在视图中，我们需要根据分类显示文章或者显示所有文章。首先，在 <dfn>application/views</dfn> 目录创建名为
<dfn>example.php</dfn> 的文件，然后将以下代码写入文件：
</p>
<pre class="brush: php">
&lt;?php
$category = $CI-&gt;uri-&gt;segment(2);
if (!empty($category))
{
	$CI-&gt;load-&gt;model('categories_model');

	// remember, all categories that have a published value of 'no' will automatically be excluded
	$category = $CI-&gt;categories_model-&gt;find_one_by_name($category);
	$articles = $category-&gt;articles;
}
else
{
	$CI-&gt;load-&gt;model('articles_model');

	// remember, all articles that have a published value of 'no' will automatically be excluded
	$articles = $CI-&gt;articles_model-&gt;find_all();
}
?&gt;

&lt;h1&gt;Articles &lt;?php if (!empty($category)) : ?&gt; : &lt;?=$category-&gt;name?&gt; &lt;?php endif; ?&gt;&lt;/h1&gt;
&lt;?php foreach($articles as $article) : ?&gt;

&lt;h2&gt;&lt;?=fuel_edit($article-&gt;id, 'Edit: '.$article-&gt;name, 'articles')?&gt;&lt;?=$article-&gt;title?&gt;&lt;/h2&gt;
&lt;p&gt;
&lt;?=$article-&gt;content_formatted?&gt;
&lt;/p&gt;
&lt;div class="author"&gt;&lt;?=$article-&gt;author-&gt;name?&gt;&lt;/div&gt;
&lt;?php endforeach; ?&gt;
</pre>
<p>接下来，我们要让 FUEL 自动找到这个视图文件。可以通过配置文件中的 <dfn>auto_search_views</dfn> 变量来实现，
在 <dfn>application/config/MY_fuel.php</dfn> 文件中修改 <dfn>$config['auto_search_views'] = TRUE</dfn>。</p>

<p class="important">FUEL 自动将 CodeIgniter 的对象 <kbd>$CI</kbd> 变量传递到视图中。</p>
<p class="important"><kbd>content_formatted</kbd> 是一个魔术方法(magic method)。通过在字符串类型的字段后添加 <kbd>_formatted</kbd>，实现使用 CI 的
<a href="http://codeigniter.org.cn/user_guide/helpers/typography_helper.html" target="_blank">auto_typography</a> 方法格式化这个字段。</p>
<p class="important"><a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_model 和 fuel_block</a> 辅助函数也可以实现将数据显示在视图。</p>


<h3>内联编辑</h3>
<p>最后在我们的视图中添加内联编辑功能，可以通过 <a href="helpers/fuel_helper">fuel_edit</a> 函数实现，我们把这个函数放置在 &lt;h2&gt; 标签里。</p>

<pre class="brush: php">
...
&lt;h2&gt;&lt;?=fuel_edit($article-&gt;id, 'Edit: '.$article-&gt;name, 'articles')?&gt;&lt;?=$article-&gt;title?&gt;&lt;/h2&gt;
...
</pre>

<p>此外，如果你想在页面中添加条目，只需要将 <dfn>create</dfn> 作为第一个参数传入函数即可实现。 </p>
&lt;h2&gt;&lt;?=fuel_edit('create', 'Create', 'articles')?&gt;&lt;?=$article-&gt;title?&gt;&lt;/h2&gt;

<p class="important"><a href="<?=user_guide_url('general/inline-editing')?>">点击这里了解内联编辑的更多信息</a></p>


<?php /* ?>
<h2>Now What?</h2>
<p>If you are wanting to create more advanced modules, <a href="<?=user_guide_url('modules/advanced')?>">click here</a>.</p>
<p><a href="<?=site_url(USER_GUIDE_FOLDER.'/examples/fuel_modules_example.zip')?>">Click here to download the files to the example.</a></p>
<?php */ ?>