<h1>模板解析器概述</h1>
<p>出于安全考虑，FUEL默认不允许在模块数据中保存PHP代码
（你必须在模块的配置中改变<a href="<?=user_guide_url('modules/simple')?>">sanitize_input</a>参数）。
FUEL实现了基于PHP5的模板系统<a href="http://dwoo.org/" target="_blank">Dwoo</a>。
</p>

<h2>MY_Parser类</h2>
<p>FUEL用<a href="<?=user_guide_url('libraries/my_parser')?>">MY_Parser</a>类重写了CodeIgniter的模板解释器类以扩展对Dwoo模板的支持。</p>


<h2>字符串帮助函数</h2>
<p>FUEL使用下列<a href="<?=user_guide_url('helpers/my_string_helper')?>">字符串帮助函数</a>来解析和转换Dwoo模板语法：</p>
<ul>
	<li>php_to_template_syntax - 将PHP语法转换成<a href="http://dwoo.org" target="_blank">Dwoo模板语法</a>。 </li>
	<li>parse_template_syntax - 解析使用<a href="http://dwoo.org" target="_blank">Dwoo模板语法</a>编写的字符串。</li>
</ul>

<h2>全局函数</h2>
<p>下列函数可以在应用程序的任何位置使用，它们可以被模板系统转换成PHP代码。</p>
<ul>
	<li>{site_url('/my/path/')} - 返回所传参数的URL，参数为空则返回网站根路径。</li>
	<li>{assets_path('images/my_asset.jpg')} - 映射到 <a href="<?=user_guide_url('helpers/asset_helper')?>">assets_path()</a>函数。</li>
	<li>{img_path('my_img.jpg')} - 映射到<a href="<?=user_guide_url('helpers/asset_helper')?>">img_path()</a>函数。</li>
	<li>{js_path('my_js.js')} - 映射到<a href="<?=user_guide_url('helpers/asset_helper')?>">js_path()</a>函数。<dfn>.js</dfn>后缀是可选的。</li>
	<li>{swf_path('my_swf.swf')} - 映射到<a href="<?=user_guide_url('helpers/asset_helper')?>">swf_path()</a>函数。<dfn>.swf</dfn>后缀是可选的。</li>
	<li>{media_path('my_movie.mov')} - 映射到<a href="<?=user_guide_url('helpers/asset_helper')?>">media_path()</a>函数.</li>
	<li>{pdf_path('my_pdf.pdf')} - 映射到<a href="<?=user_guide_url('helpers/asset_helper')?>">pdf_path()</a>函数。<dfn>.pdf</dfn>后缀是可选的。</li>
	<li>{safe_mailto('my@email.com', 'text')} - 映射到 <a href="http://codeigniter.com/user_guide/helpers/url_helper.html" target="_blank">safe_mailto()</a>函数.</li>
	<li>{redirect('my_redirect_page')} - 映射到<a href="http://codeigniter.com/user_guide/helpers/url_helper.html" target="_blank">redirect()</a>函数.</li>
	<li>{show_404} - 映射到<a href="http://codeigniter.com/user_guide/general/errors.html" target="_blank">show_404()</a>函数.</li>
</ul>

<h2>局部函数</h2>
<p>下列函数必须加载它所在模块才能使用，它们可以被模板系统转换成PHP代码。</p>

<ul>
	<li>{uri_segment(1, true/false)} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">uri_segment(n)</a>函数。</li>
	<li>{fuel_var} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_var()</a>函数。</li>
	<li>{fuel_model(model, array(key="val"...)} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_modules()</a>函数。</li>
	<li>{fuel_block(array(key="val"...))} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_block()</a>函数。</li>
	<li>{fuel_nav(array(key="val"...))} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_nav()</a>函数。</li>
	<li>{fuel_edit(id, label, module, xOffset, yOffset)} - 映射到<a href="<?=user_guide_url('helpers/fuel_helper')?>">fuel_edit()</a>函数。</li>
</ul>
<p class="important">注意有几个函数需要使用<dfn>key="val"</dfn>语法传入一个相关的数组参数。</p>

<h2>代码块</h2>
<p>标签对可以循环执行一个数组中的数据。语法需要一个开始标记<dfn>{my_var}</dfn>和一个结束标记<dfn>{/my_var}</dfn>。
例如：</p>

<pre class="brush:php">
$my_data = array();
$my_data[] = array('name' => 'Darth Vader', 'weapon' => 'light saber');
$my_data[] = array('name' => 'Han Solo', 'weapon' => 'blaster');
...
{loop $my_data}
	{$name} - {$weapon}
{loop}
</pre>

<p>你也可以在对象上迭代。例如，你将通过迭代从自定义方法返回的结果集中获得一个<dfn>user</dfn>模型(Model)：</p>
<pre class="brush:php">
...
$my_data = $this->user_model->find_all();

{foreach $my_data user}
	{$user->name} - {$user->weapon}
{/foreach}
</pre>

<p class="important">你可以取到<dfn>user</dfn>中的任何值，但不可以插入外部变量到由标签对组成的代码块中。</p>

<h2>条件语句Conditional Statements</h2>
<p>FUEL也可以使用和PHP语法一样的条件语句<dfn>{if ... }</dfn>、<dfn>{elseif ...}</dfn>和<dfn>{/if}</dfn>在视图中插入判断。
例如：
</p>

<pre class="brush:php">
{$name='Darth Vader'}
{if $name == 'Darth Vader'}
I am your father.
{/if}
</pre>


<h2>创建自定义标签</h2>
<p><a href="http://wiki.dwoo.org/index.php/WritingPlugins" target="_blank">Dwoo提供一些方法通过插件来扩展它的模板语法</a>。
加入自定义Dwoo插件的目录位于<dfn>application/libraries/dwoo/plugins</dfn>。
</p>
