/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.FzOrientation;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.util.DataUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidTank;

public abstract class DataHelper {
    protected String name;
    protected boolean valid;

    public DataHelper as(Share share, String set_name) {
        this.name = set_name;
        this.valid = this.shouldStore(share);
        return this;
    }

    public DataHelper asSameShare(String set_name) {
        this.name = set_name;
        return this;
    }

    protected abstract boolean shouldStore(Share var1);

    public abstract boolean isReader();

    public boolean isWriter() {
        return !this.isReader();
    }

    public NBTTagCompound getTag() {
        return null;
    }

    public boolean isNBT() {
        return false;
    }

    public <E> E put(E o) throws IOException {
        if (!this.valid) {
            return o;
        }
        if (o instanceof IDataSerializable) {
            return (E)((IDataSerializable)o).serialize(this.name, this);
        }
        if (o instanceof Enum) {
            Enum value = (Enum)o;
            int i = this.putInt(value.ordinal());
            if (this.isWriter()) {
                return (E)value;
            }
            return value.getDeclaringClass().getEnumConstants()[i];
        }
        if (o instanceof ItemStack) {
            ItemStack value = (ItemStack)o;
            NBTTagCompound writtenTag = value.func_77955_b(new NBTTagCompound());
            if (this.isReader()) {
                return (E)ItemStack.func_77949_a((NBTTagCompound)this.put(writtenTag));
            }
            this.put(writtenTag);
            return o;
        }
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            String base_name = this.name;
            if (this.isReader()) {
                long msb = this.asSameShare(base_name + "MSB").putLong(0L);
                long lsb = this.asSameShare(base_name + "LSB").putLong(0L);
                if (msb == 0L && lsb == 0L) {
                    return o;
                }
                return (E)new UUID(msb, lsb);
            }
            this.asSameShare(base_name + "MSB").putLong(uuid.getMostSignificantBits());
            this.asSameShare(base_name + "LSB").putLong(uuid.getLeastSignificantBits());
            return (E)uuid;
        }
        return this.putImplementation(o);
    }

    protected abstract <E> E putImplementation(E var1) throws IOException;

    public final boolean putBoolean(boolean value) throws IOException {
        return this.put(value);
    }

    public final byte putByte(byte value) throws IOException {
        return this.put(value);
    }

    public final short putShort(short value) throws IOException {
        return this.put(value);
    }

    public final int putInt(int value) throws IOException {
        return this.put(value);
    }

    public final long putLong(long value) throws IOException {
        return this.put(value);
    }

    public final float putFloat(float value) throws IOException {
        return this.put(Float.valueOf(value)).floatValue();
    }

    public final double putDouble(double value) throws IOException {
        return this.put(value);
    }

    public final UUID putUUID(UUID value) throws IOException {
        return this.put(value);
    }

    public final String putString(String value) throws IOException {
        return this.put(value);
    }

    public final FzOrientation putFzOrientation(FzOrientation value) throws IOException {
        return this.put(value);
    }

    public final ItemStack putItemStack(ItemStack value) throws IOException {
        ItemStack ret;
        if (value == null) {
            value = DataUtil.NULL_ITEM;
        }
        if ((ret = this.put(value)) != null && ret.func_77973_b() == null) {
            return null;
        }
        return ret;
    }

    public final ArrayList<ItemStack> putItemArray(ArrayList<ItemStack> value) throws IOException {
        if (!this.valid) {
            return value;
        }
        if (this.isReader() && this.hasLegacy(this.name + "_len")) {
            return this.putItemArray_legacy(value);
        }
        return this.putItemArray_efficient(value);
    }

    protected ArrayList<ItemStack> putItemArray_efficient(ArrayList<ItemStack> value) throws IOException {
        return this.putItemArray_legacy(value);
    }

    @Deprecated
    public final ArrayList<ItemStack> putItemArray_legacy(ArrayList<ItemStack> value) throws IOException {
        String prefix = this.name;
        int len = this.asSameShare(prefix + "_len").putInt(value.size());
        if (this.isReader()) {
            value.clear();
            value.ensureCapacity(len);
            for (int i = 0; i < len; ++i) {
                value.add(this.asSameShare(prefix + "_" + i).putItemStack(null));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.asSameShare(prefix + "_" + i).putItemStack(value.get(i));
            }
        }
        return value;
    }

    public final NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        return this.put(value);
    }

    public final FluidTank putTank(FluidTank tank) throws IOException {
        if (this.isWriter()) {
            NBTTagCompound tag = new NBTTagCompound();
            tank.writeToNBT(tag);
            this.putTag(tag);
            return tank;
        }
        NBTTagCompound tag = this.putTag(new NBTTagCompound());
        tank.readFromNBT(tag);
        return tank;
    }

    public Vec3 putVec3(Vec3 val) throws IOException {
        String prefix = this.name;
        val.field_72450_a = this.asSameShare(prefix + ".x").putDouble(val.field_72450_a);
        val.field_72448_b = this.asSameShare(prefix + ".y").putDouble(val.field_72448_b);
        val.field_72449_c = this.asSameShare(prefix + ".z").putDouble(val.field_72449_c);
        this.name = prefix;
        return val;
    }

    public final <E extends Enum> E putEnum(E value) throws IOException {
        return this.put(value);
    }

    public void log(String message) {
    }

    public boolean hasLegacy(String name2) {
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }
}

