/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.DataHelperNBT;
import factorization.api.datahelpers.Share;
import factorization.shared.Core;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataInNBT
extends DataHelperNBT {
    public DataInNBT(NBTTagCompound theTag) {
        this.tag = theTag;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return !share.is_transient;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    protected <E> E putImplementation(E o) throws IOException {
        if (!this.tag.func_74764_b(this.name)) {
            return o;
        }
        try {
            if (o instanceof Boolean) {
                return (E)Boolean.valueOf(this.tag.func_74767_n(this.name));
            }
            if (o instanceof Byte) {
                return (E)Byte.valueOf(this.tag.func_74771_c(this.name));
            }
            if (o instanceof Short) {
                return (E)Short.valueOf(this.tag.func_74765_d(this.name));
            }
            if (o instanceof Integer) {
                return (E)Integer.valueOf(this.tag.func_74762_e(this.name));
            }
            if (o instanceof Long) {
                return (E)Long.valueOf(this.tag.func_74763_f(this.name));
            }
            if (o instanceof Float) {
                return (E)Float.valueOf(this.tag.func_74760_g(this.name));
            }
            if (o instanceof Double) {
                return (E)Double.valueOf(this.tag.func_74769_h(this.name));
            }
            if (o instanceof String) {
                return (E)this.tag.func_74779_i(this.name);
            }
            if (o instanceof NBTTagCompound) {
                return (E)this.tag.func_74775_l(this.name);
            }
        }
        catch (Throwable t) {
            Core.logWarning("Failed to load " + this.name + "; will use default value " + o, new Object[0]);
            Core.logWarning("The tag: " + this.tag, new Object[0]);
            t.printStackTrace();
        }
        return o;
    }

    @Override
    public boolean hasLegacy(String name2) {
        return this.tag.func_74764_b(name2);
    }

    @Override
    protected ArrayList<ItemStack> putItemArray_efficient(ArrayList<ItemStack> value) throws IOException {
        NBTTagList buffer = this.tag.func_150295_c(this.name, 10);
        int size = buffer.func_74745_c();
        value.clear();
        value.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            NBTTagCompound it = buffer.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)it);
            value.add(is);
        }
        return value;
    }
}

