/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.colossi.Awakener;
import factorization.colossi.ColossusController;
import factorization.colossi.TileEntityColossalHeart;
import factorization.common.BlockIcons;
import factorization.fzds.DeltaChunk;
import factorization.fzds.Hammer;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.oreprocessing.ItemOreProcessing;
import factorization.shared.Core;
import factorization.util.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ColossalBlock
extends Block {
    static final byte MD_MASK = 0;
    static final byte MD_BODY = 4;
    static final byte MD_BODY_CRACKED = 1;
    static final byte MD_ARM = 2;
    static final byte MD_LEG = 3;
    static final byte MD_EYE = 5;
    static final byte MD_CORE = 6;
    static final byte MD_EYE_OPEN = 7;
    static final byte MD_BODY_COVERED = 8;
    static final byte MD_MASK_CRACKED = 9;
    static Material collosal_material = new Material(MapColor.field_151678_z);
    static final int UP = ForgeDirection.UP.ordinal();
    static final int DOWN = ForgeDirection.DOWN.ordinal();
    static final int EAST = ForgeDirection.EAST.ordinal();
    ChestGenHooks fractureChest = new ChestGenHooks("factorization:colossalFracture");
    boolean setup = false;

    public ColossalBlock() {
        super(collosal_material);
        this.func_149711_c(-1.0f);
        this.func_149752_b(150.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(field_149780_i);
        this.func_149663_c("factorization:colossalBlock");
        Core.tab(this, Core.TabType.BLOCKS);
    }

    public IIcon func_149691_a(int side, int md) {
        switch (md) {
            case 4: {
                return BlockIcons.colossi$body;
            }
            case 8: {
                return BlockIcons.colossi$body;
            }
            case 1: {
                return BlockIcons.colossi$body_cracked;
            }
            case 2: {
                return BlockIcons.colossi$arm_side;
            }
            case 3: {
                return BlockIcons.colossi$leg;
            }
            case 0: {
                return BlockIcons.colossi$mask;
            }
            case 9: {
                return BlockIcons.colossi$mask_cracked;
            }
            case 5: {
                return BlockIcons.colossi$eye;
            }
            case 6: {
                if (side == EAST) {
                    return BlockIcons.colossi$core;
                }
                return BlockIcons.colossi$core_back;
            }
            case 7: {
                return BlockIcons.colossi$eye_open;
            }
        }
        return super.func_149691_a(side, md);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int side) {
        int md = w.func_72805_g(x, y, z);
        if (md == 5 || md == 7) {
            if (side != EAST) {
                return BlockIcons.colossi$mask;
            }
            return md == 7 ? BlockIcons.colossi$eye_open : BlockIcons.colossi$eye;
        }
        if (md == 2) {
            if (side == UP) {
                return BlockIcons.colossi$arm_top;
            }
            if (side == DOWN) {
                return BlockIcons.colossi$arm_bottom;
            }
            Block downId = w.func_147439_a(x, y - 1, z);
            int downMd = w.func_72805_g(x, y - 1, z);
            Block upId = w.func_147439_a(x, y + 1, z);
            int upMd = w.func_72805_g(x, y + 1, z);
            if (downId == this && downMd == 2) {
                if (upId != this || upMd != 2) {
                    return BlockIcons.colossi$arm_side_top;
                }
                return BlockIcons.colossi$arm_side;
            }
            return BlockIcons.colossi$arm_side_bottom;
        }
        return this.func_149691_a(side, md);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int md = world.func_72805_g(x, y, z);
        if (md == 1 || md == 9) {
            return 6.0f;
        }
        if (md == 0) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.isSupportive(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                return super.func_149712_f(world, x, y, z);
            }
            return 50.0f;
        }
        return super.func_149712_f(world, x, y, z);
    }

    boolean isSupportive(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return false;
        }
        int md = world.func_72805_g(x, y, z);
        return md == 4 || md == 8 || md == 5 || md == 7 || md == 6;
    }

    public void func_149651_a(IIconRegister iconRegistry) {
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int md = 0; md <= 9; md = (int)((byte)(md + 1))) {
            if (md == 8) continue;
            list.add(new ItemStack((Block)this, 1, md));
        }
    }

    ChestGenHooks getChest() {
        if (this.setup) {
            return this.fractureChest;
        }
        this.setup = true;
        this.fractureChest.addItem(new WeightedRandomChestContent(new ItemStack((Item)Core.registry.logicMatrixIdentifier), 1, 1, 6));
        this.fractureChest.addItem(new WeightedRandomChestContent(new ItemStack((Item)Core.registry.logicMatrixController), 1, 1, 6));
        this.fractureChest.addItem(new WeightedRandomChestContent(new ItemStack((Item)Core.registry.ore_crystal, 1, ItemOreProcessing.OreType.DARKIRON.ID), 1, 2, 12));
        this.fractureChest.addItem(new WeightedRandomChestContent(Core.registry.dark_iron_sprocket.func_77946_l(), 2, 4, 1));
        return this.fractureChest;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int md, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (md == 0) {
            ret.add(new ItemStack((Block)this, 1, md));
        }
        if (md == 1 || md == 9) {
            int count = 1 + world.field_73012_v.nextInt(1 + fortune);
            for (int i = 0; i < count; ++i) {
                ret.add(this.getChest().getOneItem(world.field_73012_v));
            }
        }
        if (md == 6) {
            ret.add(new ItemStack((Item)Core.registry.logicMatrixProgrammer));
        }
        if (md == 1 || md == 9) {
            Coord me = new Coord(world, x, y, z);
            Coord back = me.add(ForgeDirection.WEST);
            if (back.getBlock() == this && back.getMd() == 6) {
                TransferLib.move(back, me, true, true);
                back.setIdMd(this, 4, true);
            }
            Awakener.awaken(me);
        }
        return ret;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.field_73011_w.field_76574_g != Hammer.getDimensionId()) {
            return;
        }
        int md = world.func_72805_g(x, y, z);
        int r = md == 1 ? 4 : 2;
        float px = (float)x - 0.5f + rand.nextFloat() * (float)r;
        float py = (float)y - 0.5f + rand.nextFloat() * (float)r;
        float pz = (float)z - 0.5f + rand.nextFloat() * (float)r;
        switch (md) {
            case 1: 
            case 9: {
                world.func_72869_a("flame", (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0);
                break;
            }
            case 6: {
                world.func_72869_a("reddust", (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0);
                break;
            }
            case 4: 
            case 8: {
                if (rand.nextInt(256) != 0) break;
                world.func_72869_a("explode", (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0);
                break;
            }
            case 0: 
            case 5: 
            case 7: {
                world.func_72869_a("depthsuspend", (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vecX, float vecY, float vecZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (player == null) {
            return false;
        }
        Coord at = new Coord(world, x, y, z);
        ItemStack held = player.func_70694_bm();
        int md = at.getMd();
        if (held != null && held.func_77973_b() == Core.registry.logicMatrixProgrammer) {
            if (held.func_77960_j() == 0) {
                if (md == 6) {
                    held.func_77964_b(1);
                }
                return true;
            }
            return true;
        }
        if (PlayerUtil.isPlayerCreative(player) && md == 6) {
            TileEntityColossalHeart heart = at.getTE(TileEntityColossalHeart.class);
            if (heart != null) {
                if (player.func_70093_af()) {
                    Awakener.awaken(at);
                    return true;
                }
                heart.showInfo(player);
            }
            return true;
        }
        if (md == 6) {
            Awakener.awaken(at);
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        super.func_149689_a(world, x, y, z, player, is);
        if (is.func_77960_j() != 6) {
            return;
        }
        Coord at = new Coord(world, x, y, z);
        at.setTE(new TileEntityColossalHeart());
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 6;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int md) {
        super.func_149749_a(world, x, y, z, block, md);
        if (world.field_72995_K) {
            return;
        }
        if (world == DeltaChunk.getServerShadowWorld()) {
            return;
        }
        Coord at = new Coord(world, x, y, z);
        if (md == 1 || md == 9) {
            for (Coord neighbor : at.getNeighborsAdjacent()) {
                if (neighbor.getBlock() != this || neighbor.getMd() != 4) continue;
                int air = 0;
                for (Coord n2 : neighbor.getNeighborsAdjacent()) {
                    if (!n2.isAir()) continue;
                    ++air;
                }
                if (air > true) continue;
                neighbor.setMd(8);
            }
            Awakener.awaken(at);
        }
    }

    public ColossusController findController(Coord at) {
        TileEntityColossalHeart heart = Awakener.findNearestHeart(at);
        if (heart == null) {
            return null;
        }
        UUID controllerId = heart.controllerUuid;
        if (controllerId.equals(TileEntityColossalHeart.noController)) {
            return null;
        }
        for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(at)) {
            ColossusController controller;
            IDCController c = idc.getController();
            if (!(c instanceof ColossusController) || !(controller = (ColossusController)c).func_110124_au().equals(controllerId)) continue;
            return controller;
        }
        return null;
    }
}

