/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.colossi.BlockState;
import factorization.colossi.Brush;
import factorization.colossi.MaskLoader;
import factorization.colossi.MaskTemplate;
import factorization.colossi.TileEntityColossalHeart;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.util.ForgeDirection;

public class ColossalBuilder {
    final int seed;
    final Random rand;
    final Coord start;
    int leg_size;
    int leg_height;
    int leg_spread;
    int body_height;
    int arm_size;
    int arm_height;
    int body_arm_padding;
    int body_back_padding;
    int body_front_padding;
    int shoulder_start;
    int face_width;
    int face_height;
    int face_depth;
    static final BlockState LEG = new BlockState(Core.registry.colossal_block, 3);
    static final BlockState BODY = new BlockState(Core.registry.colossal_block, 4);
    static final BlockState ARM = new BlockState(Core.registry.colossal_block, 2);
    static final BlockState MASK = new BlockState(Core.registry.colossal_block, 0);
    static final BlockState EYE = new BlockState(Core.registry.colossal_block, 5);
    static final BlockState HEART = new BlockState(Core.registry.colossal_block, 6);
    static final BlockState BODY_CRACK = new BlockState(Core.registry.colossal_block, 1);
    static final BlockState MASK_CRACK = new BlockState(Core.registry.colossal_block, 9);
    static final BlockState AIR = new BlockState(Blocks.field_150350_a, 0);

    public ColossalBuilder(int seed, Coord start) {
        this.seed = seed;
        this.rand = new Random(seed);
        this.leg_size = this.random_choice(1, 1, 1, 1, 2);
        this.leg_height = this.random_linear(this.leg_size * 3 / 2, this.leg_size * 5 / 2);
        this.leg_height = this.clipMax(2, this.leg_height);
        this.leg_spread = this.random_choice(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5);
        this.body_height = this.leg_height + this.random_linear(-this.leg_height / 2, this.leg_height * 2);
        this.body_height = this.clipMax(3, this.leg_height / 3, this.body_height);
        this.shoulder_start = this.body_height > 10 ? this.random_linear(0, 1) + this.random_exponential(0, this.body_height / 3) : 0;
        int body_leg_height = this.leg_height + this.body_height;
        this.arm_size = this.clipMin(this.leg_size, this.random_linear(2, this.leg_size));
        this.arm_height = this.clipMin(body_leg_height - this.shoulder_start - 1, this.random_linear(this.body_height + 1 + this.leg_height / 2, (this.body_height + this.leg_height) * 3 / 4));
        this.body_arm_padding = this.random_exponential(0, 2);
        this.body_back_padding = this.random_linear(1, 2) + this.random_exponential(0, 3);
        this.body_front_padding = this.clipMax(0, this.random_linear(-4, 2));
        this.face_width = this.clipMax(3, this.leg_spread + this.random_linear(this.leg_size - 1, this.leg_size * 2));
        this.face_width += this.face_width % 2;
        this.face_height = this.clipMax(3, this.random_linear(this.body_height * 1 / 3, this.body_height * 3 / 5));
        this.face_depth = this.clipMax(2, (this.leg_size + this.body_back_padding) / 2);
        start = start.add(new DeltaCoord(0, 0, -this.leg_size - this.leg_spread / 2)).add(0, 0, -1);
        int radius = this.leg_size + (this.leg_spread + 1) / 2;
        this.start = ColossalBuilder.moveUp(start, radius);
    }

    static Coord moveUp(Coord start, int radius) {
        int max_iter = 32;
        Coord level = start.copy();
        while (max_iter-- > 0) {
            class Counter
            implements ICoordFunction {
                float total;
                float solid;
                final /* synthetic */ int val$radius;

                Counter(int n) {
                    this.val$radius = n;
                }

                boolean isClear(Coord at) {
                    Coord min = at.add(-this.val$radius, 0, -this.val$radius);
                    Coord max = at.add(this.val$radius, 0, this.val$radius);
                    Coord.iterateCube(min, max, this);
                    return this.isSufficientlyClear();
                }

                @Override
                public void handle(Coord here) {
                    this.total += 1.0f;
                    if (here.isReplacable()) {
                        return;
                    }
                    if (here.isAir()) {
                        return;
                    }
                    if (here.isSolid()) {
                        this.solid += 1.0f;
                    }
                }

                boolean isSufficientlyClear() {
                    return this.solid / this.total < 0.2f;
                }
            }
            if (new Counter(radius).isClear(level)) {
                return level;
            }
            ++level.y;
        }
        return start;
    }

    int clipMax(int ... vals) {
        int ret = vals[0];
        for (int val : vals) {
            ret = Math.max(ret, val);
        }
        return ret;
    }

    int clipMin(int ... vals) {
        int ret = vals[0];
        for (int val : vals) {
            ret = Math.min(ret, val);
        }
        return ret;
    }

    int random_choice(int ... options) {
        return options[this.rand.nextInt(options.length)];
    }

    int random_linear(int min, int max) {
        int spread;
        if (min == max) {
            return min;
        }
        if (max < min) {
            int low = max;
            int high = min;
            min = low;
            max = high;
        }
        if ((spread = max - min + 1) == 0) {
            return min;
        }
        return this.rand.nextInt(spread) + min;
    }

    int random_linear_odd(int min, int max) {
        int spread;
        if (min == max) {
            return min;
        }
        if (max < min) {
            int low = max;
            int high = min;
            min = low;
            max = high;
        }
        if ((spread = max - min + 1) == 0) {
            return min;
        }
        int ret = min;
        ret = this.rand.nextInt(spread) + min;
        if (ret % 2 == 0) {
            ret = ret == max ? max - 1 : ++ret;
        }
        return ret;
    }

    int random_exponential(int min, int max) {
        double r = this.rand.nextDouble();
        r *= r;
        double spread = max - min;
        return min + (int)(spread * r);
    }

    boolean maybe(double weight) {
        return this.rand.nextDouble() <= weight;
    }

    public void construct() {
        int face_center_adjust = (this.leg_size * 2 + this.leg_spread + 1 - this.face_width) / 2;
        Coord mask_start = this.start.add(this.leg_size + this.body_front_padding + 1, this.leg_height + 1 + this.body_height, face_center_adjust);
        Coord mask_end = mask_start.add(-this.face_depth, this.face_height, this.face_width);
        this.fill(mask_start, mask_end, MASK);
        Coord leg_start = this.start.copy();
        Coord leg_end = leg_start.add(this.leg_size, this.leg_height, this.leg_size);
        this.fill(leg_start, leg_end, LEG);
        DeltaCoord legDelta = new DeltaCoord(0, 0, this.leg_size + this.leg_spread + 1);
        leg_start.adjust(legDelta);
        leg_end.adjust(legDelta);
        this.fill(leg_start, leg_end, LEG);
        Coord body_inner_start = this.start.add(0, this.leg_height + 1, 0);
        Coord body_start = body_inner_start.add(-this.body_back_padding, 0, -this.body_arm_padding);
        Coord body_end = body_inner_start.add(this.leg_size + this.body_front_padding, this.body_height, this.leg_size * 2 + this.leg_spread + this.body_arm_padding + 1);
        this.fill(body_start, body_end, BODY);
        Coord arm_start = this.start.add(0, this.leg_height + 1 + this.body_height - this.shoulder_start, 0).add(0, 0, -this.body_arm_padding - 1).add(this.arm_size, 0, 0);
        if (this.leg_size > this.arm_size) {
            arm_start = arm_start.add((this.leg_size - this.arm_size) / 2, 0, 0);
        }
        Coord arm_end = arm_start.add(-this.arm_size, -this.arm_height, -this.arm_size);
        this.fill(arm_start, arm_end, ARM);
        DeltaCoord armDelta = new DeltaCoord(0, 0, (this.leg_size + 1) * 2 + this.leg_spread + this.body_arm_padding * 2 + this.arm_size + 1);
        arm_start.adjust(armDelta);
        arm_end.adjust(armDelta);
        this.fill(arm_start, arm_end, ARM);
        this.paintMask(ForgeDirection.UP);
        this.paintMask(ForgeDirection.DOWN);
        Coord standard_eyeball = this.start.add(this.leg_size + this.body_front_padding + 1, this.leg_height + 1 + this.body_height + this.face_height / 2, 1 + this.leg_size + this.leg_spread / 2);
        this.fill(standard_eyeball, standard_eyeball, EYE);
        Drawer drawer = new Drawer();
        drawer.generateBlob();
        drawer.applyBiomeDecorations();
        Coord heart_crack = this.start.add(this.leg_size + this.body_front_padding, this.leg_height + 1 + (this.body_height + 1) / 2, this.leg_size + (1 + this.leg_spread) / 2);
        Coord hc_front = heart_crack.add(ForgeDirection.EAST);
        if (MASK.matches(hc_front) || EYE.matches(hc_front)) {
            heart_crack.adjust(ForgeDirection.EAST);
            this.fill(heart_crack, heart_crack, MASK_CRACK);
        } else {
            this.fill(heart_crack, heart_crack, BODY_CRACK);
        }
        Coord heart = heart_crack.add(ForgeDirection.WEST);
        this.fill(heart, heart, HEART);
        TileEntityColossalHeart heartTe = new TileEntityColossalHeart();
        heartTe.loadInfoFromBuilder(this);
        heart.setTE(heartTe);
    }

    void fill(Coord min, Coord max, BlockState state) {
        min = min.copy();
        max = max.copy();
        Coord.sort(min, max);
        Coord at = min.copy();
        for (int x = min.x; x <= max.x; ++x) {
            at.x = x;
            for (int y = min.y; y <= max.y; ++y) {
                at.y = y;
                int z = min.z;
                while (z <= max.z) {
                    at.z = z++;
                    at.setIdMd(state.block, state.md, true);
                }
            }
        }
    }

    int get_width() {
        return (this.leg_size + 1) * 2 + this.leg_spread + this.body_arm_padding * 2 + (this.arm_size + 1) * 2 + 1;
    }

    int get_depth() {
        return this.leg_size + this.body_front_padding + this.body_back_padding;
    }

    int get_height() {
        return this.leg_height + 1 + this.body_height + this.face_height + 4;
    }

    void paintMask(ForgeDirection dir) {
        MaskTemplate mask = MaskLoader.pickMask(this.rand, dir, this.face_width + 1, this.face_width + 1);
        if (mask == null) {
            return;
        }
        int mask_start = (this.leg_spread + this.leg_size * 2 - this.face_width + 1) / 2;
        Coord mask_anchor = this.start.add(this.body_front_padding + this.leg_size + 1, this.leg_height + 1 + this.body_height - 1, mask_start);
        if (dir == ForgeDirection.DOWN) {
            mask_anchor = mask_anchor.add(0, this.face_height, 0);
        }
        Brush maskBrush = new Brush(MASK, Brush.BrushMask.ALL, this.rand);
        Brush eyeBrush = new Brush(EYE, Brush.BrushMask.ALL, this.rand);
        mask.paint(mask_anchor, maskBrush, eyeBrush);
    }

    class Drawer
    implements ICoordFunction {
        final int BORDER;
        final Coord body_inner_start;
        final Coord bodyStart;
        final Coord bodyEnd;
        int arm_ext;
        int max_radius;
        final Coord blobStart;
        final Coord blobEnd;
        final double[] noise;
        final DeltaCoord size;
        final double len;
        final HashSet<Coord> painted;
        double sum;
        int n;
        Coord work;

        Drawer() {
            this.BORDER = 2 + ColossalBuilder.this.leg_size * 7 / 3;
            this.body_inner_start = ColossalBuilder.this.start.add(0, ColossalBuilder.this.leg_height + 1, 0);
            this.bodyStart = this.body_inner_start.add(-ColossalBuilder.this.body_back_padding, 0, -ColossalBuilder.this.body_arm_padding);
            this.bodyEnd = this.body_inner_start.add(ColossalBuilder.this.leg_size + ColossalBuilder.this.body_front_padding, ColossalBuilder.this.body_height, ColossalBuilder.this.leg_size * 2 + ColossalBuilder.this.leg_spread + ColossalBuilder.this.body_arm_padding + 1);
            this.bodyEnd.add(0, (int)((double)(-ColossalBuilder.this.leg_size) * 0.5), 0);
            this.bodyStart.add(-ColossalBuilder.this.leg_size, 0, 0);
            Coord.sort(this.bodyStart, this.bodyEnd);
            ++this.bodyStart.y;
            this.arm_ext = 1 + ColossalBuilder.this.arm_size / 2;
            this.max_radius = ColossalBuilder.this.leg_size * 4;
            this.blobStart = this.bodyStart.add(-this.max_radius, -this.max_radius, -this.max_radius);
            this.blobEnd = this.bodyEnd.add(this.max_radius, this.max_radius, this.max_radius);
            this.painted = new HashSet();
            this.work = ColossalBuilder.this.start.copy();
            Coord.sort(this.blobStart, this.blobEnd);
            this.size = this.blobEnd.difference(this.blobStart);
            ++this.size.x;
            ++this.size.y;
            ++this.size.z;
            NoiseGeneratorOctaves noiseGen = new NoiseGeneratorOctaves(ColossalBuilder.this.rand, 2);
            this.noise = new double[this.size.x * this.size.y * this.size.z];
            double s = 0.00390625;
            noiseGen.func_76304_a(this.noise, this.blobStart.x, this.blobStart.y, this.blobStart.z, this.size.x, this.size.y, this.size.z, (double)this.blobEnd.x * s, (double)this.blobEnd.y * s, (double)this.blobEnd.z * s);
            for (int i = 0; i < this.noise.length; ++i) {
                this.noise[i] = (this.noise[i] + 1.0) / 2.0;
            }
            this.len = this.size.magnitude();
        }

        public void reset() {
            this.sum = 1.0;
            this.n = -1;
        }

        double sample(Coord here) {
            int x = here.x - this.blobStart.x;
            int y = here.y - this.blobStart.y;
            int z = here.z - this.blobStart.z;
            int idx = y + z * this.size.y + x * this.size.y * this.size.z;
            return this.noise[idx];
        }

        @Override
        public void handle(Coord here) {
            double s = this.sample(here);
            if (s > this.sum && here.isReplacable()) {
                here.setId(Blocks.field_150348_b);
                this.sum += (this.sum + s) / this.len;
            }
        }

        Coord clipToBody(Coord at) {
            this.work.set(at);
            at = this.work;
            if (at.x < this.bodyStart.x) {
                at.x = this.bodyStart.x;
            }
            if (at.y < this.bodyStart.y) {
                at.y = this.bodyStart.y;
            }
            if (at.z < this.bodyStart.z) {
                at.z = this.bodyStart.z;
            }
            if (at.x > this.bodyEnd.x) {
                at.x = this.bodyEnd.x;
            }
            if (at.y > this.bodyEnd.y) {
                at.y = this.bodyEnd.y;
            }
            if (at.z > this.bodyEnd.z) {
                at.z = this.bodyEnd.z;
            }
            return at;
        }

        void generateBlob() {
            Coord.iterateEmptyBox(this.bodyStart, this.bodyEnd, new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (here.x >= Drawer.this.bodyEnd.x - ColossalBuilder.this.leg_size / 2 || here.z == Drawer.this.bodyStart.z || here.z == Drawer.this.bodyEnd.z) {
                        return;
                    }
                    Drawer.this.reset();
                    double val = Drawer.this.sample(here);
                    Drawer.this.paint(here, (int)(val + 1.9));
                }
            });
        }

        void paint(Coord center, int r) {
            if (r <= 0) {
                return;
            }
            Coord at = center.copy();
            double rShrink = 0.99;
            if ((double)r > (double)this.max_radius * rShrink) {
                r = (int)((double)r * rShrink);
            }
            for (int dx = -r; dx <= r; ++dx) {
                at.x = center.x + dx;
                int hypotX = dx * dx;
                for (int dy = -r; dy <= r; ++dy) {
                    at.y = center.y + dy;
                    int hypotY = hypotX + dy * dy;
                    for (int dz = -r; dz <= r; ++dz) {
                        at.z = center.z + dz;
                        int hypotSq = hypotY + dz * dz;
                        double R = (double)r + this.sample(at) * 0.5;
                        if (!((double)hypotSq <= (R *= R))) continue;
                        this.draw(at);
                    }
                }
            }
        }

        void draw(Coord at) {
            if (at.x > this.bodyEnd.x) {
                return;
            }
            if (at.isReplacable()) {
                at.setId(Blocks.field_150348_b);
                this.painted.add(at.copy());
            }
        }

        void applyBiomeDecorations() {
            BiomeGenBase biome = null;
            Iterator<Coord> i$ = this.painted.iterator();
            if (i$.hasNext()) {
                Coord at = i$.next();
                biome = at.getBiome();
            }
            if (biome == null) {
                return;
            }
            ArrayList<Coord> sorted = new ArrayList<Coord>();
            sorted.addAll(this.painted);
            Collections.sort(sorted, new Comparator<Coord>(){

                @Override
                public int compare(Coord a, Coord b) {
                    if (a.x == b.x) {
                        return a.z - b.z;
                    }
                    return a.x - b.x;
                }
            });
            Object[] blocks = new Block[256];
            byte[] mds = new byte[256];
            double stoneNoise = ColossalBuilder.this.rand.nextDouble();
            Coord lastCol = null;
            for (Coord at : sorted) {
                if (lastCol == null || lastCol.x != at.x || lastCol.z != at.z) {
                    this.biomeifyBlocks(lastCol, (Block[])blocks, mds, biome, stoneNoise);
                    lastCol = at;
                    Arrays.fill(blocks, Blocks.field_150350_a);
                    Arrays.fill(mds, (byte)0);
                }
                blocks[at.y] = at.getBlock();
                mds[at.y] = (byte)at.getMd();
            }
            this.biomeifyBlocks(lastCol, (Block[])blocks, mds, biome, stoneNoise);
        }

        void biomeifyBlocks(Coord col, Block[] blocks, byte[] mds, BiomeGenBase biome, double stoneNoise) {
            if (col == null) {
                return;
            }
            biome.func_150573_a(col.w, ColossalBuilder.this.rand, blocks, mds, 0, 0, stoneNoise);
            Coord at = col.copy();
            boolean onSolid = false;
            for (int y = 0; y < blocks.length; ++y) {
                Block id = blocks[y];
                byte md = mds[y];
                if (id == Blocks.field_150357_h) continue;
                if (id == Blocks.field_150350_a) {
                    onSolid = false;
                    continue;
                }
                if (!onSolid && id instanceof BlockFalling) {
                    if (id == Blocks.field_150354_m) {
                        id = Blocks.field_150322_A;
                        md = 0;
                    } else {
                        id = Blocks.field_150348_b;
                        md = 0;
                    }
                }
                at.y = y;
                at.setIdMd(id, md, false);
                onSolid = true;
            }
        }
    }
}

