/*
 * Decompiled with CFR 0.152.
 */
package factorization.colossi;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.colossi.ColossusController;
import factorization.colossi.IStateMachine;
import factorization.colossi.LimbInfo;
import factorization.colossi.Technique;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.util.SpaceUtil;
import net.minecraft.block.Block;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public enum WalkState implements IStateMachine<WalkState>
{
    IDLE{
        final Technique[] idle_interrupters = new Technique[0];

        @Override
        protected Technique[] getInterrupters() {
            return this.idle_interrupters;
        }

        @Override
        public WalkState tick(ColossusController controller, int age) {
            return controller.atTarget() ? this : TURN;
        }
    }
    ,
    TURN{
        final Technique[] turn_interrupters = new Technique[]{Technique.DEATH_FALL};

        @Override
        protected Technique[] getInterrupters() {
            return this.turn_interrupters;
        }

        @Override
        public void onEnterState(ColossusController controller, WalkState prevState) {
            this.checkRotation(controller);
            double arms_angle = 1.413716694115407;
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null || limb.type != ColossusController.LimbType.ARM) continue;
                if (limb.side == ColossusController.BodySide.LEFT ^ controller.turningDirection == 1) {
                    limb.target(new Quaternion(), 1.0);
                } else {
                    double arm_angle = 1.413716694115407 * (double)(limb.side == ColossusController.BodySide.LEFT ? 1 : -1);
                    Quaternion ar = Quaternion.getRotationQuaternionRadians(arm_angle, ForgeDirection.EAST);
                    limb.target(ar, 1.0);
                }
                limb.creak();
            }
        }

        @Override
        public WalkState tick(ColossusController controller, int age) {
            if (this.interruptWalk(controller)) {
                return IDLE;
            }
            if (controller.atTarget() || controller.targetChanged()) {
                return IDLE;
            }
            this.playStepSounds(controller, age);
            if (!controller.body.hasOrderedRotation()) {
                return this.checkRotation(controller);
            }
            double base_twist = 0.18849555921538758;
            double phase_length = 36.0;
            for (LimbInfo limb : controller.limbs) {
                IDeltaChunk idc = limb.idc.getEntity();
                if (idc == null || limb.isTurning() || limb.type != ColossusController.LimbType.LEG) continue;
                double nextRotation = base_twist;
                double nextRotationTime = phase_length;
                limb.lastTurnDirection = (byte)(limb.lastTurnDirection * -1);
                Interpolation interp = Interpolation.SMOOTH;
                if (limb.lastTurnDirection == 0) {
                    limb.lastTurnDirection = (byte)(controller.turningDirection * (limb.limbSwingParity() ? 1 : -1));
                }
                if (limb.lastTurnDirection == 1 ^ limb.limbSwingParity()) {
                    interp = Interpolation.CUBIC;
                }
                Quaternion nr = Quaternion.getRotationQuaternionRadians(nextRotation *= (double)limb.lastTurnDirection, ForgeDirection.DOWN);
                if (limb.lastTurnDirection == controller.turningDirection) {
                    nr.incrMultiply(Quaternion.getRotationQuaternionRadians(Math.toRadians(2.0), ForgeDirection.SOUTH));
                }
                limb.setTargetRotation(nr, (int)nextRotationTime, interp);
                limb.creak();
            }
            return this;
        }

        WalkState checkRotation(ColossusController controller) {
            int size;
            double rotation_speed;
            Quaternion current_rotation;
            if (controller.atTarget()) {
                return IDLE;
            }
            IDeltaChunk body = controller.body;
            Vec3 target = controller.getTarget().createVector();
            target.field_72448_b = controller.field_70163_u;
            Vec3 me = SpaceUtil.fromEntPos(body);
            Vec3 delta = me.func_72444_a(target);
            double angle = Math.atan2(delta.field_72450_a, delta.field_72449_c) - 1.5707963267948966;
            Quaternion target_rotation = Quaternion.getRotationQuaternionRadians(angle, ForgeDirection.UP);
            double rotation_distance = target_rotation.getAngleBetween(current_rotation = body.getRotation());
            double rotation_time = rotation_distance / (rotation_speed = Math.PI * 2 / (double)(360 * (size = controller.leg_size + 1) * 2));
            if (rotation_time >= 1.0) {
                controller.bodyLimbInfo.setTargetRotation(target_rotation, (int)rotation_time, Interpolation.SMOOTH);
                controller.turningDirection = angle > 0.0 ? 1 : -1;
                for (LimbInfo li : controller.limbs) {
                    li.lastTurnDirection = 0;
                }
            } else if (rotation_time > 0.001) {
                body.setRotation(target_rotation);
                body.setRotationalVelocity(new Quaternion());
            } else {
                return FORWARD;
            }
            return TURN;
        }

        @Override
        public void onExitState(ColossusController controller, WalkState nextState) {
            controller.turningDirection = 0;
            controller.resetLimbs(20, Interpolation.SMOOTH);
            controller.body.field_70181_x = 0.0;
        }
    }
    ,
    FORWARD{
        final Technique[] forward_interrupters = new Technique[]{Technique.DEATH_FALL, Technique.HIT_WITH_LIMB};
        private final double max_leg_swing_degrees = 22.5;
        private final double max_leg_swing_radians = Math.toRadians(22.5);
        private final Quaternion arm_hang = Quaternion.getRotationQuaternionRadians(Math.toRadians(5.0), ForgeDirection.EAST);
        private final int SPEED = 2;
        private final double MAX_WALK_SPEED = 0.1;

        @Override
        protected Technique[] getInterrupters() {
            return this.forward_interrupters;
        }

        @Override
        public void onEnterState(ColossusController controller, WalkState prevState) {
            if (controller.atTarget()) {
                return;
            }
            IDeltaChunk body = controller.body;
            Vec3 target = controller.getTarget().createVector();
            target.field_72448_b = controller.field_70163_u;
            Vec3 me = SpaceUtil.fromEntPos(body);
            Vec3 delta = me.func_72444_a(target);
            double walk_speed = Math.min(0.1, delta.func_72433_c());
            delta = delta.func_72432_b();
            body.field_70159_w = delta.field_72450_a * walk_speed;
            body.field_70179_y = delta.field_72449_c * walk_speed;
            controller.walked += walk_speed;
            controller.resetLimbs(20, Interpolation.SMOOTH);
        }

        @Override
        public WalkState tick(ColossusController controller, int age) {
            if (this.interruptWalk(controller)) {
                return IDLE;
            }
            if (controller.atTarget() || controller.targetChanged()) {
                return IDLE;
            }
            this.playStepSounds(controller, age);
            double legCircumference = Math.PI * 2 * (double)controller.leg_size;
            double swingTime = legCircumference * 360.0 / 90.0;
            for (LimbInfo limb : controller.limbs) {
                int p;
                IDeltaChunk idc;
                if (limb.type != ColossusController.LimbType.LEG && limb.type != ColossusController.LimbType.ARM || limb.isTurning() || (idc = limb.idc.getEntity()) == null) continue;
                double nextRotationTime = swingTime;
                int n = p = limb.limbSwingParity() ? 1 : -1;
                if (limb.lastTurnDirection == 0) {
                    nextRotationTime /= 2.0;
                    limb.lastTurnDirection = (byte)p;
                } else {
                    limb.lastTurnDirection = (byte)(limb.lastTurnDirection * -1);
                    p = limb.lastTurnDirection;
                }
                if (controller.walked == 0.0) {
                    p = 0;
                }
                Quaternion nextRotation = Quaternion.getRotationQuaternionRadians(this.max_leg_swing_radians * (double)p, ForgeDirection.NORTH);
                if (limb.type == ColossusController.LimbType.ARM) {
                    if (limb.side == ColossusController.BodySide.LEFT) {
                        nextRotation.incrMultiply(this.arm_hang);
                    } else {
                        nextRotation.incrMultiply(this.arm_hang.conjugate());
                    }
                }
                limb.setTargetRotation(nextRotation, (int)nextRotationTime, Interpolation.SMOOTH);
                limb.creak();
            }
            return this;
        }

        @Override
        public void onExitState(ColossusController controller, WalkState nextState) {
            controller.resetLimbs(20, Interpolation.SMOOTH);
            IDeltaChunk body = controller.body;
            body.field_70179_y = 0.0;
            body.field_70159_w = 0.0;
            body.field_70181_x = 0.0;
        }
    };


    @Override
    public abstract WalkState tick(ColossusController var1, int var2);

    @Override
    public void onEnterState(ColossusController controller, WalkState prevState) {
    }

    @Override
    public void onExitState(ColossusController controller, WalkState nextState) {
    }

    protected abstract Technique[] getInterrupters();

    boolean interruptWalk(ColossusController controller) {
        for (Technique tech : this.getInterrupters()) {
            if (!tech.usable(controller)) continue;
            if (controller.ai_controller.getState() == tech) break;
            controller.ai_controller.forceState(tech);
            controller.setTarget(null);
            return true;
        }
        return false;
    }

    void playStepSounds(ColossusController controller, int age) {
        if (age % 35 != 0) {
            return;
        }
        for (LimbInfo limb : controller.limbs) {
            Block.SoundType sound2;
            IDeltaChunk idc;
            if (limb.type != ColossusController.LimbType.LEG || (idc = limb.idc.getEntity()) == null) continue;
            Coord min = idc.getCorner();
            Coord max = idc.getFarCorner();
            Coord.sort(min, max);
            max.y = min.y;
            Vec3 shadowFoot = min.centerVec(max);
            Vec3 realFoot = idc.shadow2real(shadowFoot);
            Coord stomped = new Coord(controller.field_70170_p, realFoot);
            --stomped.y;
            if (stomped.isAir() || (sound2 = stomped.getBlock().field_149762_H) == null) continue;
            idc.field_70170_p.func_72908_a(realFoot.field_72450_a, realFoot.field_72448_b, realFoot.field_72449_c, sound2.func_150498_e(), sound2.func_150494_d() * 0.9f, sound2.func_150497_c() * 1.1f);
        }
    }
}

