/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.IWorldGenerator;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.common.FzConfig;
import factorization.shared.Core;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class DarkIronOreGenerator
implements IWorldGenerator {
    final int minMeteorR = 1;
    final int maxMeteorR = 2;
    final int maxWidth = 4;
    final int minBlastR = 20;
    final int maxBlastR = 28;
    final NoiseGeneratorOctaves noise = new NoiseGeneratorOctaves(new Random(0L), 2);
    double[] samples = new double[64];
    Block stoneId;
    int stoneMd;
    double rSq;
    double rSqEnd;
    Coord origin;
    Coord corner;
    int blobSize;
    ICoordFunction paintMeteor = new ICoordFunction(){

        @Override
        public void handle(Coord here) {
            int sz;
            int sy;
            int sx;
            double sample;
            if (here.y < 0) {
                return;
            }
            double distSq = here.distanceSq(DarkIronOreGenerator.this.origin);
            if (distSq > DarkIronOreGenerator.this.rSqEnd) {
                return;
            }
            if (distSq > DarkIronOreGenerator.this.rSq && (sample = DarkIronOreGenerator.this.samples[(sx = here.x - DarkIronOreGenerator.this.corner.x) * DarkIronOreGenerator.this.blobSize * DarkIronOreGenerator.this.blobSize + (sy = here.y - DarkIronOreGenerator.this.corner.y) * DarkIronOreGenerator.this.blobSize + (sz = here.z - DarkIronOreGenerator.this.corner.z)]) < 0.0) {
                return;
            }
            if (here.y == 0) {
                here.setId(Core.registry.fractured_bedrock_block, false);
            } else {
                here.setId(Core.registry.dark_iron_ore, false);
            }
        }
    };
    Coord blastOrigin;
    ICoordFunction paintBlast = new ICoordFunction(){

        @Override
        public void handle(Coord here) {
            double distSq = here.distanceSq(DarkIronOreGenerator.this.blastOrigin);
            if (distSq > DarkIronOreGenerator.this.rSq) {
                return;
            }
            if (here.getBlock() == Blocks.field_150357_h) {
                here.setIdMd(DarkIronOreGenerator.this.stoneId, DarkIronOreGenerator.this.stoneMd, false);
            }
        }
    };
    ICoordFunction burnBlast = new ICoordFunction(){

        @Override
        public void handle(Coord here) {
            if (here.getBlock() != Blocks.field_150357_h) {
                return;
            }
            double distSq = here.distanceSq(DarkIronOreGenerator.this.origin);
            double threshold = Math.sqrt(distSq) / Math.sqrt(DarkIronOreGenerator.this.rSqEnd);
            if ((double)(here.w.field_73012_v.nextFloat() * 5.0f) > threshold) {
                here.setIdMd(Core.registry.blasted_bedrock_block, 1, false);
            }
        }
    };

    boolean base(int x, int z) {
        boolean a = (x / 4 + z / 4) % 3 == 0;
        boolean b = x % 4 == 0 && z % 4 == 0;
        return a && b;
    }

    boolean rule(int x, int z) {
        if (x < 0) {
            x = -x;
        }
        if (z < 0) {
            z = -z;
        }
        int n = -1;
        int N = ((x - 1) / 8 + (z + 1) / 8) % 4;
        if (this.base(x, z)) {
            n = 0;
        } else if (this.base(x + 1, z)) {
            n = 1;
        } else if (this.base(x, z + 1)) {
            n = 2;
        } else if (this.base(x + 1, z + 1)) {
            n = 3;
        } else {
            return false;
        }
        return N == n;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int x;
        int z;
        if (!FzConfig.gen_dark_iron_ore) {
            return;
        }
        if (!world.field_73011_w.func_76569_d()) {
            return;
        }
        if (!this.rule(chunkX, chunkZ)) {
            return;
        }
        if (chunkX == 0 && chunkZ == 0) {
            z = 0;
            x = 0;
        } else {
            x = chunkX * 16 + random.nextInt(16);
            z = chunkZ * 16 + random.nextInt(16);
        }
        if (world.func_147439_a(x, 0, z) != Blocks.field_150357_h) {
            return;
        }
        for (int y = 1; y < 8; ++y) {
            this.stoneId = world.func_147439_a(x, y, z);
            if (this.stoneId == Blocks.field_150357_h) continue;
            if (this.stoneId.isReplaceableOreGen(world, x, 1, z, Blocks.field_150348_b)) {
                this.stoneMd = world.func_72805_g(x, 1, z);
                break;
            }
            this.stoneId = null;
        }
        if (this.stoneId == null) {
            return;
        }
        int meteorRadius = random.nextInt(1) + 1;
        Coord origin = new Coord(world, x, 1, z);
        this.meteorBlob(origin, meteorRadius);
        int blastRadius = random.nextInt(8) + 20;
        this.meteorBlast(origin, blastRadius);
        this.origin = null;
    }

    void meteorBlob(Coord origin, int r) {
        this.origin = origin;
        this.rSq = r * r;
        this.rSqEnd = (r + 1) * (r + 1);
        this.blobSize = r * 2;
        int d = r;
        this.samples = this.noise.func_76304_a(this.samples, origin.x, origin.y, origin.z, this.blobSize, this.blobSize, this.blobSize, (double)(origin.x + d), (double)(origin.y + d), (double)(origin.z + d));
        Coord min = origin.add(-r, -r, -r);
        Coord max = origin.add(r, r, r);
        this.corner = min;
        Coord.iterateCube(min, max, this.paintMeteor);
    }

    void meteorBlast(Coord origin, int r) {
        int blastHeight = 7;
        this.blastOrigin = origin.add(0, r - 2, 0);
        this.rSq = r * r;
        this.rSqEnd = blastHeight * blastHeight;
        Coord min = origin.add(-r, 0, -r);
        Coord max = origin.add(r, blastHeight, r);
        Coord.iterateCube(min, max, this.paintBlast);
        min.y = 0;
        min.adjust(-r / 3, 0, -r / 3);
        max.adjust(r / 3, 0, r / 3);
        Coord.iterateCube(min, max, this.burnBlast);
    }
}

