/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.registry.EntityRegistry;
import factorization.shared.Core;
import factorization.shared.Graylist;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class FzConfig {
    public static Configuration config;
    public static boolean render_barrel_item;
    public static boolean render_barrel_text;
    public static boolean render_barrel_use_displaylists;
    public static boolean render_barrel_close;
    public static int entity_relight_task_id;
    public static boolean gen_silver_ore;
    public static boolean gen_dark_iron_ore;
    public static int silver_ore_node_new_size;
    public static boolean gen_colossi;
    public static int colossus_spacing;
    public static boolean pocket_craft_anywhere;
    public static String pocketActions;
    public static boolean renderTEs;
    public static boolean renderAO;
    public static boolean add_branding;
    public static boolean debug_light_air;
    public static boolean dimension_slice_allow_smooth;
    public static boolean boilers_suck_water;
    public static double steam_output_adjust;
    public static boolean enable_cheat_commands;
    public static boolean enable_sketchy_client_commands;
    public static int tps_reporting_interval;
    public static boolean use_tps_reports;
    public static float lowest_dilation;
    public static boolean lagssie_watcher;
    public static boolean limit_integrated_server;
    public static double lagssie_interval;
    public static int max_rocket_base_size;
    public static int max_rocket_height;
    public static boolean stretchy_clay;
    public static boolean equal_opportunities_for_mobs;
    public static boolean fix_middle_click;
    public static boolean embarken_wood;
    public static boolean mushroomalize;
    public static boolean proper_projectile_physics;
    public static boolean buffed_nametags;
    public static boolean enable_solar_steam;
    public static boolean fanturpeller_works_on_players;
    public static boolean large_servo_instructions;
    public static boolean players_discover_colossus_guides;
    public static boolean disable_endermen_griefing;
    public static boolean debug_fzds_collisions;
    public static boolean enable_rocketry;
    public static boolean sockets_ignore_front_redstone;
    public static boolean show_time_on_fullscreen;
    public static boolean require_book_for_manual;
    public static boolean infinite_guide_usage;
    public static Graylist<Block> lacerator_block_graylist;
    public static boolean enable_retrogen;
    public static String retrogen_key;
    public static boolean retrogen_silver;
    public static boolean retrogen_dark_iron;
    public static boolean loaded;

    private int getIntConfig(String name2, String category, int defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultValue);
    }

    private boolean getBoolConfig(String name2, String category, boolean defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getBoolean(defaultValue);
    }

    private double getDoubleConfig(String name2, String category, double defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getDouble(defaultValue);
    }

    private String getStringConfig(String name2, String category, String defaultValue, String comment) {
        Property prop = config.get(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        this.loadConfig(null);
    }

    public void reload() {
        loaded = false;
        this.load();
    }

    public void loadConfig(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
        }
        catch (Exception e) {
            Core.logWarning("Error loading config: %s", e.toString());
            e.printStackTrace();
        }
        debug_light_air = this.getBoolConfig("debugLightAir", "client", debug_light_air, "Show invisible lamp-air");
        pocket_craft_anywhere = this.getBoolConfig("anywherePocketCraft", "client", pocket_craft_anywhere, "Lets you open the pocket crafting table from GUIs");
        render_barrel_item = this.getBoolConfig("renderBarrelItem", "client", render_barrel_item, null);
        render_barrel_item = this.getBoolConfig("renderBarrelText", "client", render_barrel_text, null);
        render_barrel_close = this.getBoolConfig("renderBarrelClose", "client", render_barrel_close, "If true, render barrel info only when nearby");
        renderTEs = this.getBoolConfig("renderOtherTileEntities", "client", renderTEs, "If false, most TEs won't draw, making everything look broken but possibly improving FPS");
        renderAO = this.getBoolConfig("renderAmbientOcclusion", "client", renderAO, "If false, never use smooth lighting for drawing sculptures");
        String attempt = this.getStringConfig("pocketCraftingActionKeys", "client", pocketActions, "3 keys for: removing (x), cycling (c), balancing (b)");
        if (attempt.length() == pocketActions.length()) {
            pocketActions = attempt;
        } else {
            Property p = config.get("pocketCraftingActionKeys", "client", pocketActions);
            p.set(pocketActions);
            p.comment = pocketActions.length() + " keys for: removing (x), cycling (c), balancing (b), filling (f)";
        }
        enable_sketchy_client_commands = this.getBoolConfig("allowUnpureCommands", "client", enable_sketchy_client_commands, null);
        use_tps_reports = this.getBoolConfig("useTimeDilation", "client", use_tps_reports, "If this is enabled, the client will run as slowly as the server does. This avoids visual artifacts on laggy servers.");
        lowest_dilation = (float)this.getDoubleConfig("lowestTimeDilation", "client", lowest_dilation, "Sets a lower bound on time dilation. Between 0 and 1.");
        lowest_dilation = Math.max(1.0f, Math.min(0.0f, lowest_dilation));
        lagssie_watcher = this.getBoolConfig("enableLagWatchDog", "client", lagssie_watcher, "If true, enables a thread that dumps a stack trace of Minecraft if it is paused for longer than lagWatchDogInterval");
        lagssie_interval = this.getDoubleConfig("lagWatchDogInterval", "client", lagssie_interval, "If the game is stuck for longer than this amount of time (in seconds), dump a stacktrace of what it is doing.");
        limit_integrated_server = this.getBoolConfig("limitIntegratedServer", "client", limit_integrated_server, "(Broken; don't use this. Attempts to limit integrated server tick speed to match the client's, but can cause deadlocks.)");
        fix_middle_click = this.getBoolConfig("fixPickBlock", "client", fix_middle_click, "Make middle clicking more useful");
        large_servo_instructions = this.getBoolConfig("largeServoInstructions", "client", large_servo_instructions, "Render servo instructions extra-large. This can also be toggled on and off using '/f servoInstructionSize'.");
        show_time_on_fullscreen = this.getBoolConfig("showTimeOnFullscreen", "client", show_time_on_fullscreen, "If true, show the time every half hour");
        add_branding = this.getBoolConfig("addBranding", "general", add_branding, null);
        gen_silver_ore = this.getBoolConfig("generateSilverOre", "general", gen_silver_ore, "Set to false to disable silver ore generation");
        int config_silver_size = this.getIntConfig("silverOreNodeNewSize", "general", silver_ore_node_new_size, "The size of silver ore nodes. Between 5 & 35. Default is " + silver_ore_node_new_size);
        silver_ore_node_new_size = Math.max(5, Math.min(config_silver_size, 35));
        gen_dark_iron_ore = this.getBoolConfig("generateDarkIronOre", "general", gen_dark_iron_ore, "Set to false to disable dark iron ore generation");
        gen_colossi = this.getBoolConfig("generateColossi", "general", gen_colossi, "If true, Colossi will generate in the world. If false, the player will be given an LMP instead of a lost map.");
        colossus_spacing = this.getIntConfig("colossusSpacing", "general", colossus_spacing, "Distance between colossi in chunks");
        enable_retrogen = this.getBoolConfig("enableRetrogen", "retrogen", enable_retrogen, null);
        retrogen_key = this.getStringConfig("retrogenKey", "retrogen", retrogen_key, null);
        retrogen_silver = this.getBoolConfig("retrogenSilver", "retrogen", retrogen_silver, null);
        retrogen_dark_iron = this.getBoolConfig("retrogenDarkIron", "retrogen", retrogen_dark_iron, null);
        entity_relight_task_id = config.get("general", "entityRelightTask", -1).getInt();
        if (entity_relight_task_id == -1) {
            entity_relight_task_id = EntityRegistry.findGlobalUniqueEntityId();
            Property prop = config.get("general", "entityRelightTask", entity_relight_task_id);
            prop.set(entity_relight_task_id);
        }
        boilers_suck_water = this.getBoolConfig("boilersSuckWater", "server", boilers_suck_water, "If false, water must be piped in");
        disable_endermen_griefing = this.getBoolConfig("disableEndermenGriefing", "server", disable_endermen_griefing, "If set to true, then endermen will not pick up blocks.");
        steam_output_adjust = this.getDoubleConfig("steamOutputAdjustment", "server", steam_output_adjust, "Scale how much steam is produced by the solar boiler");
        stretchy_clay = this.getBoolConfig("stretchyClay", "server", stretchy_clay, "If true, maximum clay lump volume is 1 m\u00b3 instead of (1 m\u00b3)/4");
        tps_reporting_interval = this.getIntConfig("tpsReportInterval", "server", tps_reporting_interval, "How many ticks the server will wait before sending out TPS reports. 20 ticks = 1 second, unless it's lagging.");
        equal_opportunities_for_mobs = this.getBoolConfig("equalOpportunitiesForMobs", "server", equal_opportunities_for_mobs, "Causes some mobs to rarely spawn wearing your armor");
        embarken_wood = this.getBoolConfig("barkRecipes", "server", embarken_wood, "Adds recipes for bark variants of logs");
        mushroomalize = this.getBoolConfig("mushroomNormalize", "server", mushroomalize, "Textures giant mushroom blocks when placed");
        proper_projectile_physics = this.getBoolConfig("properProjectilePhysics", "server", proper_projectile_physics, "Makes projectiles start with the velocity of the thrower");
        buffed_nametags = this.getBoolConfig("buffedNametags", "server", buffed_nametags, "Naming entities gives them +5 hearts");
        players_discover_colossus_guides = this.getBoolConfig("playersDiscoverColossusGuides", "server", players_discover_colossus_guides, "If set to true, players will find a lost map after getting the diamonds achievement");
        infinite_guide_usage = this.getBoolConfig("infiniteGuideUse", "server", infinite_guide_usage, "If set to true, the Lost Map won't take damage");
        enable_solar_steam = this.getBoolConfig("enableSolarSteam", "server", enable_solar_steam, "Set to false to disable the crafting recipe for solar2steam machines");
        fanturpeller_works_on_players = this.getBoolConfig("fanturpellerWorksOnPlayers", "server", fanturpeller_works_on_players, "If set to false, fanturpellers will not move players.");
        sockets_ignore_front_redstone = this.getBoolConfig("socketsIgnoreFacePower", "server", sockets_ignore_front_redstone, "Set to false to let socket blocks detect redstone from their front; provided for legacy worlds.");
        require_book_for_manual = this.getBoolConfig("requireBookForManual", "general", require_book_for_manual, "If set to true, then you must have a manual in your inventory to look up items");
        lacerator_block_graylist = Graylist.ofBlocks(this.getStringConfig("laceratorBlockGraylist", "server", "-minecraft:bedrock,minecraft:end_portal", "Comma-separated list of block names. In front of the list must be either a +, for white-listing, or a -, for black-listing."));
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        render_barrel_item = true;
        render_barrel_text = true;
        render_barrel_use_displaylists = true;
        render_barrel_close = false;
        entity_relight_task_id = -1;
        gen_silver_ore = true;
        gen_dark_iron_ore = true;
        silver_ore_node_new_size = 18;
        gen_colossi = true;
        colossus_spacing = 48;
        pocket_craft_anywhere = true;
        pocketActions = "xcbf";
        renderTEs = true;
        renderAO = true;
        add_branding = false;
        debug_light_air = false;
        dimension_slice_allow_smooth = true;
        boilers_suck_water = true;
        steam_output_adjust = 1.0;
        enable_cheat_commands = Core.dev_environ;
        enable_sketchy_client_commands = true;
        tps_reporting_interval = 20;
        use_tps_reports = true;
        lowest_dilation = 0.6f;
        lagssie_watcher = false;
        limit_integrated_server = false;
        lagssie_interval = 0.25;
        max_rocket_base_size = 400;
        max_rocket_height = 64;
        stretchy_clay = true;
        equal_opportunities_for_mobs = true;
        fix_middle_click = true;
        embarken_wood = true;
        mushroomalize = true;
        proper_projectile_physics = true;
        buffed_nametags = true;
        enable_solar_steam = true;
        fanturpeller_works_on_players = true;
        large_servo_instructions = false;
        players_discover_colossus_guides = true;
        disable_endermen_griefing = false;
        debug_fzds_collisions = false;
        enable_rocketry = Core.dev_environ;
        sockets_ignore_front_redstone = true;
        show_time_on_fullscreen = true;
        require_book_for_manual = true;
        infinite_guide_usage = false;
        enable_retrogen = false;
        retrogen_key = "DEFAULT";
        retrogen_silver = false;
        retrogen_dark_iron = false;
        loaded = false;
    }
}

