/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.ExistingSubstitutionException;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IActOnCraft;
import factorization.ceramics.ItemGlazeBucket;
import factorization.ceramics.ItemSculptingTool;
import factorization.ceramics.TileEntityGreenware;
import factorization.charge.ItemAcidBottle;
import factorization.charge.ItemBattery;
import factorization.charge.ItemChargeMeter;
import factorization.colossi.ColossalBlock;
import factorization.colossi.ColossalBlockItem;
import factorization.colossi.GargantuanBlock;
import factorization.colossi.ItemColossusGuide;
import factorization.colossi.ItemGargantuanBlock;
import factorization.colossi.TileEntityColossalHeart;
import factorization.common.BlastedBedrock;
import factorization.common.BlockResource;
import factorization.common.FactoryType;
import factorization.common.FracturedBedrock;
import factorization.common.FzConfig;
import factorization.common.ItemBlockResource;
import factorization.common.ResourceType;
import factorization.common.WorldgenManager;
import factorization.darkiron.BlockDarkIronOre;
import factorization.docs.ItemDocBook;
import factorization.oreprocessing.ItemOreProcessing;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.oreprocessing.TileEntityGrinder;
import factorization.oreprocessing.TileEntitySlagFurnace;
import factorization.servo.ItemCommenter;
import factorization.servo.ItemMatrixProgrammer;
import factorization.servo.ItemServoMotor;
import factorization.servo.ItemServoRailWidget;
import factorization.servo.ServoComponent;
import factorization.shared.BlockClass;
import factorization.shared.BlockFactorization;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.ItemBlockProxy;
import factorization.shared.ItemCraftingComponent;
import factorization.shared.ItemFactorizationBlock;
import factorization.sockets.ItemSocketPart;
import factorization.twistedblock.ItemTwistedBlock;
import factorization.util.CraftUtil;
import factorization.util.DataUtil;
import factorization.util.FzUtil;
import factorization.util.ItemUtil;
import factorization.utiligoo.ItemGoo;
import factorization.weird.ItemDayBarrel;
import factorization.weird.ItemPocketTable;
import factorization.weird.TileEntityDayBarrel;
import factorization.wrath.BlockLightAir;
import factorization.wrath.TileEntityWrathLamp;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Registry {
    public ItemFactorizationBlock item_factorization;
    public ItemBlockResource item_resource;
    public BlockFactorization factory_block;
    public BlockFactorization factory_rendering_block;
    public BlockRenderHelper blockRender = null;
    public BlockRenderHelper serverTraceHelper = null;
    public BlockRenderHelper clientTraceHelper = null;
    public BlockLightAir lightair_block;
    public BlockResource resource_block;
    public Block dark_iron_ore;
    public Block fractured_bedrock_block;
    public Block blasted_bedrock_block;
    public Block colossal_block;
    public Block gargantuan_block;
    public ItemStack servorail_item;
    public ItemStack empty_socket_item;
    public ItemStack socket_lacerator;
    public ItemStack socket_robot_hand;
    public ItemStack socket_shifter;
    public ItemStack stamper_item;
    public ItemStack packager_item;
    public ItemStack daybarrel_item_hidden;
    public ItemStack lamp_item;
    public ItemStack air_item;
    public ItemStack slagfurnace_item;
    public ItemStack battery_item_hidden;
    public ItemStack leydenjar_item;
    public ItemStack leydenjar_item_full;
    public ItemStack heater_item;
    public ItemStack steamturbine_item;
    public ItemStack solarboiler_item;
    public ItemStack caliometric_burner_item;
    public ItemStack mirror_item_hidden;
    public ItemStack leadwire_item;
    public ItemStack mixer_item;
    public ItemStack crystallizer_item;
    public ItemStack greenware_item;
    public ItemStack rocket_engine_item_hidden;
    public ItemStack parasieve_item;
    public ItemStack compression_crafter_item;
    public ItemStack silver_ore_item;
    public ItemStack silver_block_item;
    public ItemStack lead_block_item;
    public ItemStack dark_iron_block_item;
    public ItemStack is_factory;
    public ItemStack is_lamp;
    public ItemStack is_lightair;
    public ItemPocketTable pocket_table;
    public ItemCraftingComponent diamond_shard;
    public ItemCraftingComponent silver_ingot;
    public ItemCraftingComponent lead_ingot;
    public ItemCraftingComponent dark_iron;
    public ItemAcidBottle acid;
    public ItemCraftingComponent insulated_coil;
    public ItemCraftingComponent motor;
    public ItemCraftingComponent fan;
    public ItemCraftingComponent diamond_cutting_head;
    public ItemCraftingComponent corkscrew;
    public ItemStack sulfuric_acid;
    public ItemStack aqua_regia;
    public ItemChargeMeter charge_meter;
    public ItemBlockProxy mirror;
    public ItemBattery battery;
    public ItemOreProcessing ore_dirty_gravel;
    public ItemOreProcessing ore_clean_gravel;
    public ItemOreProcessing ore_reduced;
    public ItemOreProcessing ore_crystal;
    public ItemCraftingComponent sludge;
    public ItemSculptingTool sculpt_tool;
    public ItemGlazeBucket glaze_bucket;
    public ItemStack empty_glaze_bucket;
    public ItemStack base_common;
    public ItemStack glaze_base_mimicry;
    public ItemCraftingComponent logicMatrix;
    public ItemCraftingComponent logicMatrixIdentifier;
    public ItemCraftingComponent logicMatrixController;
    public ItemMatrixProgrammer logicMatrixProgrammer;
    public Fluid steamFluid;
    public ItemCraftingComponent nether_powder;
    public ItemCraftingComponent rocket_fuel;
    public ItemBlockProxy rocket_engine;
    public ItemServoMotor servo_placer;
    public ItemServoRailWidget servo_widget_instruction;
    public ItemServoRailWidget servo_widget_decor;
    public ItemStack dark_iron_sprocket;
    public ItemStack servo_motor;
    public ItemCraftingComponent giant_scissors;
    public ItemDayBarrel daybarrel;
    @Deprecated
    public ItemSocketPart socket_part;
    public ItemCraftingComponent instruction_plate;
    public ItemCommenter servo_rail_comment_editor;
    public ItemDocBook docbook;
    public ItemGoo utiligoo;
    public ItemColossusGuide colossusGuide;
    public ItemTwistedBlock twistedBlock;
    public Material materialMachine = new Material(MapColor.field_151668_h);
    WorldgenManager worldgenManager;
    public static HashMap<String, Item> nameCleanup = new HashMap();

    static void registerItem(Item item) {
        String find = Matcher.quoteReplacement("item.factorization:");
        String unlocalizedName = item.func_77658_a();
        String useName = unlocalizedName.replaceFirst(find, "");
        GameRegistry.registerItem((Item)item, (String)useName, (String)"factorization");
        nameCleanup.put("factorization:" + unlocalizedName, item);
    }

    public void makeBlocks() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.blockRender = new BlockRenderHelper();
            this.factory_rendering_block = new BlockFactorization();
        }
        this.serverTraceHelper = new BlockRenderHelper();
        this.clientTraceHelper = new BlockRenderHelper();
        this.factory_block = new BlockFactorization();
        this.lightair_block = new BlockLightAir();
        this.resource_block = new BlockResource();
        this.dark_iron_ore = new BlockDarkIronOre().func_149663_c("factorization:darkIronOre").func_149658_d("stone").func_149647_a(Core.tabFactorization).func_149711_c(3.0f).func_149752_b(5.0f);
        this.fractured_bedrock_block = new FracturedBedrock();
        this.blasted_bedrock_block = new BlastedBedrock();
        this.colossal_block = new ColossalBlock();
        this.gargantuan_block = new GargantuanBlock().func_149663_c("factorization:gargantuanBrick").func_149647_a(Core.tabFactorization);
        GameRegistry.registerBlock((Block)this.factory_block, ItemFactorizationBlock.class, (String)"FzBlock");
        GameRegistry.registerBlock((Block)this.lightair_block, (String)"Lightair");
        GameRegistry.registerBlock((Block)this.resource_block, ItemBlockResource.class, (String)"ResourceBlock");
        GameRegistry.registerBlock((Block)this.dark_iron_ore, (String)"DarkIronOre");
        GameRegistry.registerBlock((Block)this.fractured_bedrock_block, (String)"FracturedBedrock");
        GameRegistry.registerBlock((Block)this.blasted_bedrock_block, (String)"BlastedBedrock");
        GameRegistry.registerBlock((Block)this.colossal_block, ColossalBlockItem.class, (String)"ColossalBlock");
        GameRegistry.registerBlock((Block)this.gargantuan_block, ItemGargantuanBlock.class, (String)"GargantuanBlock");
        GameRegistry.registerTileEntity(TileEntityColossalHeart.class, (String)"fz_colossal_heart");
        this.is_factory = new ItemStack((Block)this.factory_block);
        this.is_lightair = new ItemStack((Block)this.lightair_block);
        Core.tab((Block)this.factory_block, Core.TabType.BLOCKS);
        Core.tab(this.resource_block, Core.TabType.BLOCKS);
        this.worldgenManager = new WorldgenManager();
    }

    public void registerDerpyAliases() {
        String[][] aliases;
        for (String[] pair : aliases = new String[][]{{"factorization:tile.null", "factorization:FZ factory"}, {"factorization:tile.factorization.ResourceBlock", "factorization:FZ resource"}, {"factorization:tile.lightair", "factorization:tile.lightair"}, {"factorization:tile.factorization:darkIronOre", "factorization:FZ dark iron ore"}, {"factorization:tile.bedrock", "factorization:FZ fractured bedrock"}}) {
            String proper = pair[0];
            String derpy = pair[1];
            try {
                GameRegistry.addSubstitutionAlias((String)derpy, (GameRegistry.Type)GameRegistry.Type.BLOCK, (Object)proper);
            }
            catch (ExistingSubstitutionException e) {
                e.printStackTrace();
            }
            try {
                GameRegistry.addSubstitutionAlias((String)derpy, (GameRegistry.Type)GameRegistry.Type.ITEM, (Object)proper);
            }
            catch (ExistingSubstitutionException e) {
                e.printStackTrace();
            }
        }
    }

    void postMakeItems() {
        HashSet<Item> foundItems = new HashSet<Item>();
        for (Field field : this.getClass().getFields()) {
            Object obj;
            try {
                obj = field.get(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            if (obj instanceof ItemStack) {
                obj = ((ItemStack)obj).func_77973_b();
            }
            if (!(obj instanceof Item)) continue;
            foundItems.add((Item)obj);
        }
        Block invalid = DataUtil.getBlock((Item)null);
        for (Item it : foundItems) {
            if (DataUtil.getBlock(it) != invalid) continue;
            it.func_111206_d(it.func_77658_a());
            Registry.registerItem(it);
        }
    }

    public void makeItems() {
        this.ore_dirty_gravel = new ItemOreProcessing("gravel");
        this.ore_clean_gravel = new ItemOreProcessing("clean");
        this.ore_reduced = new ItemOreProcessing("reduced");
        this.ore_crystal = new ItemOreProcessing("crystal");
        this.sludge = new ItemCraftingComponent("sludge");
        OreDictionary.registerOre((String)"sludge", (Item)this.sludge);
        this.item_factorization = (ItemFactorizationBlock)Item.func_150898_a((Block)this.factory_block);
        this.item_resource = (ItemBlockResource)Item.func_150898_a((Block)this.resource_block);
        this.servorail_item = FactoryType.SERVORAIL.itemStack();
        this.empty_socket_item = FactoryType.SOCKET_EMPTY.itemStack();
        this.parasieve_item = FactoryType.PARASIEVE.itemStack();
        this.compression_crafter_item = FactoryType.COMPRESSIONCRAFTER.itemStack();
        this.daybarrel_item_hidden = FactoryType.DAYBARREL.itemStack();
        this.stamper_item = FactoryType.STAMPER.itemStack();
        this.lamp_item = FactoryType.LAMP.itemStack();
        this.packager_item = FactoryType.PACKAGER.itemStack();
        this.slagfurnace_item = FactoryType.SLAGFURNACE.itemStack();
        this.battery_item_hidden = FactoryType.BATTERY.itemStack();
        this.leydenjar_item = FactoryType.LEYDENJAR.itemStack();
        this.steamturbine_item = FactoryType.STEAMTURBINE.itemStack();
        this.solarboiler_item = FactoryType.SOLARBOILER.itemStack();
        this.caliometric_burner_item = FactoryType.CALIOMETRIC_BURNER.itemStack();
        this.heater_item = FactoryType.HEATER.itemStack();
        this.mirror_item_hidden = FactoryType.MIRROR.itemStack();
        this.leadwire_item = FactoryType.LEADWIRE.itemStack();
        this.mixer_item = FactoryType.MIXER.itemStack();
        this.crystallizer_item = FactoryType.CRYSTALLIZER.itemStack();
        this.greenware_item = FactoryType.CERAMIC.itemStack();
        if (FzConfig.enable_rocketry) {
            this.rocket_engine_item_hidden = FactoryType.ROCKETENGINE.itemStack();
        }
        this.silver_ore_item = ResourceType.SILVERORE.itemStack("Silver Ore");
        this.silver_block_item = ResourceType.SILVERBLOCK.itemStack("Block of Silver");
        this.lead_block_item = ResourceType.LEADBLOCK.itemStack("Block of Lead");
        this.dark_iron_block_item = ResourceType.DARKIRONBLOCK.itemStack("Block of Dark Iron");
        this.diamond_shard = new ItemCraftingComponent("diamond_shard");
        this.dark_iron = new ItemCraftingComponent("dark_iron_ingot");
        this.lead_ingot = new ItemCraftingComponent("lead_ingot");
        this.silver_ingot = new ItemCraftingComponent("silver_ingot");
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)this.silver_ore_item);
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)new ItemStack((Item)this.silver_ingot));
        OreDictionary.registerOre((String)"ingotLead", (ItemStack)new ItemStack((Item)this.lead_ingot));
        OreDictionary.registerOre((String)"blockSilver", (ItemStack)this.silver_block_item);
        OreDictionary.registerOre((String)"blockLead", (ItemStack)this.lead_block_item);
        OreDictionary.registerOre((String)"oreFzDarkIron", (Block)this.dark_iron_ore);
        OreDictionary.registerOre((String)"ingotFzDarkIron", (Item)this.dark_iron);
        OreDictionary.registerOre((String)"blockFzDarkIron", (ItemStack)this.dark_iron_block_item);
        this.logicMatrixProgrammer = new ItemMatrixProgrammer();
        this.logicMatrix = new ItemCraftingComponent("logic_matrix");
        this.logicMatrixIdentifier = new ItemCraftingComponent("logic_matrix_identifier");
        this.logicMatrixController = new ItemCraftingComponent("logic_matrix_controller");
        this.acid = new ItemAcidBottle();
        this.sulfuric_acid = new ItemStack((Item)this.acid, 1);
        this.aqua_regia = new ItemStack((Item)this.acid, 1, 1);
        OreDictionary.registerOre((String)"sulfuricAcid", (ItemStack)this.sulfuric_acid);
        OreDictionary.registerOre((String)"bottleSulfuricAcid", (ItemStack)this.sulfuric_acid);
        OreDictionary.registerOre((String)"aquaRegia", (ItemStack)this.aqua_regia);
        this.insulated_coil = new ItemCraftingComponent("insulated_coil");
        this.motor = new ItemCraftingComponent("motor");
        this.giant_scissors = new ItemCraftingComponent("socket/scissors");
        this.fan = new ItemCraftingComponent("fan");
        this.corkscrew = new ItemCraftingComponent("corkscrew");
        this.diamond_cutting_head = new ItemCraftingComponent("diamond_cutting_head");
        this.charge_meter = new ItemChargeMeter();
        this.mirror = new ItemBlockProxy(this.mirror_item_hidden, "mirror", Core.TabType.CHARGE);
        this.battery = new ItemBattery();
        this.leydenjar_item_full = ItemStack.func_77944_b((ItemStack)this.leydenjar_item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("storage", 1280000);
        this.leydenjar_item_full.func_77982_d(tag);
        this.sculpt_tool = new ItemSculptingTool();
        this.glaze_bucket = new ItemGlazeBucket();
        this.empty_glaze_bucket = new ItemStack((Item)this.glaze_bucket, 1, 100);
        this.pocket_table = new ItemPocketTable();
        this.steamFluid = new Fluid("steam").setDensity(-500).setGaseous(true).setViscosity(100).setUnlocalizedName("factorization:fluid/steam").setTemperature(383);
        FluidRegistry.registerFluid((Fluid)this.steamFluid);
        this.nether_powder = new ItemCraftingComponent("nether_powder");
        if (FzConfig.enable_rocketry) {
            this.rocket_fuel = new ItemCraftingComponent("rocket/rocket_fuel");
            this.rocket_engine = new ItemBlockProxy(this.rocket_engine_item_hidden, "rocket/rocket_engine", Core.TabType.ROCKETRY);
            this.rocket_engine.func_77625_d(1);
        }
        this.servo_placer = new ItemServoMotor();
        this.servo_widget_decor = new ItemServoRailWidget("servo/decorator");
        this.servo_widget_instruction = new ItemServoRailWidget("servo/component");
        this.servo_widget_decor.func_77625_d(16);
        this.servo_widget_instruction.func_77625_d(1);
        this.dark_iron_sprocket = new ItemStack((Item)new ItemCraftingComponent("servo/sprocket"));
        this.servo_motor = new ItemStack((Item)new ItemCraftingComponent("servo/servo_motor"));
        this.socket_part = new ItemSocketPart("socket/", Core.TabType.SERVOS);
        this.instruction_plate = new ItemCraftingComponent("servo/instruction_plate", Core.TabType.SERVOS);
        this.instruction_plate.setSpriteNumber(0);
        this.instruction_plate.func_77625_d(16);
        this.servo_rail_comment_editor = new ItemCommenter("servo/commenter");
        this.socket_lacerator = FactoryType.SOCKET_LACERATOR.asSocketItem();
        this.socket_robot_hand = FactoryType.SOCKET_ROBOTHAND.asSocketItem();
        this.socket_shifter = FactoryType.SOCKET_SHIFTER.asSocketItem();
        this.daybarrel = new ItemDayBarrel("daybarrel");
        this.docbook = new ItemDocBook("docbook", Core.TabType.TOOLS);
        this.utiligoo = new ItemGoo("utiligoo", Core.TabType.TOOLS);
        this.colossusGuide = new ItemColossusGuide("colossusGuide", Core.TabType.TOOLS);
        this.twistedBlock = new ItemTwistedBlock();
        this.postMakeItems();
    }

    public void vanillaRecipe(ItemStack res, Object ... params) {
        GameRegistry.addRecipe((ItemStack)res, (Object[])params);
    }

    public void vanillaShapelessRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        GameRegistry.addShapelessRecipe((ItemStack)res, (Object[])params);
    }

    public void oreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        this.convertOreItems(params);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(res, params));
    }

    void batteryRecipe(ItemStack res, Object ... params) {
        for (int damage : new int[]{1, 2}) {
            ArrayList<Object> items = new ArrayList<Object>(params.length);
            for (Object p : params) {
                if (p == this.battery) {
                    p = new ItemStack((Item)this.battery, 1, damage);
                }
                items.add(p);
            }
            this.oreRecipe(res, items.toArray());
        }
    }

    public void shapelessOreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        this.convertOreItems(params);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(res, params));
    }

    private void convertOreItems(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == Blocks.field_150347_e) {
                params[i] = "cobblestone";
                continue;
            }
            if (params[i] == Blocks.field_150348_b) {
                params[i] = "stone";
                continue;
            }
            if (params[i] == Items.field_151055_y) {
                params[i] = "stickWood";
                continue;
            }
            if (params[i] != this.dark_iron) continue;
            params[i] = "ingotFzDarkIron";
        }
    }

    public void makeRecipes() {
        ItemStack slab;
        ItemStack log;
        int i;
        this.vanillaRecipe(ItemUtil.nameItemStack(new ItemStack((Block)Blocks.field_150334_T), "Double Half Slab"), "-", "-", Character.valueOf('-'), new ItemStack((Block)Blocks.field_150333_U));
        this.vanillaRecipe(ItemUtil.nameItemStack(new ItemStack((Block)Blocks.field_150334_T, 2, 8), "Flat Stone"), "##", "##", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150333_U));
        this.vanillaRecipe(ItemUtil.nameItemStack(new ItemStack((Block)Blocks.field_150334_T, 2, 9), "Flat Sandstone"), "#", "#", Character.valueOf('#'), new ItemStack(Blocks.field_150322_A, 1, 2));
        this.vanillaShapelessRecipe(ItemUtil.nameItemStack(new ItemStack(Blocks.field_150346_d, 4, 1), "Dry Dirt"), Blocks.field_150346_d, Blocks.field_150346_d, Blocks.field_150346_d, Blocks.field_150346_d);
        this.shapelessOreRecipe(new ItemStack((Item)this.dark_iron, 9), this.dark_iron_block_item);
        this.oreRecipe(this.dark_iron_block_item, new Object[]{"III", "III", "III", Character.valueOf('I'), this.dark_iron});
        this.oreRecipe(new ItemStack((Item)this.pocket_table), " #", "| ", Character.valueOf('#'), Blocks.field_150462_ai, Character.valueOf('|'), Items.field_151055_y);
        this.oreRecipe(new ItemStack((Item)this.logicMatrixIdentifier), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), Items.field_151128_bU, Character.valueOf('X'), this.logicMatrixProgrammer});
        GameRegistry.addSmelting((Item)this.logicMatrixIdentifier, (ItemStack)new ItemStack((Item)this.logicMatrix), (float)0.0f);
        this.oreRecipe(new ItemStack((Item)this.logicMatrixController), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), "ingotSilver", Character.valueOf('X'), this.logicMatrixProgrammer});
        GameRegistry.addSmelting((Item)this.logicMatrixController, (ItemStack)new ItemStack((Item)this.logicMatrix), (float)0.0f);
        this.oreRecipe(new ItemStack((Item)this.logicMatrixProgrammer), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), this.dark_iron, Character.valueOf('X'), this.logicMatrixProgrammer});
        this.oreRecipe(new ItemStack((Item)this.logicMatrixProgrammer), new Object[]{"DSI", " #>", "BSI", Character.valueOf('D'), Items.field_151096_cd, Character.valueOf('B'), Items.field_151086_cn, Character.valueOf('S'), this.diamond_shard, Character.valueOf('I'), this.dark_iron, Character.valueOf('#'), this.logicMatrix, Character.valueOf('>'), Items.field_151132_bS});
        TileEntitySlagFurnace.SlagRecipes.register(new ItemStack((Item)this.logicMatrixProgrammer), 0.6666667f, new ItemStack((Item)this.dark_iron), 0.85f, new ItemStack((Item)this.logicMatrix));
        TileEntityCrystallizer.addRecipe(new ItemStack(Blocks.field_150451_bX), new ItemStack((Item)this.logicMatrix), 1.0f, Core.registry.aqua_regia);
        this.oreRecipe(new ItemStack((Item)this.lead_ingot, 9), "#", Character.valueOf('#'), this.lead_block_item);
        this.oreRecipe(new ItemStack((Item)this.silver_ingot, 9), "#", Character.valueOf('#'), this.silver_block_item);
        this.oreRecipe(this.lead_block_item, "###", "###", "###", Character.valueOf('#'), "ingotLead");
        this.oreRecipe(this.silver_block_item, "###", "###", "###", Character.valueOf('#'), "ingotSilver");
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)this.resource_block, 1, ResourceType.SILVERORE.md), new ItemStack((Item)this.silver_ingot), 0.3f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(this.dark_iron_ore), new ItemStack((Item)this.dark_iron), 0.5f);
        this.oreRecipe(new ItemStack((Item)this.sculpt_tool), " c", "/ ", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('/'), Items.field_151055_y);
        ItemSculptingTool.addModeChangeRecipes();
        this.oreRecipe(this.empty_glaze_bucket.func_77946_l(), "_ _", "# #", "#_#", Character.valueOf('_'), "slabWood", Character.valueOf('#'), "plankWood");
        this.base_common = this.glaze_bucket.makeCraftingGlaze("base_common");
        this.glaze_base_mimicry = this.glaze_bucket.makeCraftingGlaze("base_mimicry");
        this.glaze_bucket.addGlaze(this.glaze_base_mimicry);
        ItemStack lapis = new ItemStack(Items.field_151100_aR, 1, 4);
        this.shapelessOreRecipe(this.base_common, this.empty_glaze_bucket.func_77946_l(), Items.field_151131_as, new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE), Items.field_151119_aD);
        this.shapelessOreRecipe(this.glaze_base_mimicry, this.base_common, Items.field_151137_ax, Items.field_151123_aH, lapis);
        ItemStack waterFeature = this.glaze_bucket.makeMimicingGlaze(Blocks.field_150355_j, 0, -1);
        ItemStack lavaFeature = this.glaze_bucket.makeMimicingGlaze(Blocks.field_150353_l, 0, -1);
        this.shapelessOreRecipe(waterFeature, this.base_common, Items.field_151131_as);
        this.shapelessOreRecipe(lavaFeature, this.base_common, Items.field_151129_at);
        Core.registry.glaze_bucket.doneMakingStandardGlazes();
        IRecipe sculptureMergeRecipe = new IRecipe(){

            ArrayList<ItemStack> merge(InventoryCrafting inv) {
                ArrayList<ItemStack> match = null;
                boolean part_count = false;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack is = inv.func_70301_a(i);
                    if (is == null) continue;
                    if (!is.func_77942_o()) {
                        return null;
                    }
                    Item item = is.func_77973_b();
                    if (ItemUtil.similar(Core.registry.greenware_item, is)) {
                        if (match == null) {
                            match = new ArrayList<ItemStack>(2);
                        }
                        match.add(is);
                        continue;
                    }
                    return null;
                }
                if (match == null || match.size() != 2) {
                    return null;
                }
                return match;
            }

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                ArrayList<ItemStack> matching = this.merge(inventorycrafting);
                if (matching == null) {
                    return false;
                }
                int partCount = 0;
                TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                for (ItemStack is : matching) {
                    rep.loadFromStack(is);
                    if (rep.getState() != TileEntityGreenware.ClayState.WET) {
                        return false;
                    }
                    if ((partCount += rep.parts.size()) < TileEntityGreenware.MAX_PARTS) continue;
                    return false;
                }
                return true;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.greenware_item.func_77946_l();
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                ArrayList<ItemStack> matching = this.merge(inventorycrafting);
                TileEntityGreenware target = new TileEntityGreenware();
                for (ItemStack is : matching) {
                    TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                    rep.loadFromStack(is);
                    target.parts.addAll(rep.parts);
                }
                return target.getItem();
            }
        };
        GameRegistry.addRecipe((IRecipe)sculptureMergeRecipe);
        IRecipe mimicryGlazeRecipe = new IRecipe(){
            final int[] side_map = new int[]{1, 2, 1, 4, 0, 5, 0, 3, 0};

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                int mimic_items = 0;
                int other_items = 0;
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    ItemStack is = inventorycrafting.func_70301_a(i);
                    if (is == null) continue;
                    if (ItemUtil.couldMerge(Registry.this.glaze_base_mimicry, is)) {
                        ++mimic_items;
                        continue;
                    }
                    if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                    int d = is.func_77960_j();
                    if (d < 0 || d > 16) {
                        return false;
                    }
                    Block b = Block.func_149634_a((Item)is.func_77973_b());
                    if (b == null || b.func_149739_a().equals("tile.ForgeFiller")) {
                        return false;
                    }
                    ++other_items;
                }
                return mimic_items == 1 && other_items == 1;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.glaze_base_mimicry;
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                ItemStack is;
                int bucket_slot = -1;
                int block_slot = -1;
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    Block b;
                    is = inventorycrafting.func_70301_a(i);
                    if (is == null) continue;
                    if (ItemUtil.couldMerge(Registry.this.glaze_base_mimicry, is)) {
                        bucket_slot = i;
                        continue;
                    }
                    int d = is.func_77960_j();
                    if (d < 0 || d > 16 || !(is.func_77973_b() instanceof ItemBlock) || (b = Block.func_149634_a((Item)is.func_77973_b())) == null || b.func_149739_a().equals("tile.ForgeFiller")) continue;
                    block_slot = i;
                }
                if (bucket_slot == -1 || block_slot == -1) {
                    return null;
                }
                int side = 0;
                try {
                    side = block_slot == 4 ? this.side_map[block_slot] : -1;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                is = inventorycrafting.func_70301_a(block_slot);
                return Registry.this.glaze_bucket.makeMimicingGlaze(Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j(), side);
            }
        };
        GameRegistry.addRecipe((IRecipe)mimicryGlazeRecipe);
        RecipeSorter.register((String)"factorization:sculptureMerge", sculptureMergeRecipe.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"factorization:mimicryGlaze", mimicryGlazeRecipe.getClass(), (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        for (i = 0; i < 4; ++i) {
            log = new ItemStack(Blocks.field_150364_r, 1, i);
            slab = new ItemStack((Block)Blocks.field_150376_bx, 1, i);
            TileEntityDayBarrel.makeRecipe(log, slab);
        }
        for (i = 0; i < 2; ++i) {
            log = new ItemStack(Blocks.field_150363_s, 1, i);
            slab = new ItemStack((Block)Blocks.field_150376_bx, 1, 4 + i);
            TileEntityDayBarrel.makeRecipe(log, slab);
        }
        this.oreRecipe(this.stamper_item, "#p#", "#S#", "#C#", Character.valueOf('#'), Blocks.field_150347_e, Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('S'), Items.field_151055_y, Character.valueOf('C'), Blocks.field_150462_ai);
        this.oreRecipe(this.packager_item, "#p#", "I I", "#C#", Character.valueOf('#'), Blocks.field_150347_e, Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), Blocks.field_150462_ai);
        this.oreRecipe(this.compression_crafter_item, new Object[]{"D", "C", "P", Character.valueOf('D'), this.dark_iron, Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('P'), Blocks.field_150331_J});
        this.oreRecipe(this.lamp_item, new Object[]{"ISI", "GWG", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), "ingotSilver", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('W'), this.diamond_shard});
        this.oreRecipe(this.slagfurnace_item, "CFC", "C C", "CFC", Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('F'), Blocks.field_150460_al);
        TileEntitySlagFurnace.SlagRecipes.register(Blocks.field_150450_ax, 5.8f, Items.field_151137_ax, 0.2f, Blocks.field_150348_b);
        this.oreRecipe(this.greenware_item, "c", "-", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('-'), "slabWood");
        this.shapelessOreRecipe(this.sulfuric_acid, Items.field_151016_H, Items.field_151016_H, Items.field_151044_h, Items.field_151068_bn);
        this.shapelessOreRecipe(this.sulfuric_acid, "dustSulfur", Items.field_151044_h, Items.field_151068_bn);
        this.shapelessOreRecipe(this.aqua_regia, new Object[]{this.sulfuric_acid, this.nether_powder, Items.field_151059_bz});
        this.shapelessOreRecipe(this.aqua_regia, this.sulfuric_acid, Items.field_151065_br, Items.field_151059_bz);
        this.oreRecipe(new ItemStack((Item)this.fan), "I I", " - ", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('-'), Blocks.field_150443_bT);
        this.oreRecipe(new ItemStack((Item)this.corkscrew), " |-", "-| ", " |-", Character.valueOf('|'), Items.field_151042_j, Character.valueOf('-'), Blocks.field_150443_bT);
        this.oreRecipe(new ItemStack((Item)this.giant_scissors), "I I", " S ", "P P", Character.valueOf('P'), Blocks.field_150320_F, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('I'), Items.field_151040_l);
        if (FzConfig.enable_solar_steam) {
            this.oreRecipe(this.solarboiler_item, "I#I", "I I", "III", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('#'), Blocks.field_150411_aY);
        }
        this.oreRecipe(this.steamturbine_item, new Object[]{"I#I", "GXG", "LML", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('#'), Blocks.field_150411_aY, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('X'), this.fan, Character.valueOf('L'), "ingotLead", Character.valueOf('M'), this.motor});
        this.oreRecipe(this.caliometric_burner_item, "BPB", "BAB", "BLB", Character.valueOf('B'), Items.field_151103_aS, Character.valueOf('P'), Blocks.field_150320_F, Character.valueOf('A'), this.sulfuric_acid, Character.valueOf('L'), Items.field_151116_aA);
        this.oreRecipe(new ItemStack((Item)this.charge_meter), "WSW", "W|W", "LIL", Character.valueOf('W'), "plankWood", Character.valueOf('S'), Items.field_151155_ap, Character.valueOf('|'), Items.field_151055_y, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Items.field_151042_j);
        this.oreRecipe(new ItemStack((Item)this.battery, 1, 2), new Object[]{"ILI", "LAL", "ILI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('L'), "ingotLead", Character.valueOf('A'), this.acid});
        this.oreRecipe(this.leydenjar_item, "#G#", "#L#", "L#L", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('L'), "ingotLead");
        this.oreRecipe(this.heater_item, new Object[]{"CCC", "L L", "CCC", Character.valueOf('C'), this.insulated_coil, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ItemStack((Item)this.insulated_coil, 4), "LLL", "LCL", "LLL", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), Blocks.field_150435_aG);
        this.batteryRecipe(new ItemStack((Item)this.motor), new Object[]{"CIC", "CIC", "LBL", Character.valueOf('C'), this.insulated_coil, Character.valueOf('B'), this.battery, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Items.field_151042_j});
        if (FzConfig.enable_solar_steam) {
            this.oreRecipe(new ItemStack((Item)this.mirror), "SSS", "S#S", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), Blocks.field_150410_aZ);
        }
        ItemStack with_8 = this.leadwire_item.func_77946_l();
        with_8.field_77994_a = 8;
        this.oreRecipe(with_8, "LLL", Character.valueOf('L'), "ingotLead");
        this.oreRecipe(new ItemStack((Item)this.diamond_cutting_head), new Object[]{"SSS", "S-S", "SSS", Character.valueOf('S'), this.diamond_shard, Character.valueOf('-'), Blocks.field_150443_bT});
        TileEntityGrinder.addRecipe(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h), 1.5f);
        TileEntityGrinder.addRecipe("oreRedstone", new ItemStack(Items.field_151137_ax), 5.0f);
        TileEntityGrinder.addRecipe("oreDiamond", new ItemStack(Items.field_151045_i), 1.25f);
        TileEntityGrinder.addRecipe("oreEmerald", new ItemStack(Items.field_151166_bC), 1.25f);
        TileEntityGrinder.addRecipe(new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU), 2.5f);
        TileEntityGrinder.addRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 1, 4), 8.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150348_b, new ItemStack(Blocks.field_150347_e), 1.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150347_e, new ItemStack(Blocks.field_150351_n), 1.0f);
        TileEntityGrinder.addRecipe("treeSapling", new ItemStack(Items.field_151055_y), 1.25f);
        TileEntityGrinder.addRecipe(Blocks.field_150351_n, new ItemStack((Block)Blocks.field_150354_m), 1.0f);
        TileEntityGrinder.addRecipe("treeLeaves", new ItemStack(Items.field_151055_y), 0.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150359_w, new ItemStack((Block)Blocks.field_150354_m), 0.1f);
        TileEntityGrinder.addRecipe(Blocks.field_150321_G, new ItemStack(Items.field_151007_F), 0.25f);
        TileEntityGrinder.addRecipe(Blocks.field_150336_V, new ItemStack(Items.field_151118_aC), 3.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150341_Y, new ItemStack(Blocks.field_150351_n), 1.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150474_ac, new ItemStack(Blocks.field_150411_aY), 2.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150460_al, new ItemStack(Blocks.field_150347_e), 7.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150470_am, new ItemStack(Blocks.field_150348_b), 7.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150468_ap, new ItemStack(Items.field_151055_y), 1.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150431_aC, new ItemStack(Items.field_151126_ay), 0.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150433_aE, new ItemStack(Items.field_151126_ay), 4.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150435_aG, new ItemStack(Items.field_151119_aD), 4.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150422_aJ, new ItemStack(Items.field_151055_y), 2.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO), 4.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150415_aT, new ItemStack(Items.field_151055_y), 3.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150417_aV, new ItemStack(Blocks.field_150347_e), 0.75f);
        TileEntityGrinder.addRecipe(Blocks.field_150410_aZ, new ItemStack((Block)Blocks.field_150354_m), 0.00625f);
        TileEntityGrinder.addRecipe(Blocks.field_150440_ba, new ItemStack(Items.field_151127_ba), 7.75f);
        TileEntityGrinder.addRecipe(Blocks.field_150396_be, new ItemStack(Items.field_151055_y), 2.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150385_bj, new ItemStack(Items.field_151130_bT), 3.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150386_bk, new ItemStack(Items.field_151130_bT), 2.5f);
        TileEntityGrinder.addRecipe(Blocks.field_150379_bu, new ItemStack(Items.field_151114_aO), 4.0f);
        TileEntityGrinder.addRecipe(Blocks.field_150407_cf, new ItemStack(Items.field_151015_O), 8.25f);
        TileEntityGrinder.addRecipe(Items.field_151122_aG, new ItemStack(Items.field_151116_aA), 0.75f);
        TileEntityGrinder.addRecipe(Items.field_151134_bR, new ItemStack(Items.field_151116_aA), 0.9f);
        TileEntityGrinder.addRecipe(new ItemStack(Items.field_151144_bL, 1, 0), new ItemStack(Items.field_151100_aR, 1, 15), 6.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Items.field_151144_bL, 1, 2), new ItemStack(Items.field_151078_bh), 2.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Items.field_151144_bL, 1, 3), new ItemStack(Items.field_151078_bh), 3.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Items.field_151144_bL, 1, 4), new ItemStack(Items.field_151016_H), 1.5f);
        this.oreRecipe(this.mixer_item, new Object[]{" X ", " M ", "LUL", Character.valueOf('X'), this.fan, Character.valueOf('M'), this.motor, Character.valueOf('L'), "ingotLead", Character.valueOf('U'), Items.field_151066_bu});
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Item)this.sludge), new ItemStack(Items.field_151119_aD), 0.1f);
        this.oreRecipe(this.crystallizer_item, "-", "S", "U", Character.valueOf('-'), Items.field_151055_y, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('U'), Items.field_151066_bu);
        ItemStack lime = new ItemStack(Items.field_151100_aR, 1, 10);
        TileEntityCrystallizer.addRecipe(lime, new ItemStack(Items.field_151123_aH), 1.0f, new ItemStack(Items.field_151117_aB));
        TileEntityGrinder.addRecipe(new ItemStack(Blocks.field_150424_aL), new ItemStack((Item)this.nether_powder, 1), 1.0f);
        if (FzConfig.enable_rocketry) {
            this.shapelessOreRecipe(new ItemStack((Item)this.rocket_fuel, 9), new Object[]{this.nether_powder, this.nether_powder, this.nether_powder, this.nether_powder, Items.field_151059_bz, this.nether_powder, this.nether_powder, this.nether_powder, this.nether_powder});
            this.oreRecipe(new ItemStack((Item)this.rocket_engine), new Object[]{"#F#", "#I#", "I I", Character.valueOf('#'), Blocks.field_150339_S, Character.valueOf('F'), this.rocket_fuel, Character.valueOf('I'), Items.field_151042_j});
        }
        this.makeServoRecipes();
        this.oreRecipe(this.empty_socket_item, "#", "-", "#", Character.valueOf('#'), Blocks.field_150411_aY, Character.valueOf('-'), "slabWood");
        this.oreRecipe(FactoryType.SOCKET_SHIFTER.asSocketItem(), new Object[]{"V", "@", "D", Character.valueOf('V'), Blocks.field_150438_bZ, Character.valueOf('@'), this.logicMatrixController, Character.valueOf('D'), Blocks.field_150409_cd});
        this.oreRecipe(this.socket_robot_hand, new Object[]{"+*P", "+@+", "P*+", Character.valueOf('+'), this.servorail_item, Character.valueOf('*'), this.dark_iron_sprocket, Character.valueOf('@'), this.logicMatrixController, Character.valueOf('P'), Blocks.field_150331_J});
        this.oreRecipe(new ItemStack((Item)this.instruction_plate, 5), new Object[]{"I ", "I>", "I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('>'), this.logicMatrixProgrammer});
        this.oreRecipe(new ItemStack((Item)this.servo_rail_comment_editor), new Object[]{"#", "T", Character.valueOf('#'), this.instruction_plate, Character.valueOf('T'), Items.field_151155_ap});
        GameRegistry.addSmelting((Item)this.servo_widget_instruction, (ItemStack)new ItemStack((Item)this.instruction_plate), (float)0.0f);
        this.oreRecipe(new ItemStack((Item)this.docbook), new Object[]{"B~>", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('~'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('>'), this.logicMatrixProgrammer});
        ItemStack tons_of_bonemeal = new ItemStack(Items.field_151100_aR, 12, 15);
        this.oreRecipe(tons_of_bonemeal, "MSH", "nXn", Character.valueOf('M'), Blocks.field_150440_ba, Character.valueOf('S'), Blocks.field_150354_m, Character.valueOf('H'), Blocks.field_150407_cf, Character.valueOf('n'), Items.field_151075_bm, Character.valueOf('X'), Items.field_151103_aS);
        this.shapelessOreRecipe(new ItemStack((Item)this.utiligoo, 32), new Object[]{Blocks.field_150337_Q, Items.field_151045_i, Items.field_151045_i, this.logicMatrixProgrammer});
        this.vanillaRecipe(new ItemStack(this.gargantuan_block), "#", "#", "F", Character.valueOf('#'), Blocks.field_150348_b, Character.valueOf('F'), Blocks.field_150480_ab);
        this.oreRecipe(new ItemStack((Item)this.twistedBlock), "O", "#", Character.valueOf('O'), this.dark_iron_block_item, Character.valueOf('#'), this.dark_iron_sprocket);
    }

    private void makeServoRecipes() {
        ItemStack rails = this.servorail_item.func_77946_l();
        rails.field_77994_a = 8;
        this.oreRecipe(rails, new Object[]{"LDL", Character.valueOf('D'), this.dark_iron, Character.valueOf('L'), "ingotLead"});
        ItemStack two_sprockets = this.dark_iron_sprocket.func_77946_l();
        two_sprockets.field_77994_a = 2;
        this.oreRecipe(two_sprockets, new Object[]{" D ", "DSD", " D ", Character.valueOf('D'), this.dark_iron, Character.valueOf('S'), "ingotSilver"});
        this.batteryRecipe(this.servo_motor, new Object[]{"qCL", "SIB", "rCL", Character.valueOf('q'), Items.field_151128_bU, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('S'), this.dark_iron_sprocket, Character.valueOf('C'), this.insulated_coil, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), this.battery, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ItemStack((Item)this.servo_placer), new Object[]{"M#P", " S ", "M#P", Character.valueOf('M'), this.servo_motor, Character.valueOf('#'), this.logicMatrix, Character.valueOf('P'), this.logicMatrixProgrammer, Character.valueOf('S'), this.empty_socket_item});
        ServoComponent.setupRecipes();
        this.oreRecipe(this.parasieve_item, new Object[]{"C#C", "ImI", "CvC", Character.valueOf('C'), Blocks.field_150347_e, Character.valueOf('#'), Blocks.field_150411_aY, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('m'), this.logicMatrixIdentifier, Character.valueOf('v'), Blocks.field_150409_cd});
    }

    public void setToolEffectiveness() {
        BlockClass.DarkIron.harvest("pickaxe", 2);
        BlockClass.Barrel.harvest("axe", 1);
        BlockClass.Machine.harvest("pickaxe", 1);
        BlockClass.MachineLightable.harvest("pickaxe", 1);
        BlockClass.MachineDynamicLightable.harvest("pickaxe", 1);
        BlockClass.Socket.harvest("axe", 1);
        BlockClass.Socket.harvest("pickaxe", 1);
        this.resource_block.setHarvestLevel("pickaxe", 2);
        this.dark_iron_ore.setHarvestLevel("pickaxe", 2);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TileEntityWrathLamp.handleAirUpdates();
        } else {
            this.worldgenManager.tickRetrogenQueue();
        }
    }

    @SubscribeEvent
    public boolean onItemPickup(EntityItemPickupEvent event) {
        Core.proxy.pokePocketCrafting();
        return true;
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        IInventory craftMatrix = event.craftMatrix;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            Item item;
            ItemStack here = craftMatrix.func_70301_a(i);
            if (here == null || !((item = here.func_77973_b()) instanceof IActOnCraft)) continue;
            ((IActOnCraft)item).onCraft(here, craftMatrix, i, stack, player);
        }
    }

    public void sendIMC() {
        for (String string : new String[]{"factorization crystallizer recipes@fz.crystallizing", "factorization grinder recipes@fz.grinding", "factorization mixer recipes@fz.mixing", "factorization slag furnace recipes@fz.slagging"}) {
            FMLInterModComms.sendRuntimeMessage((Object)Core.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("Factorization@" + string));
        }
        for (ItemOreProcessing.OreType oreType : ItemOreProcessing.OreType.values()) {
            if (!oreType.enabled) continue;
            FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"smeltBonusExclude", (ItemStack)new ItemStack((Item)this.ore_crystal, 1, oreType.ID));
        }
    }

    public void addOtherRecipes() {
        ArrayList<ItemStack> theLogs = new ArrayList<ItemStack>();
        for (ItemStack is : OreDictionary.getOres((String)"logWood")) {
            Block log = Block.func_149634_a((Item)is.func_77973_b());
            if (log == null || log == Blocks.field_150364_r || log == Blocks.field_150363_s) continue;
            if (!ItemUtil.isWildcard(is, false)) {
                theLogs.add(is);
                continue;
            }
            ArrayList<ItemStack> discovered_plank_types = new ArrayList<ItemStack>();
            for (int md = 0; md < 16; ++md) {
                ItemStack plank;
                ItemStack ilog = new ItemStack(log, 1, md);
                ArrayList<ItemStack> planks = FzUtil.copyWithoutNull(CraftUtil.craft1x1(null, true, ilog.func_77946_l()));
                if (planks.size() != 1 || discovered_plank_types.contains(plank = (ItemStack)planks.get(0))) continue;
                theLogs.add(ilog);
                discovered_plank_types.add(plank);
            }
        }
        for (ItemStack log : theLogs) {
            String odType;
            ItemStack slab;
            ArrayList<ItemStack> planks = FzUtil.copyWithoutNull(CraftUtil.craft1x1(null, true, (log = log.func_77946_l()).func_77946_l()));
            if (planks.size() != 1 || !CraftUtil.craft_succeeded) continue;
            ItemStack plank = ((ItemStack)planks.get(0)).func_77946_l();
            plank.field_77994_a = 1;
            ArrayList<ItemStack> slabs = FzUtil.copyWithoutNull(CraftUtil.craft3x3(null, true, true, plank.func_77946_l(), plank.func_77946_l(), plank.func_77946_l(), null, null, null, null, null, null));
            if (slabs.size() != 1 || !CraftUtil.craft_succeeded) {
                slab = plank;
                odType = "plankWood";
            } else {
                slab = (ItemStack)slabs.get(0);
                odType = "slabWood";
            }
            if (Block.func_149634_a((Item)slab.func_77973_b()) == Blocks.field_150376_bx && Block.func_149634_a((Item)plank.func_77973_b()) != Blocks.field_150344_f) {
                slab = plank;
            }
            TileEntityDayBarrel.makeRecipe(log, slab.func_77946_l());
        }
    }
}

