/*
 * Decompiled with CFR 0.152.
 */
package factorization.crafting;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Sound;
import factorization.shared.TileEntityFactorization;
import factorization.util.CraftUtil;
import factorization.util.ItemUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStamper
extends TileEntityFactorization {
    ItemStack input;
    ItemStack output;
    final ArrayList<ItemStack> outputBuffer = new ArrayList(4);
    static int[] OUTPUT_sides = new int[]{0};
    static int[] INPUT_sides = new int[]{1};

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return BlockIcons.stamper.get(this, dir);
    }

    public int func_70302_i_() {
        return 2;
    }

    public int[] func_94128_d(int s) {
        switch (ForgeDirection.getOrientation((int)s)) {
            case DOWN: {
                return INPUT_sides;
            }
        }
        return OUTPUT_sides;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex == 0;
    }

    public ItemStack func_70301_a(int i) {
        switch (i) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.output;
            }
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.input = itemstack;
        }
        if (i == 1) {
            this.output = itemstack;
        }
    }

    public String func_145825_b() {
        return "Stamper";
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        super.putData(data);
        this.input = data.as(Share.PRIVATE, "input").putItemStack(this.input);
        this.output = data.as(Share.PRIVATE, "output").putItemStack(this.output);
        if (data.isNBT()) {
            NBTTagCompound tag = data.getTag();
            if (data.isWriter()) {
                this.writeBuffer("buffer", tag, this.outputBuffer);
            } else {
                this.readBuffer("buffer", tag, this.outputBuffer);
            }
        }
    }

    boolean canMerge(List<ItemStack> items) {
        if (items == null) {
            return true;
        }
        if (this.output == null) {
            return true;
        }
        for (ItemStack item : items) {
            if (item == null) continue;
            if (!ItemUtil.couldMerge(this.output, item)) {
                return false;
            }
            if (this.output.field_77994_a + item.field_77994_a <= this.output.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    void dumpBuffer() {
        if (this.outputBuffer.isEmpty()) {
            return;
        }
        Iterator<ItemStack> it = this.outputBuffer.iterator();
        boolean any = false;
        while (it.hasNext()) {
            ItemStack here = it.next();
            if (here == null) {
                it.remove();
                continue;
            }
            if (this.output == null) {
                this.output = here;
                it.remove();
                any = true;
                continue;
            }
            if (!ItemUtil.couldMerge(this.output, here)) continue;
            any = true;
            int can_take = this.output.func_77976_d() - this.output.field_77994_a;
            if (here.field_77994_a > can_take) {
                this.output.field_77994_a += can_take;
                here.field_77994_a -= can_take;
                break;
            }
            this.output.field_77994_a += here.field_77994_a;
            it.remove();
        }
        if (any) {
            this.func_70296_d();
        }
    }

    protected List<ItemStack> tryCrafting() {
        List<ItemStack> fakeResult = CraftUtil.craft1x1(this, true, this.input);
        if (!CraftUtil.craft_succeeded) {
            return null;
        }
        if (this.canMerge(fakeResult)) {
            return CraftUtil.craft1x1(this, false, this.input.func_77979_a(1));
        }
        return null;
    }

    @Override
    protected void doLogic() {
        int new_input_count;
        List<ItemStack> craft;
        boolean can_add;
        int input_count = this.input == null ? 0 : this.input.field_77994_a;
        boolean bl = can_add = this.output == null || this.output.field_77994_a < this.output.func_77976_d();
        if (this.outputBuffer.size() == 0 && can_add && input_count > 0 && (craft = this.tryCrafting()) != null) {
            this.outputBuffer.addAll(craft);
            this.func_70296_d();
            this.drawActive(3);
        }
        if (this.input != null && this.input.field_77994_a <= 0) {
            this.input = null;
        }
        this.dumpBuffer();
        int n = new_input_count = this.input == null ? 0 : this.input.field_77994_a;
        if (input_count != new_input_count) {
            this.needLogic();
        }
        if (this.need_logic_check) {
            this.pulse();
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.STAMPER;
    }

    @Override
    protected void makeNoise() {
        Sound.stamperUse.playAt(this);
    }

    @Override
    protected int getLogicSpeed() {
        return 16;
    }
}

