/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import factorization.docs.AbstractTypesetter;
import factorization.docs.IDocGenerator;
import factorization.docs.ItemWord;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeViewer
implements IDocGenerator {
    @Override
    public void process(AbstractTypesetter out, String arg) {
        ArrayList<Integer> free = new ArrayList<Integer>();
        BiomeGenBase[] biomeGenArray = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomeGenArray.length; ++i) {
            BiomeDictionary.Type[] types;
            BiomeGenBase biome = biomeGenArray[i];
            if (biome == null) {
                free.add(i);
                continue;
            }
            out.append("\\newpage\\title{#" + biome.field_76756_M + " " + biome.field_76791_y + "}");
            out.append("\\nl Temperature: " + biome.field_76750_F);
            out.append("\\nl Humidity: " + biome.field_76751_G);
            out.append(String.format("\\nl Color: #%06X", biome.field_76790_z));
            if (biome.field_76759_H != 0xFFFFFF) {
                out.append(String.format("\\nl Water Tint: #%06X", biome.field_76759_H));
            }
            out.append("\\nl Blocks: ");
            out.emitWord(new ItemWord(new ItemStack(biome.field_76752_A)));
            out.emitWord(new ItemWord(new ItemStack(biome.field_76753_B)));
            BiomeDecorator dec = biome.field_76760_I;
            out.append("\\nl\\nl");
            this.feature(out, dec.field_76833_y, Blocks.field_150392_bi);
            this.feature(out, dec.field_76832_z, Blocks.field_150345_g);
            this.feature(out, dec.field_76802_A, (Block)Blocks.field_150328_O);
            this.feature(out, dec.field_76803_B, (Block)Blocks.field_150329_H);
            this.feature(out, dec.field_76804_C, (Block)Blocks.field_150330_I);
            this.feature(out, dec.field_76798_D, (Block)Blocks.field_150338_P);
            this.feature(out, dec.field_76799_E, Blocks.field_150436_aH);
            this.feature(out, dec.field_76800_F, Blocks.field_150434_aF);
            this.feature(out, dec.field_76801_G + dec.field_76805_H, (Block)Blocks.field_150354_m);
            this.feature(out, dec.field_76806_I, Blocks.field_150435_aG);
            this.feature(out, dec.field_76807_J, Blocks.field_150419_aX);
            if (dec.field_76808_K) {
                out.emitWord(new ItemWord(new ItemStack(Items.field_151131_as)));
            }
            out.append("\\nl");
            if (biome.func_76738_d()) {
                out.append("\\nl Rainy");
            }
            if (biome.func_76746_c()) {
                out.append("\\nl Snowy");
            }
            if ((types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) == null || types.length == 0) continue;
            out.append("\\nl \\nl");
            for (BiomeDictionary.Type t : types) {
                out.append(" " + t);
            }
        }
        out.append("\\newpage\\title{Free IDs}\\nl");
        if (free.isEmpty()) {
            out.append("There are no free biome IDs!");
        } else {
            ArrayList<Integer> contig = new ArrayList<Integer>();
            int last = -100;
            boolean firstContig = false;
            for (Integer i : free) {
                if (i == last + 1) {
                    if (firstContig) {
                        firstContig = false;
                    } else {
                        contig.remove(contig.size() - 1);
                    }
                    contig.add(-i.intValue());
                } else {
                    contig.add(i);
                    firstContig = true;
                }
                last = i;
            }
            for (Integer i : contig) {
                if (i < 0) {
                    out.append("to " + -i.intValue() + "\\nl");
                    continue;
                }
                out.append(i + " ");
            }
        }
    }

    void feature(AbstractTypesetter out, int val, Block symbol) {
        if (val <= 0) {
            return;
        }
        if (val > 99) {
            val = 99;
        }
        Item it = symbol.func_149694_d(null, 0, 0, 0);
        ItemStack is = new ItemStack(it);
        if (symbol == Blocks.field_150329_H) {
            is = new ItemStack((Block)Blocks.field_150329_H, 0, 1);
        }
        is.field_77994_a = val;
        ItemWord word = new ItemWord(is);
        out.emitWord(word);
    }
}

