/*
 * Decompiled with CFR 0.152.
 */
package factorization.docs;

import cpw.mods.fml.common.Loader;
import factorization.docs.AbstractTypesetter;
import factorization.docs.DocWorld;
import factorization.docs.DocumentationModule;
import factorization.docs.FigurePage;
import factorization.docs.IDocGenerator;
import factorization.docs.ImgWord;
import factorization.docs.ItemWord;
import factorization.docs.Tokenizer;
import factorization.docs.VerticalSpacerWord;
import factorization.docs.Word;
import factorization.docs.WordPage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class ClientTypesetter
extends AbstractTypesetter {
    public ClientTypesetter(FontRenderer font, int pageWidth, int pageHeight) {
        super(font, pageWidth, pageHeight - WordPage.TEXT_HEIGHT * 2);
    }

    @Override
    protected void handleCommand(Tokenizer tokenizer, String cmd, String link, String style) {
        if (cmd.equals("\\p")) {
            WordPage p = this.getCurrentPage();
            p.nl();
            if (this.getCurrentPage() == p) {
                p.nl();
            }
        } else if (cmd.equals("\\nl")) {
            this.getCurrentPage().nl();
        } else if (cmd.equals("\\-")) {
            this.getCurrentPage().nl();
            this.emit(" - ", null);
        } else if (cmd.equals("\\") || cmd.equals("\\ ")) {
            this.emit(style + " ", link);
        } else if (cmd.equalsIgnoreCase("\\\\")) {
            this.emit("\\", link);
        } else if (cmd.equals("\\newpage")) {
            this.newPage();
        } else if (cmd.equals("\\leftpage")) {
            int need = 1 + this.pages.size() % 2;
            for (int i = 0; i < need; ++i) {
                this.newPage();
            }
        } else if (cmd.equals("\\b") || cmd.equals("\\i") || cmd.equals("\\u") || cmd.equals("\\obf")) {
            EnumChatFormatting newStyle;
            char mode = cmd.charAt(1);
            String content = this.getParameter(cmd, tokenizer);
            if (content == null) {
                return;
            }
            if (mode == 'b') {
                newStyle = EnumChatFormatting.BOLD;
            } else if (mode == 'i') {
                newStyle = EnumChatFormatting.ITALIC;
            } else if (mode == 'u') {
                newStyle = EnumChatFormatting.UNDERLINE;
            } else if (mode == 'o') {
                newStyle = EnumChatFormatting.OBFUSCATED;
            } else {
                this.error("Unknown style: " + cmd);
                return;
            }
            this.process(content, link, style + newStyle);
        } else if (cmd.equals("\\title")) {
            String val = this.getParameter(cmd, tokenizer);
            if (val == null) {
                this.error("No content");
                return;
            }
            this.process(val, link, style + EnumChatFormatting.UNDERLINE + EnumChatFormatting.BOLD);
        } else if (cmd.equals("\\h1")) {
            String val = this.getParameter(cmd, tokenizer);
            if (val == null) {
                this.error("No content");
                return;
            }
            this.process(val, link, style + EnumChatFormatting.BOLD);
            this.getCurrentPage().nl();
        } else if (cmd.equals("\\link") || cmd.equals("\\index")) {
            String newLink = this.getParameter(cmd, tokenizer);
            if (newLink == null) {
                this.error("missing destination parameter");
                return;
            }
            String content = this.getParameter(cmd, tokenizer);
            if (content == null) {
                this.error("missing content parameter");
                return;
            }
            this.process(content, newLink, style);
            if (cmd.equals("\\index")) {
                this.getCurrentPage().nl();
            }
        } else if (cmd.equals("\\#")) {
            String itemName = this.getParameter(cmd, tokenizer);
            if (itemName == null) {
                this.error("No item specified");
                return;
            }
            ArrayList<ItemStack> items = DocumentationModule.lookup(itemName);
            if (items == null) {
                this.error(itemName + " no such item");
                return;
            }
            if (link == null) {
                this.emitWord(new ItemWord(items.get(0)));
            } else {
                this.emitWord(new ItemWord(items.get(0), link));
            }
        } else if (cmd.equals("\\img")) {
            String imgName = this.getParameter(cmd, tokenizer);
            if (imgName == null) {
                this.error("No img specified");
                return;
            }
            ResourceLocation rl = new ResourceLocation(imgName);
            Minecraft mc = Minecraft.func_71410_x();
            try {
                IResource r = mc.func_110442_L().func_110536_a(rl);
                if (r == null) {
                    this.error("Not found: " + imgName);
                    return;
                }
            }
            catch (Throwable e) {
                this.error(e.getMessage());
                e.printStackTrace();
                return;
            }
            this.emitWord(new ImgWord(rl, link));
        } else if (cmd.equals("\\imgx")) {
            int width = Integer.parseInt(this.getParameter(cmd, tokenizer));
            int height = Integer.parseInt(this.getParameter(cmd, tokenizer));
            String imgName = this.getParameter(cmd, tokenizer);
            if (imgName == null) {
                this.error("No img specified");
                return;
            }
            ResourceLocation rl = new ResourceLocation(imgName);
            Minecraft mc = Minecraft.func_71410_x();
            try {
                IResource r = mc.func_110442_L().func_110536_a(rl);
                if (r == null) {
                    this.error("Not found: " + imgName);
                    return;
                }
            }
            catch (Throwable e) {
                this.error(e.getMessage());
                e.printStackTrace();
                return;
            }
            this.emitWord(new ImgWord(rl, link, width, height));
        } else if (cmd.equals("\\figure")) {
            DocWorld figure = null;
            try {
                String fig = this.getParameter(cmd, tokenizer);
                if (fig == null) {
                    return;
                }
                figure = DocumentationModule.loadWorld(fig);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.error("figure is corrupt; see console");
                return;
            }
            if (figure == null) {
                this.error("figure failed to load");
                return;
            }
            this.pages.add(new FigurePage(figure));
        } else if (cmd.equals("\\generate")) {
            String arg = this.getParameter(cmd, tokenizer);
            String[] args = arg.split("/", 2);
            IDocGenerator gen = DocumentationModule.generators.get(args[0]);
            if (gen == null) {
                this.error("\\generate{" + arg + "}: Not found: " + args[0]);
                return;
            }
            String rest = args.length > 1 ? args[1] : "";
            gen.process(this, rest);
        } else if (cmd.equals("\\seg")) {
            ArrayList<ArrayList<Word>> lines = this.getCurrentPage().text;
            if (!lines.isEmpty()) {
                this.segmentStart = lines.get(lines.size() - 1);
            }
        } else if (cmd.equals("\\endseg")) {
            this.segmentStart = null;
        } else if (cmd.equals("\\topic")) {
            String topic = this.getParameter(cmd, tokenizer);
            if (topic == null) {
                this.error("\\topic missing parameter");
                return;
            }
            this.append(String.format("\\newpage \\generate{recipes/for/%s}", topic));
        } else if (cmd.equals("\\checkmods")) {
            String[] mods;
            String mode = this.getParameter(cmd, tokenizer);
            if (mode == null) {
                this.error("\\checkmods missing parameter");
                return;
            }
            String modList = this.getParameter(cmd, tokenizer);
            if (modList == null) {
                this.error("\\checkmods missing parameter");
                return;
            }
            String content = this.getParameter(cmd, tokenizer);
            if (content == null) {
                this.error("\\checkmods missing parameter");
                return;
            }
            int count = 0;
            for (String modId : mods = modList.split(" ")) {
                if (!Loader.isModLoaded((String)modId)) continue;
                ++count;
            }
            boolean good = false;
            if (mode.equalsIgnoreCase("all")) {
                good = count == mods.length;
            } else if (mode.equalsIgnoreCase("none")) {
                good = count == 0;
            } else if (mode.equalsIgnoreCase("some")) {
                good = count > 1;
            } else {
                this.error("\\checkmods first parameter must be 'all', 'none', or 'some', not " + mode);
                return;
            }
            String other = this.getParameter(cmd, tokenizer);
            if (good) {
                this.process(content, link, style);
            } else if (other != null) {
                this.process(other, link, style);
            }
        } else if (cmd.equals("\\vpad")) {
            String height_ = this.getParameter(cmd, tokenizer);
            if (height_ == null) {
                this.error("\\vpad missing parameter");
            }
            int height = Integer.parseInt(height_);
            this.emitWord(new VerticalSpacerWord(height));
        } else if (cmd.equals("\\ifhtml")) {
            String trueBranch = this.getParameter(cmd, tokenizer);
            String falseBranch = this.getParameter(cmd, tokenizer);
            this.process(falseBranch, link, style);
        } else {
            this.error("Unknown command: ");
            this.emit(cmd, null);
        }
    }
}

